/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.XmlResourceParser;
import android.os.Bundle;
import android.preference.Preference;
import android.preference.PreferenceInflater;
import android.preference.PreferenceScreen;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class PreferenceManager {
    public static final String KEY_HAS_SET_DEFAULT_VALUES = "_has_set_default_values";
    public static final String METADATA_KEY_PREFERENCES = "android.preference";
    private static final String TAG = "PreferenceManager";
    private Activity mActivity;
    private List<OnActivityDestroyListener> mActivityDestroyListeners;
    private List<OnActivityResultListener> mActivityResultListeners;
    private List<OnActivityStopListener> mActivityStopListeners;
    private Context mContext;
    private SharedPreferences.Editor mEditor;
    private long mNextId = 0L;
    private int mNextRequestCode;
    private boolean mNoCommit;
    private OnPreferenceTreeClickListener mOnPreferenceTreeClickListener;
    private PreferenceScreen mPreferenceScreen;
    private List<DialogInterface> mPreferencesScreens;
    private SharedPreferences mSharedPreferences;
    private int mSharedPreferencesMode;
    private String mSharedPreferencesName;

    PreferenceManager(Activity activity, int n) {
        this.mActivity = activity;
        this.mNextRequestCode = n;
        this.init(activity);
    }

    private PreferenceManager(Context context) {
        this.init(context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dismissAllScreens() {
        ArrayList<DialogInterface> arrayList;
        synchronized (this) {
            if (this.mPreferencesScreens == null) {
                return;
            }
            List<DialogInterface> list = this.mPreferencesScreens;
            arrayList = new ArrayList<DialogInterface>(list);
            this.mPreferencesScreens.clear();
        }
        int n = arrayList.size() - 1;
        while (n >= 0) {
            arrayList.get(n).dismiss();
            n += -1;
        }
        return;
    }

    public static SharedPreferences getDefaultSharedPreferences(Context context) {
        String string2 = PreferenceManager.getDefaultSharedPreferencesName(context);
        int n = PreferenceManager.getDefaultSharedPreferencesMode();
        return context.getSharedPreferences(string2, n);
    }

    private static int getDefaultSharedPreferencesMode() {
        return 0;
    }

    private static String getDefaultSharedPreferencesName(Context context) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = context.getPackageName();
        return stringBuilder.append(string2).append("_preferences").toString();
    }

    private void init(Context context) {
        this.mContext = context;
        String string2 = PreferenceManager.getDefaultSharedPreferencesName(context);
        this.setSharedPreferencesName(string2);
    }

    private List<ResolveInfo> queryIntentActivities(Intent intent) {
        return this.mContext.getPackageManager().queryIntentActivities(intent, 128);
    }

    public static void setDefaultValues(Context context, int n, boolean bl) {
        String string2 = PreferenceManager.getDefaultSharedPreferencesName(context);
        int n2 = PreferenceManager.getDefaultSharedPreferencesMode();
        PreferenceManager.setDefaultValues(context, string2, n2, n, bl);
    }

    public static void setDefaultValues(Context context, String string2, int n, int n2, boolean bl) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(KEY_HAS_SET_DEFAULT_VALUES, 0);
        if (!bl && sharedPreferences.getBoolean(KEY_HAS_SET_DEFAULT_VALUES, false)) {
            return;
        }
        PreferenceManager preferenceManager = new PreferenceManager(context);
        preferenceManager.setSharedPreferencesName(string2);
        preferenceManager.setSharedPreferencesMode(n);
        PreferenceScreen preferenceScreen = preferenceManager.inflateFromResource(context, n2, null);
        SharedPreferences.Editor editor = sharedPreferences.edit().putBoolean(KEY_HAS_SET_DEFAULT_VALUES, true);
        try {
            editor.apply();
            return;
        }
        catch (AbstractMethodError abstractMethodError) {
            boolean bl2 = editor.commit();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setNoCommit(boolean bl) {
        if (!bl && this.mEditor != null) {
            try {
                this.mEditor.apply();
            }
            catch (AbstractMethodError abstractMethodError) {
                boolean bl2 = this.mEditor.commit();
            }
        }
        this.mNoCommit = bl;
    }

    void addPreferencesScreen(DialogInterface dialogInterface) {
        synchronized (this) {
            if (this.mPreferencesScreens == null) {
                ArrayList<DialogInterface> arrayList = new ArrayList<DialogInterface>();
                this.mPreferencesScreens = arrayList;
            }
            boolean bl = this.mPreferencesScreens.add(dialogInterface);
            return;
        }
    }

    public PreferenceScreen createPreferenceScreen(Context context) {
        PreferenceScreen preferenceScreen = new PreferenceScreen(context, null);
        preferenceScreen.onAttachedToHierarchy(this);
        return preferenceScreen;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void dispatchActivityDestroy() {
        ArrayList<OnActivityDestroyListener> arrayList = null;
        // MONITORENTER : this
        if (this.mActivityDestroyListeners != null) {
            List<OnActivityDestroyListener> list = this.mActivityDestroyListeners;
            arrayList = new ArrayList<OnActivityDestroyListener>(list);
        }
        // MONITOREXIT : this
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ((OnActivityDestroyListener)arrayList.get(i)).onActivityDestroy();
            }
        }
        this.dismissAllScreens();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void dispatchActivityResult(int n, int n2, Intent intent) {
        ArrayList<OnActivityResultListener> arrayList;
        synchronized (this) {
            if (this.mActivityResultListeners == null) {
                return;
            }
            List<OnActivityResultListener> list = this.mActivityResultListeners;
            arrayList = new ArrayList<OnActivityResultListener>(list);
        }
        int n3 = arrayList.size();
        int n4 = 0;
        while (n4 < n3) {
            if (((OnActivityResultListener)arrayList.get(n4)).onActivityResult(n, n2, intent)) {
                return;
            }
            ++n4;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void dispatchActivityStop() {
        ArrayList<OnActivityStopListener> arrayList;
        synchronized (this) {
            if (this.mActivityStopListeners == null) {
                return;
            }
            List<OnActivityStopListener> list = this.mActivityStopListeners;
            arrayList = new ArrayList<OnActivityStopListener>(list);
        }
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            ((OnActivityStopListener)arrayList.get(n2)).onActivityStop();
            ++n2;
        }
        return;
    }

    void dispatchNewIntent(Intent intent) {
        this.dismissAllScreens();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Preference findPreference(CharSequence charSequence) {
        if (this.mPreferenceScreen != null) return this.mPreferenceScreen.findPreference(charSequence);
        return null;
    }

    Activity getActivity() {
        return this.mActivity;
    }

    Context getContext() {
        return this.mContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SharedPreferences.Editor getEditor() {
        SharedPreferences.Editor editor;
        if (!this.mNoCommit) return this.getSharedPreferences().edit();
        if (this.mEditor != null) return this.mEditor;
        this.mEditor = editor = this.getSharedPreferences().edit();
        return this.mEditor;
    }

    long getNextId() {
        synchronized (this) {
            long l;
            long l2 = this.mNextId;
            this.mNextId = l = 1L + l2;
            return l2;
        }
    }

    int getNextRequestCode() {
        synchronized (this) {
            int n;
            int n2 = this.mNextRequestCode;
            this.mNextRequestCode = n = n2 + 1;
            return n2;
        }
    }

    OnPreferenceTreeClickListener getOnPreferenceTreeClickListener() {
        return this.mOnPreferenceTreeClickListener;
    }

    PreferenceScreen getPreferenceScreen() {
        return this.mPreferenceScreen;
    }

    public SharedPreferences getSharedPreferences() {
        if (this.mSharedPreferences == null) {
            SharedPreferences sharedPreferences;
            Context context = this.mContext;
            String string2 = this.mSharedPreferencesName;
            int n = this.mSharedPreferencesMode;
            this.mSharedPreferences = sharedPreferences = context.getSharedPreferences(string2, n);
        }
        return this.mSharedPreferences;
    }

    public int getSharedPreferencesMode() {
        return this.mSharedPreferencesMode;
    }

    public String getSharedPreferencesName() {
        return this.mSharedPreferencesName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    PreferenceScreen inflateFromIntent(Intent intent, PreferenceScreen preferenceScreen) {
        List<ResolveInfo> list = this.queryIntentActivities(intent);
        HashSet<String> hashSet = new HashSet<String>();
        int n = list.size() - 1;
        while (true) {
            int n2;
            String string2;
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2;
            String string3;
            if (n < 0) {
                preferenceScreen.onAttachedToHierarchy(this);
                return preferenceScreen;
            }
            ActivityInfo activityInfo = list.get((int)n).activityInfo;
            Bundle bundle = activityInfo.metaData;
            if (bundle != null && bundle.containsKey(METADATA_KEY_PREFERENCES) && !hashSet.contains(string3 = (stringBuilder2 = (stringBuilder = new StringBuilder()).append(string2 = activityInfo.packageName).append(":")).append(n2 = activityInfo.metaData.getInt(METADATA_KEY_PREFERENCES)).toString())) {
                PackageManager packageManager;
                PreferenceInflater preferenceInflater;
                boolean bl = hashSet.add(string3);
                try {
                    Context context;
                    Context context2 = this.mContext;
                    String string4 = activityInfo.packageName;
                    Context context3 = context = context2.createPackageContext(string4, 0);
                    preferenceInflater = new PreferenceInflater(context3, this);
                    packageManager = context3.getPackageManager();
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    StringBuilder stringBuilder3 = new StringBuilder().append("Could not create context for ");
                    String string5 = activityInfo.packageName;
                    StringBuilder stringBuilder4 = stringBuilder3.append(string5).append(": ");
                    String string6 = Log.getStackTraceString(nameNotFoundException);
                    String string7 = stringBuilder4.append(string6).toString();
                    int n3 = Log.w(TAG, string7);
                }
                XmlResourceParser xmlResourceParser = activityInfo.loadXmlMetaData(packageManager, METADATA_KEY_PREFERENCES);
                preferenceScreen = (PreferenceScreen)preferenceInflater.inflate(xmlResourceParser, preferenceScreen, true);
                xmlResourceParser.close();
            }
            n += -1;
        }
    }

    public PreferenceScreen inflateFromResource(Context context, int n, PreferenceScreen preferenceScreen) {
        this.setNoCommit(true);
        PreferenceScreen preferenceScreen2 = (PreferenceScreen)new PreferenceInflater(context, this).inflate(n, preferenceScreen, true);
        preferenceScreen2.onAttachedToHierarchy(this);
        this.setNoCommit(false);
        return preferenceScreen2;
    }

    void registerOnActivityDestroyListener(OnActivityDestroyListener onActivityDestroyListener) {
        synchronized (this) {
            if (this.mActivityDestroyListeners == null) {
                ArrayList<OnActivityDestroyListener> arrayList = new ArrayList<OnActivityDestroyListener>();
                this.mActivityDestroyListeners = arrayList;
            }
            if (!this.mActivityDestroyListeners.contains(onActivityDestroyListener)) {
                boolean bl = this.mActivityDestroyListeners.add(onActivityDestroyListener);
            }
            return;
        }
    }

    void registerOnActivityResultListener(OnActivityResultListener onActivityResultListener) {
        synchronized (this) {
            if (this.mActivityResultListeners == null) {
                ArrayList<OnActivityResultListener> arrayList = new ArrayList<OnActivityResultListener>();
                this.mActivityResultListeners = arrayList;
            }
            if (!this.mActivityResultListeners.contains(onActivityResultListener)) {
                boolean bl = this.mActivityResultListeners.add(onActivityResultListener);
            }
            return;
        }
    }

    void registerOnActivityStopListener(OnActivityStopListener onActivityStopListener) {
        synchronized (this) {
            if (this.mActivityStopListeners == null) {
                ArrayList<OnActivityStopListener> arrayList = new ArrayList<OnActivityStopListener>();
                this.mActivityStopListeners = arrayList;
            }
            if (!this.mActivityStopListeners.contains(onActivityStopListener)) {
                boolean bl = this.mActivityStopListeners.add(onActivityStopListener);
            }
            return;
        }
    }

    void removePreferencesScreen(DialogInterface dialogInterface) {
        synchronized (this) {
            if (this.mPreferencesScreens == null) {
                return;
            }
            boolean bl = this.mPreferencesScreens.remove(dialogInterface);
            return;
        }
    }

    void setOnPreferenceTreeClickListener(OnPreferenceTreeClickListener onPreferenceTreeClickListener) {
        this.mOnPreferenceTreeClickListener = onPreferenceTreeClickListener;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean setPreferences(PreferenceScreen preferenceScreen) {
        PreferenceScreen preferenceScreen2 = this.mPreferenceScreen;
        if (preferenceScreen == preferenceScreen2) return false;
        this.mPreferenceScreen = preferenceScreen;
        return true;
    }

    public void setSharedPreferencesMode(int n) {
        this.mSharedPreferencesMode = n;
        this.mSharedPreferences = null;
    }

    public void setSharedPreferencesName(String string2) {
        this.mSharedPreferencesName = string2;
        this.mSharedPreferences = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean shouldCommit() {
        if (this.mNoCommit) return false;
        return true;
    }

    void unregisterOnActivityDestroyListener(OnActivityDestroyListener onActivityDestroyListener) {
        synchronized (this) {
            if (this.mActivityDestroyListeners != null) {
                boolean bl = this.mActivityDestroyListeners.remove(onActivityDestroyListener);
            }
            return;
        }
    }

    void unregisterOnActivityResultListener(OnActivityResultListener onActivityResultListener) {
        synchronized (this) {
            if (this.mActivityResultListeners != null) {
                boolean bl = this.mActivityResultListeners.remove(onActivityResultListener);
            }
            return;
        }
    }

    void unregisterOnActivityStopListener(OnActivityStopListener onActivityStopListener) {
        synchronized (this) {
            if (this.mActivityStopListeners != null) {
                boolean bl = this.mActivityStopListeners.remove(onActivityStopListener);
            }
            return;
        }
    }

    public static interface OnActivityDestroyListener {
        public void onActivityDestroy();
    }

    public static interface OnActivityStopListener {
        public void onActivityStop();
    }

    public static interface OnActivityResultListener {
        public boolean onActivityResult(int var1, int var2, Intent var3);
    }

    static interface OnPreferenceTreeClickListener {
        public boolean onPreferenceTreeClick(PreferenceScreen var1, Preference var2);
    }
}

