/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.Preference;
import android.preference.PreferenceGroup;
import android.preference.PreferenceGroupAdapter;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;

public final class PreferenceScreen
extends PreferenceGroup
implements AdapterView.OnItemClickListener,
DialogInterface.OnDismissListener {
    private Dialog mDialog;
    private ListAdapter mRootAdapter;

    public PreferenceScreen(Context context, AttributeSet attributeSet) {
        super(context, attributeSet, 16842891);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void showDialog(Bundle bundle) {
        Dialog dialog;
        Context context = this.getContext();
        ListView listView = new ListView(context);
        this.bind(listView);
        CharSequence charSequence = this.getTitle();
        int n = TextUtils.isEmpty(charSequence) ? 16973830 : 16973829;
        this.mDialog = dialog = new Dialog(context, n);
        dialog.setContentView(listView);
        if (!TextUtils.isEmpty(charSequence)) {
            dialog.setTitle(charSequence);
        }
        dialog.setOnDismissListener(this);
        if (bundle != null) {
            dialog.onRestoreInstanceState(bundle);
        }
        this.getPreferenceManager().addPreferencesScreen(dialog);
        dialog.show();
    }

    public void bind(ListView listView) {
        listView.setOnItemClickListener(this);
        ListAdapter listAdapter = this.getRootAdapter();
        listView.setAdapter(listAdapter);
        this.onAttachedToActivity();
    }

    public Dialog getDialog() {
        return this.mDialog;
    }

    public ListAdapter getRootAdapter() {
        if (this.mRootAdapter == null) {
            ListAdapter listAdapter;
            this.mRootAdapter = listAdapter = this.onCreateRootAdapter();
        }
        return this.mRootAdapter;
    }

    @Override
    protected boolean isOnSameScreenAsChildren() {
        return false;
    }

    @Override
    protected void onClick() {
        if (this.getIntent() != null) {
            return;
        }
        if (this.getPreferenceCount() == 0) {
            return;
        }
        this.showDialog(null);
    }

    protected ListAdapter onCreateRootAdapter() {
        return new PreferenceGroupAdapter(this);
    }

    @Override
    public void onDismiss(DialogInterface dialogInterface) {
        this.mDialog = null;
        this.getPreferenceManager().removePreferencesScreen(dialogInterface);
    }

    public void onItemClick(AdapterView adapterView, View view, int n, long l) {
        Object object = this.getRootAdapter().getItem(n);
        if (!(object instanceof Preference)) {
            return;
        }
        ((Preference)object).performClick(this);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable == null || !parcelable.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState)parcelable;
        Parcelable parcelable2 = savedState.getSuperState();
        super.onRestoreInstanceState(parcelable2);
        if (!savedState.isDialogShowing) {
            return;
        }
        Bundle bundle = savedState.dialogBundle;
        this.showDialog(bundle);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Parcelable onSaveInstanceState() {
        Bundle bundle;
        Parcelable parcelable = super.onSaveInstanceState();
        Dialog dialog = this.mDialog;
        if (dialog == null) return parcelable;
        if (!dialog.isShowing()) {
            return parcelable;
        }
        SavedState savedState = new SavedState(parcelable);
        savedState.isDialogShowing = true;
        savedState.dialogBundle = bundle = dialog.onSaveInstanceState();
        return savedState;
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        Bundle dialogBundle;
        boolean isDialogShowing;

        /*
         * Enabled aggressive block sorting
         */
        public SavedState(Parcel parcel) {
            super(parcel);
            Bundle bundle;
            boolean bl = parcel.readInt() == 1;
            this.isDialogShowing = bl;
            this.dialogBundle = bundle = parcel.readBundle();
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            int n2 = this.isDialogShowing ? 1 : 0;
            parcel.writeInt(n2);
            Bundle bundle = this.dialogBundle;
            parcel.writeBundle(bundle);
        }
    }
}

