/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.media.RingtoneManager;
import android.net.Uri;
import android.preference.Preference;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.android.internal.R;

public class RingtonePreference
extends Preference
implements PreferenceManager.OnActivityResultListener {
    private static final String TAG = "RingtonePreference";
    private int mRequestCode;
    private int mRingtoneType;
    private boolean mShowDefault;
    private boolean mShowSilent;

    public RingtonePreference(Context context) {
        this(context, null);
    }

    public RingtonePreference(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842899);
    }

    public RingtonePreference(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        boolean bl;
        boolean bl2;
        int n2;
        int[] nArray = R.styleable.RingtonePreference;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, n, 0);
        this.mRingtoneType = n2 = typedArray.getInt(0, 1);
        this.mShowDefault = bl2 = typedArray.getBoolean(1, true);
        this.mShowSilent = bl = typedArray.getBoolean(2, true);
        typedArray.recycle();
    }

    public int getRingtoneType() {
        return this.mRingtoneType;
    }

    public boolean getShowDefault() {
        return this.mShowDefault;
    }

    public boolean getShowSilent() {
        return this.mShowSilent;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onActivityResult(int n, int n2, Intent intent) {
        int n3 = this.mRequestCode;
        if (n == n3) {
            return false;
        }
        if (intent == null) return true;
        Uri uri = (Uri)intent.getParcelableExtra("android.intent.extra.ringtone.PICKED_URI");
        String string2 = uri != null ? uri.toString() : "";
        if (!this.callChangeListener(string2)) return true;
        this.onSaveRingtone(uri);
        return true;
    }

    @Override
    protected void onAttachedToHierarchy(PreferenceManager preferenceManager) {
        int n;
        super.onAttachedToHierarchy(preferenceManager);
        preferenceManager.registerOnActivityResultListener(this);
        this.mRequestCode = n = preferenceManager.getNextRequestCode();
    }

    @Override
    protected void onClick() {
        Intent intent = new Intent("android.intent.action.RINGTONE_PICKER");
        this.onPrepareRingtonePickerIntent(intent);
        Activity activity = this.getPreferenceManager().getActivity();
        int n = this.mRequestCode;
        activity.startActivityForResult(intent, n);
    }

    @Override
    protected Object onGetDefaultValue(TypedArray typedArray, int n) {
        return typedArray.getString(n);
    }

    protected void onPrepareRingtonePickerIntent(Intent intent) {
        Uri uri = this.onRestoreRingtone();
        Intent intent2 = intent.putExtra("android.intent.extra.ringtone.EXISTING_URI", uri);
        boolean bl = this.mShowDefault;
        Intent intent3 = intent.putExtra("android.intent.extra.ringtone.SHOW_DEFAULT", bl);
        if (this.mShowDefault) {
            Uri uri2 = RingtoneManager.getDefaultUri(this.getRingtoneType());
            Intent intent4 = intent.putExtra("android.intent.extra.ringtone.DEFAULT_URI", uri2);
        }
        boolean bl2 = this.mShowSilent;
        Intent intent5 = intent.putExtra("android.intent.extra.ringtone.SHOW_SILENT", bl2);
        int n = this.mRingtoneType;
        Intent intent6 = intent.putExtra("android.intent.extra.ringtone.TYPE", n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Uri onRestoreRingtone() {
        String string2 = this.getPersistedString(null);
        if (TextUtils.isEmpty(string2)) return null;
        return Uri.parse(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onSaveRingtone(Uri uri) {
        String string2 = uri != null ? uri.toString() : "";
        boolean bl = this.persistString(string2);
    }

    @Override
    protected void onSetInitialValue(boolean bl, Object object) {
        String string2 = (String)object;
        if (bl) {
            return;
        }
        if (TextUtils.isEmpty(string2)) {
            return;
        }
        Uri uri = Uri.parse(string2);
        this.onSaveRingtone(uri);
    }

    public void setRingtoneType(int n) {
        this.mRingtoneType = n;
    }

    public void setShowDefault(boolean bl) {
        this.mShowDefault = bl;
    }

    public void setShowSilent(boolean bl) {
        this.mShowSilent = bl;
    }
}

