/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.app.Dialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.ContentObserver;
import android.media.AudioManager;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.Preference;
import android.preference.PreferenceManager;
import android.preference.SeekBarPreference;
import android.provider.Settings;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.widget.SeekBar;
import com.android.internal.R;

public class VolumePreference
extends SeekBarPreference
implements PreferenceManager.OnActivityStopListener,
View.OnKeyListener {
    private static final String TAG = "VolumePreference";
    private SeekBarVolumizer mSeekBarVolumizer;
    private int mStreamType;

    public VolumePreference(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        int n;
        int[] nArray = R.styleable.VolumePreference;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, nArray, 0, 0);
        this.mStreamType = n = typedArray.getInt(0, 0);
        typedArray.recycle();
    }

    private void cleanup() {
        this.getPreferenceManager().unregisterOnActivityStopListener(this);
        if (this.mSeekBarVolumizer == null) {
            return;
        }
        Dialog dialog = this.getDialog();
        if (dialog != null && dialog.isShowing()) {
            View view = dialog.getWindow().getDecorView().findViewById(16908822);
            if (view != null) {
                view.setOnKeyListener(null);
            }
            this.mSeekBarVolumizer.revertVolume();
        }
        this.mSeekBarVolumizer.stop();
        this.mSeekBarVolumizer = null;
    }

    @Override
    public void onActivityStop() {
        this.cleanup();
    }

    @Override
    protected void onBindDialogView(View view) {
        SeekBarVolumizer seekBarVolumizer;
        super.onBindDialogView(view);
        SeekBar seekBar = (SeekBar)view.findViewById(16908822);
        Context context = this.getContext();
        int n = this.mStreamType;
        this.mSeekBarVolumizer = seekBarVolumizer = new SeekBarVolumizer(context, seekBar, n);
        this.getPreferenceManager().registerOnActivityStopListener(this);
        view.setOnKeyListener(this);
        view.setFocusableInTouchMode(true);
        boolean bl = view.requestFocus();
    }

    @Override
    protected void onDialogClosed(boolean bl) {
        super.onDialogClosed(bl);
        if (!bl && this.mSeekBarVolumizer != null) {
            this.mSeekBarVolumizer.revertVolume();
        }
        this.cleanup();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onKey(View view, int n, KeyEvent keyEvent) {
        if (this.mSeekBarVolumizer == null) {
            return true;
        }
        boolean bl = keyEvent.getAction() == 0;
        switch (n) {
            default: {
                return false;
            }
            case 25: {
                if (!bl) return true;
                this.mSeekBarVolumizer.changeVolumeBy(-1);
                return true;
            }
            case 24: 
        }
        if (!bl) return true;
        this.mSeekBarVolumizer.changeVolumeBy(1);
        return true;
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable == null || !parcelable.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState)parcelable;
        Parcelable parcelable2 = savedState.getSuperState();
        super.onRestoreInstanceState(parcelable2);
        if (this.mSeekBarVolumizer == null) {
            return;
        }
        SeekBarVolumizer seekBarVolumizer = this.mSeekBarVolumizer;
        VolumeStore volumeStore = savedState.getVolumeStore();
        seekBarVolumizer.onRestoreInstanceState(volumeStore);
    }

    protected void onSampleStarting(SeekBarVolumizer seekBarVolumizer) {
        if (this.mSeekBarVolumizer == null) {
            return;
        }
        SeekBarVolumizer seekBarVolumizer2 = this.mSeekBarVolumizer;
        if (seekBarVolumizer == seekBarVolumizer2) {
            return;
        }
        this.mSeekBarVolumizer.stopSample();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        if (this.isPersistent()) {
            return parcelable;
        }
        SavedState savedState = new SavedState(parcelable);
        if (this.mSeekBarVolumizer == null) return savedState;
        SeekBarVolumizer seekBarVolumizer = this.mSeekBarVolumizer;
        VolumeStore volumeStore = savedState.getVolumeStore();
        seekBarVolumizer.onSaveInstanceState(volumeStore);
        return savedState;
    }

    public void setStreamType(int n) {
        this.mStreamType = n;
    }

    public class SeekBarVolumizer
    implements SeekBar.OnSeekBarChangeListener,
    Runnable {
        private AudioManager mAudioManager;
        private Context mContext;
        private Handler mHandler;
        private int mLastProgress;
        private int mOriginalStreamVolume;
        private Ringtone mRingtone;
        private SeekBar mSeekBar;
        private int mStreamType;
        private ContentObserver mVolumeObserver;

        public SeekBarVolumizer(Context context, SeekBar seekBar, int n) {
            AudioManager audioManager;
            ContentObserver contentObserver;
            Handler handler;
            this.mHandler = handler = new Handler();
            this.mLastProgress = -1;
            Handler handler2 = this.mHandler;
            this.mVolumeObserver = contentObserver = new ContentObserver(handler2){

                @Override
                public void onChange(boolean bl) {
                    int n;
                    String[] stringArray;
                    String string2;
                    super.onChange(bl);
                    if (SeekBarVolumizer.this.mSeekBar == null) {
                        return;
                    }
                    ContentResolver contentResolver = SeekBarVolumizer.this.mContext.getContentResolver();
                    int n2 = Settings.System.getInt(contentResolver, string2 = (stringArray = Settings.System.VOLUME_SETTINGS)[n = SeekBarVolumizer.this.mStreamType], -1);
                    if (n2 < 0) {
                        return;
                    }
                    SeekBarVolumizer.this.mSeekBar.setProgress(n2);
                }
            };
            this.mContext = context;
            this.mAudioManager = audioManager = (AudioManager)context.getSystemService("audio");
            this.mStreamType = n;
            this.mSeekBar = seekBar;
            this.initSeekBar(seekBar);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void initSeekBar(SeekBar seekBar) {
            Ringtone ringtone;
            int n;
            AudioManager audioManager = this.mAudioManager;
            int n2 = this.mStreamType;
            int n3 = audioManager.getStreamMaxVolume(n2);
            seekBar.setMax(n3);
            AudioManager audioManager2 = this.mAudioManager;
            int n4 = this.mStreamType;
            int n5 = this.mOriginalStreamVolume = (n = audioManager2.getStreamVolume(n4));
            seekBar.setProgress(n5);
            seekBar.setOnSeekBarChangeListener(this);
            ContentResolver contentResolver = this.mContext.getContentResolver();
            String[] stringArray = Settings.System.VOLUME_SETTINGS;
            int n6 = this.mStreamType;
            Uri uri = Settings.System.getUriFor(stringArray[n6]);
            ContentObserver contentObserver = this.mVolumeObserver;
            contentResolver.registerContentObserver(uri, false, contentObserver);
            Uri uri2 = this.mStreamType == 2 ? Settings.System.DEFAULT_RINGTONE_URI : (this.mStreamType == 5 ? Settings.System.DEFAULT_NOTIFICATION_URI : Settings.System.DEFAULT_ALARM_ALERT_URI);
            this.mRingtone = ringtone = RingtoneManager.getRingtone(this.mContext, uri2);
            if (this.mRingtone == null) {
                return;
            }
            Ringtone ringtone2 = this.mRingtone;
            int n7 = this.mStreamType;
            ringtone2.setStreamType(n7);
        }

        private void sample() {
            VolumePreference.this.onSampleStarting(this);
            this.mRingtone.play();
        }

        public void changeVolumeBy(int n) {
            this.mSeekBar.incrementProgressBy(n);
            if (this.mRingtone != null && !this.mRingtone.isPlaying()) {
                this.sample();
            }
            int n2 = this.mSeekBar.getProgress();
            this.postSetVolume(n2);
        }

        public SeekBar getSeekBar() {
            return this.mSeekBar;
        }

        @Override
        public void onProgressChanged(SeekBar seekBar, int n, boolean bl) {
            if (!bl) {
                return;
            }
            this.postSetVolume(n);
        }

        public void onRestoreInstanceState(VolumeStore volumeStore) {
            int n;
            int n2;
            if (volumeStore.volume == -1) {
                return;
            }
            this.mOriginalStreamVolume = n2 = volumeStore.originalVolume;
            int n3 = this.mLastProgress = (n = volumeStore.volume);
            this.postSetVolume(n3);
        }

        public void onSaveInstanceState(VolumeStore volumeStore) {
            int n;
            int n2;
            if (this.mLastProgress < 0) {
                return;
            }
            volumeStore.volume = n2 = this.mLastProgress;
            volumeStore.originalVolume = n = this.mOriginalStreamVolume;
        }

        @Override
        public void onStartTrackingTouch(SeekBar seekBar) {
        }

        @Override
        public void onStopTrackingTouch(SeekBar seekBar) {
            if (this.mRingtone == null) {
                return;
            }
            if (this.mRingtone.isPlaying()) {
                return;
            }
            this.sample();
        }

        void postSetVolume(int n) {
            this.mLastProgress = n;
            this.mHandler.removeCallbacks(this);
            boolean bl = this.mHandler.post(this);
        }

        public void revertVolume() {
            AudioManager audioManager = this.mAudioManager;
            int n = this.mStreamType;
            int n2 = this.mOriginalStreamVolume;
            audioManager.setStreamVolume(n, n2, 0);
        }

        @Override
        public void run() {
            AudioManager audioManager = this.mAudioManager;
            int n = this.mStreamType;
            int n2 = this.mLastProgress;
            audioManager.setStreamVolume(n, n2, 0);
        }

        public void stop() {
            this.stopSample();
            ContentResolver contentResolver = this.mContext.getContentResolver();
            ContentObserver contentObserver = this.mVolumeObserver;
            contentResolver.unregisterContentObserver(contentObserver);
            this.mSeekBar.setOnSeekBarChangeListener(null);
        }

        public void stopSample() {
            if (this.mRingtone == null) {
                return;
            }
            this.mRingtone.stop();
        }
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        VolumeStore mVolumeStore;

        public SavedState(Parcel parcel) {
            super(parcel);
            int n;
            int n2;
            VolumeStore volumeStore;
            VolumeStore volumeStore2 = this.mVolumeStore = (volumeStore = new VolumeStore());
            volumeStore2.volume = n2 = parcel.readInt();
            VolumeStore volumeStore3 = this.mVolumeStore;
            volumeStore3.originalVolume = n = parcel.readInt();
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
            VolumeStore volumeStore;
            this.mVolumeStore = volumeStore = new VolumeStore();
        }

        VolumeStore getVolumeStore() {
            return this.mVolumeStore;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            int n2 = this.mVolumeStore.volume;
            parcel.writeInt(n2);
            int n3 = this.mVolumeStore.originalVolume;
            parcel.writeInt(n3);
        }
    }

    public static class VolumeStore {
        public int originalVolume = -1;
        public int volume = -1;
    }
}

