/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.accounts.Account;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.CursorEntityIterator;
import android.content.Entity;
import android.content.EntityIterator;
import android.content.Intent;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.net.Uri;
import android.os.RemoteException;
import android.pim.ICalendar;
import android.provider.BaseColumns;
import android.provider.SyncStateContract;
import android.text.TextUtils;
import android.text.format.Time;
import android.util.Log;

public final class Calendar {
    public static final String AUTHORITY = "com.android.calendar";
    public static final String CALLER_IS_SYNCADAPTER = "caller_is_syncadapter";
    public static final Uri CONTENT_URI = Uri.parse("content://com.android.calendar");
    public static final String EVENT_BEGIN_TIME = "beginTime";
    public static final String EVENT_END_TIME = "endTime";
    public static final String EVENT_REMINDER_ACTION = "android.intent.action.EVENT_REMINDER";
    public static final String TAG = "Calendar";

    public static final class SyncState
    implements SyncStateContract.Columns {
        public static final String CONTENT_DIRECTORY = "syncstate";
        public static final Uri CONTENT_URI = Uri.withAppendedPath(CONTENT_URI, "syncstate");

        private SyncState() {
        }
    }

    public static final class ExtendedProperties
    implements BaseColumns,
    ExtendedPropertiesColumns,
    EventsColumns {
        public static final Uri CONTENT_URI = Uri.parse("content://com.android.calendar/extendedproperties");
    }

    public static interface ExtendedPropertiesColumns {
        public static final String EVENT_ID = "event_id";
        public static final String NAME = "name";
        public static final String VALUE = "value";
    }

    public static final class CalendarAlerts
    implements BaseColumns,
    CalendarAlertsColumns,
    EventsColumns,
    CalendarsColumns {
        public static final Uri CONTENT_URI = Uri.parse("content://com.android.calendar/calendar_alerts");
        public static final Uri CONTENT_URI_BY_INSTANCE = Uri.parse("content://com.android.calendar/calendar_alerts/by_instance");
        private static final boolean DEBUG = true;
        private static final String SORT_ORDER_ALARMTIME_ASC = "alarmTime ASC";
        public static final String TABLE_NAME = "CalendarAlerts";
        private static final String WHERE_ALARM_EXISTS = "event_id=? AND begin=? AND alarmTime=?";
        private static final String WHERE_FINDNEXTALARMTIME = "alarmTime>=?";
        private static final String WHERE_RESCHEDULE_MISSED_ALARMS = "state=0 AND alarmTime<? AND alarmTime>? AND end>=?";

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static final boolean alarmExists(ContentResolver contentResolver, long l, long l2, long l3) {
            String string2;
            String string3;
            String[] stringArray = new String[]{"alarmTime"};
            String string4 = Long.toString(l);
            String[] stringArray2 = new String[]{string4, string3 = Long.toString(l2), string2 = Long.toString(l3)};
            Cursor cursor = CalendarAlerts.query(contentResolver, stringArray, WHERE_ALARM_EXISTS, stringArray2, null);
            boolean bl = false;
            if (cursor == null) return bl;
            try {
                int n = cursor.getCount();
                if (n <= 0) return bl;
                bl = true;
                return bl;
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static final long findNextAlarmTime(ContentResolver contentResolver, long l) {
            String string2 = "alarmTime>=" + l;
            String[] stringArray = new String[]{"alarmTime"};
            String string3 = Long.toString(l);
            String[] stringArray2 = new String[]{string3};
            Cursor cursor = CalendarAlerts.query(contentResolver, stringArray, WHERE_FINDNEXTALARMTIME, stringArray2, SORT_ORDER_ALARMTIME_ASC);
            long l2 = 65535L;
            if (cursor == null) return l2;
            try {
                long l3;
                if (!cursor.moveToFirst()) return l2;
                l2 = l3 = cursor.getLong(0);
                return l2;
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }

        public static final Uri insert(ContentResolver contentResolver, long l, long l2, long l3, long l4, int n) {
            ContentValues contentValues = new ContentValues();
            Long l5 = l;
            contentValues.put("event_id", l5);
            Long l6 = l2;
            contentValues.put("begin", l6);
            Long l7 = l3;
            contentValues.put("end", l7);
            Long l8 = l4;
            contentValues.put("alarmTime", l8);
            Long l9 = System.currentTimeMillis();
            contentValues.put("creationTime", l9);
            Integer n2 = 0;
            contentValues.put("receivedTime", n2);
            Integer n3 = 0;
            contentValues.put("notifyTime", n3);
            Integer n4 = 0;
            contentValues.put("state", n4);
            Integer n5 = n;
            contentValues.put("minutes", n5);
            Uri uri = CONTENT_URI;
            return contentResolver.insert(uri, contentValues);
        }

        public static final Cursor query(ContentResolver contentResolver, String[] stringArray, String string2, String[] stringArray2, String string3) {
            Uri uri = CONTENT_URI;
            ContentResolver contentResolver2 = contentResolver;
            String[] stringArray3 = stringArray;
            String string4 = string2;
            String[] stringArray4 = stringArray2;
            String string5 = string3;
            return contentResolver2.query(uri, stringArray3, string4, stringArray4, string5);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static final void rescheduleMissedAlarms(ContentResolver contentResolver, Context context, AlarmManager alarmManager) {
            String string2;
            String string3;
            long l = System.currentTimeMillis();
            long l2 = l - 86400000L;
            String[] stringArray = new String[]{"alarmTime"};
            String string4 = Long.toString(l);
            String[] stringArray2 = new String[]{string4, string3 = Long.toString(l2), string2 = Long.toString(l)};
            Cursor cursor = CalendarAlerts.query(contentResolver, stringArray, WHERE_RESCHEDULE_MISSED_ALARMS, stringArray2, SORT_ORDER_ALARMTIME_ASC);
            if (cursor == null) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder().append("missed alarms found: ");
            int n = cursor.getCount();
            String string5 = stringBuilder.append(n).toString();
            int n2 = Log.d(Calendar.TAG, string5);
            long l3 = 65535L;
            try {
                while (true) {
                    if (!cursor.moveToNext()) {
                        cursor.close();
                        return;
                    }
                    long l4 = cursor.getLong(0);
                    if (l3 == l4) continue;
                    String string6 = "rescheduling missed alarm. alarmTime: " + l4;
                    int n3 = Log.w(Calendar.TAG, string6);
                    CalendarAlerts.scheduleAlarm(context, alarmManager, l4);
                    long l5 = l4;
                }
            }
            catch (Throwable throwable) {
                cursor.close();
                throw throwable;
            }
        }

        public static void scheduleAlarm(Context context, AlarmManager alarmManager, long l) {
            Time time = new Time();
            time.set(l);
            String string2 = time.format(" %a, %b %d, %Y %I:%M%P");
            String string3 = "Schedule alarm at " + l + " " + string2;
            int n = Log.d(Calendar.TAG, string3);
            if (alarmManager == null) {
                alarmManager = (AlarmManager)context.getSystemService("alarm");
            }
            Intent intent = new Intent(Calendar.EVENT_REMINDER_ACTION);
            Uri uri = ContentUris.withAppendedId(CONTENT_URI, l);
            Intent intent2 = intent.setData(uri);
            Intent intent3 = intent.putExtra("alarmTime", l);
            PendingIntent pendingIntent = PendingIntent.getBroadcast(context, 0, intent, 0);
            alarmManager.set(0, l, pendingIntent);
        }
    }

    public static interface CalendarAlertsColumns {
        public static final String ALARM_TIME = "alarmTime";
        public static final String BEGIN = "begin";
        public static final String CREATION_TIME = "creationTime";
        public static final String DEFAULT_SORT_ORDER = "begin ASC,title ASC";
        public static final int DISMISSED = 2;
        public static final String END = "end";
        public static final String EVENT_ID = "event_id";
        public static final int FIRED = 1;
        public static final String MINUTES = "minutes";
        public static final String NOTIFY_TIME = "notifyTime";
        public static final String RECEIVED_TIME = "receivedTime";
        public static final int SCHEDULED = 0;
        public static final String STATE = "state";
    }

    public static final class Reminders
    implements BaseColumns,
    RemindersColumns,
    EventsColumns {
        public static final Uri CONTENT_URI = Uri.parse("content://com.android.calendar/reminders");
        public static final String TABLE_NAME = "Reminders";
    }

    public static interface RemindersColumns {
        public static final String EVENT_ID = "event_id";
        public static final String METHOD = "method";
        public static final int METHOD_ALERT = 1;
        public static final int METHOD_DEFAULT = 0;
        public static final int METHOD_EMAIL = 2;
        public static final int METHOD_SMS = 3;
        public static final String MINUTES = "minutes";
        public static final int MINUTES_DEFAULT = 255;
    }

    public static final class EventDays
    implements EventDaysColumns {
        public static final Uri CONTENT_URI = Uri.parse("content://com.android.calendar/instances/groupbyday");
        public static final String[] PROJECTION;
        public static final String SELECTION = "selected=1";

        static {
            String[] stringArray = new String[]{"startDay", "endDay"};
            PROJECTION = stringArray;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static final Cursor query(ContentResolver contentResolver, int n, int n2) {
            if (n2 < 1) {
                return null;
            }
            int n3 = n + n2 - 1;
            Uri.Builder builder = CONTENT_URI.buildUpon();
            long l = n;
            Uri.Builder builder2 = ContentUris.appendId(builder, l);
            long l2 = n3;
            Uri.Builder builder3 = ContentUris.appendId(builder, l2);
            Uri uri = builder.build();
            String[] stringArray = PROJECTION;
            return contentResolver.query(uri, stringArray, SELECTION, null, "startDay");
        }
    }

    public static interface EventDaysColumns {
        public static final String ENDDAY = "endDay";
        public static final String STARTDAY = "startDay";
    }

    public static final class CalendarMetaData
    implements CalendarMetaDataColumns {
    }

    public static interface CalendarMetaDataColumns {
        public static final String LOCAL_TIMEZONE = "localTimezone";
        public static final String MAX_EVENTDAYS = "maxEventDays";
        public static final String MAX_INSTANCE = "maxInstance";
        public static final String MIN_EVENTDAYS = "minEventDays";
        public static final String MIN_INSTANCE = "minInstance";
    }

    public static class CalendarCache
    implements CalendarCacheColumns {
        public static final String[] POJECTION;
        public static final String TIMEZONE_KEY_INSTANCES = "timezoneInstances";
        public static final String TIMEZONE_KEY_INSTANCES_PREVIOUS = "timezoneInstancesPrevious";
        public static final String TIMEZONE_KEY_TYPE = "timezoneType";
        public static final String TIMEZONE_TYPE_AUTO = "auto";
        public static final String TIMEZONE_TYPE_HOME = "home";
        public static final Uri URI;
        public static final String WHERE = "key=?";

        static {
            URI = Uri.parse("content://com.android.calendar/properties");
            String[] stringArray = new String[]{"key", "value"};
            POJECTION = stringArray;
        }
    }

    public static interface CalendarCacheColumns {
        public static final String KEY = "key";
        public static final String VALUE = "value";
    }

    public static final class Instances
    implements BaseColumns,
    EventsColumns,
    CalendarsColumns {
        public static final String BEGIN = "begin";
        public static final Uri CONTENT_BY_DAY_URI;
        public static final Uri CONTENT_URI;
        public static final String DEFAULT_SORT_ORDER = "begin ASC";
        public static final String END = "end";
        public static final String END_DAY = "endDay";
        public static final String END_MINUTE = "endMinute";
        public static final String EVENT_ID = "event_id";
        public static final String SORT_CALENDAR_VIEW = "begin ASC, end DESC, title ASC";
        public static final String START_DAY = "startDay";
        public static final String START_MINUTE = "startMinute";
        private static final String WHERE_CALENDARS_SELECTED = "selected=1";

        static {
            CONTENT_URI = Uri.parse("content://com.android.calendar/instances/when");
            CONTENT_BY_DAY_URI = Uri.parse("content://com.android.calendar/instances/whenbyday");
        }

        public static final Cursor query(ContentResolver contentResolver, String[] stringArray, long l, long l2) {
            Uri.Builder builder = CONTENT_URI.buildUpon();
            Uri.Builder builder2 = ContentUris.appendId(builder, l);
            Uri.Builder builder3 = ContentUris.appendId(builder, l2);
            Uri uri = builder.build();
            ContentResolver contentResolver2 = contentResolver;
            String[] stringArray2 = stringArray;
            return contentResolver2.query(uri, stringArray2, WHERE_CALENDARS_SELECTED, null, DEFAULT_SORT_ORDER);
        }

        /*
         * Enabled aggressive block sorting
         */
        public static final Cursor query(ContentResolver contentResolver, String[] stringArray, long l, long l2, String string2, String string3) {
            Uri.Builder builder = CONTENT_URI.buildUpon();
            Uri.Builder builder2 = ContentUris.appendId(builder, l);
            Uri.Builder builder3 = ContentUris.appendId(builder, l2);
            String string4 = TextUtils.isEmpty(string2) ? WHERE_CALENDARS_SELECTED : "(" + string2 + ") AND " + WHERE_CALENDARS_SELECTED;
            Uri uri = builder.build();
            String[] stringArray2 = null;
            String string5 = string3 == null ? DEFAULT_SORT_ORDER : string3;
            ContentResolver contentResolver2 = contentResolver;
            String[] stringArray3 = stringArray;
            String string6 = string4;
            return contentResolver2.query(uri, stringArray3, string6, stringArray2, string5);
        }
    }

    public static final class Events
    implements BaseColumns,
    EventsColumns,
    CalendarsColumns {
        private static final String[] ATTENDEES_COLUMNS;
        public static final Uri CONTENT_URI;
        public static final String DEFAULT_SORT_ORDER = "";
        public static final Uri DELETED_CONTENT_URI;
        private static final String[] FETCH_ENTRY_COLUMNS;

        static {
            String[] stringArray = new String[]{"_sync_account", "_sync_id"};
            FETCH_ENTRY_COLUMNS = stringArray;
            String[] stringArray2 = new String[]{"attendeeName", "attendeeEmail", "attendeeRelationship", "attendeeType", "attendeeStatus"};
            ATTENDEES_COLUMNS = stringArray2;
            CONTENT_URI = Uri.parse("content://com.android.calendar/events");
            DELETED_CONTENT_URI = Uri.parse("content://com.android.calendar/deleted_events");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static String extractValue(ICalendar.Component component, String string2) {
            ICalendar.Property property = component.getFirstProperty(string2);
            if (property == null) return null;
            return property.getValue();
        }

        public static final Cursor query(ContentResolver contentResolver, String[] stringArray) {
            Uri uri = CONTENT_URI;
            ContentResolver contentResolver2 = contentResolver;
            String[] stringArray2 = stringArray;
            String[] stringArray3 = null;
            return contentResolver2.query(uri, stringArray2, null, stringArray3, DEFAULT_SORT_ORDER);
        }

        /*
         * Enabled aggressive block sorting
         */
        public static final Cursor query(ContentResolver contentResolver, String[] stringArray, String string2, String string3) {
            Uri uri = CONTENT_URI;
            String string4 = string3 == null ? DEFAULT_SORT_ORDER : string3;
            ContentResolver contentResolver2 = contentResolver;
            String[] stringArray2 = stringArray;
            String string5 = string2;
            return contentResolver2.query(uri, stringArray2, string5, null, string4);
        }
    }

    public static final class EventsEntity
    implements BaseColumns,
    EventsColumns,
    CalendarsColumns {
        public static final Uri CONTENT_URI = Uri.parse("content://com.android.calendar/event_entities");

        public static EntityIterator newEntityIterator(Cursor cursor, ContentProviderClient contentProviderClient) {
            return new EntityIteratorImpl(cursor, contentProviderClient);
        }

        public static EntityIterator newEntityIterator(Cursor cursor, ContentResolver contentResolver) {
            return new EntityIteratorImpl(cursor, contentResolver);
        }

        private static class EntityIteratorImpl
        extends CursorEntityIterator {
            private static final String[] ATTENDEES_PROJECTION;
            private static final int COLUMN_ATTENDEE_EMAIL = 1;
            private static final int COLUMN_ATTENDEE_NAME = 0;
            private static final int COLUMN_ATTENDEE_RELATIONSHIP = 2;
            private static final int COLUMN_ATTENDEE_STATUS = 4;
            private static final int COLUMN_ATTENDEE_TYPE = 3;
            private static final int COLUMN_ID = 0;
            private static final int COLUMN_METHOD = 1;
            private static final int COLUMN_MINUTES = 0;
            private static final int COLUMN_NAME = 1;
            private static final int COLUMN_VALUE = 2;
            private static final String[] EXTENDED_PROJECTION;
            private static final String[] REMINDERS_PROJECTION;
            private static final String WHERE_EVENT_ID = "event_id=?";
            private final ContentProviderClient mProvider;
            private final ContentResolver mResolver;

            static {
                String[] stringArray = new String[]{"minutes", "method"};
                REMINDERS_PROJECTION = stringArray;
                String[] stringArray2 = new String[]{"attendeeName", "attendeeEmail", "attendeeRelationship", "attendeeType", "attendeeStatus"};
                ATTENDEES_PROJECTION = stringArray2;
                String[] stringArray3 = new String[]{"_id", "name", "value"};
                EXTENDED_PROJECTION = stringArray3;
            }

            public EntityIteratorImpl(Cursor cursor, ContentProviderClient contentProviderClient) {
                super(cursor);
                this.mResolver = null;
                this.mProvider = contentProviderClient;
            }

            public EntityIteratorImpl(Cursor cursor, ContentResolver contentResolver) {
                super(cursor);
                this.mResolver = contentResolver;
                this.mProvider = null;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Entity getEntityAndIncrementCursor(Cursor cursor) throws RemoteException {
                Cursor cursor2;
                Cursor cursor3;
                Cursor cursor4;
                int n = cursor.getColumnIndexOrThrow("_id");
                long l = cursor.getLong(n);
                ContentValues contentValues = new ContentValues();
                Long l2 = l;
                contentValues.put("_id", l2);
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, contentValues, "calendar_id");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "htmlUri");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "title");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "description");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "eventLocation");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, contentValues, "eventStatus");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, contentValues, "selfAttendeeStatus");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "commentsUri");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, contentValues, "dtstart");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, contentValues, "dtend");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "duration");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "eventTimezone");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "allDay");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, contentValues, "visibility");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, contentValues, "transparency");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "hasAlarm");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "hasExtendedProperties");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "rrule");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "rdate");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "exrule");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "exdate");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "originalEvent");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, contentValues, "originalInstanceTime");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, contentValues, "originalAllDay");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, contentValues, "lastDate");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, contentValues, "hasAttendeeData");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, contentValues, "guestsCanInviteOthers");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, contentValues, "guestsCanModify");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, contentValues, "guestsCanSeeGuests");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "organizer");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "_sync_id");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "_sync_local_id");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, contentValues, "_sync_dirty");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "_sync_version");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, contentValues, "deleted");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "url");
                Entity entity = new Entity(contentValues);
                if (this.mResolver != null) {
                    ContentResolver contentResolver = this.mResolver;
                    Uri uri = Reminders.CONTENT_URI;
                    String[] stringArray = REMINDERS_PROJECTION;
                    String string2 = Long.toString(l);
                    String[] stringArray2 = new String[]{string2};
                    cursor4 = contentResolver.query(uri, stringArray, WHERE_EVENT_ID, stringArray2, null);
                } else {
                    ContentProviderClient contentProviderClient = this.mProvider;
                    Uri uri = Reminders.CONTENT_URI;
                    String[] stringArray = REMINDERS_PROJECTION;
                    String string3 = Long.toString(l);
                    String[] stringArray3 = new String[]{string3};
                    cursor4 = contentProviderClient.query(uri, stringArray, WHERE_EVENT_ID, stringArray3, null);
                }
                try {
                    while (cursor4.moveToNext()) {
                        ContentValues contentValues2 = new ContentValues();
                        Integer n2 = cursor4.getInt(0);
                        contentValues2.put("minutes", n2);
                        Integer n3 = cursor4.getInt(1);
                        contentValues2.put("method", n3);
                        Uri uri = Reminders.CONTENT_URI;
                        entity.addSubValue(uri, contentValues2);
                    }
                }
                finally {
                    cursor4.close();
                }
                if (this.mResolver != null) {
                    ContentResolver contentResolver = this.mResolver;
                    Uri uri = Attendees.CONTENT_URI;
                    String[] stringArray = ATTENDEES_PROJECTION;
                    String string4 = Long.toString(l);
                    String[] stringArray4 = new String[]{string4};
                    cursor3 = contentResolver.query(uri, stringArray, WHERE_EVENT_ID, stringArray4, null);
                } else {
                    ContentProviderClient contentProviderClient = this.mProvider;
                    Uri uri = Attendees.CONTENT_URI;
                    String[] stringArray = ATTENDEES_PROJECTION;
                    String string5 = Long.toString(l);
                    String[] stringArray5 = new String[]{string5};
                    cursor3 = contentProviderClient.query(uri, stringArray, WHERE_EVENT_ID, stringArray5, null);
                }
                try {
                    while (cursor3.moveToNext()) {
                        ContentValues contentValues3 = new ContentValues();
                        String string6 = cursor3.getString(0);
                        contentValues3.put("attendeeName", string6);
                        String string7 = cursor3.getString(1);
                        contentValues3.put("attendeeEmail", string7);
                        Integer n4 = cursor3.getInt(2);
                        contentValues3.put("attendeeRelationship", n4);
                        Integer n5 = cursor3.getInt(3);
                        contentValues3.put("attendeeType", n5);
                        Integer n6 = cursor3.getInt(4);
                        contentValues3.put("attendeeStatus", n6);
                        Uri uri = Attendees.CONTENT_URI;
                        entity.addSubValue(uri, contentValues3);
                    }
                }
                finally {
                    cursor3.close();
                }
                if (this.mResolver != null) {
                    ContentResolver contentResolver = this.mResolver;
                    Uri uri = ExtendedProperties.CONTENT_URI;
                    String[] stringArray = EXTENDED_PROJECTION;
                    String string8 = Long.toString(l);
                    String[] stringArray6 = new String[]{string8};
                    cursor2 = contentResolver.query(uri, stringArray, WHERE_EVENT_ID, stringArray6, null);
                } else {
                    ContentProviderClient contentProviderClient = this.mProvider;
                    Uri uri = ExtendedProperties.CONTENT_URI;
                    String[] stringArray = EXTENDED_PROJECTION;
                    String string9 = Long.toString(l);
                    String[] stringArray7 = new String[]{string9};
                    cursor2 = contentProviderClient.query(uri, stringArray, WHERE_EVENT_ID, stringArray7, null);
                }
                try {
                    while (cursor2.moveToNext()) {
                        ContentValues contentValues4 = new ContentValues();
                        String string10 = cursor2.getString(0);
                        contentValues4.put("_id", string10);
                        String string11 = cursor2.getString(1);
                        contentValues4.put("name", string11);
                        String string12 = cursor2.getString(2);
                        contentValues4.put("value", string12);
                        Uri uri = ExtendedProperties.CONTENT_URI;
                        entity.addSubValue(uri, contentValues4);
                    }
                }
                finally {
                    cursor2.close();
                }
                boolean bl = cursor.moveToNext();
                return entity;
            }
        }
    }

    public static interface EventsColumns {
        public static final String ALL_DAY = "allDay";
        public static final String CALENDAR_ID = "calendar_id";
        public static final String CAN_INVITE_OTHERS = "canInviteOthers";
        public static final String COMMENTS_URI = "commentsUri";
        public static final String DELETED = "deleted";
        public static final String DESCRIPTION = "description";
        public static final String DTEND = "dtend";
        public static final String DTSTART = "dtstart";
        public static final String DURATION = "duration";
        public static final String EVENT_LOCATION = "eventLocation";
        public static final String EVENT_TIMEZONE = "eventTimezone";
        public static final String EXDATE = "exdate";
        public static final String EXRULE = "exrule";
        public static final String GUESTS_CAN_INVITE_OTHERS = "guestsCanInviteOthers";
        public static final String GUESTS_CAN_MODIFY = "guestsCanModify";
        public static final String GUESTS_CAN_SEE_GUESTS = "guestsCanSeeGuests";
        public static final String HAS_ALARM = "hasAlarm";
        public static final String HAS_ATTENDEE_DATA = "hasAttendeeData";
        public static final String HAS_EXTENDED_PROPERTIES = "hasExtendedProperties";
        public static final String HTML_URI = "htmlUri";
        public static final String LAST_DATE = "lastDate";
        public static final String ORGANIZER = "organizer";
        public static final String ORIGINAL_ALL_DAY = "originalAllDay";
        public static final String ORIGINAL_EVENT = "originalEvent";
        public static final String ORIGINAL_INSTANCE_TIME = "originalInstanceTime";
        public static final String OWNER_ACCOUNT = "ownerAccount";
        public static final String RDATE = "rdate";
        public static final String RRULE = "rrule";
        public static final String SELF_ATTENDEE_STATUS = "selfAttendeeStatus";
        public static final String STATUS = "eventStatus";
        public static final int STATUS_CANCELED = 2;
        public static final int STATUS_CONFIRMED = 1;
        public static final int STATUS_TENTATIVE = 0;
        public static final String SYNC_ADAPTER_DATA = "syncAdapterData";
        public static final String TITLE = "title";
        public static final String TRANSPARENCY = "transparency";
        public static final int TRANSPARENCY_OPAQUE = 0;
        public static final int TRANSPARENCY_TRANSPARENT = 1;
        public static final String VISIBILITY = "visibility";
        public static final int VISIBILITY_CONFIDENTIAL = 1;
        public static final int VISIBILITY_DEFAULT = 0;
        public static final int VISIBILITY_PRIVATE = 2;
        public static final int VISIBILITY_PUBLIC = 3;
    }

    public static final class Attendees
    implements BaseColumns,
    AttendeesColumns,
    EventsColumns {
        public static final Uri CONTENT_URI = Uri.parse("content://com.android.calendar/attendees");
    }

    public static interface AttendeesColumns {
        public static final String ATTENDEE_EMAIL = "attendeeEmail";
        public static final String ATTENDEE_NAME = "attendeeName";
        public static final String ATTENDEE_RELATIONSHIP = "attendeeRelationship";
        public static final String ATTENDEE_STATUS = "attendeeStatus";
        public static final int ATTENDEE_STATUS_ACCEPTED = 1;
        public static final int ATTENDEE_STATUS_DECLINED = 2;
        public static final int ATTENDEE_STATUS_INVITED = 3;
        public static final int ATTENDEE_STATUS_NONE = 0;
        public static final int ATTENDEE_STATUS_TENTATIVE = 4;
        public static final String ATTENDEE_TYPE = "attendeeType";
        public static final String EVENT_ID = "event_id";
        public static final int RELATIONSHIP_ATTENDEE = 1;
        public static final int RELATIONSHIP_NONE = 0;
        public static final int RELATIONSHIP_ORGANIZER = 2;
        public static final int RELATIONSHIP_PERFORMER = 3;
        public static final int RELATIONSHIP_SPEAKER = 4;
        public static final int TYPE_NONE = 0;
        public static final int TYPE_OPTIONAL = 2;
        public static final int TYPE_REQUIRED = 1;
    }

    public static class Calendars
    implements BaseColumns,
    CalendarsColumns {
        public static final Uri CONTENT_URI = Uri.parse("content://com.android.calendar/calendars");
        public static final String DEFAULT_SORT_ORDER = "displayName";
        public static final String DISPLAY_NAME = "displayName";
        public static final String HIDDEN = "hidden";
        public static final String LOCATION = "location";
        public static final String NAME = "name";
        public static final String ORGANIZER_CAN_RESPOND = "organizerCanRespond";
        public static final String OWNER_ACCOUNT = "ownerAccount";
        public static final String URL = "url";
        private static final String WHERE_DELETE_FOR_ACCOUNT = "_sync_account=? AND _sync_account_type=?";

        public static int delete(ContentResolver contentResolver, String string2, String[] stringArray) {
            Uri uri = CONTENT_URI;
            return contentResolver.delete(uri, string2, stringArray);
        }

        public static int deleteCalendarsForAccount(ContentResolver contentResolver, Account account) {
            String string2 = account.name;
            String string3 = account.type;
            String[] stringArray = new String[]{string2, string3};
            return Calendars.delete(contentResolver, WHERE_DELETE_FOR_ACCOUNT, stringArray);
        }

        /*
         * Enabled aggressive block sorting
         */
        public static final Cursor query(ContentResolver contentResolver, String[] stringArray, String string2, String string3) {
            Uri uri = CONTENT_URI;
            String string4 = string3 == null ? "displayName" : string3;
            ContentResolver contentResolver2 = contentResolver;
            String[] stringArray2 = stringArray;
            String string5 = string2;
            return contentResolver2.query(uri, stringArray2, string5, null, string4);
        }
    }

    public static interface CalendarsColumns {
        public static final String ACCESS_LEVEL = "access_level";
        public static final String ACCOUNT_NAME = "account_name";
        public static final String ACCOUNT_TYPE = "account_type";
        public static final String COLOR = "color";
        public static final int CONTRIBUTOR_ACCESS = 500;
        public static final int EDITOR_ACCESS = 600;
        public static final int FREEBUSY_ACCESS = 100;
        public static final int NO_ACCESS = 0;
        public static final int OVERRIDE_ACCESS = 400;
        public static final int OWNER_ACCESS = 700;
        public static final int READ_ACCESS = 200;
        public static final int RESPOND_ACCESS = 300;
        public static final int ROOT_ACCESS = 800;
        public static final String SELECTED = "selected";
        public static final String SYNC_EVENTS = "sync_events";
        public static final String SYNC_STATE = "sync_state";
        public static final String TIMEZONE = "timezone";
        public static final String _SYNC_ACCOUNT = "_sync_account";
        public static final String _SYNC_ACCOUNT_TYPE = "_sync_account_type";
        public static final String _SYNC_DATA = "_sync_local_id";
        public static final String _SYNC_DIRTY = "_sync_dirty";
        public static final String _SYNC_ID = "_sync_id";
        public static final String _SYNC_MARK = "_sync_mark";
        public static final String _SYNC_TIME = "_sync_time";
        public static final String _SYNC_VERSION = "_sync_version";
    }
}

