/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.accounts.Account;
import android.content.ContentProviderClient;
import android.content.ContentProviderOperation;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.CursorEntityIterator;
import android.content.Entity;
import android.content.EntityIterator;
import android.content.Intent;
import android.content.res.Resources;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteException;
import android.graphics.Rect;
import android.net.Uri;
import android.os.RemoteException;
import android.provider.BaseColumns;
import android.provider.SyncStateContract;
import android.text.TextUtils;
import android.util.Pair;
import android.view.View;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public final class ContactsContract {
    public static final String AUTHORITY = "com.android.contacts";
    public static final Uri AUTHORITY_URI = Uri.parse("content://com.android.contacts");
    public static final String CALLER_IS_SYNCADAPTER = "caller_is_syncadapter";
    public static final String REQUESTING_PACKAGE_PARAM_KEY = "requesting_package";

    public static final class Intents {
        public static final String ATTACH_IMAGE = "com.android.contacts.action.ATTACH_IMAGE";
        public static final String EXTRA_CREATE_DESCRIPTION = "com.android.contacts.action.CREATE_DESCRIPTION";
        @Deprecated
        public static final String EXTRA_EXCLUDE_MIMES = "exclude_mimes";
        public static final String EXTRA_FORCE_CREATE = "com.android.contacts.action.FORCE_CREATE";
        @Deprecated
        public static final String EXTRA_MODE = "mode";
        @Deprecated
        public static final String EXTRA_TARGET_RECT = "target_rect";
        @Deprecated
        public static final int MODE_LARGE = 3;
        @Deprecated
        public static final int MODE_MEDIUM = 2;
        @Deprecated
        public static final int MODE_SMALL = 1;
        public static final String SEARCH_SUGGESTION_CLICKED = "android.provider.Contacts.SEARCH_SUGGESTION_CLICKED";
        public static final String SEARCH_SUGGESTION_CREATE_CONTACT_CLICKED = "android.provider.Contacts.SEARCH_SUGGESTION_CREATE_CONTACT_CLICKED";
        public static final String SEARCH_SUGGESTION_DIAL_NUMBER_CLICKED = "android.provider.Contacts.SEARCH_SUGGESTION_DIAL_NUMBER_CLICKED";
        public static final String SHOW_OR_CREATE_CONTACT = "com.android.contacts.action.SHOW_OR_CREATE_CONTACT";

        public static final class Insert {
            public static final String ACTION = "android.intent.action.INSERT";
            public static final String COMPANY = "company";
            public static final String EMAIL = "email";
            public static final String EMAIL_ISPRIMARY = "email_isprimary";
            public static final String EMAIL_TYPE = "email_type";
            public static final String FULL_MODE = "full_mode";
            public static final String IM_HANDLE = "im_handle";
            public static final String IM_ISPRIMARY = "im_isprimary";
            public static final String IM_PROTOCOL = "im_protocol";
            public static final String JOB_TITLE = "job_title";
            public static final String NAME = "name";
            public static final String NOTES = "notes";
            public static final String PHONE = "phone";
            public static final String PHONETIC_NAME = "phonetic_name";
            public static final String PHONE_ISPRIMARY = "phone_isprimary";
            public static final String PHONE_TYPE = "phone_type";
            public static final String POSTAL = "postal";
            public static final String POSTAL_ISPRIMARY = "postal_isprimary";
            public static final String POSTAL_TYPE = "postal_type";
            public static final String SECONDARY_EMAIL = "secondary_email";
            public static final String SECONDARY_EMAIL_TYPE = "secondary_email_type";
            public static final String SECONDARY_PHONE = "secondary_phone";
            public static final String SECONDARY_PHONE_TYPE = "secondary_phone_type";
            public static final String TERTIARY_EMAIL = "tertiary_email";
            public static final String TERTIARY_EMAIL_TYPE = "tertiary_email_type";
            public static final String TERTIARY_PHONE = "tertiary_phone";
            public static final String TERTIARY_PHONE_TYPE = "tertiary_phone_type";
        }

        public static final class UI {
            public static final String FILTER_CONTACTS_ACTION = "com.android.contacts.action.FILTER_CONTACTS";
            public static final String FILTER_TEXT_EXTRA_KEY = "com.android.contacts.extra.FILTER_TEXT";
            public static final String GROUP_NAME_EXTRA_KEY = "com.android.contacts.extra.GROUP";
            public static final String LIST_ALL_CONTACTS_ACTION = "com.android.contacts.action.LIST_ALL_CONTACTS";
            public static final String LIST_CONTACTS_WITH_PHONES_ACTION = "com.android.contacts.action.LIST_CONTACTS_WITH_PHONES";
            public static final String LIST_DEFAULT = "com.android.contacts.action.LIST_DEFAULT";
            public static final String LIST_FREQUENT_ACTION = "com.android.contacts.action.LIST_FREQUENT";
            public static final String LIST_GROUP_ACTION = "com.android.contacts.action.LIST_GROUP";
            public static final String LIST_STARRED_ACTION = "com.android.contacts.action.LIST_STARRED";
            public static final String LIST_STREQUENT_ACTION = "com.android.contacts.action.LIST_STREQUENT";
            public static final String TITLE_EXTRA_KEY = "com.android.contacts.extra.TITLE_EXTRA";
        }
    }

    public static final class QuickContact {
        public static final String ACTION_QUICK_CONTACT = "com.android.contacts.action.QUICK_CONTACT";
        public static final String EXTRA_EXCLUDE_MIMES = "exclude_mimes";
        public static final String EXTRA_MODE = "mode";
        public static final String EXTRA_SELECTED_CONTACTS_APP_TAB_INDEX = "SELECTED_TAB_INDEX";
        @Deprecated
        public static final String EXTRA_TARGET_RECT = "target_rect";
        public static final int MODE_LARGE = 3;
        public static final int MODE_MEDIUM = 2;
        public static final int MODE_SMALL = 1;

        public static Intent getQuickContactIntent(Context context, Rect rect, Uri uri, int n, String[] stringArray) {
            Intent intent = new Intent(ACTION_QUICK_CONTACT);
            Intent intent2 = intent.setFlags(337641472);
            Intent intent3 = intent.setData(uri);
            intent.setSourceBounds(rect);
            Intent intent4 = intent.putExtra(EXTRA_MODE, n);
            Intent intent5 = intent.putExtra(EXTRA_EXCLUDE_MIMES, stringArray);
            return intent;
        }

        public static Intent getQuickContactIntent(Context context, View view, Uri uri, int n, String[] stringArray) {
            int n2;
            int n3;
            int n4;
            int n5;
            float f = context.getResources().getCompatibilityInfo().applicationScale;
            int[] nArray = new int[2];
            view.getLocationOnScreen(nArray);
            Rect rect = new Rect();
            rect.left = n5 = (int)((float)nArray[0] * f + 0.5f);
            rect.top = n4 = (int)((float)nArray[1] * f + 0.5f);
            int n6 = nArray[0];
            int n7 = view.getWidth();
            rect.right = n3 = (int)((float)(n6 + n7) * f + 0.5f);
            int n8 = nArray[1];
            int n9 = view.getHeight();
            rect.bottom = n2 = (int)((float)(n8 + n9) * f + 0.5f);
            return QuickContact.getQuickContactIntent(context, rect, uri, n, stringArray);
        }

        public static void showQuickContact(Context context, Rect rect, Uri uri, int n, String[] stringArray) {
            Intent intent = QuickContact.getQuickContactIntent(context, rect, uri, n, stringArray);
            context.startActivity(intent);
        }

        public static void showQuickContact(Context context, View view, Uri uri, int n, String[] stringArray) {
            Intent intent = QuickContact.getQuickContactIntent(context, view, uri, n, stringArray);
            context.startActivity(intent);
        }
    }

    public static final class ProviderStatus {
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/provider_status";
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "provider_status");
        public static final String DATA1 = "data1";
        public static final String STATUS = "status";
        public static final int STATUS_CHANGING_LOCALE = 3;
        public static final int STATUS_NORMAL = 0;
        public static final int STATUS_UPGRADE_OUT_OF_MEMORY = 2;
        public static final int STATUS_UPGRADING = 1;

        private ProviderStatus() {
        }
    }

    public static final class Settings
    implements SettingsColumns {
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/setting";
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/setting";
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "settings");

        private Settings() {
        }
    }

    protected static interface SettingsColumns {
        public static final String ACCOUNT_NAME = "account_name";
        public static final String ACCOUNT_TYPE = "account_type";
        public static final String ANY_UNSYNCED = "any_unsynced";
        public static final String SHOULD_SYNC = "should_sync";
        public static final String UNGROUPED_COUNT = "summ_count";
        public static final String UNGROUPED_VISIBLE = "ungrouped_visible";
        public static final String UNGROUPED_WITH_PHONES = "summ_phones";
    }

    public static final class AggregationExceptions
    implements BaseColumns {
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/aggregation_exception";
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/aggregation_exception";
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "aggregation_exceptions");
        public static final String RAW_CONTACT_ID1 = "raw_contact_id1";
        public static final String RAW_CONTACT_ID2 = "raw_contact_id2";
        public static final String TYPE = "type";
        public static final int TYPE_AUTOMATIC = 0;
        public static final int TYPE_KEEP_SEPARATE = 2;
        public static final int TYPE_KEEP_TOGETHER = 1;

        private AggregationExceptions() {
        }
    }

    public static final class Groups
    implements BaseColumns,
    GroupsColumns,
    SyncColumns {
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/group";
        public static final Uri CONTENT_SUMMARY_URI;
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/group";
        public static final Uri CONTENT_URI;

        static {
            CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "groups");
            CONTENT_SUMMARY_URI = Uri.withAppendedPath(AUTHORITY_URI, "groups_summary");
        }

        private Groups() {
        }

        public static EntityIterator newEntityIterator(Cursor cursor) {
            return new EntityIteratorImpl(cursor);
        }

        private static class EntityIteratorImpl
        extends CursorEntityIterator {
            public EntityIteratorImpl(Cursor cursor) {
                super(cursor);
            }

            @Override
            public Entity getEntityAndIncrementCursor(Cursor cursor) throws RemoteException {
                ContentValues contentValues = new ContentValues();
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, contentValues, "_id");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "account_name");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "account_type");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, contentValues, "dirty");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, contentValues, "version");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "sourceid");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "res_package");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "title");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "title_res");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, contentValues, "group_visible");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "sync1");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "sync2");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "sync3");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "sync4");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "system_id");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, contentValues, "deleted");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "notes");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "should_sync");
                boolean bl = cursor.moveToNext();
                return new Entity(contentValues);
            }
        }
    }

    protected static interface GroupsColumns {
        public static final String DELETED = "deleted";
        public static final String GROUP_VISIBLE = "group_visible";
        public static final String NOTES = "notes";
        public static final String RES_PACKAGE = "res_package";
        public static final String SHOULD_SYNC = "should_sync";
        public static final String SUMMARY_COUNT = "summ_count";
        public static final String SUMMARY_WITH_PHONES = "summ_phones";
        public static final String SYSTEM_ID = "system_id";
        public static final String TITLE = "title";
        public static final String TITLE_RES = "title_res";
    }

    public static final class CommonDataKinds {
        public static final String PACKAGE_COMMON = "common";

        private CommonDataKinds() {
        }

        public static final class SipAddress
        implements DataColumnsWithJoins,
        CommonColumns {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/sip_address";
            public static final String SIP_ADDRESS = "data1";
            public static final int TYPE_HOME = 1;
            public static final int TYPE_OTHER = 3;
            public static final int TYPE_WORK = 2;

            private SipAddress() {
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public static final CharSequence getTypeLabel(Resources resources, int n, CharSequence charSequence) {
                if (n == 0 && !TextUtils.isEmpty(charSequence)) {
                    return charSequence;
                }
                int n2 = SipAddress.getTypeLabelResource(n);
                return resources.getText(n2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public static final int getTypeLabelResource(int n) {
                switch (n) {
                    default: {
                        return 17039989;
                    }
                    case 1: {
                        return 17039990;
                    }
                    case 2: {
                        return 17039991;
                    }
                    case 3: 
                }
                return 17039992;
            }
        }

        public static final class Website
        implements DataColumnsWithJoins,
        CommonColumns {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/website";
            public static final int TYPE_BLOG = 2;
            public static final int TYPE_FTP = 6;
            public static final int TYPE_HOME = 4;
            public static final int TYPE_HOMEPAGE = 1;
            public static final int TYPE_OTHER = 7;
            public static final int TYPE_PROFILE = 3;
            public static final int TYPE_WORK = 5;
            public static final String URL = "data1";

            private Website() {
            }
        }

        public static final class GroupMembership
        implements DataColumnsWithJoins {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/group_membership";
            public static final String GROUP_ROW_ID = "data1";
            public static final String GROUP_SOURCE_ID = "group_sourceid";

            private GroupMembership() {
            }
        }

        public static final class Note
        implements DataColumnsWithJoins {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/note";
            public static final String NOTE = "data1";

            private Note() {
            }
        }

        public static final class Photo
        implements DataColumnsWithJoins {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/photo";
            public static final String PHOTO = "data15";

            private Photo() {
            }
        }

        public static final class Event
        implements DataColumnsWithJoins,
        CommonColumns {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/contact_event";
            public static final String START_DATE = "data1";
            public static final int TYPE_ANNIVERSARY = 1;
            public static final int TYPE_BIRTHDAY = 3;
            public static final int TYPE_OTHER = 2;

            private Event() {
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public static int getTypeResource(Integer n) {
                if (n == null) {
                    return 17039962;
                }
                switch (n) {
                    default: {
                        return 17039962;
                    }
                    case 1: {
                        return 17039961;
                    }
                    case 3: {
                        return 17039960;
                    }
                    case 2: 
                }
                return 17039962;
            }
        }

        public static final class Relation
        implements DataColumnsWithJoins,
        CommonColumns {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/relation";
            public static final String NAME = "data1";
            public static final int TYPE_ASSISTANT = 1;
            public static final int TYPE_BROTHER = 2;
            public static final int TYPE_CHILD = 3;
            public static final int TYPE_DOMESTIC_PARTNER = 4;
            public static final int TYPE_FATHER = 5;
            public static final int TYPE_FRIEND = 6;
            public static final int TYPE_MANAGER = 7;
            public static final int TYPE_MOTHER = 8;
            public static final int TYPE_PARENT = 9;
            public static final int TYPE_PARTNER = 10;
            public static final int TYPE_REFERRED_BY = 11;
            public static final int TYPE_RELATIVE = 12;
            public static final int TYPE_SISTER = 13;
            public static final int TYPE_SPOUSE = 14;

            private Relation() {
            }
        }

        public static final class Organization
        implements DataColumnsWithJoins,
        CommonColumns {
            public static final String COMPANY = "data1";
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/organization";
            public static final String DEPARTMENT = "data5";
            public static final String JOB_DESCRIPTION = "data6";
            public static final String OFFICE_LOCATION = "data9";
            public static final String PHONETIC_NAME = "data8";
            public static final String PHONETIC_NAME_STYLE = "data10";
            public static final String SYMBOL = "data7";
            public static final String TITLE = "data4";
            public static final int TYPE_OTHER = 2;
            public static final int TYPE_WORK = 1;

            private Organization() {
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public static final CharSequence getTypeLabel(Resources resources, int n, CharSequence charSequence) {
                if (n == 0 && !TextUtils.isEmpty(charSequence)) {
                    return charSequence;
                }
                int n2 = Organization.getTypeLabelResource(n);
                return resources.getText(n2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public static final int getTypeLabelResource(int n) {
                switch (n) {
                    default: {
                        return 17039988;
                    }
                    case 1: {
                        return 17039986;
                    }
                    case 2: 
                }
                return 17039987;
            }
        }

        public static final class Im
        implements DataColumnsWithJoins,
        CommonColumns {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/im";
            public static final String CUSTOM_PROTOCOL = "data6";
            public static final String PROTOCOL = "data5";
            public static final int PROTOCOL_AIM = 0;
            public static final int PROTOCOL_CUSTOM = 255;
            public static final int PROTOCOL_GOOGLE_TALK = 5;
            public static final int PROTOCOL_ICQ = 6;
            public static final int PROTOCOL_JABBER = 7;
            public static final int PROTOCOL_MSN = 1;
            public static final int PROTOCOL_NETMEETING = 8;
            public static final int PROTOCOL_QQ = 4;
            public static final int PROTOCOL_SKYPE = 3;
            public static final int PROTOCOL_YAHOO = 2;
            public static final int TYPE_HOME = 1;
            public static final int TYPE_OTHER = 3;
            public static final int TYPE_WORK = 2;

            private Im() {
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public static final CharSequence getProtocolLabel(Resources resources, int n, CharSequence charSequence) {
                if (n == -1 && !TextUtils.isEmpty(charSequence)) {
                    return charSequence;
                }
                int n2 = Im.getProtocolLabelResource(n);
                return resources.getText(n2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public static final int getProtocolLabelResource(int n) {
                switch (n) {
                    default: {
                        return 17039976;
                    }
                    case 0: {
                        return 17039977;
                    }
                    case 1: {
                        return 17039978;
                    }
                    case 2: {
                        return 17039979;
                    }
                    case 3: {
                        return 17039980;
                    }
                    case 4: {
                        return 17039981;
                    }
                    case 5: {
                        return 17039982;
                    }
                    case 6: {
                        return 17039983;
                    }
                    case 7: {
                        return 17039984;
                    }
                    case 8: 
                }
                return 17039985;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public static final CharSequence getTypeLabel(Resources resources, int n, CharSequence charSequence) {
                if (n == 0 && !TextUtils.isEmpty(charSequence)) {
                    return charSequence;
                }
                int n2 = Im.getTypeLabelResource(n);
                return resources.getText(n2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public static final int getTypeLabelResource(int n) {
                switch (n) {
                    default: {
                        return 17039972;
                    }
                    case 1: {
                        return 17039973;
                    }
                    case 2: {
                        return 17039974;
                    }
                    case 3: 
                }
                return 17039975;
            }
        }

        public static final class StructuredPostal
        implements DataColumnsWithJoins,
        CommonColumns {
            public static final String CITY = "data7";
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/postal-address_v2";
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/postal-address_v2";
            public static final Uri CONTENT_URI = Uri.withAppendedPath(Data.CONTENT_URI, "postals");
            public static final String COUNTRY = "data10";
            public static final String FORMATTED_ADDRESS = "data1";
            public static final String NEIGHBORHOOD = "data6";
            public static final String POBOX = "data5";
            public static final String POSTCODE = "data9";
            public static final String REGION = "data8";
            public static final String STREET = "data4";
            public static final int TYPE_HOME = 1;
            public static final int TYPE_OTHER = 3;
            public static final int TYPE_WORK = 2;

            private StructuredPostal() {
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public static final CharSequence getTypeLabel(Resources resources, int n, CharSequence charSequence) {
                if (n == 0 && !TextUtils.isEmpty(charSequence)) {
                    return charSequence;
                }
                int n2 = StructuredPostal.getTypeLabelResource(n);
                return resources.getText(n2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public static final int getTypeLabelResource(int n) {
                switch (n) {
                    default: {
                        return 17039968;
                    }
                    case 1: {
                        return 17039969;
                    }
                    case 2: {
                        return 17039970;
                    }
                    case 3: 
                }
                return 17039971;
            }
        }

        public static final class Email
        implements DataColumnsWithJoins,
        CommonColumns {
            public static final String ADDRESS = "data1";
            public static final Uri CONTENT_FILTER_URI;
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/email_v2";
            public static final Uri CONTENT_LOOKUP_URI;
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/email_v2";
            public static final Uri CONTENT_URI;
            public static final String DISPLAY_NAME = "data4";
            public static final int TYPE_HOME = 1;
            public static final int TYPE_MOBILE = 4;
            public static final int TYPE_OTHER = 3;
            public static final int TYPE_WORK = 2;

            static {
                CONTENT_URI = Uri.withAppendedPath(Data.CONTENT_URI, "emails");
                CONTENT_LOOKUP_URI = Uri.withAppendedPath(CONTENT_URI, "lookup");
                CONTENT_FILTER_URI = Uri.withAppendedPath(CONTENT_URI, "filter");
            }

            private Email() {
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public static final CharSequence getTypeLabel(Resources resources, int n, CharSequence charSequence) {
                if (n == 0 && !TextUtils.isEmpty(charSequence)) {
                    return charSequence;
                }
                int n2 = Email.getTypeLabelResource(n);
                return resources.getText(n2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public static final int getTypeLabelResource(int n) {
                switch (n) {
                    default: {
                        return 17039963;
                    }
                    case 1: {
                        return 17039964;
                    }
                    case 2: {
                        return 17039965;
                    }
                    case 3: {
                        return 17039966;
                    }
                    case 4: 
                }
                return 17039967;
            }
        }

        public static final class Phone
        implements DataColumnsWithJoins,
        CommonColumns {
            public static final Uri CONTENT_FILTER_URI;
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/phone_v2";
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/phone_v2";
            public static final Uri CONTENT_URI;
            public static final String NUMBER = "data1";
            public static final int TYPE_ASSISTANT = 19;
            public static final int TYPE_CALLBACK = 8;
            public static final int TYPE_CAR = 9;
            public static final int TYPE_COMPANY_MAIN = 10;
            public static final int TYPE_FAX_HOME = 5;
            public static final int TYPE_FAX_WORK = 4;
            public static final int TYPE_HOME = 1;
            public static final int TYPE_ISDN = 11;
            public static final int TYPE_MAIN = 12;
            public static final int TYPE_MMS = 20;
            public static final int TYPE_MOBILE = 2;
            public static final int TYPE_OTHER = 7;
            public static final int TYPE_OTHER_FAX = 13;
            public static final int TYPE_PAGER = 6;
            public static final int TYPE_RADIO = 14;
            public static final int TYPE_TELEX = 15;
            public static final int TYPE_TTY_TDD = 16;
            public static final int TYPE_WORK = 3;
            public static final int TYPE_WORK_MOBILE = 17;
            public static final int TYPE_WORK_PAGER = 18;

            static {
                CONTENT_URI = Uri.withAppendedPath(Data.CONTENT_URI, "phones");
                CONTENT_FILTER_URI = Uri.withAppendedPath(CONTENT_URI, "filter");
            }

            private Phone() {
            }

            @Deprecated
            public static final CharSequence getDisplayLabel(Context context, int n, CharSequence charSequence) {
                return Phone.getTypeLabel(context.getResources(), n, charSequence);
            }

            @Deprecated
            public static final CharSequence getDisplayLabel(Context context, int n, CharSequence charSequence, CharSequence[] charSequenceArray) {
                return Phone.getTypeLabel(context.getResources(), n, charSequence);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public static final CharSequence getTypeLabel(Resources resources, int n, CharSequence charSequence) {
                if (!(n != 0 && n != 19 || TextUtils.isEmpty(charSequence))) {
                    return charSequence;
                }
                int n2 = Phone.getTypeLabelResource(n);
                return resources.getText(n2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public static final int getTypeLabelResource(int n) {
                switch (n) {
                    default: {
                        return 17039939;
                    }
                    case 1: {
                        return 17039940;
                    }
                    case 2: {
                        return 17039941;
                    }
                    case 3: {
                        return 17039942;
                    }
                    case 4: {
                        return 17039943;
                    }
                    case 5: {
                        return 17039944;
                    }
                    case 6: {
                        return 17039945;
                    }
                    case 7: {
                        return 17039946;
                    }
                    case 8: {
                        return 17039947;
                    }
                    case 9: {
                        return 17039948;
                    }
                    case 10: {
                        return 17039949;
                    }
                    case 11: {
                        return 17039950;
                    }
                    case 12: {
                        return 17039951;
                    }
                    case 13: {
                        return 17039952;
                    }
                    case 14: {
                        return 17039953;
                    }
                    case 15: {
                        return 17039954;
                    }
                    case 16: {
                        return 17039955;
                    }
                    case 17: {
                        return 17039956;
                    }
                    case 18: {
                        return 17039957;
                    }
                    case 19: {
                        return 17039958;
                    }
                    case 20: 
                }
                return 17039959;
            }
        }

        public static final class Nickname
        implements DataColumnsWithJoins,
        CommonColumns {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/nickname";
            public static final String NAME = "data1";
            public static final int TYPE_DEFAULT = 1;
            public static final int TYPE_INITIALS = 5;
            public static final int TYPE_MAIDEN_NAME = 3;
            @Deprecated
            public static final int TYPE_MAINDEN_NAME = 3;
            public static final int TYPE_OTHER_NAME = 2;
            public static final int TYPE_SHORT_NAME = 4;

            private Nickname() {
            }
        }

        public static final class StructuredName
        implements DataColumnsWithJoins {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/name";
            public static final String DISPLAY_NAME = "data1";
            public static final String FAMILY_NAME = "data3";
            public static final String FULL_NAME_STYLE = "data10";
            public static final String GIVEN_NAME = "data2";
            public static final String MIDDLE_NAME = "data5";
            public static final String PHONETIC_FAMILY_NAME = "data9";
            public static final String PHONETIC_GIVEN_NAME = "data7";
            public static final String PHONETIC_MIDDLE_NAME = "data8";
            public static final String PHONETIC_NAME_STYLE = "data11";
            public static final String PREFIX = "data4";
            public static final String SUFFIX = "data6";

            private StructuredName() {
            }
        }

        protected static interface CommonColumns
        extends BaseTypes {
            public static final String DATA = "data1";
            public static final String LABEL = "data3";
            public static final String TYPE = "data2";
        }

        public static interface BaseTypes {
            public static final int TYPE_CUSTOM;
        }
    }

    public static class SearchSnippetColumns {
        public static final String SNIPPET_DATA1 = "snippet_data1";
        public static final String SNIPPET_DATA2 = "snippet_data2";
        public static final String SNIPPET_DATA3 = "snippet_data3";
        public static final String SNIPPET_DATA4 = "snippet_data4";
        public static final String SNIPPET_DATA_ID = "snippet_data_id";
        public static final String SNIPPET_MIMETYPE = "snippet_mimetype";
    }

    @Deprecated
    public static final class Presence
    extends StatusUpdates {
    }

    public static class StatusUpdates
    implements StatusColumns,
    PresenceColumns {
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/status-update";
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/status-update";
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "status_updates");

        private StatusUpdates() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static final int getPresenceIconResourceId(int n) {
            switch (n) {
                default: {
                    return 17301610;
                }
                case 5: {
                    return 17301611;
                }
                case 2: 
                case 3: {
                    return 17301607;
                }
                case 4: {
                    return 17301608;
                }
                case 1: 
            }
            return 17301609;
        }

        public static final int getPresencePrecedence(int n) {
            return n;
        }
    }

    protected static interface PresenceColumns {
        public static final String CUSTOM_PROTOCOL = "custom_protocol";
        public static final String DATA_ID = "presence_data_id";
        public static final String IM_ACCOUNT = "im_account";
        public static final String IM_HANDLE = "im_handle";
        public static final String PROTOCOL = "protocol";
    }

    public static final class PhoneLookup
    implements BaseColumns,
    PhoneLookupColumns,
    ContactsColumns,
    ContactOptionsColumns {
        public static final Uri CONTENT_FILTER_URI = Uri.withAppendedPath(AUTHORITY_URI, "phone_lookup");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/phone_lookup";

        private PhoneLookup() {
        }
    }

    protected static interface PhoneLookupColumns {
        public static final String LABEL = "label";
        public static final String NUMBER = "number";
        public static final String TYPE = "type";
    }

    public static final class RawContactsEntity
    implements BaseColumns,
    DataColumns,
    RawContactsColumns {
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/raw_contact_entity";
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "raw_contact_entities");
        public static final String DATA_ID = "data_id";
        public static final String FOR_EXPORT_ONLY = "for_export_only";

        private RawContactsEntity() {
        }
    }

    public static final class Data
    implements DataColumnsWithJoins {
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/data";
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "data");
        public static final String FOR_EXPORT_ONLY = "for_export_only";

        private Data() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static Uri getContactLookupUri(ContentResolver contentResolver, Uri uri) {
            Cursor cursor;
            block3: {
                String[] stringArray = new String[]{"contact_id", "lookup"};
                ContentResolver contentResolver2 = contentResolver;
                Uri uri2 = uri;
                String[] stringArray2 = null;
                String string2 = null;
                cursor = contentResolver2.query(uri2, stringArray, null, stringArray2, string2);
                if (cursor != null) {
                    try {
                        Uri uri3;
                        if (!cursor.moveToFirst()) break block3;
                        long l = cursor.getLong(0);
                        String string3 = cursor.getString(1);
                        Uri uri4 = uri3 = Contacts.getLookupUri(l, string3);
                        if (cursor == null) return uri4;
                        cursor.close();
                        return uri4;
                    }
                    catch (Throwable throwable) {
                        if (cursor == null) throw throwable;
                        cursor.close();
                        throw throwable;
                    }
                }
            }
            if (cursor == null) return null;
            cursor.close();
            return null;
        }
    }

    protected static interface DataColumnsWithJoins
    extends BaseColumns,
    DataColumns,
    StatusColumns,
    RawContactsColumns,
    ContactsColumns,
    ContactNameColumns,
    ContactOptionsColumns,
    ContactStatusColumns {
    }

    protected static interface DataColumns {
        public static final String DATA1 = "data1";
        public static final String DATA10 = "data10";
        public static final String DATA11 = "data11";
        public static final String DATA12 = "data12";
        public static final String DATA13 = "data13";
        public static final String DATA14 = "data14";
        public static final String DATA15 = "data15";
        public static final String DATA2 = "data2";
        public static final String DATA3 = "data3";
        public static final String DATA4 = "data4";
        public static final String DATA5 = "data5";
        public static final String DATA6 = "data6";
        public static final String DATA7 = "data7";
        public static final String DATA8 = "data8";
        public static final String DATA9 = "data9";
        public static final String DATA_VERSION = "data_version";
        public static final String IS_PRIMARY = "is_primary";
        public static final String IS_SUPER_PRIMARY = "is_super_primary";
        public static final String MIMETYPE = "mimetype";
        public static final String RAW_CONTACT_ID = "raw_contact_id";
        public static final String RES_PACKAGE = "res_package";
        public static final String SYNC1 = "data_sync1";
        public static final String SYNC2 = "data_sync2";
        public static final String SYNC3 = "data_sync3";
        public static final String SYNC4 = "data_sync4";
    }

    protected static interface StatusColumns {
        public static final int AVAILABLE = 5;
        public static final int AWAY = 2;
        public static final int CAPABILITY_HAS_CAMERA = 4;
        public static final int CAPABILITY_HAS_VIDEO_PLAYBACK_ONLY = 1;
        public static final int CAPABILITY_HAS_VOICE = 2;
        public static final String CHAT_CAPABILITY = "chat_capability";
        public static final int DO_NOT_DISTURB = 4;
        public static final int IDLE = 3;
        public static final int INVISIBLE = 1;
        public static final int OFFLINE = 0;
        public static final String PRESENCE = "mode";
        @Deprecated
        public static final String PRESENCE_CUSTOM_STATUS = "status";
        @Deprecated
        public static final String PRESENCE_STATUS = "mode";
        public static final String STATUS = "status";
        public static final String STATUS_ICON = "status_icon";
        public static final String STATUS_LABEL = "status_label";
        public static final String STATUS_RES_PACKAGE = "status_res_package";
        public static final String STATUS_TIMESTAMP = "status_ts";
    }

    public static final class RawContacts
    implements BaseColumns,
    RawContactsColumns,
    ContactOptionsColumns,
    ContactNameColumns,
    SyncColumns {
        public static final int AGGREGATION_MODE_DEFAULT = 0;
        public static final int AGGREGATION_MODE_DISABLED = 3;
        public static final int AGGREGATION_MODE_IMMEDIATE = 1;
        public static final int AGGREGATION_MODE_SUSPENDED = 2;
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/raw_contact";
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/raw_contact";
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "raw_contacts");

        private RawContacts() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static Uri getContactLookupUri(ContentResolver contentResolver, Uri uri) {
            Cursor cursor;
            block3: {
                Uri uri2 = Uri.withAppendedPath(uri, "data");
                String[] stringArray = new String[]{"contact_id", "lookup"};
                ContentResolver contentResolver2 = contentResolver;
                String[] stringArray2 = null;
                String string2 = null;
                cursor = contentResolver2.query(uri2, stringArray, null, stringArray2, string2);
                if (cursor != null) {
                    try {
                        Uri uri3;
                        if (!cursor.moveToFirst()) break block3;
                        long l = cursor.getLong(0);
                        String string3 = cursor.getString(1);
                        Uri uri4 = uri3 = Contacts.getLookupUri(l, string3);
                        if (cursor == null) return uri4;
                        cursor.close();
                        return uri4;
                    }
                    catch (Throwable throwable) {
                        if (cursor == null) throw throwable;
                        cursor.close();
                        throw throwable;
                    }
                }
            }
            if (cursor == null) return null;
            cursor.close();
            return null;
        }

        public static EntityIterator newEntityIterator(Cursor cursor) {
            return new EntityIteratorImpl(cursor);
        }

        private static class EntityIteratorImpl
        extends CursorEntityIterator {
            private static final String[] DATA_KEYS;

            static {
                String[] stringArray = new String[]{"data1", "data2", "data3", "data4", "data5", "data6", "data7", "data8", "data9", "data10", "data11", "data12", "data13", "data14", "data15", "data_sync1", "data_sync2", "data_sync3", "data_sync4"};
                DATA_KEYS = stringArray;
            }

            public EntityIteratorImpl(Cursor cursor) {
                super(cursor);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public android.content.Entity getEntityAndIncrementCursor(Cursor cursor) throws RemoteException {
                int n = cursor.getColumnIndexOrThrow("_id");
                long l = cursor.getLong(n);
                ContentValues contentValues = new ContentValues();
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "account_name");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "account_type");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, contentValues, "_id");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, contentValues, "dirty");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, contentValues, "version");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "sourceid");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "sync1");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "sync2");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "sync3");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues, "sync4");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, contentValues, "deleted");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, contentValues, "contact_id");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, contentValues, "starred");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, contentValues, "is_restricted");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, contentValues, "name_verified");
                android.content.Entity entity = new android.content.Entity(contentValues);
                do {
                    long l2;
                    if (l != (l2 = cursor.getLong(n))) {
                        return entity;
                    }
                    ContentValues contentValues2 = new ContentValues();
                    int n2 = cursor.getColumnIndexOrThrow("data_id");
                    Long l3 = cursor.getLong(n2);
                    contentValues2.put("_id", l3);
                    DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues2, "res_package");
                    DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues2, "mimetype");
                    DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, contentValues2, "is_primary");
                    DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, contentValues2, "is_super_primary");
                    DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, contentValues2, "data_version");
                    DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues2, "group_sourceid");
                    DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, contentValues2, "data_version");
                    for (String string2 : DATA_KEYS) {
                        int n3 = cursor.getColumnIndexOrThrow(string2);
                        if (cursor.isNull(n3)) continue;
                        try {
                            String string3 = cursor.getString(n3);
                            contentValues2.put(string2, string3);
                        }
                        catch (SQLiteException sQLiteException) {
                            byte[] byArray = cursor.getBlob(n3);
                            contentValues2.put(string2, byArray);
                        }
                    }
                    Uri uri = android.provider.ContactsContract$Data.CONTENT_URI;
                    entity.addSubValue(uri, contentValues2);
                } while (cursor.moveToNext());
                return entity;
            }
        }

        public static final class Entity
        implements BaseColumns,
        DataColumns {
            public static final String CONTENT_DIRECTORY = "entity";
            public static final String DATA_ID = "data_id";

            private Entity() {
            }
        }

        public static final class Data
        implements BaseColumns,
        DataColumns {
            public static final String CONTENT_DIRECTORY = "data";

            private Data() {
            }
        }
    }

    protected static interface RawContactsColumns {
        public static final String AGGREGATION_MODE = "aggregation_mode";
        public static final String CONTACT_ID = "contact_id";
        public static final String DELETED = "deleted";
        public static final String IS_RESTRICTED = "is_restricted";
        public static final String NAME_VERIFIED = "name_verified";
    }

    public static class Contacts
    implements BaseColumns,
    ContactsColumns,
    ContactOptionsColumns,
    ContactNameColumns,
    ContactStatusColumns {
        public static final Uri CONTENT_FILTER_URI;
        public static final Uri CONTENT_GROUP_URI;
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/contact";
        public static final Uri CONTENT_LOOKUP_URI;
        public static final Uri CONTENT_MULTI_VCARD_URI;
        public static final Uri CONTENT_STREQUENT_FILTER_URI;
        public static final Uri CONTENT_STREQUENT_URI;
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/contact";
        public static final Uri CONTENT_URI;
        public static final String CONTENT_VCARD_TYPE = "text/x-vcard";
        public static final Uri CONTENT_VCARD_URI;

        static {
            CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "contacts");
            CONTENT_LOOKUP_URI = Uri.withAppendedPath(CONTENT_URI, "lookup");
            CONTENT_VCARD_URI = Uri.withAppendedPath(CONTENT_URI, "as_vcard");
            CONTENT_MULTI_VCARD_URI = Uri.withAppendedPath(CONTENT_URI, "as_multi_vcard");
            CONTENT_FILTER_URI = Uri.withAppendedPath(CONTENT_URI, "filter");
            CONTENT_STREQUENT_URI = Uri.withAppendedPath(CONTENT_URI, "strequent");
            CONTENT_STREQUENT_FILTER_URI = Uri.withAppendedPath(CONTENT_STREQUENT_URI, "filter");
            CONTENT_GROUP_URI = Uri.withAppendedPath(CONTENT_URI, "group");
        }

        private Contacts() {
        }

        public static Uri getLookupUri(long l, String string2) {
            return ContentUris.withAppendedId(Uri.withAppendedPath(CONTENT_LOOKUP_URI, string2), l);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static Uri getLookupUri(ContentResolver contentResolver, Uri uri) {
            String[] stringArray = new String[]{"lookup", "_id"};
            ContentResolver contentResolver2 = contentResolver;
            Uri uri2 = uri;
            String[] stringArray2 = null;
            String string2 = null;
            Cursor cursor = contentResolver2.query(uri2, stringArray, null, stringArray2, string2);
            if (cursor == null) {
                return null;
            }
            try {
                if (cursor.moveToFirst()) {
                    Uri uri3;
                    String string3 = cursor.getString(0);
                    Uri uri4 = uri3 = Contacts.getLookupUri(cursor.getLong(1), string3);
                    cursor.close();
                    return uri4;
                }
                cursor.close();
                return null;
            }
            catch (Throwable throwable) {
                cursor.close();
                throw throwable;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static Uri lookupContact(ContentResolver contentResolver, Uri uri) {
            if (uri == null) {
                return null;
            }
            String[] stringArray = new String[]{"_id"};
            ContentResolver contentResolver2 = contentResolver;
            Uri uri2 = uri;
            String[] stringArray2 = null;
            String string2 = null;
            Cursor cursor = contentResolver2.query(uri2, stringArray, null, stringArray2, string2);
            if (cursor == null) {
                return null;
            }
            try {
                if (cursor.moveToFirst()) {
                    Uri uri3;
                    long l = cursor.getLong(0);
                    Uri uri4 = uri3 = ContentUris.withAppendedId(CONTENT_URI, l);
                    cursor.close();
                    return uri4;
                }
                cursor.close();
                return null;
            }
            catch (Throwable throwable) {
                cursor.close();
                throw throwable;
            }
        }

        public static void markAsContacted(ContentResolver contentResolver, long l) {
            Uri uri = ContentUris.withAppendedId(CONTENT_URI, l);
            ContentValues contentValues = new ContentValues();
            Long l2 = System.currentTimeMillis();
            contentValues.put("last_time_contacted", l2);
            int n = contentResolver.update(uri, contentValues, null, null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static InputStream openContactPhotoInputStream(ContentResolver contentResolver, Uri uri) {
            ByteArrayInputStream byteArrayInputStream;
            byte[] byArray;
            Cursor cursor;
            block9: {
                byte[] byArray2;
                block8: {
                    Uri uri2 = Uri.withAppendedPath(uri, "photo");
                    if (uri2 == null) {
                        return null;
                    }
                    String[] stringArray = new String[]{"data15"};
                    ContentResolver contentResolver2 = contentResolver;
                    String[] stringArray2 = null;
                    String string2 = null;
                    cursor = contentResolver2.query(uri2, stringArray, null, stringArray2, string2);
                    if (cursor != null) {
                        boolean bl = cursor.moveToNext();
                        if (bl != null) break block8;
                    }
                    if (cursor == null) return null;
                    cursor.close();
                    return null;
                }
                int n = 0;
                byArray = byArray2 = cursor.getBlob(n);
                if (byArray != null) break block9;
                if (cursor == null) return null;
                cursor.close();
                return null;
            }
            try {
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                return byteArrayInputStream;
            }
            finally {
                if (cursor == null) return byteArrayInputStream;
                cursor.close();
                return byteArrayInputStream;
            }
        }

        public static final class Photo
        implements BaseColumns,
        DataColumns {
            public static final String CONTENT_DIRECTORY = "photo";
            public static final String PHOTO = "data15";

            private Photo() {
            }
        }

        public static final class AggregationSuggestions
        implements BaseColumns,
        ContactsColumns {
            public static final String CONTENT_DIRECTORY = "suggestions";

            private AggregationSuggestions() {
            }
        }

        public static final class Data
        implements BaseColumns,
        DataColumns {
            public static final String CONTENT_DIRECTORY = "data";

            private Data() {
            }
        }
    }

    public static final class ContactCounts {
        public static final String ADDRESS_BOOK_INDEX_EXTRAS = "address_book_index_extras";
        public static final String EXTRA_ADDRESS_BOOK_INDEX_COUNTS = "address_book_index_counts";
        public static final String EXTRA_ADDRESS_BOOK_INDEX_TITLES = "address_book_index_titles";
    }

    protected static interface ContactNameColumns {
        public static final String DISPLAY_NAME_ALTERNATIVE = "display_name_alt";
        public static final String DISPLAY_NAME_PRIMARY = "display_name";
        public static final String DISPLAY_NAME_SOURCE = "display_name_source";
        public static final String PHONETIC_NAME = "phonetic_name";
        public static final String PHONETIC_NAME_STYLE = "phonetic_name_style";
        public static final String SORT_KEY_ALTERNATIVE = "sort_key_alt";
        public static final String SORT_KEY_PRIMARY = "sort_key";
    }

    public static interface DisplayNameSources {
        public static final int EMAIL = 10;
        public static final int NICKNAME = 35;
        public static final int ORGANIZATION = 30;
        public static final int PHONE = 20;
        public static final int STRUCTURED_NAME = 40;
        public static final int UNDEFINED;
    }

    public static interface PhoneticNameStyle {
        public static final int JAPANESE = 4;
        public static final int KOREAN = 5;
        public static final int PINYIN = 3;
        public static final int UNDEFINED;
    }

    public static interface FullNameStyle {
        public static final int CHINESE = 3;
        public static final int CJK = 2;
        public static final int JAPANESE = 4;
        public static final int KOREAN = 5;
        public static final int UNDEFINED = 0;
        public static final int WESTERN = 1;
    }

    protected static interface ContactStatusColumns {
        public static final String CONTACT_CHAT_CAPABILITY = "contact_chat_capability";
        public static final String CONTACT_PRESENCE = "contact_presence";
        public static final String CONTACT_STATUS = "contact_status";
        public static final String CONTACT_STATUS_ICON = "contact_status_icon";
        public static final String CONTACT_STATUS_LABEL = "contact_status_label";
        public static final String CONTACT_STATUS_RES_PACKAGE = "contact_status_res_package";
        public static final String CONTACT_STATUS_TIMESTAMP = "contact_status_ts";
    }

    protected static interface ContactsColumns {
        public static final String DISPLAY_NAME = "display_name";
        public static final String HAS_PHONE_NUMBER = "has_phone_number";
        public static final String IN_VISIBLE_GROUP = "in_visible_group";
        public static final String LOOKUP_KEY = "lookup";
        public static final String NAME_RAW_CONTACT_ID = "name_raw_contact_id";
        public static final String PHOTO_ID = "photo_id";
    }

    protected static interface ContactOptionsColumns {
        public static final String CUSTOM_RINGTONE = "custom_ringtone";
        public static final String LAST_TIME_CONTACTED = "last_time_contacted";
        public static final String SEND_TO_VOICEMAIL = "send_to_voicemail";
        public static final String STARRED = "starred";
        public static final String TIMES_CONTACTED = "times_contacted";
    }

    protected static interface SyncColumns
    extends BaseSyncColumns {
        public static final String ACCOUNT_NAME = "account_name";
        public static final String ACCOUNT_TYPE = "account_type";
        public static final String DIRTY = "dirty";
        public static final String SOURCE_ID = "sourceid";
        public static final String VERSION = "version";
    }

    protected static interface BaseSyncColumns {
        public static final String SYNC1 = "sync1";
        public static final String SYNC2 = "sync2";
        public static final String SYNC3 = "sync3";
        public static final String SYNC4 = "sync4";
    }

    public static final class SyncState
    implements SyncStateContract.Columns {
        public static final String CONTENT_DIRECTORY = "syncstate";
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "syncstate");

        private SyncState() {
        }

        public static byte[] get(ContentProviderClient contentProviderClient, Account account) throws RemoteException {
            Uri uri = CONTENT_URI;
            return SyncStateContract.Helpers.get(contentProviderClient, uri, account);
        }

        public static Pair<Uri, byte[]> getWithUri(ContentProviderClient contentProviderClient, Account account) throws RemoteException {
            Uri uri = CONTENT_URI;
            return SyncStateContract.Helpers.getWithUri(contentProviderClient, uri, account);
        }

        public static ContentProviderOperation newSetOperation(Account account, byte[] byArray) {
            return SyncStateContract.Helpers.newSetOperation(CONTENT_URI, account, byArray);
        }

        public static void set(ContentProviderClient contentProviderClient, Account account, byte[] byArray) throws RemoteException {
            Uri uri = CONTENT_URI;
            SyncStateContract.Helpers.set(contentProviderClient, uri, account, byArray);
        }
    }

    @Deprecated
    public static interface SyncStateColumns
    extends SyncStateContract.Columns {
    }

    public static final class Preferences {
        public static final String DISPLAY_ORDER = "android.contacts.DISPLAY_ORDER";
        public static final int DISPLAY_ORDER_ALTERNATIVE = 2;
        public static final int DISPLAY_ORDER_PRIMARY = 1;
        public static final String SORT_ORDER = "android.contacts.SORT_ORDER";
        public static final int SORT_ORDER_ALTERNATIVE = 2;
        public static final int SORT_ORDER_PRIMARY = 1;
    }
}

