/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.net.Uri;
import android.os.Environment;
import android.provider.BaseColumns;
import android.util.Log;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class MediaStore {
    public static final String ACTION_IMAGE_CAPTURE = "android.media.action.IMAGE_CAPTURE";
    public static final String ACTION_VIDEO_CAPTURE = "android.media.action.VIDEO_CAPTURE";
    public static final String AUTHORITY = "media";
    private static final String CONTENT_AUTHORITY_SLASH = "content://media/";
    public static final String EXTRA_DURATION_LIMIT = "android.intent.extra.durationLimit";
    public static final String EXTRA_FINISH_ON_COMPLETION = "android.intent.extra.finishOnCompletion";
    public static final String EXTRA_FULL_SCREEN = "android.intent.extra.fullScreen";
    public static final String EXTRA_MEDIA_ALBUM = "android.intent.extra.album";
    public static final String EXTRA_MEDIA_ARTIST = "android.intent.extra.artist";
    public static final String EXTRA_MEDIA_FOCUS = "android.intent.extra.focus";
    public static final String EXTRA_MEDIA_TITLE = "android.intent.extra.title";
    public static final String EXTRA_OUTPUT = "output";
    public static final String EXTRA_SCREEN_ORIENTATION = "android.intent.extra.screenOrientation";
    public static final String EXTRA_SHOW_ACTION_ICONS = "android.intent.extra.showActionIcons";
    public static final String EXTRA_SIZE_LIMIT = "android.intent.extra.sizeLimit";
    public static final String EXTRA_VIDEO_QUALITY = "android.intent.extra.videoQuality";
    public static final String INTENT_ACTION_MEDIA_PLAY_FROM_SEARCH = "android.media.action.MEDIA_PLAY_FROM_SEARCH";
    public static final String INTENT_ACTION_MEDIA_SEARCH = "android.intent.action.MEDIA_SEARCH";
    public static final String INTENT_ACTION_MUSIC_PLAYER = "android.intent.action.MUSIC_PLAYER";
    public static final String INTENT_ACTION_STILL_IMAGE_CAMERA = "android.media.action.STILL_IMAGE_CAMERA";
    public static final String INTENT_ACTION_VIDEO_CAMERA = "android.media.action.VIDEO_CAMERA";
    public static final String MEDIA_IGNORE_FILENAME = ".nomedia";
    public static final String MEDIA_SCANNER_VOLUME = "volume";
    private static final String TAG = "MediaStore";
    public static final String UNKNOWN_STRING = "<unknown>";

    public static Uri getMediaScannerUri() {
        return Uri.parse("content://media/none/media_scanner");
    }

    public static final class Video {
        public static final String DEFAULT_SORT_ORDER = "_display_name";

        public static final Cursor query(ContentResolver contentResolver, Uri uri, String[] stringArray) {
            ContentResolver contentResolver2 = contentResolver;
            Uri uri2 = uri;
            String[] stringArray2 = stringArray;
            String[] stringArray3 = null;
            return contentResolver2.query(uri2, stringArray2, null, stringArray3, DEFAULT_SORT_ORDER);
        }

        public static class Thumbnails
        implements BaseColumns {
            public static final String DATA = "_data";
            public static final String DEFAULT_SORT_ORDER = "video_id ASC";
            public static final Uri EXTERNAL_CONTENT_URI;
            public static final int FULL_SCREEN_KIND = 2;
            public static final String HEIGHT = "height";
            public static final Uri INTERNAL_CONTENT_URI;
            public static final String KIND = "kind";
            public static final int MICRO_KIND = 3;
            public static final int MINI_KIND = 1;
            public static final String VIDEO_ID = "video_id";
            public static final String WIDTH = "width";

            static {
                INTERNAL_CONTENT_URI = Thumbnails.getContentUri("internal");
                EXTERNAL_CONTENT_URI = Thumbnails.getContentUri("external");
            }

            public static void cancelThumbnailRequest(ContentResolver contentResolver, long l) {
                Uri uri = EXTERNAL_CONTENT_URI;
                ContentResolver contentResolver2 = contentResolver;
                long l2 = l;
                InternalThumbnails.cancelThumbnailRequest(contentResolver2, l2, uri, 0L);
            }

            public static void cancelThumbnailRequest(ContentResolver contentResolver, long l, long l2) {
                Uri uri = EXTERNAL_CONTENT_URI;
                ContentResolver contentResolver2 = contentResolver;
                long l3 = l;
                long l4 = l2;
                InternalThumbnails.cancelThumbnailRequest(contentResolver2, l3, uri, l4);
            }

            public static Uri getContentUri(String string2) {
                return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/video/thumbnails");
            }

            public static Bitmap getThumbnail(ContentResolver contentResolver, long l, int n, BitmapFactory.Options options) {
                Uri uri = EXTERNAL_CONTENT_URI;
                ContentResolver contentResolver2 = contentResolver;
                long l2 = l;
                int n2 = n;
                BitmapFactory.Options options2 = options;
                return InternalThumbnails.getThumbnail(contentResolver2, l2, 0L, n2, options2, uri, true);
            }

            public static Bitmap getThumbnail(ContentResolver contentResolver, long l, long l2, int n, BitmapFactory.Options options) {
                Uri uri = EXTERNAL_CONTENT_URI;
                ContentResolver contentResolver2 = contentResolver;
                long l3 = l;
                long l4 = l2;
                int n2 = n;
                BitmapFactory.Options options2 = options;
                return InternalThumbnails.getThumbnail(contentResolver2, l3, l4, n2, options2, uri, true);
            }
        }

        public static final class Media
        implements VideoColumns {
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/video";
            public static final String DEFAULT_SORT_ORDER = "title";
            public static final Uri EXTERNAL_CONTENT_URI;
            public static final Uri INTERNAL_CONTENT_URI;

            static {
                INTERNAL_CONTENT_URI = Media.getContentUri("internal");
                EXTERNAL_CONTENT_URI = Media.getContentUri("external");
            }

            public static Uri getContentUri(String string2) {
                return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/video/media");
            }
        }

        public static interface VideoColumns
        extends MediaColumns {
            public static final String ALBUM = "album";
            public static final String ARTIST = "artist";
            public static final String BOOKMARK = "bookmark";
            public static final String BUCKET_DISPLAY_NAME = "bucket_display_name";
            public static final String BUCKET_ID = "bucket_id";
            public static final String CATEGORY = "category";
            public static final String DATE_TAKEN = "datetaken";
            public static final String DESCRIPTION = "description";
            public static final String DURATION = "duration";
            public static final String IS_PRIVATE = "isprivate";
            public static final String LANGUAGE = "language";
            public static final String LATITUDE = "latitude";
            public static final String LONGITUDE = "longitude";
            public static final String MINI_THUMB_MAGIC = "mini_thumb_magic";
            public static final String RESOLUTION = "resolution";
            public static final String TAGS = "tags";
        }
    }

    public static final class Audio {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static String keyFor(String string2) {
            String string3;
            if (string2 == null) return null;
            boolean bl = false;
            if (string2.equals(MediaStore.UNKNOWN_STRING)) {
                return "\u0001";
            }
            if (string2.startsWith("\u0001")) {
                bl = true;
            }
            if ((string3 = string2.trim().toLowerCase()).startsWith("the ")) {
                string3 = string3.substring(4);
            }
            if (string3.startsWith("an ")) {
                string3 = string3.substring(3);
            }
            if (string3.startsWith("a ")) {
                string3 = string3.substring(2);
            }
            if (string3.endsWith(", the") || string3.endsWith(",the") || string3.endsWith(", an") || string3.endsWith(",an") || string3.endsWith(", a") || string3.endsWith(",a")) {
                int n = string3.lastIndexOf(44);
                string3 = string3.substring(0, n);
            }
            if ((string2 = string3.replaceAll("[\\[\\]\\(\\)\"'.,?!]", "").trim()).length() <= 0) return "";
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = stringBuilder.append('.');
            int n = string2.length();
            for (int i = 0; i < n; ++i) {
                char c = string2.charAt(i);
                StringBuilder stringBuilder3 = stringBuilder.append(c);
                StringBuilder stringBuilder4 = stringBuilder.append('.');
            }
            String string4 = DatabaseUtils.getCollationKey(stringBuilder.toString());
            if (!bl) return string4;
            string4 = "\u0001" + string4;
            return string4;
        }

        public static final class Albums
        implements BaseColumns,
        AlbumColumns {
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/albums";
            public static final String DEFAULT_SORT_ORDER = "album_key";
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/album";
            public static final Uri EXTERNAL_CONTENT_URI;
            public static final Uri INTERNAL_CONTENT_URI;

            static {
                INTERNAL_CONTENT_URI = Albums.getContentUri("internal");
                EXTERNAL_CONTENT_URI = Albums.getContentUri("external");
            }

            public static Uri getContentUri(String string2) {
                return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/audio/albums");
            }
        }

        public static interface AlbumColumns {
            public static final String ALBUM = "album";
            public static final String ALBUM_ART = "album_art";
            public static final String ALBUM_ID = "album_id";
            public static final String ALBUM_KEY = "album_key";
            public static final String ARTIST = "artist";
            public static final String FIRST_YEAR = "minyear";
            public static final String LAST_YEAR = "maxyear";
            public static final String NUMBER_OF_SONGS = "numsongs";
            public static final String NUMBER_OF_SONGS_FOR_ARTIST = "numsongs_by_artist";
        }

        public static final class Artists
        implements BaseColumns,
        ArtistColumns {
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/artists";
            public static final String DEFAULT_SORT_ORDER = "artist_key";
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/artist";
            public static final Uri EXTERNAL_CONTENT_URI;
            public static final Uri INTERNAL_CONTENT_URI;

            static {
                INTERNAL_CONTENT_URI = Artists.getContentUri("internal");
                EXTERNAL_CONTENT_URI = Artists.getContentUri("external");
            }

            public static Uri getContentUri(String string2) {
                return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/audio/artists");
            }

            public static final class Albums
            implements AlbumColumns {
                public static final Uri getContentUri(String string2, long l) {
                    return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/audio/artists/" + l + "/albums");
                }
            }
        }

        public static interface ArtistColumns {
            public static final String ARTIST = "artist";
            public static final String ARTIST_KEY = "artist_key";
            public static final String NUMBER_OF_ALBUMS = "number_of_albums";
            public static final String NUMBER_OF_TRACKS = "number_of_tracks";
        }

        public static final class Playlists
        implements BaseColumns,
        PlaylistsColumns {
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/playlist";
            public static final String DEFAULT_SORT_ORDER = "name";
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/playlist";
            public static final Uri EXTERNAL_CONTENT_URI;
            public static final Uri INTERNAL_CONTENT_URI;

            static {
                INTERNAL_CONTENT_URI = Playlists.getContentUri("internal");
                EXTERNAL_CONTENT_URI = Playlists.getContentUri("external");
            }

            public static Uri getContentUri(String string2) {
                return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/audio/playlists");
            }

            public static final class Members
            implements AudioColumns {
                public static final String AUDIO_ID = "audio_id";
                public static final String CONTENT_DIRECTORY = "members";
                public static final String DEFAULT_SORT_ORDER = "play_order";
                public static final String PLAYLIST_ID = "playlist_id";
                public static final String PLAY_ORDER = "play_order";
                public static final String _ID = "_id";

                public static final Uri getContentUri(String string2, long l) {
                    return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/audio/playlists/" + l + "/members");
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public static final boolean moveItem(ContentResolver contentResolver, long l, int n, int n2) {
                    Uri.Builder builder = Members.getContentUri("external", l).buildUpon();
                    String string2 = String.valueOf(n);
                    Uri uri = builder.appendEncodedPath(string2).appendQueryParameter("move", "true").build();
                    ContentValues contentValues = new ContentValues();
                    Integer n3 = n2;
                    contentValues.put("play_order", n3);
                    if (contentResolver.update(uri, contentValues, null, null) == 0) return false;
                    return true;
                }
            }
        }

        public static interface PlaylistsColumns {
            public static final String DATA = "_data";
            public static final String DATE_ADDED = "date_added";
            public static final String DATE_MODIFIED = "date_modified";
            public static final String NAME = "name";
        }

        public static final class Genres
        implements BaseColumns,
        GenresColumns {
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/genre";
            public static final String DEFAULT_SORT_ORDER = "name";
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/genre";
            public static final Uri EXTERNAL_CONTENT_URI;
            public static final Uri INTERNAL_CONTENT_URI;

            static {
                INTERNAL_CONTENT_URI = Genres.getContentUri("internal");
                EXTERNAL_CONTENT_URI = Genres.getContentUri("external");
            }

            public static Uri getContentUri(String string2) {
                return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/audio/genres");
            }

            public static final class Members
            implements AudioColumns {
                public static final String AUDIO_ID = "audio_id";
                public static final String CONTENT_DIRECTORY = "members";
                public static final String DEFAULT_SORT_ORDER = "title_key";
                public static final String GENRE_ID = "genre_id";

                public static final Uri getContentUri(String string2, long l) {
                    return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/audio/genres/" + l + "/members");
                }
            }
        }

        public static interface GenresColumns {
            public static final String NAME = "name";
        }

        public static final class Media
        implements AudioColumns {
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/audio";
            public static final String DEFAULT_SORT_ORDER = "title_key";
            public static final Uri EXTERNAL_CONTENT_URI;
            public static final String EXTRA_MAX_BYTES = "android.provider.MediaStore.extra.MAX_BYTES";
            public static final Uri INTERNAL_CONTENT_URI;
            public static final String RECORD_SOUND_ACTION = "android.provider.MediaStore.RECORD_SOUND";

            static {
                INTERNAL_CONTENT_URI = Media.getContentUri("internal");
                EXTERNAL_CONTENT_URI = Media.getContentUri("external");
            }

            public static Uri getContentUri(String string2) {
                return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/audio/media");
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public static Uri getContentUriForPath(String string2) {
                String string3 = Environment.getExternalStorageDirectory().getPath();
                if (!string2.startsWith(string3)) return INTERNAL_CONTENT_URI;
                return EXTERNAL_CONTENT_URI;
            }
        }

        public static interface AudioColumns
        extends MediaColumns {
            public static final String ALBUM = "album";
            public static final String ALBUM_ART = "album_art";
            public static final String ALBUM_ARTIST = "album_artist";
            public static final String ALBUM_ID = "album_id";
            public static final String ALBUM_KEY = "album_key";
            public static final String ARTIST = "artist";
            public static final String ARTIST_ID = "artist_id";
            public static final String ARTIST_KEY = "artist_key";
            public static final String BOOKMARK = "bookmark";
            public static final String COMPILATION = "compilation";
            public static final String COMPOSER = "composer";
            public static final String DURATION = "duration";
            public static final String IS_ALARM = "is_alarm";
            public static final String IS_MUSIC = "is_music";
            public static final String IS_NOTIFICATION = "is_notification";
            public static final String IS_PODCAST = "is_podcast";
            public static final String IS_RINGTONE = "is_ringtone";
            public static final String TITLE_KEY = "title_key";
            public static final String TRACK = "track";
            public static final String YEAR = "year";
        }
    }

    public static final class Images {

        public static class Thumbnails
        implements BaseColumns {
            public static final String DATA = "_data";
            public static final String DEFAULT_SORT_ORDER = "image_id ASC";
            public static final Uri EXTERNAL_CONTENT_URI;
            public static final int FULL_SCREEN_KIND = 2;
            public static final String HEIGHT = "height";
            public static final String IMAGE_ID = "image_id";
            public static final Uri INTERNAL_CONTENT_URI;
            public static final String KIND = "kind";
            public static final int MICRO_KIND = 3;
            public static final int MINI_KIND = 1;
            public static final String THUMB_DATA = "thumb_data";
            public static final String WIDTH = "width";

            static {
                INTERNAL_CONTENT_URI = Thumbnails.getContentUri("internal");
                EXTERNAL_CONTENT_URI = Thumbnails.getContentUri("external");
            }

            public static void cancelThumbnailRequest(ContentResolver contentResolver, long l) {
                Uri uri = EXTERNAL_CONTENT_URI;
                ContentResolver contentResolver2 = contentResolver;
                long l2 = l;
                InternalThumbnails.cancelThumbnailRequest(contentResolver2, l2, uri, 0L);
            }

            public static void cancelThumbnailRequest(ContentResolver contentResolver, long l, long l2) {
                Uri uri = EXTERNAL_CONTENT_URI;
                ContentResolver contentResolver2 = contentResolver;
                long l3 = l;
                long l4 = l2;
                InternalThumbnails.cancelThumbnailRequest(contentResolver2, l3, uri, l4);
            }

            public static Uri getContentUri(String string2) {
                return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/images/thumbnails");
            }

            public static Bitmap getThumbnail(ContentResolver contentResolver, long l, int n, BitmapFactory.Options options) {
                Uri uri = EXTERNAL_CONTENT_URI;
                ContentResolver contentResolver2 = contentResolver;
                long l2 = l;
                int n2 = n;
                BitmapFactory.Options options2 = options;
                return InternalThumbnails.getThumbnail(contentResolver2, l2, 0L, n2, options2, uri, false);
            }

            public static Bitmap getThumbnail(ContentResolver contentResolver, long l, long l2, int n, BitmapFactory.Options options) {
                Uri uri = EXTERNAL_CONTENT_URI;
                ContentResolver contentResolver2 = contentResolver;
                long l3 = l;
                long l4 = l2;
                int n2 = n;
                BitmapFactory.Options options2 = options;
                return InternalThumbnails.getThumbnail(contentResolver2, l3, l4, n2, options2, uri, false);
            }

            public static final Cursor query(ContentResolver contentResolver, Uri uri, String[] stringArray) {
                ContentResolver contentResolver2 = contentResolver;
                Uri uri2 = uri;
                String[] stringArray2 = stringArray;
                String[] stringArray3 = null;
                return contentResolver2.query(uri2, stringArray2, null, stringArray3, DEFAULT_SORT_ORDER);
            }

            public static final Cursor queryMiniThumbnail(ContentResolver contentResolver, long l, int n, String[] stringArray) {
                Uri uri = EXTERNAL_CONTENT_URI;
                String string2 = "image_id = " + l + " AND " + KIND + " = " + n;
                ContentResolver contentResolver2 = contentResolver;
                String[] stringArray2 = stringArray;
                String string3 = null;
                return contentResolver2.query(uri, stringArray2, string2, null, string3);
            }

            public static final Cursor queryMiniThumbnails(ContentResolver contentResolver, Uri uri, int n, String[] stringArray) {
                String string2 = "kind = " + n;
                ContentResolver contentResolver2 = contentResolver;
                Uri uri2 = uri;
                String[] stringArray2 = stringArray;
                return contentResolver2.query(uri2, stringArray2, string2, null, DEFAULT_SORT_ORDER);
            }
        }

        public static final class Media
        implements ImageColumns {
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/image";
            public static final String DEFAULT_SORT_ORDER = "bucket_display_name";
            public static final Uri EXTERNAL_CONTENT_URI;
            public static final Uri INTERNAL_CONTENT_URI;

            static {
                INTERNAL_CONTENT_URI = Media.getContentUri("internal");
                EXTERNAL_CONTENT_URI = Media.getContentUri("external");
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private static final Bitmap StoreThumbnail(ContentResolver contentResolver, Bitmap bitmap, long l, float f, float f2, int n) {
                Matrix matrix = new Matrix();
                float f3 = bitmap.getWidth();
                float f4 = f / f3;
                float f5 = bitmap.getHeight();
                float f6 = f2 / f5;
                matrix.setScale(f4, f6);
                int n2 = bitmap.getWidth();
                int n3 = bitmap.getHeight();
                Bitmap bitmap2 = Bitmap.createBitmap(bitmap, 0, 0, n2, n3, matrix, true);
                ContentValues contentValues = new ContentValues(4);
                Integer n4 = n;
                contentValues.put("kind", n4);
                Integer n5 = (int)l;
                contentValues.put("image_id", n5);
                Integer n6 = bitmap2.getHeight();
                contentValues.put("height", n6);
                Integer n7 = bitmap2.getWidth();
                contentValues.put("width", n7);
                Uri uri = Thumbnails.EXTERNAL_CONTENT_URI;
                Uri uri2 = contentResolver.insert(uri, contentValues);
                try {
                    OutputStream outputStream = contentResolver.openOutputStream(uri2);
                    Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.JPEG;
                    boolean bl = bitmap2.compress(compressFormat, 100, outputStream);
                    outputStream.close();
                    return bitmap2;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
            }

            public static final Bitmap getBitmap(ContentResolver contentResolver, Uri uri) throws FileNotFoundException, IOException {
                InputStream inputStream = contentResolver.openInputStream(uri);
                Bitmap bitmap = BitmapFactory.decodeStream(inputStream);
                inputStream.close();
                return bitmap;
            }

            public static Uri getContentUri(String string2) {
                return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/images/media");
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public static final String insertImage(ContentResolver var0, Bitmap var1_1, String var2_6, String var3_7) {
                block13: {
                    var4_8 = new ContentValues();
                    var4_8.put("title", var2_6);
                    var4_8.put("description", var3_7);
                    var4_8.put("mime_type", "image/jpeg");
                    var5_9 = null;
                    try {
                        var6_10 = Media.EXTERNAL_CONTENT_URI;
                        var7_11 = var0.insert(var6_10, var4_8);
                        var8_12 = var7_11;
                        ** if (var1_1 == null) goto lbl37
                    }
                    catch (Exception var1_5) {
                        ** continue;
                    }
lbl-1000:
                    // 1 sources

                    {
                        var5_9 = var7_11 = var0.openOutputStream(var8_12);
                        var9_13 = Bitmap.CompressFormat.JPEG;
                        var10_14 = var1_1.compress(var9_13, 50, (OutputStream)var5_9);
                        var5_9.close();
                        var11_15 = ContentUris.parseId(var8_12);
                        var13_16 = Thumbnails.getThumbnail(var0, var11_15, 1, null);
                        var14_17 = Media.StoreThumbnail(var0, var13_16, var11_15, 50.0f, 50.0f, 3);
                        var15_18 = var8_12;
lbl22:
                        // 2 sources

                        while (true) {
                            if (var15_18 == null) return null;
                            return var15_18.toString();
                        }
                        catch (Throwable var1_2) {
                            try {
                                var5_9.close();
                                throw var1_2;
                            }
                            catch (Exception var1_3) {
                                var5_9 = var8_12;
lbl31:
                                // 2 sources

                                while (true) {
                                    var17_20 = Log.e("MediaStore", "Failed to insert image", (Throwable)var1_4);
                                    if (var5_9 != null) {
                                        var18_21 = var0.delete((Uri)var5_9, null, null);
                                        return null;
                                    }
                                    break block13;
                                    break;
                                }
                            }
                        }
                    }
lbl37:
                    // 1 sources

                    {
                        var19_22 = Log.e("MediaStore", "Failed to create thumbnail, removing original");
                        var20_23 = var0.delete(var8_12, null, null);
                        return null;
                    }
                }
                var15_18 = var5_9;
                ** while (true)
            }

            public static final String insertImage(ContentResolver contentResolver, String string2, String string3, String string4) throws FileNotFoundException {
                FileInputStream fileInputStream = new FileInputStream(string2);
                try {
                    Bitmap bitmap = BitmapFactory.decodeFile(string2);
                    String string5 = Media.insertImage(contentResolver, bitmap, string3, string4);
                    bitmap.recycle();
                    return string5;
                }
                finally {
                    fileInputStream.close();
                }
            }

            public static final Cursor query(ContentResolver contentResolver, Uri uri, String[] stringArray) {
                ContentResolver contentResolver2 = contentResolver;
                Uri uri2 = uri;
                String[] stringArray2 = stringArray;
                String[] stringArray3 = null;
                return contentResolver2.query(uri2, stringArray2, null, stringArray3, DEFAULT_SORT_ORDER);
            }

            /*
             * Enabled aggressive block sorting
             */
            public static final Cursor query(ContentResolver contentResolver, Uri uri, String[] stringArray, String string2, String string3) {
                String string4 = string3 == null ? DEFAULT_SORT_ORDER : string3;
                ContentResolver contentResolver2 = contentResolver;
                Uri uri2 = uri;
                String[] stringArray2 = stringArray;
                String string5 = string2;
                return contentResolver2.query(uri2, stringArray2, string5, null, string4);
            }

            /*
             * Enabled aggressive block sorting
             */
            public static final Cursor query(ContentResolver contentResolver, Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
                String string4 = string3 == null ? DEFAULT_SORT_ORDER : string3;
                ContentResolver contentResolver2 = contentResolver;
                Uri uri2 = uri;
                String[] stringArray3 = stringArray;
                String string5 = string2;
                String[] stringArray4 = stringArray2;
                return contentResolver2.query(uri2, stringArray3, string5, stringArray4, string4);
            }
        }

        public static interface ImageColumns
        extends MediaColumns {
            public static final String BUCKET_DISPLAY_NAME = "bucket_display_name";
            public static final String BUCKET_ID = "bucket_id";
            public static final String DATE_TAKEN = "datetaken";
            public static final String DESCRIPTION = "description";
            public static final String IS_PRIVATE = "isprivate";
            public static final String LATITUDE = "latitude";
            public static final String LONGITUDE = "longitude";
            public static final String MINI_THUMB_MAGIC = "mini_thumb_magic";
            public static final String ORIENTATION = "orientation";
            public static final String PICASA_ID = "picasa_id";
        }
    }

    private static class InternalThumbnails
    implements BaseColumns {
        static final int DEFAULT_GROUP_ID = 0;
        private static final int FULL_SCREEN_KIND = 2;
        private static final int MICRO_KIND = 3;
        private static final int MINI_KIND = 1;
        private static final String[] PROJECTION;
        private static byte[] sThumbBuf;
        private static final Object sThumbBufLock;

        static {
            String[] stringArray = new String[]{"_id", "_data"};
            PROJECTION = stringArray;
            sThumbBufLock = new Object();
        }

        private InternalThumbnails() {
        }

        static void cancelThumbnailRequest(ContentResolver contentResolver, long l, Uri uri, long l2) {
            Uri.Builder builder = uri.buildUpon().appendQueryParameter("cancel", "1");
            String string2 = String.valueOf(l);
            Uri.Builder builder2 = builder.appendQueryParameter("orig_id", string2);
            String string3 = String.valueOf(l2);
            Uri uri2 = builder2.appendQueryParameter("group_id", string3).build();
            try {
                Cursor cursor;
                String[] stringArray = PROJECTION;
                Cursor cursor2 = cursor = contentResolver.query(uri2, stringArray, null, null, null);
                if (cursor2 == null) {
                    return;
                }
                cursor2.close();
                return;
            }
            catch (Throwable throwable) {
                if (false) {
                    ((Cursor)null).close();
                }
                throw throwable;
            }
        }

        /*
         * Exception decompiling
         */
        private static Bitmap getMiniThumbFromFile(Cursor var0, Uri var1, ContentResolver var2, BitmapFactory.Options var3) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IllegalStateException: Invisible function parameters on a non-constructor (or reads of uninitialised local variables).
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.assignSSAIdentifiers(Op02WithProcessedDataAndRefs.java:1631)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.discoverStorageLiveness(Op02WithProcessedDataAndRefs.java:1871)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:461)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        static Bitmap getThumbnail(ContentResolver var0, long var1, long var3, int var5, BitmapFactory.Options var6, Uri var7, boolean var8) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IllegalStateException: Invisible function parameters on a non-constructor (or reads of uninitialised local variables).
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.assignSSAIdentifiers(Op02WithProcessedDataAndRefs.java:1631)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.discoverStorageLiveness(Op02WithProcessedDataAndRefs.java:1871)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:461)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static interface MediaColumns
    extends BaseColumns {
        public static final String DATA = "_data";
        public static final String DATE_ADDED = "date_added";
        public static final String DATE_MODIFIED = "date_modified";
        public static final String DISPLAY_NAME = "_display_name";
        public static final String MIME_TYPE = "mime_type";
        public static final String SIZE = "_size";
        public static final String TITLE = "title";
    }
}

