/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import android.provider.BaseColumns;
import android.text.TextUtils;
import android.util.Log;

public class SearchRecentSuggestions {
    private static final int DBG_SUGGESTION_TIMESTAMPS = 0;
    private static final String LOG_TAG = "SearchSuggestions";
    private static final int MAX_HISTORY_COUNT = 250;
    public static final String[] QUERIES_PROJECTION_1LINE;
    public static final String[] QUERIES_PROJECTION_2LINE;
    public static final int QUERIES_PROJECTION_DATE_INDEX = 1;
    public static final int QUERIES_PROJECTION_DISPLAY1_INDEX = 3;
    public static final int QUERIES_PROJECTION_DISPLAY2_INDEX = 4;
    public static final int QUERIES_PROJECTION_QUERY_INDEX = 2;
    private static final String[] TRUNCATE_HISTORY_PROJECTION;
    private String mAuthority;
    private Context mContext;
    private String[] mQueriesProjection;
    private Uri mSuggestionsUri;
    private boolean mTwoLineDisplay;

    static {
        String[] stringArray = new String[]{"_id", "date", "query", "display1"};
        QUERIES_PROJECTION_1LINE = stringArray;
        String[] stringArray2 = new String[]{"_id", "date", "query", "display1", "display2"};
        QUERIES_PROJECTION_2LINE = stringArray2;
        String[] stringArray3 = new String[]{"_id", "date"};
        TRUNCATE_HISTORY_PROJECTION = stringArray3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public SearchRecentSuggestions(Context context, String string2, int n) {
        Uri uri;
        String string3;
        if (TextUtils.isEmpty(string2) || (n & 1) == 0) {
            throw new IllegalArgumentException();
        }
        boolean bl = (n & 2) != 0;
        this.mTwoLineDisplay = bl;
        this.mContext = context;
        this.mAuthority = string3 = new String(string2);
        StringBuilder stringBuilder = new StringBuilder().append("content://");
        String string4 = this.mAuthority;
        this.mSuggestionsUri = uri = Uri.parse(stringBuilder.append(string4).append("/suggestions").toString());
        if (this.mTwoLineDisplay) {
            String[] stringArray = QUERIES_PROJECTION_2LINE;
            this.mQueriesProjection = stringArray;
            return;
        }
        String[] stringArray = QUERIES_PROJECTION_1LINE;
        this.mQueriesProjection = stringArray;
    }

    public void clearHistory() {
        ContentResolver contentResolver = this.mContext.getContentResolver();
        this.truncateHistory(contentResolver, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveRecentQuery(String string2, String string3) {
        if (TextUtils.isEmpty(string2)) {
            return;
        }
        if (!this.mTwoLineDisplay && !TextUtils.isEmpty(string3)) {
            throw new IllegalArgumentException();
        }
        ContentResolver contentResolver = this.mContext.getContentResolver();
        long l = System.currentTimeMillis();
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put("display1", string2);
            if (this.mTwoLineDisplay) {
                contentValues.put("display2", string3);
            }
            contentValues.put("query", string2);
            Long l2 = l;
            contentValues.put("date", l2);
            Uri uri = this.mSuggestionsUri;
            Uri uri2 = contentResolver.insert(uri, contentValues);
        }
        catch (RuntimeException runtimeException) {
            int n = Log.e(LOG_TAG, "saveRecentQuery", runtimeException);
        }
        this.truncateHistory(contentResolver, 250);
    }

    /*
     * Unable to fully structure code
     */
    protected void truncateHistory(ContentResolver var1_1, int var2_2) {
        if (var2_2 < 0) {
            throw new IllegalArgumentException();
        }
        var3_3 = null;
        if (var2_2 <= 0) ** GOTO lbl9
        try {
            var4_4 = new StringBuilder().append("_id IN (SELECT _id FROM suggestions ORDER BY date DESC LIMIT -1 OFFSET ");
            var5_5 = String.valueOf(var2_2);
            var3_3 = var4_4.append(var5_5).append(")").toString();
lbl9:
            // 2 sources

            var6_6 = this.mSuggestionsUri;
            var7_7 = var1_1.delete(var6_6, var3_3, null);
            return;
        }
        catch (RuntimeException var8_8) {
            var9_9 = Log.e("SearchSuggestions", "truncateHistory", var8_8);
            return;
        }
    }

    private static class SuggestionColumns
    implements BaseColumns {
        public static final String DATE = "date";
        public static final String DISPLAY1 = "display1";
        public static final String DISPLAY2 = "display2";
        public static final String QUERY = "query";

        private SuggestionColumns() {
        }
    }
}

