/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.IContentProvider;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.Cursor;
import android.database.SQLException;
import android.net.Uri;
import android.provider.BaseColumns;
import android.text.TextUtils;
import android.util.AndroidException;
import android.util.Log;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;

public final class Settings {
    public static final String ACTION_ACCESSIBILITY_SETTINGS = "android.settings.ACCESSIBILITY_SETTINGS";
    public static final String ACTION_ADD_ACCOUNT = "android.settings.ADD_ACCOUNT_SETTINGS";
    public static final String ACTION_AIRPLANE_MODE_SETTINGS = "android.settings.AIRPLANE_MODE_SETTINGS";
    public static final String ACTION_APN_SETTINGS = "android.settings.APN_SETTINGS";
    public static final String ACTION_APPLICATION_DETAILS_SETTINGS = "android.settings.APPLICATION_DETAILS_SETTINGS";
    public static final String ACTION_APPLICATION_DEVELOPMENT_SETTINGS = "android.settings.APPLICATION_DEVELOPMENT_SETTINGS";
    public static final String ACTION_APPLICATION_SETTINGS = "android.settings.APPLICATION_SETTINGS";
    public static final String ACTION_BLUETOOTH_SETTINGS = "android.settings.BLUETOOTH_SETTINGS";
    public static final String ACTION_DATA_ROAMING_SETTINGS = "android.settings.DATA_ROAMING_SETTINGS";
    public static final String ACTION_DATE_SETTINGS = "android.settings.DATE_SETTINGS";
    public static final String ACTION_DEVICE_INFO_SETTINGS = "android.settings.DEVICE_INFO_SETTINGS";
    public static final String ACTION_DISPLAY_SETTINGS = "android.settings.DISPLAY_SETTINGS";
    public static final String ACTION_INPUT_METHOD_SETTINGS = "android.settings.INPUT_METHOD_SETTINGS";
    public static final String ACTION_INTERNAL_STORAGE_SETTINGS = "android.settings.INTERNAL_STORAGE_SETTINGS";
    public static final String ACTION_LOCALE_SETTINGS = "android.settings.LOCALE_SETTINGS";
    public static final String ACTION_LOCATION_SOURCE_SETTINGS = "android.settings.LOCATION_SOURCE_SETTINGS";
    public static final String ACTION_MANAGE_ALL_APPLICATIONS_SETTINGS = "android.settings.MANAGE_ALL_APPLICATIONS_SETTINGS";
    public static final String ACTION_MANAGE_APPLICATIONS_SETTINGS = "android.settings.MANAGE_APPLICATIONS_SETTINGS";
    public static final String ACTION_MEMORY_CARD_SETTINGS = "android.settings.MEMORY_CARD_SETTINGS";
    public static final String ACTION_NETWORK_OPERATOR_SETTINGS = "android.settings.NETWORK_OPERATOR_SETTINGS";
    public static final String ACTION_PRIVACY_SETTINGS = "android.settings.PRIVACY_SETTINGS";
    public static final String ACTION_QUICK_LAUNCH_SETTINGS = "android.settings.QUICK_LAUNCH_SETTINGS";
    public static final String ACTION_SEARCH_SETTINGS = "android.search.action.SEARCH_SETTINGS";
    public static final String ACTION_SECURITY_SETTINGS = "android.settings.SECURITY_SETTINGS";
    public static final String ACTION_SETTINGS = "android.settings.SETTINGS";
    public static final String ACTION_SOUND_SETTINGS = "android.settings.SOUND_SETTINGS";
    public static final String ACTION_SYNC_SETTINGS = "android.settings.SYNC_SETTINGS";
    public static final String ACTION_SYSTEM_UPDATE_SETTINGS = "android.settings.SYSTEM_UPDATE_SETTINGS";
    public static final String ACTION_USER_DICTIONARY_SETTINGS = "android.settings.USER_DICTIONARY_SETTINGS";
    public static final String ACTION_WIFI_IP_SETTINGS = "android.settings.WIFI_IP_SETTINGS";
    public static final String ACTION_WIFI_SETTINGS = "android.settings.WIFI_SETTINGS";
    public static final String ACTION_WIRELESS_SETTINGS = "android.settings.WIRELESS_SETTINGS";
    public static final String AUTHORITY = "settings";
    public static final String CALL_METHOD_GET_SECURE = "GET_secure";
    public static final String CALL_METHOD_GET_SYSTEM = "GET_system";
    public static final String EXTRA_AUTHORITIES = "authorities";
    private static final String JID_RESOURCE_PREFIX = "android";
    private static final boolean LOCAL_LOGV = false;
    private static final String TAG = "Settings";

    public static String getGTalkDeviceId(long l) {
        StringBuilder stringBuilder = new StringBuilder().append("android-");
        String string2 = Long.toHexString(l);
        return stringBuilder.append(string2).toString();
    }

    public static final class Bookmarks
    implements BaseColumns {
        public static final Uri CONTENT_URI = Uri.parse("content://settings/bookmarks");
        public static final String FOLDER = "folder";
        public static final String ID = "_id";
        public static final String INTENT = "intent";
        public static final String ORDERING = "ordering";
        public static final String SHORTCUT = "shortcut";
        private static final String TAG = "Bookmarks";
        public static final String TITLE = "title";
        private static final String[] sIntentProjection;
        private static final String[] sShortcutProjection;
        private static final String sShortcutSelection = "shortcut=?";

        static {
            String[] stringArray = new String[]{INTENT};
            sIntentProjection = stringArray;
            String[] stringArray2 = new String[]{ID, SHORTCUT};
            sShortcutProjection = stringArray2;
        }

        public static Uri add(ContentResolver contentResolver, Intent intent, String string2, String string3, char c, int n) {
            if (c != null) {
                Uri uri = CONTENT_URI;
                String[] stringArray = sShortcutProjection;
                String string4 = String.valueOf((int)c);
                String[] stringArray2 = new String[]{string4};
                Cursor cursor = contentResolver.query(uri, stringArray, sShortcutSelection, stringArray2, null);
                try {
                    if (cursor.moveToFirst()) {
                        while (cursor.getCount() > 0) {
                            if (cursor.deleteRow()) continue;
                            int n2 = Log.w(TAG, "Could not delete existing shortcut row");
                        }
                    }
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
            ContentValues contentValues = new ContentValues();
            if (string2 != null) {
                contentValues.put(TITLE, string2);
            }
            if (string3 != null) {
                contentValues.put(FOLDER, string3);
            }
            String string5 = intent.toURI();
            contentValues.put(INTENT, string5);
            if (c != null) {
                Integer n3 = c;
                contentValues.put(SHORTCUT, n3);
            }
            Integer n4 = n;
            contentValues.put(ORDERING, n4);
            Uri uri = CONTENT_URI;
            return contentResolver.insert(uri, contentValues);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static Intent getIntentForShortcut(ContentResolver contentResolver, char c) {
            Object object = null;
            Uri uri = CONTENT_URI;
            String[] stringArray = sIntentProjection;
            String string2 = String.valueOf((int)c);
            String[] stringArray2 = new String[]{string2};
            Cursor cursor = contentResolver.query(uri, stringArray, sShortcutSelection, stringArray2, ORDERING);
            while (object == null) {
                try {
                    Object object2 = cursor.moveToNext();
                    if (object2 == null) break;
                    try {
                        int n = cursor.getColumnIndexOrThrow(INTENT);
                        object2 = Intent.getIntent(cursor.getString(n));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        int n = Log.w(TAG, "Intent column not found", illegalArgumentException);
                        continue;
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        continue;
                    }
                    object = object2;
                }
                catch (Throwable throwable) {
                    if (cursor != null) {
                        cursor.close();
                    }
                    throw throwable;
                }
            }
            if (cursor != null) {
                cursor.close();
            }
            return object;
        }

        public static CharSequence getLabelForFolder(Resources resources, String string2) {
            return string2;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static CharSequence getTitle(Context context, Cursor cursor) {
            void var5_6;
            int n = cursor.getColumnIndex(TITLE);
            int n2 = cursor.getColumnIndex(INTENT);
            if (n == -1 || n2 == -1) {
                throw new IllegalArgumentException("The cursor must contain the TITLE and INTENT columns.");
            }
            String string2 = cursor.getString(n);
            if (!TextUtils.isEmpty(string2)) {
                String string3 = string2;
                return var5_6;
            }
            String string4 = cursor.getString(n2);
            if (TextUtils.isEmpty(string4)) {
                return var5_6;
            }
            try {
                Intent intent;
                Intent intent2 = intent = Intent.getIntent(string4);
                PackageManager packageManager = context.getPackageManager();
                ResolveInfo resolveInfo = packageManager.resolveActivity(intent2, 0);
                if (resolveInfo == null) return var5_6;
                CharSequence charSequence = resolveInfo.loadLabel(packageManager);
                return var5_6;
            }
            catch (URISyntaxException uRISyntaxException) {
                String string5 = "";
                return var5_6;
            }
        }
    }

    public static final class Secure
    extends NameValueTable {
        public static final String ACCESSIBILITY_ENABLED = "accessibility_enabled";
        public static final String ADB_ENABLED = "adb_enabled";
        public static final String ALLOWED_GEOLOCATION_ORIGINS = "allowed_geolocation_origins";
        public static final String ALLOW_MOCK_LOCATION = "mock_location";
        public static final String ANDROID_ID = "android_id";
        public static final String ANR_SHOW_BACKGROUND = "anr_show_background";
        public static final String ASSISTED_GPS_ENABLED = "assisted_gps_enabled";
        public static final String BACKGROUND_DATA = "background_data";
        public static final String BACKUP_AUTO_RESTORE = "backup_auto_restore";
        public static final String BACKUP_ENABLED = "backup_enabled";
        public static final String BACKUP_PROVISIONED = "backup_provisioned";
        public static final String BACKUP_TRANSPORT = "backup_transport";
        public static final String BATTERY_DISCHARGE_DURATION_THRESHOLD = "battery_discharge_duration_threshold";
        public static final String BATTERY_DISCHARGE_THRESHOLD = "battery_discharge_threshold";
        public static final String BLUETOOTH_ON = "bluetooth_on";
        public static final String CDMA_CELL_BROADCAST_SMS = "cdma_cell_broadcast_sms";
        public static final String CDMA_ROAMING_MODE = "roaming_settings";
        public static final String CDMA_SUBSCRIPTION_MODE = "subscription_mode";
        public static final Uri CONTENT_URI;
        public static final String DATA_ROAMING = "data_roaming";
        public static final String DEFAULT_INPUT_METHOD = "default_input_method";
        public static final String DEFAULT_INSTALL_LOCATION = "default_install_location";
        public static final String DEVICE_PROVISIONED = "device_provisioned";
        public static final String DISABLED_SYSTEM_INPUT_METHODS = "disabled_system_input_methods";
        public static final String DISK_FREE_CHANGE_REPORTING_THRESHOLD = "disk_free_change_reporting_threshold";
        public static final String DOWNLOAD_MAX_BYTES_OVER_MOBILE = "download_manager_max_bytes_over_mobile";
        public static final String DOWNLOAD_RECOMMENDED_MAX_BYTES_OVER_MOBILE = "download_manager_recommended_max_bytes_over_mobile";
        public static final String DROPBOX_AGE_SECONDS = "dropbox_age_seconds";
        public static final String DROPBOX_MAX_FILES = "dropbox_max_files";
        public static final String DROPBOX_QUOTA_KB = "dropbox_quota_kb";
        public static final String DROPBOX_QUOTA_PERCENT = "dropbox_quota_percent";
        public static final String DROPBOX_RESERVE_PERCENT = "dropbox_reserve_percent";
        public static final String DROPBOX_TAG_PREFIX = "dropbox:";
        public static final String ENABLED_ACCESSIBILITY_SERVICES = "enabled_accessibility_services";
        public static final String ENABLED_INPUT_METHODS = "enabled_input_methods";
        public static final String ENHANCED_VOICE_PRIVACY_ENABLED = "enhanced_voice_privacy_enabled";
        public static final String ERROR_LOGCAT_PREFIX = "logcat_for_";
        public static final String GPRS_REGISTER_CHECK_PERIOD_MS = "gprs_register_check_period_ms";
        public static final String HTTP_PROXY = "http_proxy";
        public static final String INCALL_POWER_BUTTON_BEHAVIOR = "incall_power_button_behavior";
        public static final int INCALL_POWER_BUTTON_BEHAVIOR_DEFAULT = 1;
        public static final int INCALL_POWER_BUTTON_BEHAVIOR_HANGUP = 2;
        public static final int INCALL_POWER_BUTTON_BEHAVIOR_SCREEN_OFF = 1;
        public static final String INET_CONDITION_DEBOUNCE_DOWN_DELAY = "inet_condition_debounce_down_delay";
        public static final String INET_CONDITION_DEBOUNCE_UP_DELAY = "inet_condition_debounce_up_delay";
        public static final String INSTALL_NON_MARKET_APPS = "install_non_market_apps";
        public static final String LAST_SETUP_SHOWN = "last_setup_shown";
        public static final String LOCATION_PROVIDERS_ALLOWED = "location_providers_allowed";
        public static final String LOCK_PATTERN_ENABLED = "lock_pattern_autolock";
        public static final String LOCK_PATTERN_TACTILE_FEEDBACK_ENABLED = "lock_pattern_tactile_feedback_enabled";
        public static final String LOCK_PATTERN_VISIBLE = "lock_pattern_visible_pattern";
        @Deprecated
        public static final String LOGGING_ID = "logging_id";
        public static final String MEMCHECK_EXEC_END_TIME = "memcheck_exec_end_time";
        public static final String MEMCHECK_EXEC_START_TIME = "memcheck_exec_start_time";
        public static final String MEMCHECK_INTERVAL = "memcheck_interval";
        public static final String MEMCHECK_LOG_REALTIME_INTERVAL = "memcheck_log_realtime_interval";
        public static final String MEMCHECK_MIN_ALARM = "memcheck_min_alarm";
        public static final String MEMCHECK_MIN_SCREEN_OFF = "memcheck_min_screen_off";
        public static final String MEMCHECK_PHONE_ENABLED = "memcheck_phone_enabled";
        public static final String MEMCHECK_PHONE_HARD_THRESHOLD = "memcheck_phone_hard";
        public static final String MEMCHECK_PHONE_SOFT_THRESHOLD = "memcheck_phone_soft";
        public static final String MEMCHECK_RECHECK_INTERVAL = "memcheck_recheck_interval";
        public static final String MEMCHECK_SYSTEM_ENABLED = "memcheck_system_enabled";
        public static final String MEMCHECK_SYSTEM_HARD_THRESHOLD = "memcheck_system_hard";
        public static final String MEMCHECK_SYSTEM_SOFT_THRESHOLD = "memcheck_system_soft";
        public static final String MOBILE_DATA = "mobile_data";
        public static final String MOUNT_PLAY_NOTIFICATION_SND = "mount_play_not_snd";
        public static final String MOUNT_UMS_AUTOSTART = "mount_ums_autostart";
        public static final String MOUNT_UMS_NOTIFY_ENABLED = "mount_ums_notify_enabled";
        public static final String MOUNT_UMS_PROMPT = "mount_ums_prompt";
        public static final String NETWORK_PREFERENCE = "network_preference";
        public static final String NITZ_UPDATE_DIFF = "nitz_update_diff";
        public static final String NITZ_UPDATE_SPACING = "nitz_update_spacing";
        public static final String PARENTAL_CONTROL_ENABLED = "parental_control_enabled";
        public static final String PARENTAL_CONTROL_LAST_UPDATE = "parental_control_last_update";
        public static final String PARENTAL_CONTROL_REDIRECT_URL = "parental_control_redirect_url";
        public static final String PDP_WATCHDOG_ERROR_POLL_COUNT = "pdp_watchdog_error_poll_count";
        public static final String PDP_WATCHDOG_ERROR_POLL_INTERVAL_MS = "pdp_watchdog_error_poll_interval_ms";
        public static final String PDP_WATCHDOG_LONG_POLL_INTERVAL_MS = "pdp_watchdog_long_poll_interval_ms";
        public static final String PDP_WATCHDOG_MAX_PDP_RESET_FAIL_COUNT = "pdp_watchdog_max_pdp_reset_fail_count";
        public static final String PDP_WATCHDOG_PING_ADDRESS = "pdp_watchdog_ping_address";
        public static final String PDP_WATCHDOG_PING_DEADLINE = "pdp_watchdog_ping_deadline";
        public static final String PDP_WATCHDOG_POLL_INTERVAL_MS = "pdp_watchdog_poll_interval_ms";
        public static final String PDP_WATCHDOG_TRIGGER_PACKET_COUNT = "pdp_watchdog_trigger_packet_count";
        public static final String PREFERRED_CDMA_SUBSCRIPTION = "preferred_cdma_subscription";
        public static final String PREFERRED_NETWORK_MODE = "preferred_network_mode";
        public static final String PREFERRED_TTY_MODE = "preferred_tty_mode";
        public static final String REBOOT_INTERVAL = "reboot_interval";
        public static final String REBOOT_START_TIME = "reboot_start_time";
        public static final String REBOOT_WINDOW = "reboot_window";
        public static final String SEARCH_MAX_RESULTS_PER_SOURCE = "search_max_results_per_source";
        public static final String SEARCH_MAX_RESULTS_TO_DISPLAY = "search_max_results_to_display";
        public static final String SEARCH_MAX_SHORTCUTS_RETURNED = "search_max_shortcuts_returned";
        public static final String SEARCH_MAX_SOURCE_EVENT_AGE_MILLIS = "search_max_source_event_age_millis";
        public static final String SEARCH_MAX_STAT_AGE_MILLIS = "search_max_stat_age_millis";
        public static final String SEARCH_MIN_CLICKS_FOR_SOURCE_RANKING = "search_min_clicks_for_source_ranking";
        public static final String SEARCH_MIN_IMPRESSIONS_FOR_SOURCE_RANKING = "search_min_impressions_for_source_ranking";
        public static final String SEARCH_NUM_PROMOTED_SOURCES = "search_num_promoted_sources";
        public static final String SEARCH_PER_SOURCE_CONCURRENT_QUERY_LIMIT = "search_per_source_concurrent_query_limit";
        public static final String SEARCH_PREFILL_MILLIS = "search_prefill_millis";
        public static final String SEARCH_PROMOTED_SOURCE_DEADLINE_MILLIS = "search_promoted_source_deadline_millis";
        public static final String SEARCH_QUERY_THREAD_CORE_POOL_SIZE = "search_query_thread_core_pool_size";
        public static final String SEARCH_QUERY_THREAD_MAX_POOL_SIZE = "search_query_thread_max_pool_size";
        public static final String SEARCH_SHORTCUT_REFRESH_CORE_POOL_SIZE = "search_shortcut_refresh_core_pool_size";
        public static final String SEARCH_SHORTCUT_REFRESH_MAX_POOL_SIZE = "search_shortcut_refresh_max_pool_size";
        public static final String SEARCH_SOURCE_TIMEOUT_MILLIS = "search_source_timeout_millis";
        public static final String SEARCH_THREAD_KEEPALIVE_SECONDS = "search_thread_keepalive_seconds";
        public static final String SEARCH_WEB_RESULTS_OVERRIDE_LIMIT = "search_web_results_override_limit";
        public static final String SEND_ACTION_APP_ERROR = "send_action_app_error";
        public static final String SETTINGS_CLASSNAME = "settings_classname";
        public static final String[] SETTINGS_TO_BACKUP;
        public static final String SET_INSTALL_LOCATION = "set_install_location";
        public static final String SHORT_KEYLIGHT_DELAY_MS = "short_keylight_delay_ms";
        public static final String SMS_OUTGOING_CHECK_INTERVAL_MS = "sms_outgoing_check_interval_ms";
        public static final String SMS_OUTGOING_CHECK_MAX_COUNT = "sms_outgoing_check_max_count";
        public static final String SYNC_MAX_RETRY_DELAY_IN_SECONDS = "sync_max_retry_delay_in_seconds";
        public static final String SYS_FREE_STORAGE_LOG_INTERVAL = "sys_free_storage_log_interval";
        public static final String SYS_PROP_SETTING_VERSION = "sys.settings_secure_version";
        public static final String SYS_STORAGE_FULL_THRESHOLD_BYTES = "sys_storage_full_threshold_bytes";
        public static final String SYS_STORAGE_THRESHOLD_PERCENTAGE = "sys_storage_threshold_percentage";
        public static final String TETHER_DUN_APN = "tether_dun_apn";
        public static final String TETHER_DUN_REQUIRED = "tether_dun_required";
        public static final String TETHER_SUPPORTED = "tether_supported";
        public static final String THROTTLE_HELP_URI = "throttle_help_uri";
        public static final String THROTTLE_MAX_NTP_CACHE_AGE_SEC = "throttle_max_ntp_cache_age_sec";
        public static final String THROTTLE_NOTIFICATION_TYPE = "throttle_notification_type";
        public static final String THROTTLE_POLLING_SEC = "throttle_polling_sec";
        public static final String THROTTLE_RESET_DAY = "throttle_reset_day";
        public static final String THROTTLE_THRESHOLD_BYTES = "throttle_threshold_bytes";
        public static final String THROTTLE_VALUE_KBITSPS = "throttle_value_kbitsps";
        public static final String TTS_DEFAULT_COUNTRY = "tts_default_country";
        public static final String TTS_DEFAULT_LANG = "tts_default_lang";
        public static final String TTS_DEFAULT_PITCH = "tts_default_pitch";
        public static final String TTS_DEFAULT_RATE = "tts_default_rate";
        public static final String TTS_DEFAULT_SYNTH = "tts_default_synth";
        public static final String TTS_DEFAULT_VARIANT = "tts_default_variant";
        public static final String TTS_ENABLED_PLUGINS = "tts_enabled_plugins";
        public static final String TTS_USE_DEFAULTS = "tts_use_defaults";
        public static final String TTY_MODE_ENABLED = "tty_mode_enabled";
        public static final String UI_NIGHT_MODE = "ui_night_mode";
        public static final String USB_MASS_STORAGE_ENABLED = "usb_mass_storage_enabled";
        public static final String USE_GOOGLE_MAIL = "use_google_mail";
        public static final String VOICE_RECOGNITION_SERVICE = "voice_recognition_service";
        public static final String WIFI_AP_PASSWD = "wifi_ap_passwd";
        public static final String WIFI_AP_SECURITY = "wifi_ap_security";
        public static final String WIFI_AP_SSID = "wifi_ap_ssid";
        public static final String WIFI_IDLE_MS = "wifi_idle_ms";
        public static final String WIFI_MAX_DHCP_RETRY_COUNT = "wifi_max_dhcp_retry_count";
        public static final String WIFI_MOBILE_DATA_TRANSITION_WAKELOCK_TIMEOUT_MS = "wifi_mobile_data_transition_wakelock_timeout_ms";
        public static final String WIFI_NETWORKS_AVAILABLE_NOTIFICATION_ON = "wifi_networks_available_notification_on";
        public static final String WIFI_NETWORKS_AVAILABLE_REPEAT_DELAY = "wifi_networks_available_repeat_delay";
        public static final String WIFI_NUM_ALLOWED_CHANNELS = "wifi_num_allowed_channels";
        public static final String WIFI_NUM_OPEN_NETWORKS_KEPT = "wifi_num_open_networks_kept";
        public static final String WIFI_ON = "wifi_on";
        public static final String WIFI_SAVED_STATE = "wifi_saved_state";
        public static final String WIFI_WATCHDOG_ACCEPTABLE_PACKET_LOSS_PERCENTAGE = "wifi_watchdog_acceptable_packet_loss_percentage";
        public static final String WIFI_WATCHDOG_AP_COUNT = "wifi_watchdog_ap_count";
        public static final String WIFI_WATCHDOG_BACKGROUND_CHECK_DELAY_MS = "wifi_watchdog_background_check_delay_ms";
        public static final String WIFI_WATCHDOG_BACKGROUND_CHECK_ENABLED = "wifi_watchdog_background_check_enabled";
        public static final String WIFI_WATCHDOG_BACKGROUND_CHECK_TIMEOUT_MS = "wifi_watchdog_background_check_timeout_ms";
        public static final String WIFI_WATCHDOG_INITIAL_IGNORED_PING_COUNT = "wifi_watchdog_initial_ignored_ping_count";
        public static final String WIFI_WATCHDOG_MAX_AP_CHECKS = "wifi_watchdog_max_ap_checks";
        public static final String WIFI_WATCHDOG_ON = "wifi_watchdog_on";
        public static final String WIFI_WATCHDOG_PING_COUNT = "wifi_watchdog_ping_count";
        public static final String WIFI_WATCHDOG_PING_DELAY_MS = "wifi_watchdog_ping_delay_ms";
        public static final String WIFI_WATCHDOG_PING_TIMEOUT_MS = "wifi_watchdog_ping_timeout_ms";
        public static final String WIFI_WATCHDOG_WATCH_LIST = "wifi_watchdog_watch_list";
        public static final String WTF_IS_FATAL = "wtf_is_fatal";
        private static NameValueCache sNameValueCache;

        static {
            sNameValueCache = null;
            CONTENT_URI = Uri.parse("content://settings/secure");
            String[] stringArray = new String[]{ADB_ENABLED, ALLOW_MOCK_LOCATION, PARENTAL_CONTROL_ENABLED, PARENTAL_CONTROL_REDIRECT_URL, USB_MASS_STORAGE_ENABLED, ACCESSIBILITY_ENABLED, BACKUP_AUTO_RESTORE, ENABLED_ACCESSIBILITY_SERVICES, TTS_USE_DEFAULTS, TTS_DEFAULT_RATE, TTS_DEFAULT_PITCH, TTS_DEFAULT_SYNTH, TTS_DEFAULT_LANG, TTS_DEFAULT_COUNTRY, TTS_ENABLED_PLUGINS, WIFI_NETWORKS_AVAILABLE_NOTIFICATION_ON, WIFI_NETWORKS_AVAILABLE_REPEAT_DELAY, WIFI_NUM_ALLOWED_CHANNELS, WIFI_NUM_OPEN_NETWORKS_KEPT, MOUNT_PLAY_NOTIFICATION_SND, MOUNT_UMS_AUTOSTART, MOUNT_UMS_PROMPT, MOUNT_UMS_NOTIFY_ENABLED, UI_NIGHT_MODE};
            SETTINGS_TO_BACKUP = stringArray;
        }

        public static final String getBluetoothA2dpSinkPriorityKey(String string2) {
            StringBuilder stringBuilder = new StringBuilder().append("bluetooth_a2dp_sink_priority_");
            String string3 = string2.toUpperCase();
            return stringBuilder.append(string3).toString();
        }

        public static final String getBluetoothHeadsetPriorityKey(String string2) {
            StringBuilder stringBuilder = new StringBuilder().append("bluetooth_headset_priority_");
            String string3 = string2.toUpperCase();
            return stringBuilder.append(string3).toString();
        }

        public static float getFloat(ContentResolver contentResolver, String string2) throws SettingNotFoundException {
            String string3 = Secure.getString(contentResolver, string2);
            try {
                float f = Float.parseFloat(string3);
                return f;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SettingNotFoundException(string2);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static float getFloat(ContentResolver contentResolver, String string2, float f) {
            String string3 = Secure.getString(contentResolver, string2);
            if (string3 == null) return f;
            try {
                float f2 = Float.parseFloat(string3);
                return f2;
            }
            catch (NumberFormatException numberFormatException) {
                return f;
            }
        }

        public static int getInt(ContentResolver contentResolver, String string2) throws SettingNotFoundException {
            String string3 = Secure.getString(contentResolver, string2);
            try {
                int n = Integer.parseInt(string3);
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SettingNotFoundException(string2);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static int getInt(ContentResolver contentResolver, String string2, int n) {
            String string3 = Secure.getString(contentResolver, string2);
            if (string3 == null) return n;
            try {
                int n2 = Integer.parseInt(string3);
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
        }

        public static long getLong(ContentResolver contentResolver, String string2) throws SettingNotFoundException {
            String string3 = Secure.getString(contentResolver, string2);
            try {
                long l = Long.parseLong(string3);
                return l;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SettingNotFoundException(string2);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static long getLong(ContentResolver contentResolver, String string2, long l) {
            String string3 = Secure.getString(contentResolver, string2);
            if (string3 == null) return l;
            try {
                long l2 = Long.parseLong(string3);
                return l2;
            }
            catch (NumberFormatException numberFormatException) {
                return l;
            }
        }

        public static String getString(ContentResolver contentResolver, String string2) {
            synchronized (Secure.class) {
                String string3;
                if (sNameValueCache == null) {
                    Uri uri = CONTENT_URI;
                    sNameValueCache = new NameValueCache(SYS_PROP_SETTING_VERSION, uri, Settings.CALL_METHOD_GET_SECURE);
                }
                String string4 = string3 = sNameValueCache.getString(contentResolver, string2);
                return string4;
            }
        }

        public static Uri getUriFor(String string2) {
            return Secure.getUriFor(CONTENT_URI, string2);
        }

        public static final boolean isLocationProviderEnabled(ContentResolver contentResolver, String string2) {
            return TextUtils.delimitedStringContains(Secure.getString(contentResolver, LOCATION_PROVIDERS_ALLOWED), ',', string2);
        }

        public static boolean putFloat(ContentResolver contentResolver, String string2, float f) {
            String string3 = Float.toString(f);
            return Secure.putString(contentResolver, string2, string3);
        }

        public static boolean putInt(ContentResolver contentResolver, String string2, int n) {
            String string3 = Integer.toString(n);
            return Secure.putString(contentResolver, string2, string3);
        }

        public static boolean putLong(ContentResolver contentResolver, String string2, long l) {
            String string3 = Long.toString(l);
            return Secure.putString(contentResolver, string2, string3);
        }

        public static boolean putString(ContentResolver contentResolver, String string2, String string3) {
            Uri uri = CONTENT_URI;
            return Secure.putString(contentResolver, uri, string2, string3);
        }

        /*
         * Enabled aggressive block sorting
         */
        public static final void setLocationProviderEnabled(ContentResolver contentResolver, String string2, boolean bl) {
            String string3 = bl ? "+" + string2 : "-" + string2;
            boolean bl2 = Secure.putString(contentResolver, LOCATION_PROVIDERS_ALLOWED, string3);
        }
    }

    public static final class System
    extends NameValueTable {
        public static final String ACCELEROMETER_ROTATION = "accelerometer_rotation";
        @Deprecated
        public static final String ADB_ENABLED = "adb_enabled";
        public static final String AIRPLANE_MODE_ON = "airplane_mode_on";
        public static final String AIRPLANE_MODE_RADIOS = "airplane_mode_radios";
        public static final String AIRPLANE_MODE_TOGGLEABLE_RADIOS = "airplane_mode_toggleable_radios";
        public static final String ALARM_ALERT = "alarm_alert";
        public static final String ALWAYS_FINISH_ACTIVITIES = "always_finish_activities";
        @Deprecated
        public static final String ANDROID_ID = "android_id";
        public static final String APPEND_FOR_LAST_AUDIBLE = "_last_audible";
        public static final String AUTO_TIME = "auto_time";
        public static final String BLUETOOTH_DISCOVERABILITY = "bluetooth_discoverability";
        public static final String BLUETOOTH_DISCOVERABILITY_TIMEOUT = "bluetooth_discoverability_timeout";
        @Deprecated
        public static final String BLUETOOTH_ON = "bluetooth_on";
        public static final String CALL_AUTO_RETRY = "call_auto_retry";
        public static final String CAR_DOCK_SOUND = "car_dock_sound";
        public static final String CAR_UNDOCK_SOUND = "car_undock_sound";
        public static final String COMPATIBILITY_MODE = "compatibility_mode";
        public static final Uri CONTENT_URI;
        @Deprecated
        public static final String DATA_ROAMING = "data_roaming";
        public static final String DATE_FORMAT = "date_format";
        public static final String DEBUG_APP = "debug_app";
        public static final Uri DEFAULT_ALARM_ALERT_URI;
        public static final Uri DEFAULT_NOTIFICATION_URI;
        public static final Uri DEFAULT_RINGTONE_URI;
        public static final String DESK_DOCK_SOUND = "desk_dock_sound";
        public static final String DESK_UNDOCK_SOUND = "desk_undock_sound";
        @Deprecated
        public static final String DEVICE_PROVISIONED = "device_provisioned";
        public static final String DIM_SCREEN = "dim_screen";
        public static final String DOCK_SOUNDS_ENABLED = "dock_sounds_enabled";
        public static final String DTMF_TONE_TYPE_WHEN_DIALING = "dtmf_tone_type";
        public static final String DTMF_TONE_WHEN_DIALING = "dtmf_tone";
        public static final String EMERGENCY_TONE = "emergency_tone";
        public static final String END_BUTTON_BEHAVIOR = "end_button_behavior";
        public static final int END_BUTTON_BEHAVIOR_DEFAULT = 2;
        public static final int END_BUTTON_BEHAVIOR_HOME = 1;
        public static final int END_BUTTON_BEHAVIOR_SLEEP = 2;
        public static final String FANCY_IME_ANIMATIONS = "fancy_ime_animations";
        public static final String FONT_SCALE = "font_scale";
        public static final String HAPTIC_FEEDBACK_ENABLED = "haptic_feedback_enabled";
        public static final String HEARING_AID = "hearing_aid";
        @Deprecated
        public static final String HTTP_PROXY = "http_proxy";
        @Deprecated
        public static final String INSTALL_NON_MARKET_APPS = "install_non_market_apps";
        @Deprecated
        public static final String LOCATION_PROVIDERS_ALLOWED = "location_providers_allowed";
        public static final String LOCKSCREEN_SOUNDS_ENABLED = "lockscreen_sounds_enabled";
        @Deprecated
        public static final String LOCK_PATTERN_ENABLED = "lock_pattern_autolock";
        @Deprecated
        public static final String LOCK_PATTERN_TACTILE_FEEDBACK_ENABLED = "lock_pattern_tactile_feedback_enabled";
        @Deprecated
        public static final String LOCK_PATTERN_VISIBLE = "lock_pattern_visible_pattern";
        public static final String LOCK_SOUND = "lock_sound";
        @Deprecated
        public static final String LOGGING_ID = "logging_id";
        public static final String LOW_BATTERY_SOUND = "low_battery_sound";
        public static final String MODE_RINGER = "mode_ringer";
        public static final String MODE_RINGER_STREAMS_AFFECTED = "mode_ringer_streams_affected";
        private static final HashSet<String> MOVED_TO_SECURE;
        public static final String MUTE_STREAMS_AFFECTED = "mute_streams_affected";
        @Deprecated
        public static final String NETWORK_PREFERENCE = "network_preference";
        public static final String NEXT_ALARM_FORMATTED = "next_alarm_formatted";
        public static final String NOTIFICATIONS_USE_RING_VOLUME = "notifications_use_ring_volume";
        public static final String NOTIFICATION_LIGHT_PULSE = "notification_light_pulse";
        public static final String NOTIFICATION_SOUND = "notification_sound";
        @Deprecated
        public static final String PARENTAL_CONTROL_ENABLED = "parental_control_enabled";
        @Deprecated
        public static final String PARENTAL_CONTROL_LAST_UPDATE = "parental_control_last_update";
        @Deprecated
        public static final String PARENTAL_CONTROL_REDIRECT_URL = "parental_control_redirect_url";
        public static final String POINTER_LOCATION = "pointer_location";
        public static final String POWER_SOUNDS_ENABLED = "power_sounds_enabled";
        public static final String RADIO_BLUETOOTH = "bluetooth";
        public static final String RADIO_CELL = "cell";
        public static final String RADIO_WIFI = "wifi";
        public static final String RINGTONE = "ringtone";
        public static final String SCREEN_BRIGHTNESS = "screen_brightness";
        public static final String SCREEN_BRIGHTNESS_MODE = "screen_brightness_mode";
        public static final int SCREEN_BRIGHTNESS_MODE_AUTOMATIC = 1;
        public static final int SCREEN_BRIGHTNESS_MODE_MANUAL = 0;
        public static final String SCREEN_OFF_TIMEOUT = "screen_off_timeout";
        @Deprecated
        public static final String SETTINGS_CLASSNAME = "settings_classname";
        public static final String[] SETTINGS_TO_BACKUP;
        public static final String SETUP_WIZARD_HAS_RUN = "setup_wizard_has_run";
        public static final String SHOW_GTALK_SERVICE_STATUS = "SHOW_GTALK_SERVICE_STATUS";
        public static final String SHOW_PROCESSES = "show_processes";
        public static final String SHOW_WEB_SUGGESTIONS = "show_web_suggestions";
        public static final String SIP_ADDRESS_ONLY = "SIP_ADDRESS_ONLY";
        public static final String SIP_ALWAYS = "SIP_ALWAYS";
        public static final String SIP_ASK_ME_EACH_TIME = "SIP_ASK_ME_EACH_TIME";
        public static final String SIP_CALL_OPTIONS = "sip_call_options";
        public static final String SIP_RECEIVE_CALLS = "sip_receive_calls";
        public static final String SOUND_EFFECTS_ENABLED = "sound_effects_enabled";
        public static final String STAY_ON_WHILE_PLUGGED_IN = "stay_on_while_plugged_in";
        public static final String SYS_PROP_SETTING_VERSION = "sys.settings_system_version";
        public static final String TEXT_AUTO_CAPS = "auto_caps";
        public static final String TEXT_AUTO_PUNCTUATE = "auto_punctuate";
        public static final String TEXT_AUTO_REPLACE = "auto_replace";
        public static final String TEXT_SHOW_PASSWORD = "show_password";
        public static final String TIME_12_24 = "time_12_24";
        public static final String TRANSITION_ANIMATION_SCALE = "transition_animation_scale";
        public static final String TTY_MODE = "tty_mode";
        public static final String UNLOCK_SOUND = "unlock_sound";
        @Deprecated
        public static final String USB_MASS_STORAGE_ENABLED = "usb_mass_storage_enabled";
        @Deprecated
        public static final String USE_GOOGLE_MAIL = "use_google_mail";
        public static final String VIBRATE_IN_SILENT = "vibrate_in_silent";
        public static final String VIBRATE_ON = "vibrate_on";
        public static final String VOLUME_ALARM = "volume_alarm";
        public static final String VOLUME_BLUETOOTH_SCO = "volume_bluetooth_sco";
        public static final String VOLUME_MUSIC = "volume_music";
        public static final String VOLUME_NOTIFICATION = "volume_notification";
        public static final String VOLUME_RING = "volume_ring";
        public static final String[] VOLUME_SETTINGS;
        public static final String VOLUME_SYSTEM = "volume_system";
        public static final String VOLUME_VOICE = "volume_voice";
        public static final String WAIT_FOR_DEBUGGER = "wait_for_debugger";
        public static final String WALLPAPER_ACTIVITY = "wallpaper_activity";
        @Deprecated
        public static final String WIFI_MAX_DHCP_RETRY_COUNT = "wifi_max_dhcp_retry_count";
        @Deprecated
        public static final String WIFI_MOBILE_DATA_TRANSITION_WAKELOCK_TIMEOUT_MS = "wifi_mobile_data_transition_wakelock_timeout_ms";
        @Deprecated
        public static final String WIFI_NETWORKS_AVAILABLE_NOTIFICATION_ON = "wifi_networks_available_notification_on";
        @Deprecated
        public static final String WIFI_NETWORKS_AVAILABLE_REPEAT_DELAY = "wifi_networks_available_repeat_delay";
        public static final String WIFI_NUM_ALLOWED_CHANNELS = "wifi_num_allowed_channels";
        @Deprecated
        public static final String WIFI_NUM_OPEN_NETWORKS_KEPT = "wifi_num_open_networks_kept";
        @Deprecated
        public static final String WIFI_ON = "wifi_on";
        public static final String WIFI_SLEEP_POLICY = "wifi_sleep_policy";
        public static final int WIFI_SLEEP_POLICY_DEFAULT = 0;
        public static final int WIFI_SLEEP_POLICY_NEVER = 2;
        public static final int WIFI_SLEEP_POLICY_NEVER_WHILE_PLUGGED = 1;
        public static final String WIFI_STATIC_DNS1 = "wifi_static_dns1";
        public static final String WIFI_STATIC_DNS2 = "wifi_static_dns2";
        public static final String WIFI_STATIC_GATEWAY = "wifi_static_gateway";
        public static final String WIFI_STATIC_IP = "wifi_static_ip";
        public static final String WIFI_STATIC_NETMASK = "wifi_static_netmask";
        public static final String WIFI_USE_STATIC_IP = "wifi_use_static_ip";
        @Deprecated
        public static final String WIFI_WATCHDOG_ACCEPTABLE_PACKET_LOSS_PERCENTAGE = "wifi_watchdog_acceptable_packet_loss_percentage";
        @Deprecated
        public static final String WIFI_WATCHDOG_AP_COUNT = "wifi_watchdog_ap_count";
        @Deprecated
        public static final String WIFI_WATCHDOG_BACKGROUND_CHECK_DELAY_MS = "wifi_watchdog_background_check_delay_ms";
        @Deprecated
        public static final String WIFI_WATCHDOG_BACKGROUND_CHECK_ENABLED = "wifi_watchdog_background_check_enabled";
        @Deprecated
        public static final String WIFI_WATCHDOG_BACKGROUND_CHECK_TIMEOUT_MS = "wifi_watchdog_background_check_timeout_ms";
        @Deprecated
        public static final String WIFI_WATCHDOG_INITIAL_IGNORED_PING_COUNT = "wifi_watchdog_initial_ignored_ping_count";
        @Deprecated
        public static final String WIFI_WATCHDOG_MAX_AP_CHECKS = "wifi_watchdog_max_ap_checks";
        @Deprecated
        public static final String WIFI_WATCHDOG_ON = "wifi_watchdog_on";
        @Deprecated
        public static final String WIFI_WATCHDOG_PING_COUNT = "wifi_watchdog_ping_count";
        @Deprecated
        public static final String WIFI_WATCHDOG_PING_DELAY_MS = "wifi_watchdog_ping_delay_ms";
        @Deprecated
        public static final String WIFI_WATCHDOG_PING_TIMEOUT_MS = "wifi_watchdog_ping_timeout_ms";
        public static final String WINDOW_ANIMATION_SCALE = "window_animation_scale";
        private static NameValueCache sNameValueCache;

        static {
            sNameValueCache = null;
            MOVED_TO_SECURE = new HashSet(30);
            boolean bl = MOVED_TO_SECURE.add(ADB_ENABLED);
            boolean bl2 = MOVED_TO_SECURE.add(ANDROID_ID);
            boolean bl3 = MOVED_TO_SECURE.add(BLUETOOTH_ON);
            boolean bl4 = MOVED_TO_SECURE.add(DATA_ROAMING);
            boolean bl5 = MOVED_TO_SECURE.add(DEVICE_PROVISIONED);
            boolean bl6 = MOVED_TO_SECURE.add(HTTP_PROXY);
            boolean bl7 = MOVED_TO_SECURE.add(INSTALL_NON_MARKET_APPS);
            boolean bl8 = MOVED_TO_SECURE.add(LOCATION_PROVIDERS_ALLOWED);
            boolean bl9 = MOVED_TO_SECURE.add(LOCK_PATTERN_ENABLED);
            boolean bl10 = MOVED_TO_SECURE.add(LOCK_PATTERN_VISIBLE);
            boolean bl11 = MOVED_TO_SECURE.add(LOCK_PATTERN_TACTILE_FEEDBACK_ENABLED);
            boolean bl12 = MOVED_TO_SECURE.add(LOGGING_ID);
            boolean bl13 = MOVED_TO_SECURE.add(PARENTAL_CONTROL_ENABLED);
            boolean bl14 = MOVED_TO_SECURE.add(PARENTAL_CONTROL_LAST_UPDATE);
            boolean bl15 = MOVED_TO_SECURE.add(PARENTAL_CONTROL_REDIRECT_URL);
            boolean bl16 = MOVED_TO_SECURE.add(SETTINGS_CLASSNAME);
            boolean bl17 = MOVED_TO_SECURE.add(USB_MASS_STORAGE_ENABLED);
            boolean bl18 = MOVED_TO_SECURE.add(USE_GOOGLE_MAIL);
            boolean bl19 = MOVED_TO_SECURE.add(WIFI_NETWORKS_AVAILABLE_NOTIFICATION_ON);
            boolean bl20 = MOVED_TO_SECURE.add(WIFI_NETWORKS_AVAILABLE_REPEAT_DELAY);
            boolean bl21 = MOVED_TO_SECURE.add(WIFI_NUM_OPEN_NETWORKS_KEPT);
            boolean bl22 = MOVED_TO_SECURE.add(WIFI_ON);
            boolean bl23 = MOVED_TO_SECURE.add(WIFI_WATCHDOG_ACCEPTABLE_PACKET_LOSS_PERCENTAGE);
            boolean bl24 = MOVED_TO_SECURE.add(WIFI_WATCHDOG_AP_COUNT);
            boolean bl25 = MOVED_TO_SECURE.add(WIFI_WATCHDOG_BACKGROUND_CHECK_DELAY_MS);
            boolean bl26 = MOVED_TO_SECURE.add(WIFI_WATCHDOG_BACKGROUND_CHECK_ENABLED);
            boolean bl27 = MOVED_TO_SECURE.add(WIFI_WATCHDOG_BACKGROUND_CHECK_TIMEOUT_MS);
            boolean bl28 = MOVED_TO_SECURE.add(WIFI_WATCHDOG_INITIAL_IGNORED_PING_COUNT);
            boolean bl29 = MOVED_TO_SECURE.add(WIFI_WATCHDOG_MAX_AP_CHECKS);
            boolean bl30 = MOVED_TO_SECURE.add(WIFI_WATCHDOG_ON);
            boolean bl31 = MOVED_TO_SECURE.add(WIFI_WATCHDOG_PING_COUNT);
            boolean bl32 = MOVED_TO_SECURE.add(WIFI_WATCHDOG_PING_DELAY_MS);
            boolean bl33 = MOVED_TO_SECURE.add(WIFI_WATCHDOG_PING_TIMEOUT_MS);
            CONTENT_URI = Uri.parse("content://settings/system");
            String[] stringArray = new String[]{VOLUME_VOICE, VOLUME_SYSTEM, VOLUME_RING, VOLUME_MUSIC, VOLUME_ALARM, VOLUME_NOTIFICATION, VOLUME_BLUETOOTH_SCO};
            VOLUME_SETTINGS = stringArray;
            DEFAULT_RINGTONE_URI = System.getUriFor(RINGTONE);
            DEFAULT_NOTIFICATION_URI = System.getUriFor(NOTIFICATION_SOUND);
            DEFAULT_ALARM_ALERT_URI = System.getUriFor(ALARM_ALERT);
            String[] stringArray2 = new String[]{STAY_ON_WHILE_PLUGGED_IN, WIFI_SLEEP_POLICY, WIFI_USE_STATIC_IP, WIFI_STATIC_IP, WIFI_STATIC_GATEWAY, WIFI_STATIC_NETMASK, WIFI_STATIC_DNS1, WIFI_STATIC_DNS2, BLUETOOTH_DISCOVERABILITY, BLUETOOTH_DISCOVERABILITY_TIMEOUT, DIM_SCREEN, SCREEN_OFF_TIMEOUT, SCREEN_BRIGHTNESS, SCREEN_BRIGHTNESS_MODE, VIBRATE_ON, NOTIFICATIONS_USE_RING_VOLUME, MODE_RINGER, MODE_RINGER_STREAMS_AFFECTED, MUTE_STREAMS_AFFECTED, VOLUME_VOICE, VOLUME_SYSTEM, VOLUME_RING, VOLUME_MUSIC, VOLUME_ALARM, VOLUME_NOTIFICATION, VOLUME_BLUETOOTH_SCO, "volume_voice_last_audible", "volume_system_last_audible", "volume_ring_last_audible", "volume_music_last_audible", "volume_alarm_last_audible", "volume_notification_last_audible", "volume_bluetooth_sco_last_audible", VIBRATE_IN_SILENT, TEXT_AUTO_REPLACE, TEXT_AUTO_CAPS, TEXT_AUTO_PUNCTUATE, TEXT_SHOW_PASSWORD, AUTO_TIME, TIME_12_24, DATE_FORMAT, ACCELEROMETER_ROTATION, DTMF_TONE_WHEN_DIALING, DTMF_TONE_TYPE_WHEN_DIALING, EMERGENCY_TONE, CALL_AUTO_RETRY, HEARING_AID, TTY_MODE, SOUND_EFFECTS_ENABLED, HAPTIC_FEEDBACK_ENABLED, POWER_SOUNDS_ENABLED, DOCK_SOUNDS_ENABLED, LOCKSCREEN_SOUNDS_ENABLED, SHOW_WEB_SUGGESTIONS, NOTIFICATION_LIGHT_PULSE, SIP_CALL_OPTIONS, SIP_RECEIVE_CALLS};
            SETTINGS_TO_BACKUP = stringArray2;
        }

        public static void getConfiguration(ContentResolver contentResolver, Configuration configuration) {
            float f;
            float f2 = configuration.fontScale;
            configuration.fontScale = f = System.getFloat(contentResolver, FONT_SCALE, f2);
            if (!(configuration.fontScale < 0.0f)) {
                return;
            }
            configuration.fontScale = 1.0f;
        }

        public static float getFloat(ContentResolver contentResolver, String string2) throws SettingNotFoundException {
            String string3 = System.getString(contentResolver, string2);
            try {
                float f = Float.parseFloat(string3);
                return f;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SettingNotFoundException(string2);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static float getFloat(ContentResolver contentResolver, String string2, float f) {
            String string3 = System.getString(contentResolver, string2);
            if (string3 == null) return f;
            try {
                float f2 = Float.parseFloat(string3);
                return f2;
            }
            catch (NumberFormatException numberFormatException) {
                return f;
            }
        }

        public static int getInt(ContentResolver contentResolver, String string2) throws SettingNotFoundException {
            String string3 = System.getString(contentResolver, string2);
            try {
                int n = Integer.parseInt(string3);
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SettingNotFoundException(string2);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static int getInt(ContentResolver contentResolver, String string2, int n) {
            String string3 = System.getString(contentResolver, string2);
            if (string3 == null) return n;
            try {
                int n2 = Integer.parseInt(string3);
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
        }

        public static long getLong(ContentResolver contentResolver, String string2) throws SettingNotFoundException {
            String string3 = System.getString(contentResolver, string2);
            try {
                long l = Long.parseLong(string3);
                return l;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SettingNotFoundException(string2);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static long getLong(ContentResolver contentResolver, String string2, long l) {
            String string3 = System.getString(contentResolver, string2);
            if (string3 == null) return l;
            try {
                long l2 = Long.parseLong(string3);
                return l2;
            }
            catch (NumberFormatException numberFormatException) {
                return l;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static boolean getShowGTalkServiceStatus(ContentResolver contentResolver) {
            if (System.getInt(contentResolver, SHOW_GTALK_SERVICE_STATUS, 0) == 0) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static String getString(ContentResolver contentResolver, String string2) {
            synchronized (System.class) {
                block4: {
                    if (!MOVED_TO_SECURE.contains(string2)) break block4;
                    String string3 = "Setting " + string2 + " has moved from android.provider.Settings.System" + " to android.provider.Settings.Secure, returning read-only value.";
                    int n = Log.w(Settings.TAG, string3);
                    String string4 = Secure.getString(contentResolver, string2);
                    return string4;
                }
                String string5 = sNameValueCache.getString(contentResolver, string2);
                if (sNameValueCache != null) return string5;
                Uri uri = CONTENT_URI;
                sNameValueCache = new NameValueCache(SYS_PROP_SETTING_VERSION, uri, Settings.CALL_METHOD_GET_SYSTEM);
                return string5;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static Uri getUriFor(String string2) {
            if (!MOVED_TO_SECURE.contains(string2)) return System.getUriFor(CONTENT_URI, string2);
            String string3 = "Setting " + string2 + " has moved from android.provider.Settings.System" + " to android.provider.Settings.Secure, returning Secure URI.";
            int n = Log.w(Settings.TAG, string3);
            return Secure.getUriFor(Secure.CONTENT_URI, string2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static boolean hasInterestingConfigurationChanges(int n) {
            if ((0x40000000 & n) == 0) return false;
            return true;
        }

        public static boolean putConfiguration(ContentResolver contentResolver, Configuration configuration) {
            float f = configuration.fontScale;
            return System.putFloat(contentResolver, FONT_SCALE, f);
        }

        public static boolean putFloat(ContentResolver contentResolver, String string2, float f) {
            String string3 = Float.toString(f);
            return System.putString(contentResolver, string2, string3);
        }

        public static boolean putInt(ContentResolver contentResolver, String string2, int n) {
            String string3 = Integer.toString(n);
            return System.putString(contentResolver, string2, string3);
        }

        public static boolean putLong(ContentResolver contentResolver, String string2, long l) {
            String string3 = Long.toString(l);
            return System.putString(contentResolver, string2, string3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static boolean putString(ContentResolver contentResolver, String string2, String string3) {
            if (MOVED_TO_SECURE.contains(string2)) {
                String string4 = "Setting " + string2 + " has moved from android.provider.Settings.System" + " to android.provider.Settings.Secure, value is unchanged.";
                int n = Log.w(Settings.TAG, string4);
                return false;
            }
            Uri uri = CONTENT_URI;
            return System.putString(contentResolver, uri, string2, string3);
        }

        /*
         * Enabled aggressive block sorting
         */
        public static void setShowGTalkServiceStatus(ContentResolver contentResolver, boolean bl) {
            int n = bl ? 1 : 0;
            boolean bl2 = System.putInt(contentResolver, SHOW_GTALK_SERVICE_STATUS, n);
        }
    }

    private static class NameValueCache {
        private static final String NAME_EQ_PLACEHOLDER = "name=?";
        private static final String[] SELECT_VALUE;
        private final String mCallCommand;
        private IContentProvider mContentProvider;
        private final Uri mUri;
        private final HashMap<String, String> mValues;
        private long mValuesVersion;
        private final String mVersionSystemProperty;

        static {
            String[] stringArray = new String[]{"value"};
            SELECT_VALUE = stringArray;
        }

        public NameValueCache(String string2, Uri uri, String string3) {
            HashMap hashMap = new HashMap();
            this.mValues = hashMap;
            this.mValuesVersion = 0L;
            this.mContentProvider = null;
            this.mVersionSystemProperty = string2;
            this.mUri = uri;
            this.mCallCommand = string3;
        }

        /*
         * Exception decompiling
         */
        public String getString(ContentResolver var1_1, String var2_2) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 174->176)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static class NameValueTable
    implements BaseColumns {
        public static final String NAME = "name";
        public static final String VALUE = "value";

        public static Uri getUriFor(Uri uri, String string2) {
            return Uri.withAppendedPath(uri, string2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected static boolean putString(ContentResolver contentResolver, Uri uri, String string2, String string3) {
            try {
                ContentValues contentValues = new ContentValues();
                contentValues.put(NAME, string2);
                contentValues.put(VALUE, string3);
                Uri uri2 = contentResolver.insert(uri, contentValues);
                return true;
            }
            catch (SQLException sQLException) {
                String string4 = "Can't set key " + string2 + " in " + uri;
                int n = Log.w(Settings.TAG, string4, sQLException);
                return false;
            }
        }
    }

    public static class SettingNotFoundException
    extends AndroidException {
        public SettingNotFoundException(String string2) {
            super(string2);
        }
    }
}

