/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.provider.BaseColumns;
import android.telephony.SmsMessage;
import android.text.TextUtils;
import android.util.Log;
import android.util.Patterns;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Telephony {
    private static final boolean DEBUG = true;
    private static final boolean LOCAL_LOGV = true;
    private static final String TAG = "Telephony";

    public static final class Intents {
        public static final String EXTRA_PLMN = "plmn";
        public static final String EXTRA_SHOW_PLMN = "showPlmn";
        public static final String EXTRA_SHOW_SPN = "showSpn";
        public static final String EXTRA_SPN = "spn";
        public static final String SECRET_CODE_ACTION = "android.provider.Telephony.SECRET_CODE";
        public static final String SPN_STRINGS_UPDATED_ACTION = "android.provider.Telephony.SPN_STRINGS_UPDATED";

        private Intents() {
        }
    }

    public static final class Carriers
    implements BaseColumns {
        public static final String APN = "apn";
        public static final String AUTH_TYPE = "authtype";
        public static final Uri CONTENT_URI = Uri.parse("content://telephony/carriers");
        public static final String CURRENT = "current";
        public static final String DEFAULT_SORT_ORDER = "name ASC";
        public static final String MCC = "mcc";
        public static final String MMSC = "mmsc";
        public static final String MMSPORT = "mmsport";
        public static final String MMSPROXY = "mmsproxy";
        public static final String MNC = "mnc";
        public static final String NAME = "name";
        public static final String NUMERIC = "numeric";
        public static final String PASSWORD = "password";
        public static final String PORT = "port";
        public static final String PROXY = "proxy";
        public static final String SERVER = "server";
        public static final String TYPE = "type";
        public static final String USER = "user";
    }

    public static final class MmsSms
    implements BaseColumns {
        public static final Uri CONTENT_CONVERSATIONS_URI;
        public static final Uri CONTENT_DRAFT_URI;
        public static final Uri CONTENT_FILTER_BYPHONE_URI;
        public static final Uri CONTENT_LOCKED_URI;
        public static final Uri CONTENT_UNDELIVERED_URI;
        public static final Uri CONTENT_URI;
        public static final int ERR_TYPE_GENERIC = 1;
        public static final int ERR_TYPE_GENERIC_PERMANENT = 10;
        public static final int ERR_TYPE_MMS_PROTO_PERMANENT = 12;
        public static final int ERR_TYPE_MMS_PROTO_TRANSIENT = 3;
        public static final int ERR_TYPE_SMS_PROTO_PERMANENT = 11;
        public static final int ERR_TYPE_SMS_PROTO_TRANSIENT = 2;
        public static final int ERR_TYPE_TRANSPORT_FAILURE = 4;
        public static final int MMS_PROTO = 1;
        public static final int NO_ERROR = 0;
        public static final Uri SEARCH_URI;
        public static final int SMS_PROTO = 0;
        public static final String TYPE_DISCRIMINATOR_COLUMN = "transport_type";

        static {
            CONTENT_URI = Uri.parse("content://mms-sms/");
            CONTENT_CONVERSATIONS_URI = Uri.parse("content://mms-sms/conversations");
            CONTENT_FILTER_BYPHONE_URI = Uri.parse("content://mms-sms/messages/byphone");
            CONTENT_UNDELIVERED_URI = Uri.parse("content://mms-sms/undelivered");
            CONTENT_DRAFT_URI = Uri.parse("content://mms-sms/draft");
            CONTENT_LOCKED_URI = Uri.parse("content://mms-sms/locked");
            SEARCH_URI = Uri.parse("content://mms-sms/search");
        }

        public static final class WordsTable {
            public static final String ID = "_id";
            public static final String INDEXED_TEXT = "index_text";
            public static final String SOURCE_ROW_ID = "source_id";
            public static final String TABLE_ID = "table_to_use";
        }

        public static final class PendingMessages
        implements BaseColumns {
            public static final Uri CONTENT_URI = Uri.withAppendedPath(CONTENT_URI, "pending");
            public static final String DUE_TIME = "due_time";
            public static final String ERROR_CODE = "err_code";
            public static final String ERROR_TYPE = "err_type";
            public static final String LAST_TRY = "last_try";
            public static final String MSG_ID = "msg_id";
            public static final String MSG_TYPE = "msg_type";
            public static final String PROTO_TYPE = "proto_type";
            public static final String RETRY_INDEX = "retry_index";
        }
    }

    public static final class Mms
    implements BaseMmsColumns {
        public static final Uri CONTENT_URI = Uri.parse("content://mms");
        public static final String DEFAULT_SORT_ORDER = "date DESC";
        public static final Pattern NAME_ADDR_EMAIL_PATTERN;
        public static final Pattern QUOTED_STRING_PATTERN;
        public static final Uri REPORT_REQUEST_URI;
        public static final Uri REPORT_STATUS_URI;

        static {
            REPORT_REQUEST_URI = Uri.withAppendedPath(CONTENT_URI, "report-request");
            REPORT_STATUS_URI = Uri.withAppendedPath(CONTENT_URI, "report-status");
            NAME_ADDR_EMAIL_PATTERN = Pattern.compile("\\s*(\"[^\"]*\"|[^<>\"]+)\\s*<([^<>]+)>\\s*");
            QUOTED_STRING_PATTERN = Pattern.compile("\\s*\"([^\"]*)\"\\s*");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static String extractAddrSpec(String string2) {
            Matcher matcher = NAME_ADDR_EMAIL_PATTERN.matcher(string2);
            if (!matcher.matches()) return string2;
            return matcher.group(2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static final String getMessageBoxName(int n) {
            switch (n) {
                default: {
                    String string2 = "Invalid message box: " + n;
                    throw new IllegalArgumentException(string2);
                }
                case 0: {
                    return "all";
                }
                case 1: {
                    return "inbox";
                }
                case 2: {
                    return "sent";
                }
                case 3: {
                    return "drafts";
                }
                case 4: 
            }
            return "outbox";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static boolean isEmailAddress(String string2) {
            if (TextUtils.isEmpty(string2)) {
                return false;
            }
            String string3 = Mms.extractAddrSpec(string2);
            return Patterns.EMAIL_ADDRESS.matcher(string3).matches();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static boolean isPhoneNumber(String string2) {
            if (!TextUtils.isEmpty(string2)) return Patterns.PHONE.matcher(string2).matches();
            return false;
        }

        public static final Cursor query(ContentResolver contentResolver, String[] stringArray) {
            Uri uri = CONTENT_URI;
            ContentResolver contentResolver2 = contentResolver;
            String[] stringArray2 = stringArray;
            String[] stringArray3 = null;
            return contentResolver2.query(uri, stringArray2, null, stringArray3, DEFAULT_SORT_ORDER);
        }

        /*
         * Enabled aggressive block sorting
         */
        public static final Cursor query(ContentResolver contentResolver, String[] stringArray, String string2, String string3) {
            Uri uri = CONTENT_URI;
            String string4 = string3 == null ? DEFAULT_SORT_ORDER : string3;
            ContentResolver contentResolver2 = contentResolver;
            String[] stringArray2 = stringArray;
            String string5 = string2;
            return contentResolver2.query(uri, stringArray2, string5, null, string4);
        }

        public static final class Intents {
            public static final String CONTENT_CHANGED_ACTION = "android.intent.action.CONTENT_CHANGED";
            public static final String DELETED_CONTENTS = "deleted_contents";
            public static final String EXTRA_BCC = "bcc";
            public static final String EXTRA_CC = "cc";
            public static final String EXTRA_CONTENTS = "contents";
            public static final String EXTRA_SUBJECT = "subject";
            public static final String EXTRA_TYPES = "types";

            private Intents() {
            }
        }

        public static final class ScrapSpace {
            public static final Uri CONTENT_URI = Uri.parse("content://mms/scrapSpace");
            public static final String SCRAP_FILE_PATH = "/sdcard/mms/scrapSpace/.temp.jpg";
        }

        public static final class Rate {
            public static final Uri CONTENT_URI = Uri.withAppendedPath(CONTENT_URI, "rate");
            public static final String SENT_TIME = "sent_time";
        }

        public static final class Part
        implements BaseColumns {
            public static final String CHARSET = "chset";
            public static final String CONTENT_DISPOSITION = "cd";
            public static final String CONTENT_ID = "cid";
            public static final String CONTENT_LOCATION = "cl";
            public static final String CONTENT_TYPE = "ct";
            public static final String CT_START = "ctt_s";
            public static final String CT_TYPE = "ctt_t";
            public static final String FILENAME = "fn";
            public static final String MSG_ID = "mid";
            public static final String NAME = "name";
            public static final String SEQ = "seq";
            public static final String TEXT = "text";
            public static final String _DATA = "_data";
        }

        public static final class Addr
        implements BaseColumns {
            public static final String ADDRESS = "address";
            public static final String CHARSET = "charset";
            public static final String CONTACT_ID = "contact_id";
            public static final String MSG_ID = "msg_id";
            public static final String TYPE = "type";
        }

        public static final class Outbox
        implements BaseMmsColumns {
            public static final Uri CONTENT_URI = Uri.parse("content://mms/outbox");
            public static final String DEFAULT_SORT_ORDER = "date DESC";
        }

        public static final class Draft
        implements BaseMmsColumns {
            public static final Uri CONTENT_URI = Uri.parse("content://mms/drafts");
            public static final String DEFAULT_SORT_ORDER = "date DESC";
        }

        public static final class Sent
        implements BaseMmsColumns {
            public static final Uri CONTENT_URI = Uri.parse("content://mms/sent");
            public static final String DEFAULT_SORT_ORDER = "date DESC";
        }

        public static final class Inbox
        implements BaseMmsColumns {
            public static final Uri CONTENT_URI = Uri.parse("content://mms/inbox");
            public static final String DEFAULT_SORT_ORDER = "date DESC";
        }
    }

    public static final class Threads
    implements ThreadsColumns {
        public static final int BROADCAST_THREAD = 1;
        public static final int COMMON_THREAD = 0;
        public static final Uri CONTENT_URI;
        private static final String[] ID_PROJECTION;
        public static final Uri OBSOLETE_THREADS_URI;
        private static final String STANDARD_ENCODING = "UTF-8";
        private static final Uri THREAD_ID_CONTENT_URI;

        static {
            String[] stringArray = new String[]{"_id"};
            ID_PROJECTION = stringArray;
            THREAD_ID_CONTENT_URI = Uri.parse("content://mms-sms/threadID");
            CONTENT_URI = Uri.withAppendedPath(MmsSms.CONTENT_URI, "conversations");
            OBSOLETE_THREADS_URI = Uri.withAppendedPath(CONTENT_URI, "obsolete");
        }

        private Threads() {
        }

        public static long getOrCreateThreadId(Context context, String string2) {
            HashSet<String> hashSet = new HashSet<String>();
            boolean bl = hashSet.add(string2);
            return Threads.getOrCreateThreadId(context, hashSet);
        }

        /*
         * Loose catch block
         */
        public static long getOrCreateThreadId(Context context, Set<String> set) {
            Uri.Builder builder = THREAD_ID_CONTENT_URI.buildUpon();
            for (String string2 : set) {
                if (Mms.isEmailAddress(string2)) {
                    string2 = Mms.extractAddrSpec(string2);
                }
                Uri.Builder builder2 = builder.appendQueryParameter("recipient", string2);
            }
            Uri uri = builder.build();
            ContentResolver contentResolver = context.getContentResolver();
            String[] stringArray = ID_PROJECTION;
            Context context2 = context;
            String[] stringArray2 = null;
            String string3 = null;
            Cursor cursor = SqliteWrapper.query(context2, contentResolver, uri, stringArray, null, stringArray2, string3);
            StringBuilder stringBuilder = new StringBuilder().append("getOrCreateThreadId cursor cnt: ");
            int n = cursor.getCount();
            String string4 = stringBuilder.append(n).toString();
            int n2 = Log.v(Telephony.TAG, string4);
            if (cursor != null) {
                block7: {
                    long l;
                    if (!cursor.moveToFirst()) break block7;
                    long l2 = l = cursor.getLong(0);
                    cursor.close();
                    return l2;
                }
                int n3 = Log.e(Telephony.TAG, "getOrCreateThreadId returned no rows!");
            }
            StringBuilder stringBuilder2 = new StringBuilder().append("getOrCreateThreadId failed with uri ");
            String string5 = uri.toString();
            String string6 = stringBuilder2.append(string5).toString();
            int n4 = Log.e(Telephony.TAG, string6);
            throw new IllegalArgumentException("Unable to find or allocate a thread ID.");
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                cursor.close();
            }
        }
    }

    public static interface ThreadsColumns
    extends BaseColumns {
        public static final String DATE = "date";
        public static final String ERROR = "error";
        public static final String HAS_ATTACHMENT = "has_attachment";
        public static final String MESSAGE_COUNT = "message_count";
        public static final String READ = "read";
        public static final String RECIPIENT_IDS = "recipient_ids";
        public static final String SNIPPET = "snippet";
        public static final String SNIPPET_CHARSET = "snippet_cs";
        public static final String TYPE = "type";
    }

    public static interface CanonicalAddressesColumns
    extends BaseColumns {
        public static final String ADDRESS = "address";
    }

    public static interface BaseMmsColumns
    extends BaseColumns {
        public static final String ADAPTATION_ALLOWED = "adp_a";
        public static final String APPLIC_ID = "apl_id";
        public static final String AUX_APPLIC_ID = "aux_apl_id";
        public static final String BCC = "bcc";
        public static final String CANCEL_ID = "cl_id";
        public static final String CANCEL_STATUS = "cl_st";
        public static final String CC = "cc";
        public static final String CONTENT_CLASS = "ct_cls";
        public static final String CONTENT_LOCATION = "ct_l";
        public static final String CONTENT_TYPE = "ct_t";
        public static final String DATE = "date";
        public static final String DELIVERY_REPORT = "d_rpt";
        public static final String DELIVERY_TIME = "d_tm";
        public static final String DELIVERY_TIME_TOKEN = "d_tm_tok";
        public static final String DISTRIBUTION_INDICATOR = "d_ind";
        public static final String DRM_CONTENT = "drm_c";
        public static final String ELEMENT_DESCRIPTOR = "e_des";
        public static final String EXPIRY = "exp";
        public static final String FROM = "from";
        public static final String LIMIT = "limit";
        public static final String LOCKED = "locked";
        public static final String MBOX_QUOTAS = "mb_qt";
        public static final String MBOX_QUOTAS_TOKEN = "mb_qt_tok";
        public static final String MBOX_TOTALS = "mb_t";
        public static final String MBOX_TOTALS_TOKEN = "mb_t_tok";
        public static final String MESSAGE_BOX = "msg_box";
        public static final int MESSAGE_BOX_ALL = 0;
        public static final int MESSAGE_BOX_DRAFTS = 3;
        public static final int MESSAGE_BOX_INBOX = 1;
        public static final int MESSAGE_BOX_OUTBOX = 4;
        public static final int MESSAGE_BOX_SENT = 2;
        public static final String MESSAGE_CLASS = "m_cls";
        public static final String MESSAGE_COUNT = "m_cnt";
        public static final String MESSAGE_ID = "m_id";
        public static final String MESSAGE_SIZE = "m_size";
        public static final String MESSAGE_TYPE = "m_type";
        public static final String META_DATA = "meta_data";
        public static final String MMS_VERSION = "v";
        public static final String MM_FLAGS = "mm_flg";
        public static final String MM_FLAGS_TOKEN = "mm_flg_tok";
        public static final String MM_STATE = "mm_st";
        public static final String PREVIOUSLY_SENT_BY = "p_s_by";
        public static final String PREVIOUSLY_SENT_DATE = "p_s_d";
        public static final String PRIORITY = "pri";
        public static final String QUOTAS = "qt";
        public static final String READ = "read";
        public static final String READ_REPORT = "rr";
        public static final String READ_STATUS = "read_status";
        public static final String RECOMMENDED_RETRIEVAL_MODE = "r_r_mod";
        public static final String RECOMMENDED_RETRIEVAL_MODE_TEXT = "r_r_mod_txt";
        public static final String REPLACE_ID = "repl_id";
        public static final String REPLY_APPLIC_ID = "r_apl_id";
        public static final String REPLY_CHARGING = "r_chg";
        public static final String REPLY_CHARGING_DEADLINE = "r_chg_dl";
        public static final String REPLY_CHARGING_DEADLINE_TOKEN = "r_chg_dl_tok";
        public static final String REPLY_CHARGING_ID = "r_chg_id";
        public static final String REPLY_CHARGING_SIZE = "r_chg_sz";
        public static final String REPORT_ALLOWED = "rpt_a";
        public static final String RESPONSE_STATUS = "resp_st";
        public static final String RESPONSE_TEXT = "resp_txt";
        public static final String RETRIEVE_STATUS = "retr_st";
        public static final String RETRIEVE_TEXT = "retr_txt";
        public static final String RETRIEVE_TEXT_CHARSET = "retr_txt_cs";
        public static final String SEEN = "seen";
        public static final String SENDER_VISIBILITY = "s_vis";
        public static final String START = "start";
        public static final String STATUS = "st";
        public static final String STATUS_TEXT = "st_txt";
        public static final String STORE = "store";
        public static final String STORED = "stored";
        public static final String STORE_STATUS = "store_st";
        public static final String STORE_STATUS_TEXT = "store_st_txt";
        public static final String SUBJECT = "sub";
        public static final String SUBJECT_CHARSET = "sub_cs";
        public static final String THREAD_ID = "thread_id";
        public static final String TO = "to";
        public static final String TOTALS = "totals";
        public static final String TRANSACTION_ID = "tr_id";
    }

    public static final class Sms
    implements BaseColumns,
    TextBasedSmsColumns {
        public static final Uri CONTENT_URI = Uri.parse("content://sms");
        public static final String DEFAULT_SORT_ORDER = "date DESC";

        public static Uri addMessageToUri(ContentResolver contentResolver, Uri uri, String string2, String string3, String string4, Long l, boolean bl, boolean bl2) {
            ContentResolver contentResolver2 = contentResolver;
            Uri uri2 = uri;
            String string5 = string2;
            String string6 = string3;
            String string7 = string4;
            Long l2 = l;
            boolean bl3 = bl;
            boolean bl4 = bl2;
            long l3 = 65535L;
            return Sms.addMessageToUri(contentResolver2, uri2, string5, string6, string7, l2, bl3, bl4, l3);
        }

        /*
         * Enabled aggressive block sorting
         */
        public static Uri addMessageToUri(ContentResolver contentResolver, Uri uri, String string2, String string3, String string4, Long l, boolean bl, boolean bl2, long l2) {
            ContentValues contentValues = new ContentValues(7);
            contentValues.put("address", string2);
            if (l != null) {
                contentValues.put("date", l);
            }
            String string5 = "read";
            Integer n = bl ? Integer.valueOf(1) : Integer.valueOf(0);
            contentValues.put(string5, n);
            contentValues.put("subject", string4);
            contentValues.put("body", string3);
            if (bl2) {
                Integer n2 = 32;
                contentValues.put("status", n2);
            }
            if (l2 != 65535L) {
                Long l3 = l2;
                contentValues.put("thread_id", l3);
            }
            return contentResolver.insert(uri, contentValues);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static boolean isOutgoingFolder(int n) {
            if (n == 5) return true;
            if (n == 4) return true;
            if (n == 2) return true;
            if (n != 6) return false;
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        public static boolean moveMessageToFolder(Context context, Uri uri, int n, int n2) {
            if (uri == null) {
                return false;
            }
            boolean bl = false;
            boolean bl2 = false;
            switch (n) {
                default: {
                    return false;
                }
                case 2: 
                case 4: {
                    bl2 = true;
                    break;
                }
                case 5: 
                case 6: {
                    bl = true;
                }
                case 1: 
                case 3: 
            }
            ContentValues contentValues = new ContentValues(3);
            Integer n3 = n;
            contentValues.put("type", n3);
            if (bl) {
                Integer n4 = 0;
                contentValues.put("read", n4);
            } else if (bl2) {
                Integer n5 = 1;
                contentValues.put("read", n5);
            }
            Integer n6 = n2;
            contentValues.put("error_code", n6);
            ContentResolver contentResolver = context.getContentResolver();
            Context context2 = context;
            Uri uri2 = uri;
            String[] stringArray = null;
            int n7 = SqliteWrapper.update(context2, contentResolver, uri2, contentValues, null, stringArray);
            if (1 == n7) return false;
            return true;
        }

        public static final Cursor query(ContentResolver contentResolver, String[] stringArray) {
            Uri uri = CONTENT_URI;
            ContentResolver contentResolver2 = contentResolver;
            String[] stringArray2 = stringArray;
            String[] stringArray3 = null;
            return contentResolver2.query(uri, stringArray2, null, stringArray3, DEFAULT_SORT_ORDER);
        }

        /*
         * Enabled aggressive block sorting
         */
        public static final Cursor query(ContentResolver contentResolver, String[] stringArray, String string2, String string3) {
            Uri uri = CONTENT_URI;
            String string4 = string3 == null ? DEFAULT_SORT_ORDER : string3;
            ContentResolver contentResolver2 = contentResolver;
            String[] stringArray2 = stringArray;
            String string5 = string2;
            return contentResolver2.query(uri, stringArray2, string5, null, string4);
        }

        public static final class Intents {
            public static final String DATA_SMS_RECEIVED_ACTION = "android.intent.action.DATA_SMS_RECEIVED";
            public static final int RESULT_SMS_GENERIC_ERROR = 2;
            public static final int RESULT_SMS_HANDLED = 1;
            public static final int RESULT_SMS_OUT_OF_MEMORY = 3;
            public static final int RESULT_SMS_UNSUPPORTED = 4;
            public static final String SIM_FULL_ACTION = "android.provider.Telephony.SIM_FULL";
            public static final String SMS_RECEIVED_ACTION = "android.provider.Telephony.SMS_RECEIVED";
            public static final String SMS_REJECTED_ACTION = "android.provider.Telephony.SMS_REJECTED";
            public static final String WAP_PUSH_RECEIVED_ACTION = "android.provider.Telephony.WAP_PUSH_RECEIVED";

            public static final SmsMessage[] getMessagesFromIntent(Intent intent) {
                int n;
                Object[] objectArray = (Object[])intent.getSerializableExtra("pdus");
                byte[] byArray = new byte[objectArray.length];
                for (int i = 0; i < (n = objectArray.length); ++i) {
                    byte[] byArray2 = (byte[])objectArray[i];
                    byArray[i] = (byte)byArray2;
                }
                byte[] byArray3 = new byte[byArray.length];
                int n2 = byArray3.length;
                SmsMessage[] smsMessageArray = new SmsMessage[n2];
                for (int i = 0; i < n2; ++i) {
                    SmsMessage smsMessage;
                    byte by;
                    byArray3[i] = by = byArray[i];
                    smsMessageArray[i] = smsMessage = SmsMessage.createFromPdu((byte[])byArray3[i]);
                }
                return smsMessageArray;
            }
        }

        public static final class Conversations
        implements BaseColumns,
        TextBasedSmsColumns {
            public static final Uri CONTENT_URI = Uri.parse("content://sms/conversations");
            public static final String DEFAULT_SORT_ORDER = "date DESC";
            public static final String MESSAGE_COUNT = "msg_count";
            public static final String SNIPPET = "snippet";
        }

        public static final class Outbox
        implements BaseColumns,
        TextBasedSmsColumns {
            public static final Uri CONTENT_URI = Uri.parse("content://sms/outbox");
            public static final String DEFAULT_SORT_ORDER = "date DESC";

            public static Uri addMessage(ContentResolver contentResolver, String string2, String string3, String string4, Long l, boolean bl, long l2) {
                Uri uri = CONTENT_URI;
                ContentResolver contentResolver2 = contentResolver;
                String string5 = string2;
                String string6 = string3;
                String string7 = string4;
                Long l3 = l;
                boolean bl2 = bl;
                long l4 = l2;
                return Sms.addMessageToUri(contentResolver2, uri, string5, string6, string7, l3, true, bl2, l4);
            }
        }

        public static final class Draft
        implements BaseColumns,
        TextBasedSmsColumns {
            public static final Uri CONTENT_URI = Uri.parse("content://sms/draft");
            public static final String DEFAULT_SORT_ORDER = "date DESC";

            public static Uri addMessage(ContentResolver contentResolver, String string2, String string3, String string4, Long l) {
                Uri uri = CONTENT_URI;
                ContentResolver contentResolver2 = contentResolver;
                String string5 = string2;
                String string6 = string3;
                String string7 = string4;
                Long l2 = l;
                return Sms.addMessageToUri(contentResolver2, uri, string5, string6, string7, l2, true, false);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public static boolean saveMessage(ContentResolver contentResolver, Uri uri, String string2) {
                ContentValues contentValues = new ContentValues(2);
                contentValues.put("body", string2);
                Long l = System.currentTimeMillis();
                contentValues.put("date", l);
                if (contentResolver.update(uri, contentValues, null, null) != 1) return false;
                return true;
            }
        }

        public static final class Sent
        implements BaseColumns,
        TextBasedSmsColumns {
            public static final Uri CONTENT_URI = Uri.parse("content://sms/sent");
            public static final String DEFAULT_SORT_ORDER = "date DESC";

            public static Uri addMessage(ContentResolver contentResolver, String string2, String string3, String string4, Long l) {
                Uri uri = CONTENT_URI;
                ContentResolver contentResolver2 = contentResolver;
                String string5 = string2;
                String string6 = string3;
                String string7 = string4;
                Long l2 = l;
                return Sms.addMessageToUri(contentResolver2, uri, string5, string6, string7, l2, true, false);
            }
        }

        public static final class Inbox
        implements BaseColumns,
        TextBasedSmsColumns {
            public static final Uri CONTENT_URI = Uri.parse("content://sms/inbox");
            public static final String DEFAULT_SORT_ORDER = "date DESC";

            public static Uri addMessage(ContentResolver contentResolver, String string2, String string3, String string4, Long l, boolean bl) {
                Uri uri = CONTENT_URI;
                ContentResolver contentResolver2 = contentResolver;
                String string5 = string2;
                String string6 = string3;
                String string7 = string4;
                Long l2 = l;
                boolean bl2 = bl;
                return Sms.addMessageToUri(contentResolver2, uri, string5, string6, string7, l2, bl2, false);
            }
        }
    }

    public static interface TextBasedSmsColumns {
        public static final String ADDRESS = "address";
        public static final String BODY = "body";
        public static final String DATE = "date";
        public static final String ERROR_CODE = "error_code";
        public static final String LOCKED = "locked";
        public static final int MESSAGE_TYPE_ALL = 0;
        public static final int MESSAGE_TYPE_DRAFT = 3;
        public static final int MESSAGE_TYPE_FAILED = 5;
        public static final int MESSAGE_TYPE_INBOX = 1;
        public static final int MESSAGE_TYPE_OUTBOX = 4;
        public static final int MESSAGE_TYPE_QUEUED = 6;
        public static final int MESSAGE_TYPE_SENT = 2;
        public static final String META_DATA = "meta_data";
        public static final String PERSON = "person";
        public static final String PERSON_ID = "person";
        public static final String PROTOCOL = "protocol";
        public static final String READ = "read";
        public static final String REPLY_PATH_PRESENT = "reply_path_present";
        public static final String SEEN = "seen";
        public static final String SERVICE_CENTER = "service_center";
        public static final String STATUS = "status";
        public static final int STATUS_COMPLETE = 0;
        public static final int STATUS_FAILED = 64;
        public static final int STATUS_NONE = 255;
        public static final int STATUS_PENDING = 32;
        public static final String SUBJECT = "subject";
        public static final String THREAD_ID = "thread_id";
        public static final String TYPE = "type";
    }
}

