/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.renderscript.BaseObj;
import android.renderscript.Dimension;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.Type;

public class Allocation
extends BaseObj {
    private static BitmapFactory.Options mBitmapOptions = new BitmapFactory.Options();
    Bitmap mBitmap;
    Type mType;

    static {
        Allocation.mBitmapOptions.inScaled = false;
    }

    Allocation(int n, RenderScript renderScript, Type type) {
        super(renderScript);
        this.mID = n;
        this.mType = type;
    }

    public static Allocation createBitmapRef(RenderScript renderScript, Bitmap bitmap) throws IllegalArgumentException {
        renderScript.validate();
        Type type = Allocation.typeFromBitmap(renderScript, bitmap);
        int n = type.getID();
        int n2 = renderScript.nAllocationCreateBitmapRef(n, bitmap);
        if (n2 == 0) {
            throw new IllegalStateException("Load failed.");
        }
        Allocation allocation = new Allocation(n2, renderScript, type);
        allocation.mBitmap = bitmap;
        return allocation;
    }

    public static Allocation createFromBitmap(RenderScript renderScript, Bitmap bitmap, Element element, boolean bl) throws IllegalArgumentException {
        renderScript.validate();
        Type type = Allocation.typeFromBitmap(renderScript, bitmap);
        int n = element.mID;
        int n2 = renderScript.nAllocationCreateFromBitmap(n, bl, bitmap);
        if (n2 == 0) {
            throw new IllegalStateException("Load failed.");
        }
        return new Allocation(n2, renderScript, type);
    }

    static Allocation createFromBitmapBoxed(RenderScript renderScript, Bitmap bitmap, Element element, boolean bl) throws IllegalArgumentException {
        renderScript.validate();
        int n = element.mID;
        int n2 = renderScript.nAllocationCreateFromBitmapBoxed(n, bl, bitmap);
        if (n2 == 0) {
            throw new IllegalStateException("Load failed.");
        }
        return new Allocation(n2, renderScript, null);
    }

    /*
     * Exception decompiling
     */
    public static Allocation createFromBitmapResource(RenderScript var0, Resources var1_1, int var2_2, Element var3_3, boolean var4_4) throws IllegalArgumentException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3, 4 : 83->96)] java.lang.Exception
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Allocation createFromBitmapResourceBoxed(RenderScript renderScript, Resources resources, int n, Element element, boolean bl) throws IllegalArgumentException {
        Allocation.mBitmapOptions.inPreferredConfig = null;
        Element element2 = renderScript.mElement_RGBA_8888;
        if (element == element2) {
            Bitmap.Config config;
            BitmapFactory.Options options = mBitmapOptions;
            options.inPreferredConfig = config = Bitmap.Config.ARGB_8888;
        } else {
            Element element3 = renderScript.mElement_RGB_888;
            if (element == element3) {
                Bitmap.Config config;
                BitmapFactory.Options options = mBitmapOptions;
                options.inPreferredConfig = config = Bitmap.Config.ARGB_8888;
            } else {
                Element element4 = renderScript.mElement_RGBA_4444;
                if (element == element4) {
                    Bitmap.Config config;
                    BitmapFactory.Options options = mBitmapOptions;
                    options.inPreferredConfig = config = Bitmap.Config.ARGB_4444;
                } else {
                    Element element5 = renderScript.mElement_RGB_565;
                    if (element == element5) {
                        Bitmap.Config config;
                        BitmapFactory.Options options = mBitmapOptions;
                        options.inPreferredConfig = config = Bitmap.Config.RGB_565;
                    }
                }
            }
        }
        BitmapFactory.Options options = mBitmapOptions;
        Bitmap bitmap = BitmapFactory.decodeResource(resources, n, options);
        return Allocation.createFromBitmapBoxed(renderScript, bitmap, element, bl);
    }

    public static Allocation createSized(RenderScript renderScript, Element element, int n) throws IllegalArgumentException {
        renderScript.validate();
        Type.Builder builder = new Type.Builder(renderScript, element);
        Dimension dimension = Dimension.X;
        builder.add(dimension, n);
        Type type = builder.create();
        int n2 = type.mID;
        int n3 = renderScript.nAllocationCreateTyped(n2);
        if (n3 == 0) {
            throw new IllegalStateException("Bad element.");
        }
        return new Allocation(n3, renderScript, type);
    }

    public static Allocation createTyped(RenderScript renderScript, Type type) throws IllegalArgumentException {
        renderScript.validate();
        if (type.mID == 0) {
            throw new IllegalStateException("Bad Type");
        }
        int n = type.mID;
        int n2 = renderScript.nAllocationCreateTyped(n);
        return new Allocation(n2, renderScript, type);
    }

    private void data1DChecks(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        this.mRS.validate();
        if (n < 0 || n2 < 1 || (n6 = n + n2) > (n5 = this.mType.getElementCount())) {
            throw new IllegalArgumentException("Offset or Count out of bounds.");
        }
        if (n3 >= n4) {
            return;
        }
        throw new IllegalArgumentException("Array too small for allocation type.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Element elementFromBitmap(RenderScript renderScript, Bitmap bitmap) {
        Bitmap.Config config;
        Bitmap.Config config2 = bitmap.getConfig();
        if (config2 == (config = Bitmap.Config.ALPHA_8)) {
            return Element.A_8(renderScript);
        }
        Bitmap.Config config3 = Bitmap.Config.ARGB_4444;
        if (config2 == config3) {
            return Element.RGBA_4444(renderScript);
        }
        Bitmap.Config config4 = Bitmap.Config.ARGB_8888;
        if (config2 == config4) {
            return Element.RGBA_8888(renderScript);
        }
        Bitmap.Config config5 = Bitmap.Config.RGB_565;
        if (config2 != config5) throw new IllegalStateException("Bad bitmap type.");
        return Element.RGB_565(renderScript);
    }

    private static Type typeFromBitmap(RenderScript renderScript, Bitmap bitmap) {
        Element element = Allocation.elementFromBitmap(renderScript, bitmap);
        Type.Builder builder = new Type.Builder(renderScript, element);
        Dimension dimension = Dimension.X;
        int n = bitmap.getWidth();
        builder.add(dimension, n);
        Dimension dimension2 = Dimension.Y;
        int n2 = bitmap.getHeight();
        builder.add(dimension2, n2);
        return builder.create();
    }

    public Adapter1D createAdapter1D() {
        this.mRS.validate();
        int n = this.mRS.nAdapter1DCreate();
        if (n == 0) {
            throw new IllegalStateException("allocation failed.");
        }
        RenderScript renderScript = this.mRS;
        int n2 = this.mID;
        renderScript.nAdapter1DBindAllocation(n, n2);
        RenderScript renderScript2 = this.mRS;
        return new Adapter1D(n, renderScript2);
    }

    public Adapter2D createAdapter2D() {
        this.mRS.validate();
        int n = this.mRS.nAdapter2DCreate();
        if (n == 0) {
            throw new IllegalStateException("allocation failed.");
        }
        RenderScript renderScript = this.mRS;
        int n2 = this.mID;
        renderScript.nAdapter2DBindAllocation(n, n2);
        RenderScript renderScript2 = this.mRS;
        return new Adapter2D(n, renderScript2);
    }

    public void data(Object object) {
        this.mRS.validate();
        RenderScript renderScript = this.mRS;
        int n = this.mID;
        Type type = this.mType;
        renderScript.nAllocationSubDataFromObject(n, type, 0, object);
    }

    public void data(byte[] byArray) {
        this.mRS.validate();
        int n = this.mType.getElementCount();
        this.subData1D(0, n, byArray);
    }

    public void data(float[] fArray) {
        this.mRS.validate();
        int n = this.mType.getElementCount();
        this.subData1D(0, n, fArray);
    }

    public void data(int[] nArray) {
        this.mRS.validate();
        int n = this.mType.getElementCount();
        this.subData1D(0, n, nArray);
    }

    public void data(short[] sArray) {
        this.mRS.validate();
        int n = this.mType.getElementCount();
        this.subData1D(0, n, sArray);
    }

    public Type getType() {
        return this.mType;
    }

    public void read(Object object) {
        this.mRS.validate();
        RenderScript renderScript = this.mRS;
        int n = this.mID;
        Type type = this.mType;
        renderScript.nAllocationSubReadFromObject(n, type, 0, object);
    }

    public void readData(float[] fArray) {
        this.mRS.validate();
        RenderScript renderScript = this.mRS;
        int n = this.mID;
        renderScript.nAllocationRead(n, fArray);
    }

    public void readData(int[] nArray) {
        this.mRS.validate();
        RenderScript renderScript = this.mRS;
        int n = this.mID;
        renderScript.nAllocationRead(n, nArray);
    }

    public void subData(int n, Object object) {
        this.mRS.validate();
        RenderScript renderScript = this.mRS;
        int n2 = this.mID;
        Type type = this.mType;
        renderScript.nAllocationSubDataFromObject(n2, type, n, object);
    }

    public void subData1D(int n, int n2, byte[] byArray) {
        int n3 = this.mType.mElement.getSizeBytes() * n2;
        int n4 = byArray.length;
        this.data1DChecks(n, n2, n4, n3);
        RenderScript renderScript = this.mRS;
        int n5 = this.mID;
        int n6 = n;
        int n7 = n2;
        byte[] byArray2 = byArray;
        renderScript.nAllocationSubData1D(n5, n6, n7, byArray2, n3);
    }

    public void subData1D(int n, int n2, float[] fArray) {
        int n3 = this.mType.mElement.getSizeBytes() * n2;
        int n4 = fArray.length * 4;
        this.data1DChecks(n, n2, n4, n3);
        RenderScript renderScript = this.mRS;
        int n5 = this.mID;
        int n6 = n;
        int n7 = n2;
        float[] fArray2 = fArray;
        renderScript.nAllocationSubData1D(n5, n6, n7, fArray2, n3);
    }

    public void subData1D(int n, int n2, int[] nArray) {
        int n3 = this.mType.mElement.getSizeBytes() * n2;
        int n4 = nArray.length * 4;
        this.data1DChecks(n, n2, n4, n3);
        RenderScript renderScript = this.mRS;
        int n5 = this.mID;
        int n6 = n;
        int n7 = n2;
        int[] nArray2 = nArray;
        renderScript.nAllocationSubData1D(n5, n6, n7, nArray2, n3);
    }

    public void subData1D(int n, int n2, short[] sArray) {
        int n3 = this.mType.mElement.getSizeBytes() * n2;
        int n4 = sArray.length * 2;
        this.data1DChecks(n, n2, n4, n3);
        RenderScript renderScript = this.mRS;
        int n5 = this.mID;
        int n6 = n;
        int n7 = n2;
        short[] sArray2 = sArray;
        renderScript.nAllocationSubData1D(n5, n6, n7, sArray2, n3);
    }

    public void subData2D(int n, int n2, int n3, int n4, float[] fArray) {
        this.mRS.validate();
        RenderScript renderScript = this.mRS;
        int n5 = this.mID;
        int n6 = fArray.length * 4;
        int n7 = n;
        int n8 = n2;
        int n9 = n3;
        int n10 = n4;
        float[] fArray2 = fArray;
        renderScript.nAllocationSubData2D(n5, n7, n8, n9, n10, fArray2, n6);
    }

    public void subData2D(int n, int n2, int n3, int n4, int[] nArray) {
        this.mRS.validate();
        RenderScript renderScript = this.mRS;
        int n5 = this.mID;
        int n6 = nArray.length * 4;
        int n7 = n;
        int n8 = n2;
        int n9 = n3;
        int n10 = n4;
        int[] nArray2 = nArray;
        renderScript.nAllocationSubData2D(n5, n7, n8, n9, n10, nArray2, n6);
    }

    public void uploadToBufferObject() {
        this.mRS.validate();
        RenderScript renderScript = this.mRS;
        int n = this.mID;
        renderScript.nAllocationUploadToBufferObject(n);
    }

    public void uploadToTexture(int n) {
        this.mRS.validate();
        RenderScript renderScript = this.mRS;
        int n2 = this.mID;
        renderScript.nAllocationUploadToTexture(n2, false, n);
    }

    public void uploadToTexture(boolean bl, int n) {
        this.mRS.validate();
        RenderScript renderScript = this.mRS;
        int n2 = this.mID;
        renderScript.nAllocationUploadToTexture(n2, bl, n);
    }

    public class Adapter2D
    extends BaseObj {
        Adapter2D(int n, RenderScript renderScript) {
            super(renderScript);
            this.mID = n;
        }

        public void data(float[] fArray) {
            this.mRS.validate();
            RenderScript renderScript = this.mRS;
            int n = this.mID;
            renderScript.nAdapter2DData(n, fArray);
        }

        public void data(int[] nArray) {
            this.mRS.validate();
            RenderScript renderScript = this.mRS;
            int n = this.mID;
            renderScript.nAdapter2DData(n, nArray);
        }

        public void setConstraint(Dimension dimension, int n) {
            this.mRS.validate();
            RenderScript renderScript = this.mRS;
            int n2 = this.mID;
            int n3 = dimension.mID;
            renderScript.nAdapter2DSetConstraint(n2, n3, n);
        }

        public void subData(int n, int n2, int n3, int n4, float[] fArray) {
            this.mRS.validate();
            RenderScript renderScript = this.mRS;
            int n5 = this.mID;
            int n6 = n;
            int n7 = n2;
            int n8 = n3;
            int n9 = n4;
            float[] fArray2 = fArray;
            renderScript.nAdapter2DSubData(n5, n6, n7, n8, n9, fArray2);
        }

        public void subData(int n, int n2, int n3, int n4, int[] nArray) {
            this.mRS.validate();
            RenderScript renderScript = this.mRS;
            int n5 = this.mID;
            int n6 = n;
            int n7 = n2;
            int n8 = n3;
            int n9 = n4;
            int[] nArray2 = nArray;
            renderScript.nAdapter2DSubData(n5, n6, n7, n8, n9, nArray2);
        }
    }

    public class Adapter1D
    extends BaseObj {
        Adapter1D(int n, RenderScript renderScript) {
            super(renderScript);
            this.mID = n;
        }

        public void data(float[] fArray) {
            this.mRS.validate();
            RenderScript renderScript = this.mRS;
            int n = this.mID;
            renderScript.nAdapter1DData(n, fArray);
        }

        public void data(int[] nArray) {
            this.mRS.validate();
            RenderScript renderScript = this.mRS;
            int n = this.mID;
            renderScript.nAdapter1DData(n, nArray);
        }

        public void setConstraint(Dimension dimension, int n) {
            this.mRS.validate();
            RenderScript renderScript = this.mRS;
            int n2 = this.mID;
            int n3 = dimension.mID;
            renderScript.nAdapter1DSetConstraint(n2, n3, n);
        }

        public void subData(int n, int n2, float[] fArray) {
            this.mRS.validate();
            RenderScript renderScript = this.mRS;
            int n3 = this.mID;
            renderScript.nAdapter1DSubData(n3, n, n2, fArray);
        }

        public void subData(int n, int n2, int[] nArray) {
            this.mRS.validate();
            RenderScript renderScript = this.mRS;
            int n3 = this.mID;
            renderScript.nAdapter1DSubData(n3, n, n2, nArray);
        }
    }
}

