/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.RenderScript;
import java.io.UnsupportedEncodingException;

class BaseObj {
    boolean mDestroyed;
    int mID;
    String mName;
    RenderScript mRS;

    BaseObj(RenderScript renderScript) {
        renderScript.validate();
        this.mRS = renderScript;
        this.mID = 0;
        this.mDestroyed = false;
    }

    public void destroy() {
        if (this.mDestroyed) {
            throw new IllegalStateException("Object already destroyed.");
        }
        this.mDestroyed = true;
        RenderScript renderScript = this.mRS;
        int n = this.mID;
        renderScript.nObjDestroy(n);
    }

    protected void finalize() throws Throwable {
        if (!this.mDestroyed) {
            if (this.mID != 0 && this.mRS.isAlive()) {
                RenderScript renderScript = this.mRS;
                int n = this.mID;
                renderScript.nObjDestroyOOB(n);
            }
            this.mRS = null;
            this.mID = 0;
            this.mDestroyed = true;
        }
        super.finalize();
    }

    public int getID() {
        return this.mID;
    }

    public void setName(String string2) throws IllegalStateException, IllegalArgumentException {
        if (string2.length() < 1) {
            throw new IllegalArgumentException("setName does not accept a zero length string.");
        }
        if (this.mName != null) {
            throw new IllegalArgumentException("setName object already has a name.");
        }
        try {
            byte[] byArray = string2.getBytes("UTF-8");
            RenderScript renderScript = this.mRS;
            int n = this.mID;
            renderScript.nAssignName(n, byArray);
            this.mName = string2;
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }
}

