/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.RenderScript;
import java.lang.reflect.Field;

public class Element
extends BaseObj {
    String[] mElementNames;
    Element[] mElements;
    DataKind mKind;
    boolean mNormalized;
    int mSize;
    DataType mType;
    int mVectorSize;

    Element(RenderScript renderScript, DataType dataType, DataKind dataKind, boolean bl, int n) {
        super(renderScript);
        int n2;
        int n3;
        this.mSize = n3 = dataType.mSize * n;
        this.mType = dataType;
        this.mKind = dataKind;
        this.mNormalized = bl;
        this.mVectorSize = n;
        int n4 = dataType.mID;
        int n5 = dataKind.mID;
        this.mID = n2 = renderScript.nElementCreate(n4, n5, bl, n);
    }

    Element(RenderScript renderScript, Element[] elementArray, String[] stringArray) {
        super(renderScript);
        int n;
        int n2;
        this.mSize = 0;
        this.mElements = elementArray;
        this.mElementNames = stringArray;
        int[] nArray = new int[this.mElements.length];
        for (int i = 0; i < (n2 = this.mElements.length); ++i) {
            int n3;
            int n4;
            int n5 = this.mSize;
            int n6 = this.mElements[i].mSize;
            this.mSize = n4 = n5 + n6;
            nArray[i] = n3 = this.mElements[i].mID;
        }
        String[] stringArray2 = this.mElementNames;
        this.mID = n = renderScript.nElementCreate2(nArray, stringArray2);
    }

    public static Element ATTRIB_COLOR_F32_4(RenderScript renderScript) {
        if (renderScript.mElement_COLOR_F32_4 == null) {
            Element element;
            DataType dataType = DataType.FLOAT_32;
            DataKind dataKind = DataKind.COLOR;
            renderScript.mElement_COLOR_F32_4 = element = Element.createAttrib(renderScript, dataType, dataKind, 4);
        }
        return renderScript.mElement_COLOR_F32_4;
    }

    public static Element ATTRIB_COLOR_U8_4(RenderScript renderScript) {
        if (renderScript.mElement_COLOR_U8_4 == null) {
            Element element;
            DataType dataType = DataType.UNSIGNED_8;
            DataKind dataKind = DataKind.COLOR;
            renderScript.mElement_COLOR_U8_4 = element = Element.createAttrib(renderScript, dataType, dataKind, 4);
        }
        return renderScript.mElement_COLOR_U8_4;
    }

    public static Element ATTRIB_NORMAL_3(RenderScript renderScript) {
        if (renderScript.mElement_NORMAL_3 == null) {
            Element element;
            DataType dataType = DataType.FLOAT_32;
            DataKind dataKind = DataKind.NORMAL;
            renderScript.mElement_NORMAL_3 = element = Element.createAttrib(renderScript, dataType, dataKind, 3);
        }
        return renderScript.mElement_NORMAL_3;
    }

    public static Element ATTRIB_POSITION_2(RenderScript renderScript) {
        if (renderScript.mElement_POSITION_2 == null) {
            Element element;
            DataType dataType = DataType.FLOAT_32;
            DataKind dataKind = DataKind.POSITION;
            renderScript.mElement_POSITION_2 = element = Element.createAttrib(renderScript, dataType, dataKind, 2);
        }
        return renderScript.mElement_POSITION_2;
    }

    public static Element ATTRIB_POSITION_3(RenderScript renderScript) {
        if (renderScript.mElement_POSITION_3 == null) {
            Element element;
            DataType dataType = DataType.FLOAT_32;
            DataKind dataKind = DataKind.POSITION;
            renderScript.mElement_POSITION_3 = element = Element.createAttrib(renderScript, dataType, dataKind, 3);
        }
        return renderScript.mElement_POSITION_3;
    }

    public static Element ATTRIB_TEXTURE_2(RenderScript renderScript) {
        if (renderScript.mElement_TEXTURE_2 == null) {
            Element element;
            DataType dataType = DataType.FLOAT_32;
            DataKind dataKind = DataKind.TEXTURE;
            renderScript.mElement_TEXTURE_2 = element = Element.createAttrib(renderScript, dataType, dataKind, 2);
        }
        return renderScript.mElement_TEXTURE_2;
    }

    public static Element A_8(RenderScript renderScript) {
        if (renderScript.mElement_A_8 == null) {
            Element element;
            DataType dataType = DataType.UNSIGNED_8;
            DataKind dataKind = DataKind.PIXEL_A;
            renderScript.mElement_A_8 = element = Element.createPixel(renderScript, dataType, dataKind);
        }
        return renderScript.mElement_A_8;
    }

    public static Element INDEX_16(RenderScript renderScript) {
        if (renderScript.mElement_INDEX_16 == null) {
            Element element;
            renderScript.mElement_INDEX_16 = element = Element.createIndex(renderScript);
        }
        return renderScript.mElement_INDEX_16;
    }

    public static Element RGBA_4444(RenderScript renderScript) {
        if (renderScript.mElement_RGBA_4444 == null) {
            Element element;
            DataType dataType = DataType.UNSIGNED_4_4_4_4;
            DataKind dataKind = DataKind.PIXEL_RGBA;
            renderScript.mElement_RGBA_4444 = element = Element.createPixel(renderScript, dataType, dataKind);
        }
        return renderScript.mElement_RGBA_4444;
    }

    public static Element RGBA_5551(RenderScript renderScript) {
        if (renderScript.mElement_RGBA_5551 == null) {
            Element element;
            DataType dataType = DataType.UNSIGNED_5_5_5_1;
            DataKind dataKind = DataKind.PIXEL_RGBA;
            renderScript.mElement_RGBA_5551 = element = Element.createPixel(renderScript, dataType, dataKind);
        }
        return renderScript.mElement_RGBA_5551;
    }

    public static Element RGBA_8888(RenderScript renderScript) {
        if (renderScript.mElement_RGBA_8888 == null) {
            Element element;
            DataType dataType = DataType.UNSIGNED_8;
            DataKind dataKind = DataKind.PIXEL_RGBA;
            renderScript.mElement_RGBA_8888 = element = Element.createPixel(renderScript, dataType, dataKind);
        }
        return renderScript.mElement_RGBA_8888;
    }

    public static Element RGB_565(RenderScript renderScript) {
        if (renderScript.mElement_RGB_565 == null) {
            Element element;
            DataType dataType = DataType.UNSIGNED_5_6_5;
            DataKind dataKind = DataKind.PIXEL_RGB;
            renderScript.mElement_RGB_565 = element = Element.createPixel(renderScript, dataType, dataKind);
        }
        return renderScript.mElement_RGB_565;
    }

    public static Element RGB_888(RenderScript renderScript) {
        if (renderScript.mElement_RGB_888 == null) {
            Element element;
            DataType dataType = DataType.UNSIGNED_8;
            DataKind dataKind = DataKind.PIXEL_RGB;
            renderScript.mElement_RGB_888 = element = Element.createPixel(renderScript, dataType, dataKind);
        }
        return renderScript.mElement_RGB_888;
    }

    public static Element USER_F32(RenderScript renderScript) {
        if (renderScript.mElement_USER_F32 == null) {
            Element element;
            DataType dataType = DataType.FLOAT_32;
            renderScript.mElement_USER_F32 = element = Element.createUser(renderScript, dataType);
        }
        return renderScript.mElement_USER_F32;
    }

    public static Element USER_I32(RenderScript renderScript) {
        if (renderScript.mElement_USER_I32 == null) {
            Element element;
            DataType dataType = DataType.SIGNED_32;
            renderScript.mElement_USER_I32 = element = Element.createUser(renderScript, dataType);
        }
        return renderScript.mElement_USER_I32;
    }

    public static Element USER_I8(RenderScript renderScript) {
        if (renderScript.mElement_USER_I8 == null) {
            Element element;
            DataType dataType = DataType.SIGNED_8;
            renderScript.mElement_USER_I8 = element = Element.createUser(renderScript, dataType);
        }
        return renderScript.mElement_USER_I8;
    }

    public static Element USER_U32(RenderScript renderScript) {
        if (renderScript.mElement_USER_U32 == null) {
            Element element;
            DataType dataType = DataType.UNSIGNED_32;
            renderScript.mElement_USER_U32 = element = Element.createUser(renderScript, dataType);
        }
        return renderScript.mElement_USER_U32;
    }

    public static Element USER_U8(RenderScript renderScript) {
        if (renderScript.mElement_USER_U8 == null) {
            Element element;
            DataType dataType = DataType.UNSIGNED_8;
            renderScript.mElement_USER_U8 = element = Element.createUser(renderScript, dataType);
        }
        return renderScript.mElement_USER_U8;
    }

    public static Element createAttrib(RenderScript renderScript, DataType dataType, DataKind dataKind, int n) {
        DataType dataType2;
        DataType dataType3;
        DataType dataType4;
        DataType dataType5;
        DataType dataType6;
        DataType dataType7;
        DataKind dataKind2;
        DataKind dataKind3;
        DataKind dataKind4;
        DataKind dataKind5;
        DataKind dataKind6;
        DataType dataType8;
        DataType dataType9;
        DataType dataType10;
        DataType dataType11;
        DataType dataType12;
        DataType dataType13;
        DataType dataType14 = DataType.FLOAT_32;
        if (dataType != dataType14 && dataType != (dataType13 = DataType.UNSIGNED_8) && dataType != (dataType12 = DataType.UNSIGNED_16) && dataType != (dataType11 = DataType.UNSIGNED_32) && dataType != (dataType10 = DataType.SIGNED_8) && dataType != (dataType9 = DataType.SIGNED_16) && dataType != (dataType8 = DataType.SIGNED_32)) {
            throw new IllegalArgumentException("Unsupported DataType");
        }
        DataKind dataKind7 = DataKind.COLOR;
        if (dataKind != dataKind7 && dataKind != (dataKind6 = DataKind.POSITION) && dataKind != (dataKind5 = DataKind.TEXTURE) && dataKind != (dataKind4 = DataKind.NORMAL) && dataKind != (dataKind3 = DataKind.POINT_SIZE) && dataKind != (dataKind2 = DataKind.USER)) {
            throw new IllegalArgumentException("Unsupported DataKind");
        }
        DataKind dataKind8 = DataKind.COLOR;
        if (dataKind == dataKind8 && (dataType != (dataType7 = DataType.FLOAT_32) && dataType != (dataType6 = DataType.UNSIGNED_8) || n < 3 || n > 4)) {
            throw new IllegalArgumentException("Bad combo");
        }
        DataKind dataKind9 = DataKind.POSITION;
        if (dataKind == dataKind9 && (n < 1 || n > 4)) {
            throw new IllegalArgumentException("Bad combo");
        }
        DataKind dataKind10 = DataKind.TEXTURE;
        if (dataKind == dataKind10 && (dataType != (dataType5 = DataType.FLOAT_32) || n < 1 || n > 4)) {
            throw new IllegalArgumentException("Bad combo");
        }
        DataKind dataKind11 = DataKind.NORMAL;
        if (dataKind == dataKind11 && (dataType != (dataType4 = DataType.FLOAT_32) || n != 3)) {
            throw new IllegalArgumentException("Bad combo");
        }
        DataKind dataKind12 = DataKind.POINT_SIZE;
        if (dataKind == dataKind12 && (dataType != (dataType3 = DataType.FLOAT_32) || n != 1)) {
            throw new IllegalArgumentException("Bad combo");
        }
        boolean bl = false;
        DataKind dataKind13 = DataKind.COLOR;
        if (dataKind == dataKind13 && dataType == (dataType2 = DataType.UNSIGNED_8)) {
            bl = true;
        }
        RenderScript renderScript2 = renderScript;
        DataType dataType15 = dataType;
        DataKind dataKind14 = dataKind;
        int n2 = n;
        return new Element(renderScript2, dataType15, dataKind14, bl, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Element createFromClass(RenderScript renderScript, Class clazz) {
        renderScript.validate();
        Field[] fieldArray = clazz.getFields();
        Builder builder = new Builder(renderScript);
        Field[] fieldArray2 = fieldArray;
        int n = fieldArray2.length;
        int n2 = 0;
        while (n2 < n) {
            Class<Integer> clazz2;
            Field field = fieldArray2[n2];
            Class<?> clazz3 = field.getType();
            if (clazz3 == (clazz2 = Integer.TYPE)) {
                DataType dataType = DataType.SIGNED_32;
                Element element = Element.createUser(renderScript, dataType);
                String string2 = field.getName();
                builder.add(element, string2);
            } else {
                Class<Short> clazz4 = Short.TYPE;
                if (clazz3 == clazz4) {
                    DataType dataType = DataType.SIGNED_16;
                    Element element = Element.createUser(renderScript, dataType);
                    String string3 = field.getName();
                    builder.add(element, string3);
                } else {
                    Class<Byte> clazz5 = Byte.TYPE;
                    if (clazz3 == clazz5) {
                        DataType dataType = DataType.SIGNED_8;
                        Element element = Element.createUser(renderScript, dataType);
                        String string4 = field.getName();
                        builder.add(element, string4);
                    } else {
                        Class<Float> clazz6 = Float.TYPE;
                        if (clazz3 != clazz6) {
                            throw new IllegalArgumentException("Unkown field type");
                        }
                        DataType dataType = DataType.FLOAT_32;
                        Element element = Element.createUser(renderScript, dataType);
                        String string5 = field.getName();
                        builder.add(element, string5);
                    }
                }
            }
            ++n2;
        }
        return builder.create();
    }

    public static Element createIndex(RenderScript renderScript) {
        DataType dataType = DataType.UNSIGNED_16;
        DataKind dataKind = DataKind.INDEX;
        RenderScript renderScript2 = renderScript;
        return new Element(renderScript2, dataType, dataKind, false, 1);
    }

    public static Element createPixel(RenderScript renderScript, DataType dataType, DataKind dataKind) {
        DataKind dataKind2;
        DataKind dataKind3;
        DataKind dataKind4;
        DataKind dataKind5;
        DataKind dataKind6;
        DataType dataType2;
        DataType dataType3;
        DataType dataType4;
        DataKind dataKind7;
        DataKind dataKind8;
        DataKind dataKind9;
        DataKind dataKind10;
        DataKind dataKind11 = DataKind.PIXEL_L;
        if (dataKind != dataKind11 && dataKind != (dataKind10 = DataKind.PIXEL_A) && dataKind != (dataKind9 = DataKind.PIXEL_LA) && dataKind != (dataKind8 = DataKind.PIXEL_RGB) && dataKind != (dataKind7 = DataKind.PIXEL_RGBA)) {
            throw new IllegalArgumentException("Unsupported DataKind");
        }
        DataType dataType5 = DataType.UNSIGNED_8;
        if (dataType != dataType5 && dataType != (dataType4 = DataType.UNSIGNED_5_6_5) && dataType != (dataType3 = DataType.UNSIGNED_4_4_4_4) && dataType != (dataType2 = DataType.UNSIGNED_5_5_5_1)) {
            throw new IllegalArgumentException("Unsupported DataType");
        }
        DataType dataType6 = DataType.UNSIGNED_5_6_5;
        if (dataType == dataType6 && dataKind != (dataKind6 = DataKind.PIXEL_RGB)) {
            throw new IllegalArgumentException("Bad kind and type combo");
        }
        DataType dataType7 = DataType.UNSIGNED_5_5_5_1;
        if (dataType == dataType7 && dataKind != (dataKind5 = DataKind.PIXEL_RGBA)) {
            throw new IllegalArgumentException("Bad kind and type combo");
        }
        DataType dataType8 = DataType.UNSIGNED_4_4_4_4;
        if (dataType == dataType8 && dataKind != (dataKind4 = DataKind.PIXEL_RGBA)) {
            throw new IllegalArgumentException("Bad kind and type combo");
        }
        int n = 1;
        DataKind dataKind12 = DataKind.PIXEL_LA;
        if (dataKind == dataKind12) {
            n = 2;
        }
        if (dataKind == (dataKind3 = DataKind.PIXEL_RGB)) {
            n = 3;
        }
        if (dataKind == (dataKind2 = DataKind.PIXEL_RGBA)) {
            n = 4;
        }
        RenderScript renderScript2 = renderScript;
        DataType dataType9 = dataType;
        DataKind dataKind13 = dataKind;
        return new Element(renderScript2, dataType9, dataKind13, true, n);
    }

    public static Element createUser(RenderScript renderScript, DataType dataType) {
        DataKind dataKind = DataKind.USER;
        RenderScript renderScript2 = renderScript;
        DataType dataType2 = dataType;
        return new Element(renderScript2, dataType2, dataKind, false, 1);
    }

    public static Element createVector(RenderScript renderScript, DataType dataType, int n) {
        if (n < 2 || n > 4) {
            throw new IllegalArgumentException("Bad size");
        }
        DataKind dataKind = DataKind.USER;
        RenderScript renderScript2 = renderScript;
        DataType dataType2 = dataType;
        int n2 = n;
        return new Element(renderScript2, dataType2, dataKind, false, n2);
    }

    static void initPredefined(RenderScript renderScript) {
        int n = DataType.UNSIGNED_8.mID;
        int n2 = DataKind.PIXEL_A.mID;
        int n3 = renderScript.nElementCreate(n, n2, true, 1);
        int n4 = DataType.UNSIGNED_4_4_4_4.mID;
        int n5 = DataKind.PIXEL_RGBA.mID;
        int n6 = renderScript.nElementCreate(n4, n5, true, 4);
        int n7 = DataType.UNSIGNED_8.mID;
        int n8 = DataKind.PIXEL_RGBA.mID;
        int n9 = renderScript.nElementCreate(n7, n8, true, 4);
        int n10 = DataType.UNSIGNED_5_6_5.mID;
        int n11 = DataKind.PIXEL_RGB.mID;
        int n12 = renderScript.nElementCreate(n10, n11, true, 3);
        renderScript.nInitElements(n3, n6, n9, n12);
    }

    @Override
    public void destroy() throws IllegalStateException {
        super.destroy();
    }

    int getSizeBytes() {
        return this.mSize;
    }

    public static class Builder {
        int mCount;
        String[] mElementNames;
        Element[] mElements;
        RenderScript mRS;

        public Builder(RenderScript renderScript) {
            this.mRS = renderScript;
            this.mCount = 0;
            Element[] elementArray = new Element[8];
            this.mElements = elementArray;
            String[] stringArray = new String[8];
            this.mElementNames = stringArray;
        }

        public void add(Element element, String string2) {
            int n;
            int n2 = this.mCount;
            int n3 = this.mElements.length;
            if (n2 != n3) {
                Element[] elementArray = new Element[this.mCount + 8];
                String[] stringArray = new String[this.mCount + 8];
                Element[] elementArray2 = this.mElements;
                int n4 = this.mCount;
                System.arraycopy(elementArray2, 0, elementArray, 0, n4);
                String[] stringArray2 = this.mElementNames;
                int n5 = this.mCount;
                System.arraycopy(stringArray2, 0, stringArray, 0, n5);
                this.mElements = elementArray;
                this.mElementNames = stringArray;
            }
            Element[] elementArray = this.mElements;
            int n6 = this.mCount;
            elementArray[n6] = element;
            String[] stringArray = this.mElementNames;
            int n7 = this.mCount;
            stringArray[n7] = string2;
            this.mCount = n = this.mCount + 1;
        }

        public Element create() {
            this.mRS.validate();
            Element[] elementArray = new Element[this.mCount];
            String[] stringArray = new String[this.mCount];
            Element[] elementArray2 = this.mElements;
            int n = this.mCount;
            System.arraycopy(elementArray2, 0, elementArray, 0, n);
            String[] stringArray2 = this.mElementNames;
            int n2 = this.mCount;
            System.arraycopy(stringArray2, 0, stringArray, 0, n2);
            RenderScript renderScript = this.mRS;
            return new Element(renderScript, elementArray, stringArray);
        }
    }

    public static final class DataKind
    extends Enum<DataKind> {
        private static final /* synthetic */ DataKind[] $VALUES;
        public static final /* enum */ DataKind COLOR;
        public static final /* enum */ DataKind INDEX;
        public static final /* enum */ DataKind NORMAL;
        public static final /* enum */ DataKind PIXEL_A;
        public static final /* enum */ DataKind PIXEL_L;
        public static final /* enum */ DataKind PIXEL_LA;
        public static final /* enum */ DataKind PIXEL_RGB;
        public static final /* enum */ DataKind PIXEL_RGBA;
        public static final /* enum */ DataKind POINT_SIZE;
        public static final /* enum */ DataKind POSITION;
        public static final /* enum */ DataKind TEXTURE;
        public static final /* enum */ DataKind USER;
        int mID;

        static {
            USER = new DataKind(0);
            COLOR = new DataKind(1);
            POSITION = new DataKind(2);
            TEXTURE = new DataKind(3);
            NORMAL = new DataKind(4);
            INDEX = new DataKind(5);
            POINT_SIZE = new DataKind(6);
            PIXEL_L = new DataKind(7);
            PIXEL_A = new DataKind(8);
            PIXEL_LA = new DataKind(9);
            PIXEL_RGB = new DataKind(10);
            PIXEL_RGBA = new DataKind(11);
            DataKind dataKind = USER;
            DataKind dataKind2 = COLOR;
            DataKind dataKind3 = POSITION;
            DataKind dataKind4 = TEXTURE;
            DataKind dataKind5 = NORMAL;
            DataKind dataKind6 = INDEX;
            DataKind dataKind7 = POINT_SIZE;
            DataKind dataKind8 = PIXEL_L;
            DataKind dataKind9 = PIXEL_A;
            DataKind dataKind10 = PIXEL_LA;
            DataKind dataKind11 = PIXEL_RGB;
            DataKind dataKind12 = PIXEL_RGBA;
            DataKind[] dataKindArray = new DataKind[]{dataKind, dataKind2, dataKind3, dataKind4, dataKind5, dataKind6, dataKind7, dataKind8, dataKind9, dataKind10, dataKind11, dataKind12};
            $VALUES = dataKindArray;
        }

        private DataKind(int n2) {
            this.mID = n2;
        }

        public static DataKind valueOf(String string2) {
            return Enum.valueOf(DataKind.class, string2);
        }

        public static DataKind[] values() {
            return (DataKind[])$VALUES.clone();
        }
    }

    public static final class DataType
    extends Enum<DataType> {
        private static final /* synthetic */ DataType[] $VALUES;
        public static final /* enum */ DataType FLOAT_32 = new DataType(2, 4);
        public static final /* enum */ DataType RS_ALLOCATION;
        public static final /* enum */ DataType RS_ELEMENT;
        public static final /* enum */ DataType RS_MESH;
        public static final /* enum */ DataType RS_PROGRAM_FRAGMENT;
        public static final /* enum */ DataType RS_PROGRAM_RASTER;
        public static final /* enum */ DataType RS_PROGRAM_STORE;
        public static final /* enum */ DataType RS_PROGRAM_VERTEX;
        public static final /* enum */ DataType RS_SAMPLER;
        public static final /* enum */ DataType RS_SCRIPT;
        public static final /* enum */ DataType RS_TYPE;
        public static final /* enum */ DataType SIGNED_16;
        public static final /* enum */ DataType SIGNED_32;
        public static final /* enum */ DataType SIGNED_8;
        public static final /* enum */ DataType UNSIGNED_16;
        public static final /* enum */ DataType UNSIGNED_32;
        public static final /* enum */ DataType UNSIGNED_4_4_4_4;
        public static final /* enum */ DataType UNSIGNED_5_5_5_1;
        public static final /* enum */ DataType UNSIGNED_5_6_5;
        public static final /* enum */ DataType UNSIGNED_8;
        int mID;
        int mSize;

        static {
            SIGNED_8 = new DataType(4, 1);
            SIGNED_16 = new DataType(5, 2);
            SIGNED_32 = new DataType(6, 4);
            UNSIGNED_8 = new DataType(8, 1);
            UNSIGNED_16 = new DataType(9, 2);
            UNSIGNED_32 = new DataType(10, 4);
            UNSIGNED_5_6_5 = new DataType(12, 2);
            UNSIGNED_5_5_5_1 = new DataType(13, 2);
            UNSIGNED_4_4_4_4 = new DataType(14, 2);
            RS_ELEMENT = new DataType(15, 4);
            RS_TYPE = new DataType(16, 4);
            RS_ALLOCATION = new DataType(17, 4);
            RS_SAMPLER = new DataType(18, 4);
            RS_SCRIPT = new DataType(19, 4);
            RS_MESH = new DataType(20, 4);
            RS_PROGRAM_FRAGMENT = new DataType(21, 4);
            RS_PROGRAM_VERTEX = new DataType(22, 4);
            RS_PROGRAM_RASTER = new DataType(23, 4);
            RS_PROGRAM_STORE = new DataType(24, 4);
            DataType dataType = FLOAT_32;
            DataType dataType2 = SIGNED_8;
            DataType dataType3 = SIGNED_16;
            DataType dataType4 = SIGNED_32;
            DataType dataType5 = UNSIGNED_8;
            DataType dataType6 = UNSIGNED_16;
            DataType dataType7 = UNSIGNED_32;
            DataType dataType8 = UNSIGNED_5_6_5;
            DataType dataType9 = UNSIGNED_5_5_5_1;
            DataType dataType10 = UNSIGNED_4_4_4_4;
            DataType dataType11 = RS_ELEMENT;
            DataType dataType12 = RS_TYPE;
            DataType dataType13 = RS_ALLOCATION;
            DataType dataType14 = RS_SAMPLER;
            DataType dataType15 = RS_SCRIPT;
            DataType dataType16 = RS_MESH;
            DataType dataType17 = RS_PROGRAM_FRAGMENT;
            DataType dataType18 = RS_PROGRAM_VERTEX;
            DataType dataType19 = RS_PROGRAM_RASTER;
            DataType dataType20 = RS_PROGRAM_STORE;
            DataType[] dataTypeArray = new DataType[]{dataType, dataType2, dataType3, dataType4, dataType5, dataType6, dataType7, dataType8, dataType9, dataType10, dataType11, dataType12, dataType13, dataType14, dataType15, dataType16, dataType17, dataType18, dataType19, dataType20};
            $VALUES = dataTypeArray;
        }

        private DataType(int n2, int n3) {
            this.mID = n2;
            this.mSize = n3;
        }

        public static DataType valueOf(String string2) {
            return Enum.valueOf(DataType.class, string2);
        }

        public static DataType[] values() {
            return (DataType[])$VALUES.clone();
        }
    }
}

