/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

public class FieldPacker {
    private final byte[] mData;
    private int mPos = 0;

    public FieldPacker(int n) {
        byte[] byArray = new byte[n];
        this.mData = byArray;
    }

    void addF32(float f) {
        int n = Float.floatToRawIntBits(f);
        this.addI32(n);
    }

    void addF64(float f) {
        long l = Double.doubleToRawLongBits(f);
        this.addI64(l);
    }

    void addI16(short s) {
        byte by;
        int n;
        byte by2;
        int n2;
        this.align(2);
        byte[] byArray = this.mData;
        int n3 = this.mPos;
        this.mPos = n2 = n3 + 1;
        byArray[n3] = by2 = (byte)(s & 0xFF);
        byte[] byArray2 = this.mData;
        int n4 = this.mPos;
        this.mPos = n = n4 + 1;
        byArray2[n4] = by = (byte)(s >> 8);
    }

    void addI32(int n) {
        byte by;
        int n2;
        byte by2;
        int n3;
        byte by3;
        int n4;
        byte by4;
        int n5;
        this.align(4);
        byte[] byArray = this.mData;
        int n6 = this.mPos;
        this.mPos = n5 = n6 + 1;
        byArray[n6] = by4 = (byte)(n & 0xFF);
        byte[] byArray2 = this.mData;
        int n7 = this.mPos;
        this.mPos = n4 = n7 + 1;
        byArray2[n7] = by3 = (byte)(n >> 8 & 0xFF);
        byte[] byArray3 = this.mData;
        int n8 = this.mPos;
        this.mPos = n3 = n8 + 1;
        byArray3[n8] = by2 = (byte)(n >> 16 & 0xFF);
        byte[] byArray4 = this.mData;
        int n9 = this.mPos;
        this.mPos = n2 = n9 + 1;
        byArray4[n9] = by = (byte)(n >> 24 & 0xFF);
    }

    void addI64(long l) {
        byte by;
        int n;
        byte by2;
        int n2;
        byte by3;
        int n3;
        byte by4;
        int n4;
        byte by5;
        int n5;
        byte by6;
        int n6;
        byte by7;
        int n7;
        byte by8;
        int n8;
        this.align(8);
        byte[] byArray = this.mData;
        int n9 = this.mPos;
        this.mPos = n8 = n9 + 1;
        byArray[n9] = by8 = (byte)(l & 0xFFL);
        byte[] byArray2 = this.mData;
        int n10 = this.mPos;
        this.mPos = n7 = n10 + 1;
        byArray2[n10] = by7 = (byte)(l >> 8 & 0xFFL);
        byte[] byArray3 = this.mData;
        int n11 = this.mPos;
        this.mPos = n6 = n11 + 1;
        byArray3[n11] = by6 = (byte)(l >> 16 & 0xFFL);
        byte[] byArray4 = this.mData;
        int n12 = this.mPos;
        this.mPos = n5 = n12 + 1;
        byArray4[n12] = by5 = (byte)(l >> 24 & 0xFFL);
        byte[] byArray5 = this.mData;
        int n13 = this.mPos;
        this.mPos = n4 = n13 + 1;
        byArray5[n13] = by4 = (byte)(l >> 32 & 0xFFL);
        byte[] byArray6 = this.mData;
        int n14 = this.mPos;
        this.mPos = n3 = n14 + 1;
        byArray6[n14] = by3 = (byte)(l >> 40 & 0xFFL);
        byte[] byArray7 = this.mData;
        int n15 = this.mPos;
        this.mPos = n2 = n15 + 1;
        byArray7[n15] = by2 = (byte)(l >> 48 & 0xFFL);
        byte[] byArray8 = this.mData;
        int n16 = this.mPos;
        this.mPos = n = n16 + 1;
        byArray8[n16] = by = (byte)(l >> 56 & 0xFFL);
    }

    void addI8(byte by) {
        int n;
        byte[] byArray = this.mData;
        int n2 = this.mPos;
        this.mPos = n = n2 + 1;
        byArray[n2] = by;
    }

    void addU16(int n) {
        byte by;
        int n2;
        byte by2;
        int n3;
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.align(2);
        byte[] byArray = this.mData;
        int n4 = this.mPos;
        this.mPos = n3 = n4 + 1;
        byArray[n4] = by2 = (byte)(n & 0xFF);
        byte[] byArray2 = this.mData;
        int n5 = this.mPos;
        this.mPos = n2 = n5 + 1;
        byArray2[n5] = by = (byte)(n >> 8);
    }

    void addU32(long l) {
        byte by;
        int n;
        byte by2;
        int n2;
        byte by3;
        int n3;
        byte by4;
        int n4;
        if (l < 0L || l > 65535L) {
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.align(4);
        byte[] byArray = this.mData;
        int n5 = this.mPos;
        this.mPos = n4 = n5 + 1;
        byArray[n5] = by4 = (byte)(l & 0xFFL);
        byte[] byArray2 = this.mData;
        int n6 = this.mPos;
        this.mPos = n3 = n6 + 1;
        byArray2[n6] = by3 = (byte)(l >> 8 & 0xFFL);
        byte[] byArray3 = this.mData;
        int n7 = this.mPos;
        this.mPos = n2 = n7 + 1;
        byArray3[n7] = by2 = (byte)(l >> 16 & 0xFFL);
        byte[] byArray4 = this.mData;
        int n8 = this.mPos;
        this.mPos = n = n8 + 1;
        byArray4[n8] = by = (byte)(l >> 24 & 0xFFL);
    }

    void addU64(long l) {
        byte by;
        int n;
        byte by2;
        int n2;
        byte by3;
        int n3;
        byte by4;
        int n4;
        byte by5;
        int n5;
        byte by6;
        int n6;
        byte by7;
        int n7;
        byte by8;
        int n8;
        if (l < 0L) {
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        this.align(8);
        byte[] byArray = this.mData;
        int n9 = this.mPos;
        this.mPos = n8 = n9 + 1;
        byArray[n9] = by8 = (byte)(l & 0xFFL);
        byte[] byArray2 = this.mData;
        int n10 = this.mPos;
        this.mPos = n7 = n10 + 1;
        byArray2[n10] = by7 = (byte)(l >> 8 & 0xFFL);
        byte[] byArray3 = this.mData;
        int n11 = this.mPos;
        this.mPos = n6 = n11 + 1;
        byArray3[n11] = by6 = (byte)(l >> 16 & 0xFFL);
        byte[] byArray4 = this.mData;
        int n12 = this.mPos;
        this.mPos = n5 = n12 + 1;
        byArray4[n12] = by5 = (byte)(l >> 24 & 0xFFL);
        byte[] byArray5 = this.mData;
        int n13 = this.mPos;
        this.mPos = n4 = n13 + 1;
        byArray5[n13] = by4 = (byte)(l >> 32 & 0xFFL);
        byte[] byArray6 = this.mData;
        int n14 = this.mPos;
        this.mPos = n3 = n14 + 1;
        byArray6[n14] = by3 = (byte)(l >> 40 & 0xFFL);
        byte[] byArray7 = this.mData;
        int n15 = this.mPos;
        this.mPos = n2 = n15 + 1;
        byArray7[n15] = by2 = (byte)(l >> 48 & 0xFFL);
        byte[] byArray8 = this.mData;
        int n16 = this.mPos;
        this.mPos = n = n16 + 1;
        byArray8[n16] = by = (byte)(l >> 56 & 0xFFL);
    }

    void addU8(short s) {
        byte by;
        int n;
        if (s < 0 || s > 255) {
            throw new IllegalArgumentException("Saving value out of range for type");
        }
        byte[] byArray = this.mData;
        int n2 = this.mPos;
        this.mPos = n = n2 + 1;
        byArray[n2] = by = (byte)s;
    }

    public void align(int n) {
        int n2;
        int n3;
        while (((n3 = this.mPos) & (n2 = n - 1)) != 0) {
            int n4;
            byte[] byArray = this.mData;
            int n5 = this.mPos;
            this.mPos = n4 = n5 + 1;
            byArray[n5] = 0;
        }
        return;
    }

    final byte[] getData() {
        return this.mData;
    }

    void reset() {
        this.mPos = 0;
    }
}

