/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

public class Matrix4f {
    final float[] mMat;

    public Matrix4f() {
        float[] fArray = new float[16];
        this.mMat = fArray;
        this.loadIdentity();
    }

    public float get(int n, int n2) {
        float[] fArray = this.mMat;
        int n3 = n * 4 + n2;
        return fArray[n3];
    }

    public void load(Matrix4f matrix4f) {
        System.arraycopy(this.mMat, 0, matrix4f, 0, 16);
    }

    public void loadFrustum(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7;
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        this.loadIdentity();
        float[] fArray = this.mMat;
        float f13 = 2.0f * f5;
        float f14 = f2 - f;
        fArray[0] = f12 = f13 / f14;
        float[] fArray2 = this.mMat;
        float f15 = 2.0f * f5;
        float f16 = f4 - f3;
        fArray2[5] = f11 = f15 / f16;
        float[] fArray3 = this.mMat;
        float f17 = f2 + f;
        float f18 = f2 - f;
        fArray3[8] = f10 = f17 / f18;
        float[] fArray4 = this.mMat;
        float f19 = f4 + f3;
        float f20 = f4 - f3;
        fArray4[9] = f9 = f19 / f20;
        float[] fArray5 = this.mMat;
        float f21 = -(f6 + f5);
        float f22 = f6 - f5;
        fArray5[10] = f8 = f21 / f22;
        this.mMat[11] = -1082130432;
        float[] fArray6 = this.mMat;
        float f23 = -2.0f * f6 * f5;
        float f24 = f6 - f5;
        fArray6[14] = f7 = f23 / f24;
        this.mMat[15] = 0.0f;
    }

    public void loadIdentity() {
        this.mMat[0] = 1065353216;
        this.mMat[1] = 0.0f;
        this.mMat[2] = 0.0f;
        this.mMat[3] = 0.0f;
        this.mMat[4] = 0.0f;
        this.mMat[5] = 1065353216;
        this.mMat[6] = 0.0f;
        this.mMat[7] = 0.0f;
        this.mMat[8] = 0.0f;
        this.mMat[9] = 0.0f;
        this.mMat[10] = 1065353216;
        this.mMat[11] = 0.0f;
        this.mMat[12] = 0.0f;
        this.mMat[13] = 0.0f;
        this.mMat[14] = 0.0f;
        this.mMat[15] = 1065353216;
    }

    public void loadMultiply(Matrix4f matrix4f, Matrix4f matrix4f2) {
        int n = 0;
        while (n < 4) {
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            for (int i = 0; i < 4; ++i) {
                float f5 = matrix4f2.get(n, i);
                float f6 = matrix4f.get(i, 0) * f5;
                f += f6;
                float f7 = matrix4f.get(i, 1) * f5;
                f2 += f7;
                float f8 = matrix4f.get(i, 2) * f5;
                f3 += f8;
                float f9 = matrix4f.get(i, 3) * f5;
                f4 += f9;
            }
            this.set(n, 0, f);
            this.set(n, 1, f2);
            this.set(n, 2, f3);
            this.set(n, 3, f4);
            ++n;
        }
        return;
    }

    public void loadOrtho(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7;
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        this.loadIdentity();
        float[] fArray = this.mMat;
        float f13 = f2 - f;
        fArray[0] = f12 = 2.0f / f13;
        float[] fArray2 = this.mMat;
        float f14 = f4 - f3;
        fArray2[5] = f11 = 2.0f / f14;
        float[] fArray3 = this.mMat;
        float f15 = f6 - f5;
        fArray3[10] = f10 = -2.0f / f15;
        float[] fArray4 = this.mMat;
        float f16 = -(f2 + f);
        float f17 = f2 - f;
        fArray4[12] = f9 = f16 / f17;
        float[] fArray5 = this.mMat;
        float f18 = -(f4 + f3);
        float f19 = f4 - f3;
        fArray5[13] = f8 = f18 / f19;
        float[] fArray6 = this.mMat;
        float f20 = -(f6 + f5);
        float f21 = f6 - f5;
        fArray6[14] = f7 = f20 / f21;
    }

    public void loadRotate(float f, float f2, float f3, float f4) {
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        this.mMat[3] = 0.0f;
        this.mMat[7] = 0.0f;
        this.mMat[11] = 0.0f;
        this.mMat[12] = 0.0f;
        this.mMat[13] = 0.0f;
        this.mMat[14] = 0.0f;
        this.mMat[15] = 1065353216;
        float f14 = f * ((float)Math.PI / 180);
        float f15 = (float)Math.cos(f14);
        float f16 = (float)Math.sin(f14);
        float f17 = f2 * f2;
        float f18 = f3 * f3;
        float f19 = f17 + f18;
        float f20 = f4 * f4;
        float f21 = (float)Math.sqrt(f19 + f20);
        if (f21 == 1.0f) {
            float f22 = 1.0f / f21;
            f2 *= f22;
            f3 *= f22;
            f4 *= f22;
        }
        float f23 = 1.0f - f15;
        float f24 = f2 * f3;
        float f25 = f3 * f4;
        float f26 = f4 * f2;
        float f27 = f2 * f16;
        float f28 = f3 * f16;
        float f29 = f4 * f16;
        float[] fArray = this.mMat;
        fArray[0] = f13 = f2 * f2 * f23 + f15;
        float[] fArray2 = this.mMat;
        fArray2[4] = f12 = f24 * f23 - f29;
        float[] fArray3 = this.mMat;
        fArray3[8] = f11 = f26 * f23 + f28;
        float[] fArray4 = this.mMat;
        fArray4[1] = f10 = f24 * f23 + f29;
        float[] fArray5 = this.mMat;
        fArray5[5] = f9 = f3 * f3 * f23 + f15;
        float[] fArray6 = this.mMat;
        fArray6[9] = f8 = f25 * f23 - f27;
        float[] fArray7 = this.mMat;
        fArray7[2] = f7 = f26 * f23 - f28;
        float[] fArray8 = this.mMat;
        fArray8[6] = f6 = f25 * f23 + f27;
        float[] fArray9 = this.mMat;
        fArray9[10] = f5 = f4 * f4 * f23 + f15;
    }

    public void loadScale(float f, float f2, float f3) {
        this.loadIdentity();
        this.mMat[0] = f;
        this.mMat[5] = f2;
        this.mMat[10] = f3;
    }

    public void loadTranslate(float f, float f2, float f3) {
        this.loadIdentity();
        this.mMat[12] = f;
        this.mMat[13] = f2;
        this.mMat[14] = f3;
    }

    public void multiply(Matrix4f matrix4f) {
        Matrix4f matrix4f2 = new Matrix4f();
        matrix4f2.loadMultiply(this, matrix4f);
        this.load(matrix4f2);
    }

    public void rotate(float f, float f2, float f3, float f4) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.loadRotate(f, f2, f3, f4);
        this.multiply(matrix4f);
    }

    public void scale(float f, float f2, float f3) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.loadScale(f, f2, f3);
        this.multiply(matrix4f);
    }

    public void set(int n, int n2, float f) {
        float[] fArray = this.mMat;
        int n3 = n * 4 + n2;
        fArray[n3] = f;
    }

    public void translate(float f, float f2, float f3) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.loadTranslate(f, f2, f3);
        this.multiply(matrix4f);
    }
}

