/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.Sampler;
import android.renderscript.Type;

public class Program
extends BaseObj {
    public static final int MAX_CONSTANT = 8;
    public static final int MAX_INPUT = 8;
    public static final int MAX_OUTPUT = 8;
    public static final int MAX_TEXTURE = 8;
    Type[] mConstants;
    Element[] mInputs;
    Element[] mOutputs;
    String mShader;
    int mTextureCount;

    Program(int n, RenderScript renderScript) {
        super(renderScript);
        this.mID = n;
    }

    public void bindConstants(Allocation allocation, int n) {
        RenderScript renderScript = this.mRS;
        int n2 = this.mID;
        int n3 = allocation.mID;
        renderScript.nProgramBindConstants(n2, n, n3);
    }

    public void bindSampler(Sampler sampler, int n) throws IllegalArgumentException {
        int n2;
        this.mRS.validate();
        if (n < 0 || n >= (n2 = this.mTextureCount)) {
            throw new IllegalArgumentException("Slot ID out of range.");
        }
        RenderScript renderScript = this.mRS;
        int n3 = this.mID;
        int n4 = sampler.mID;
        renderScript.nProgramBindSampler(n3, n, n4);
    }

    public void bindTexture(Allocation allocation, int n) throws IllegalArgumentException {
        int n2;
        this.mRS.validate();
        if (n < 0 || n >= (n2 = this.mTextureCount)) {
            throw new IllegalArgumentException("Slot ID out of range.");
        }
        RenderScript renderScript = this.mRS;
        int n3 = this.mID;
        int n4 = allocation.mID;
        renderScript.nProgramBindTexture(n3, n, n4);
    }

    public static class BaseProgramBuilder {
        int mConstantCount;
        Type[] mConstants;
        int mInputCount;
        Element[] mInputs;
        int mOutputCount;
        Element[] mOutputs;
        RenderScript mRS;
        String mShader;
        int mTextureCount;
        Type[] mTextures;

        protected BaseProgramBuilder(RenderScript renderScript) {
            this.mRS = renderScript;
            Element[] elementArray = new Element[8];
            this.mInputs = elementArray;
            Element[] elementArray2 = new Element[8];
            this.mOutputs = elementArray2;
            Type[] typeArray = new Type[8];
            this.mConstants = typeArray;
            this.mInputCount = 0;
            this.mOutputCount = 0;
            this.mConstantCount = 0;
            this.mTextureCount = 0;
        }

        public int addConstant(Type type) throws IllegalStateException {
            int n;
            if (this.mConstantCount >= 8) {
                throw new IllegalArgumentException("Max input count exceeded.");
            }
            Type[] typeArray = this.mConstants;
            int n2 = this.mConstantCount;
            typeArray[n2] = type;
            int n3 = this.mConstantCount;
            this.mConstantCount = n = n3 + 1;
            return n3;
        }

        public void addInput(Element element) throws IllegalStateException {
            int n;
            if (this.mInputCount >= 8) {
                throw new IllegalArgumentException("Max input count exceeded.");
            }
            Element[] elementArray = this.mInputs;
            int n2 = this.mInputCount;
            this.mInputCount = n = n2 + 1;
            elementArray[n2] = element;
        }

        public void addOutput(Element element) throws IllegalStateException {
            int n;
            if (this.mOutputCount >= 8) {
                throw new IllegalArgumentException("Max output count exceeded.");
            }
            Element[] elementArray = this.mOutputs;
            int n2 = this.mOutputCount;
            this.mOutputCount = n = n2 + 1;
            elementArray[n2] = element;
        }

        protected void initProgram(Program program) {
            int n;
            Element[] elementArray = new Element[this.mInputCount];
            program.mInputs = elementArray;
            Element[] elementArray2 = this.mInputs;
            Element[] elementArray3 = program.mInputs;
            int n2 = this.mInputCount;
            System.arraycopy(elementArray2, 0, elementArray3, 0, n2);
            Element[] elementArray4 = new Element[this.mOutputCount];
            program.mOutputs = elementArray4;
            Element[] elementArray5 = this.mOutputs;
            Element[] elementArray6 = program.mOutputs;
            int n3 = this.mOutputCount;
            System.arraycopy(elementArray5, 0, elementArray6, 0, n3);
            Type[] typeArray = new Type[this.mConstantCount];
            program.mConstants = typeArray;
            Type[] typeArray2 = this.mConstants;
            Type[] typeArray3 = program.mConstants;
            int n4 = this.mConstantCount;
            System.arraycopy(typeArray2, 0, typeArray3, 0, n4);
            program.mTextureCount = n = this.mTextureCount;
        }

        public void setShader(String string2) {
            this.mShader = string2;
        }

        public void setTextureCount(int n) throws IllegalArgumentException {
            if (n >= 8) {
                throw new IllegalArgumentException("Max texture count exceeded.");
            }
            this.mTextureCount = n;
        }
    }
}

