/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Program;
import android.renderscript.RenderScript;

public class ProgramFragment
extends Program {
    ProgramFragment(int n, RenderScript renderScript) {
        super(n, renderScript);
    }

    public static class Builder {
        public static final int MAX_TEXTURE = 2;
        boolean mPointSpriteEnable;
        RenderScript mRS;
        Slot[] mSlots;

        public Builder(RenderScript renderScript) {
            this.mRS = renderScript;
            Slot[] slotArray = new Slot[2];
            this.mSlots = slotArray;
            this.mPointSpriteEnable = false;
        }

        /*
         * Enabled aggressive block sorting
         */
        public ProgramFragment create() {
            this.mRS.validate();
            int[] nArray = new int[5];
            if (this.mSlots[0] != null) {
                int n;
                int n2;
                nArray[0] = n2 = this.mSlots[0].env.mID;
                nArray[1] = n = this.mSlots[0].format.mID;
            }
            if (this.mSlots[1] != null) {
                int n;
                int n3;
                nArray[2] = n3 = this.mSlots[1].env.mID;
                nArray[3] = n = this.mSlots[1].format.mID;
            }
            int n = 4;
            int n4 = this.mPointSpriteEnable ? 1 : 0;
            nArray[n] = n4;
            int n5 = this.mRS.nProgramFragmentCreate(nArray);
            RenderScript renderScript = this.mRS;
            ProgramFragment programFragment = new ProgramFragment(n5, renderScript);
            programFragment.mTextureCount = 2;
            return programFragment;
        }

        public void setPointSpriteTexCoordinateReplacement(boolean bl) {
            this.mPointSpriteEnable = bl;
        }

        public void setTexture(EnvMode envMode, Format format, int n) throws IllegalArgumentException {
            Slot slot;
            if (n < 0 || n >= 2) {
                throw new IllegalArgumentException("MAX_TEXTURE exceeded.");
            }
            Slot[] slotArray = this.mSlots;
            slotArray[n] = slot = new Slot(envMode, format);
        }

        private class Slot {
            EnvMode env;
            Format format;

            Slot(EnvMode envMode, Format format) {
                this.env = envMode;
                this.format = format;
            }
        }

        public static final class Format
        extends Enum<Format> {
            private static final /* synthetic */ Format[] $VALUES;
            public static final /* enum */ Format ALPHA = new Format(1);
            public static final /* enum */ Format LUMINANCE_ALPHA = new Format(2);
            public static final /* enum */ Format RGB = new Format(3);
            public static final /* enum */ Format RGBA = new Format(4);
            int mID;

            static {
                Format format = ALPHA;
                Format format2 = LUMINANCE_ALPHA;
                Format format3 = RGB;
                Format format4 = RGBA;
                Format[] formatArray = new Format[]{format, format2, format3, format4};
                $VALUES = formatArray;
            }

            private Format(int n2) {
                this.mID = n2;
            }

            public static Format valueOf(String string2) {
                return Enum.valueOf(Format.class, string2);
            }

            public static Format[] values() {
                return (Format[])$VALUES.clone();
            }
        }

        public static final class EnvMode
        extends Enum<EnvMode> {
            private static final /* synthetic */ EnvMode[] $VALUES;
            public static final /* enum */ EnvMode DECAL;
            public static final /* enum */ EnvMode MODULATE;
            public static final /* enum */ EnvMode REPLACE;
            int mID;

            static {
                REPLACE = new EnvMode(1);
                MODULATE = new EnvMode(2);
                DECAL = new EnvMode(3);
                EnvMode envMode = REPLACE;
                EnvMode envMode2 = MODULATE;
                EnvMode envMode3 = DECAL;
                EnvMode[] envModeArray = new EnvMode[]{envMode, envMode2, envMode3};
                $VALUES = envModeArray;
            }

            private EnvMode(int n2) {
                this.mID = n2;
            }

            public static EnvMode valueOf(String string2) {
                return Enum.valueOf(EnvMode.class, string2);
            }

            public static EnvMode[] values() {
                return (EnvMode[])$VALUES.clone();
            }
        }
    }

    public static class ShaderBuilder
    extends Program.BaseProgramBuilder {
        public ShaderBuilder(RenderScript renderScript) {
            super(renderScript);
        }

        public ProgramFragment create() {
            int n;
            int n2;
            int n3;
            int n4;
            this.mRS.validate();
            int n5 = this.mInputCount;
            int n6 = this.mOutputCount;
            int n7 = n5 + n6;
            int n8 = this.mConstantCount;
            int[] nArray = new int[(n7 + n8 + 1) * 2];
            int n9 = 0;
            for (int i = 0; i < (n4 = this.mInputCount); ++i) {
                int n10;
                int n11 = n9 + 1;
                nArray[n9] = 0;
                n9 = n11 + 1;
                nArray[n11] = n10 = this.mInputs[i].mID;
            }
            for (int i = 0; i < (n3 = this.mOutputCount); ++i) {
                int n12;
                int n13 = n9 + 1;
                nArray[n9] = 1;
                n9 = n13 + 1;
                nArray[n13] = n12 = this.mOutputs[i].mID;
            }
            for (int i = 0; i < (n2 = this.mConstantCount); ++i) {
                int n14;
                int n15 = n9 + 1;
                nArray[n9] = 2;
                n9 = n15 + 1;
                nArray[n15] = n14 = this.mConstants[i].mID;
            }
            int n16 = n9 + 1;
            nArray[n9] = 3;
            int n17 = n16 + 1;
            nArray[n16] = n = this.mTextureCount;
            RenderScript renderScript = this.mRS;
            String string2 = this.mShader;
            int n18 = renderScript.nProgramFragmentCreate2(string2, nArray);
            RenderScript renderScript2 = this.mRS;
            ProgramFragment programFragment = new ProgramFragment(n18, renderScript2);
            this.initProgram(programFragment);
            return programFragment;
        }
    }
}

