/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.RenderScript;

public class ProgramRaster
extends BaseObj {
    Element mIn;
    boolean mLineSmooth;
    float mLineWidth;
    Element mOut;
    float mPointSize;
    boolean mPointSmooth;
    boolean mPointSprite;

    ProgramRaster(int n, RenderScript renderScript) {
        super(renderScript);
        this.mID = n;
        this.mPointSize = 1.0f;
        this.mLineWidth = 1.0f;
        this.mPointSmooth = false;
        this.mLineSmooth = false;
        this.mPointSprite = false;
    }

    void internalInit() {
        int n;
        int n2 = 0;
        int n3 = 0;
        if (this.mIn != null) {
            n2 = this.mIn.mID;
        }
        if (this.mOut != null) {
            n3 = this.mOut.mID;
        }
        RenderScript renderScript = this.mRS;
        boolean bl = this.mPointSmooth;
        boolean bl2 = this.mLineSmooth;
        boolean bl3 = this.mPointSprite;
        this.mID = n = renderScript.nProgramRasterCreate(n2, n3, bl, bl2, bl3);
    }

    public void setLineWidth(float f) {
        this.mRS.validate();
        this.mLineWidth = f;
        RenderScript renderScript = this.mRS;
        int n = this.mID;
        renderScript.nProgramRasterSetLineWidth(n, f);
    }

    public void setPointSize(float f) {
        this.mRS.validate();
        this.mPointSize = f;
        RenderScript renderScript = this.mRS;
        int n = this.mID;
        renderScript.nProgramRasterSetPointSize(n, f);
    }

    public static class Builder {
        ProgramRaster mPR;
        RenderScript mRS;

        public Builder(RenderScript renderScript, Element element, Element element2) {
            ProgramRaster programRaster;
            this.mRS = renderScript;
            this.mPR = programRaster = new ProgramRaster(0, renderScript);
        }

        static ProgramRaster internalCreate(RenderScript renderScript, Builder builder) {
            synchronized (Builder.class) {
                ProgramRaster programRaster;
                builder.mPR.internalInit();
                ProgramRaster programRaster2 = builder.mPR;
                RenderScript renderScript2 = builder.mRS;
                builder.mPR = programRaster = new ProgramRaster(0, renderScript2);
                return programRaster2;
            }
        }

        public ProgramRaster create() {
            this.mRS.validate();
            return Builder.internalCreate(this.mRS, this);
        }

        public void setLineSmoothEnable(boolean bl) {
            this.mPR.mLineSmooth = bl;
        }

        public void setPointSmoothEnable(boolean bl) {
            this.mPR.mPointSmooth = bl;
        }

        public void setPointSpriteEnable(boolean bl) {
            this.mPR.mPointSprite = bl;
        }
    }
}

