/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.Matrix4f;
import android.renderscript.Program;
import android.renderscript.RenderScript;

public class ProgramVertex
extends Program {
    public static final int MAX_LIGHT = 8;

    ProgramVertex(int n, RenderScript renderScript) {
        super(n, renderScript);
    }

    public void bindAllocation(MatrixAllocation matrixAllocation) {
        this.mRS.validate();
        Allocation allocation = matrixAllocation.mAlloc;
        this.bindConstants(allocation, 0);
    }

    public static class MatrixAllocation {
        static final int MODELVIEW_OFFSET = 0;
        static final int PROJECTION_OFFSET = 16;
        static final int TEXTURE_OFFSET = 32;
        public Allocation mAlloc;
        Matrix4f mModel;
        Matrix4f mProjection;
        Matrix4f mTexture;

        public MatrixAllocation(RenderScript renderScript) {
            Allocation allocation;
            Matrix4f matrix4f;
            Matrix4f matrix4f2;
            Matrix4f matrix4f3;
            this.mModel = matrix4f3 = new Matrix4f();
            this.mProjection = matrix4f2 = new Matrix4f();
            this.mTexture = matrix4f = new Matrix4f();
            Element.DataType dataType = Element.DataType.FLOAT_32;
            Element element = Element.createUser(renderScript, dataType);
            Allocation allocation2 = this.mAlloc = (allocation = Allocation.createSized(renderScript, element, 48));
            float[] fArray = this.mModel.mMat;
            allocation2.subData1D(0, 16, fArray);
            Allocation allocation3 = this.mAlloc;
            float[] fArray2 = this.mProjection.mMat;
            allocation3.subData1D(16, 16, fArray2);
            Allocation allocation4 = this.mAlloc;
            float[] fArray3 = this.mTexture.mMat;
            allocation4.subData1D(32, 16, fArray3);
        }

        public void destroy() {
            this.mAlloc.destroy();
            this.mAlloc = null;
        }

        public void loadModelview(Matrix4f matrix4f) {
            this.mModel = matrix4f;
            Allocation allocation = this.mAlloc;
            float[] fArray = matrix4f.mMat;
            allocation.subData1D(0, 16, fArray);
        }

        public void loadProjection(Matrix4f matrix4f) {
            this.mProjection = matrix4f;
            Allocation allocation = this.mAlloc;
            float[] fArray = matrix4f.mMat;
            allocation.subData1D(16, 16, fArray);
        }

        public void loadTexture(Matrix4f matrix4f) {
            this.mTexture = matrix4f;
            Allocation allocation = this.mAlloc;
            float[] fArray = matrix4f.mMat;
            allocation.subData1D(32, 16, fArray);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setupOrthoNormalized(int n, int n2) {
            if (n > n2) {
                float f = n;
                float f2 = n2;
                float f3 = f / f2;
                Matrix4f matrix4f = this.mProjection;
                float f4 = -f3;
                float f5 = -1.0f;
                float f6 = 1.0f;
                matrix4f.loadOrtho(f4, f3, -1.0f, 1.0f, f5, f6);
            } else {
                float f = n2;
                float f7 = n;
                float f8 = f / f7;
                Matrix4f matrix4f = this.mProjection;
                float f9 = -f8;
                float f10 = -1.0f;
                float f11 = 1.0f;
                float f12 = f8;
                float f13 = -1.0f;
                float f14 = 1.0f;
                matrix4f.loadOrtho(f10, f11, f9, f12, f13, f14);
            }
            Allocation allocation = this.mAlloc;
            float[] fArray = this.mProjection.mMat;
            allocation.subData1D(16, 16, fArray);
        }

        public void setupOrthoWindow(int n, int n2) {
            Matrix4f matrix4f = this.mProjection;
            float f = n;
            float f2 = n2;
            float f3 = 0.0f;
            matrix4f.loadOrtho(0.0f, f, f2, f3, -1.0f, 1.0f);
            Allocation allocation = this.mAlloc;
            float[] fArray = this.mProjection.mMat;
            allocation.subData1D(16, 16, fArray);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setupProjectionNormalized(int n, int n2) {
            Matrix4f matrix4f = new Matrix4f();
            Matrix4f matrix4f2 = new Matrix4f();
            if (n > n2) {
                float f = n;
                float f2 = n2;
                float f3 = f / f2;
                float f4 = -f3;
                matrix4f.loadFrustum(f4, f3, -1.0f, 1.0f, 1.0f, 100.0f);
            } else {
                float f = n2;
                float f5 = n;
                float f6 = f / f5;
                float f7 = -f6;
                Matrix4f matrix4f3 = matrix4f;
                float f8 = f6;
                matrix4f3.loadFrustum(-1.0f, 1.0f, f7, f8, 1.0f, 100.0f);
            }
            matrix4f2.loadRotate(180.0f, 0.0f, 1.0f, 0.0f);
            matrix4f.loadMultiply(matrix4f, matrix4f2);
            matrix4f2.loadScale(-2.0f, 2.0f, 1.0f);
            matrix4f.loadMultiply(matrix4f, matrix4f2);
            matrix4f2.loadTranslate(0.0f, 0.0f, 2.0f);
            matrix4f.loadMultiply(matrix4f, matrix4f2);
            this.mProjection = matrix4f;
            Allocation allocation = this.mAlloc;
            float[] fArray = this.mProjection.mMat;
            allocation.subData1D(16, 16, fArray);
        }
    }

    public static class ShaderBuilder
    extends Program.BaseProgramBuilder {
        public ShaderBuilder(RenderScript renderScript) {
            super(renderScript);
        }

        public ProgramVertex create() {
            int n;
            int n2;
            int n3;
            int n4;
            this.mRS.validate();
            int n5 = this.mInputCount;
            int n6 = this.mOutputCount;
            int n7 = n5 + n6;
            int n8 = this.mConstantCount;
            int[] nArray = new int[(n7 + n8 + 1) * 2];
            int n9 = 0;
            for (int i = 0; i < (n4 = this.mInputCount); ++i) {
                int n10;
                int n11 = n9 + 1;
                nArray[n9] = 0;
                n9 = n11 + 1;
                nArray[n11] = n10 = this.mInputs[i].mID;
            }
            for (int i = 0; i < (n3 = this.mOutputCount); ++i) {
                int n12;
                int n13 = n9 + 1;
                nArray[n9] = 1;
                n9 = n13 + 1;
                nArray[n13] = n12 = this.mOutputs[i].mID;
            }
            for (int i = 0; i < (n2 = this.mConstantCount); ++i) {
                int n14;
                int n15 = n9 + 1;
                nArray[n9] = 2;
                n9 = n15 + 1;
                nArray[n15] = n14 = this.mConstants[i].mID;
            }
            int n16 = n9 + 1;
            nArray[n9] = 3;
            int n17 = n16 + 1;
            nArray[n16] = n = this.mTextureCount;
            RenderScript renderScript = this.mRS;
            String string2 = this.mShader;
            int n18 = renderScript.nProgramVertexCreate2(string2, nArray);
            RenderScript renderScript2 = this.mRS;
            ProgramVertex programVertex = new ProgramVertex(n18, renderScript2);
            this.initProgram(programVertex);
            return programVertex;
        }
    }

    public static class Builder {
        RenderScript mRS;
        boolean mTextureMatrixEnable;

        public Builder(RenderScript renderScript, Element element, Element element2) {
            this.mRS = renderScript;
        }

        public ProgramVertex create() {
            RenderScript renderScript = this.mRS;
            boolean bl = this.mTextureMatrixEnable;
            int n = renderScript.nProgramVertexCreate(bl);
            RenderScript renderScript2 = this.mRS;
            return new ProgramVertex(n, renderScript2);
        }

        public void setTextureMatrixEnable(boolean bl) {
            this.mTextureMatrixEnable = bl;
        }
    }
}

