/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.RenderScript;

public class Sampler
extends BaseObj {
    Sampler(int n, RenderScript renderScript) {
        super(renderScript);
        this.mID = n;
    }

    public static class Builder {
        Value mMag;
        Value mMin;
        RenderScript mRS;
        Value mWrapR;
        Value mWrapS;
        Value mWrapT;

        public Builder(RenderScript renderScript) {
            Value value;
            Value value2;
            Value value3;
            Value value4;
            Value value5;
            this.mRS = renderScript;
            this.mMin = value5 = Value.NEAREST;
            this.mMag = value4 = Value.NEAREST;
            this.mWrapS = value3 = Value.WRAP;
            this.mWrapT = value2 = Value.WRAP;
            this.mWrapR = value = Value.WRAP;
        }

        static Sampler internalCreate(RenderScript renderScript, Builder builder) {
            synchronized (Builder.class) {
                renderScript.nSamplerBegin();
                int n = builder.mMin.mID;
                renderScript.nSamplerSet(0, n);
                int n2 = builder.mMag.mID;
                renderScript.nSamplerSet(1, n2);
                int n3 = builder.mWrapS.mID;
                renderScript.nSamplerSet(2, n3);
                int n4 = builder.mWrapT.mID;
                renderScript.nSamplerSet(3, n4);
                int n5 = builder.mWrapR.mID;
                renderScript.nSamplerSet(4, n5);
                int n6 = renderScript.nSamplerCreate();
                Sampler sampler = new Sampler(n6, renderScript);
                return sampler;
            }
        }

        public Sampler create() {
            this.mRS.validate();
            return Builder.internalCreate(this.mRS, this);
        }

        public void setMag(Value value) {
            Value value2;
            Value value3 = Value.NEAREST;
            if (value == value3 || value == (value2 = Value.LINEAR)) {
                this.mMag = value;
                return;
            }
            throw new IllegalArgumentException("Invalid value");
        }

        public void setMin(Value value) {
            Value value2;
            Value value3;
            Value value4 = Value.NEAREST;
            if (value == value4 || value == (value3 = Value.LINEAR) || value == (value2 = Value.LINEAR_MIP_LINEAR)) {
                this.mMin = value;
                return;
            }
            throw new IllegalArgumentException("Invalid value");
        }

        public void setWrapR(Value value) {
            Value value2;
            Value value3 = Value.WRAP;
            if (value == value3 || value == (value2 = Value.CLAMP)) {
                this.mWrapR = value;
                return;
            }
            throw new IllegalArgumentException("Invalid value");
        }

        public void setWrapS(Value value) {
            Value value2;
            Value value3 = Value.WRAP;
            if (value == value3 || value == (value2 = Value.CLAMP)) {
                this.mWrapS = value;
                return;
            }
            throw new IllegalArgumentException("Invalid value");
        }

        public void setWrapT(Value value) {
            Value value2;
            Value value3 = Value.WRAP;
            if (value == value3 || value == (value2 = Value.CLAMP)) {
                this.mWrapT = value;
                return;
            }
            throw new IllegalArgumentException("Invalid value");
        }
    }

    public static final class Value
    extends Enum<Value> {
        private static final /* synthetic */ Value[] $VALUES;
        public static final /* enum */ Value CLAMP;
        public static final /* enum */ Value LINEAR;
        public static final /* enum */ Value LINEAR_MIP_LINEAR;
        public static final /* enum */ Value NEAREST;
        public static final /* enum */ Value WRAP;
        int mID;

        static {
            NEAREST = new Value(0);
            LINEAR = new Value(1);
            LINEAR_MIP_LINEAR = new Value(2);
            WRAP = new Value(3);
            CLAMP = new Value(4);
            Value value = NEAREST;
            Value value2 = LINEAR;
            Value value3 = LINEAR_MIP_LINEAR;
            Value value4 = WRAP;
            Value value5 = CLAMP;
            Value[] valueArray = new Value[]{value, value2, value3, value4, value5};
            $VALUES = valueArray;
        }

        private Value(int n2) {
            this.mID = n2;
        }

        public static Value valueOf(String string2) {
            return Enum.valueOf(Value.class, string2);
        }

        public static Value[] values() {
            return (Value[])$VALUES.clone();
        }
    }
}

