/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.RenderScript;
import android.renderscript.Type;
import java.io.UnsupportedEncodingException;

public class Script
extends BaseObj {
    public static final int MAX_SLOT = 16;
    Invokable[] mInvokables;
    boolean mIsRoot;
    Type[] mTypes;
    boolean[] mWritable;

    Script(int n, RenderScript renderScript) {
        super(renderScript);
        this.mID = n;
    }

    public void bindAllocation(Allocation allocation, int n) {
        this.mRS.validate();
        RenderScript renderScript = this.mRS;
        int n2 = this.mID;
        int n3 = allocation.mID;
        renderScript.nScriptBindAllocation(n2, n3, n);
    }

    public void setClearColor(float f, float f2, float f3, float f4) {
        this.mRS.validate();
        RenderScript renderScript = this.mRS;
        int n = this.mID;
        float f5 = f;
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        renderScript.nScriptSetClearColor(n, f5, f6, f7, f8);
    }

    public void setClearDepth(float f) {
        this.mRS.validate();
        RenderScript renderScript = this.mRS;
        int n = this.mID;
        renderScript.nScriptSetClearDepth(n, f);
    }

    public void setClearStencil(int n) {
        this.mRS.validate();
        RenderScript renderScript = this.mRS;
        int n2 = this.mID;
        renderScript.nScriptSetClearStencil(n2, n);
    }

    public void setTimeZone(String string2) {
        this.mRS.validate();
        try {
            RenderScript renderScript = this.mRS;
            int n = this.mID;
            byte[] byArray = string2.getBytes("UTF-8");
            renderScript.nScriptSetTimeZone(n, byArray);
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static class Builder {
        int mInvokableCount = 0;
        Invokable[] mInvokables;
        boolean mIsRoot = false;
        String[] mNames;
        RenderScript mRS;
        Type[] mTypes;
        boolean[] mWritable;

        Builder(RenderScript renderScript) {
            this.mRS = renderScript;
            Type[] typeArray = new Type[16];
            this.mTypes = typeArray;
            String[] stringArray = new String[16];
            this.mNames = stringArray;
            boolean[] blArray = new boolean[16];
            this.mWritable = blArray;
            Invokable[] invokableArray = new Invokable[16];
            this.mInvokables = invokableArray;
        }

        public Invokable addInvokable(String string2) {
            int n;
            int n2;
            RenderScript renderScript;
            Invokable invokable = new Invokable();
            invokable.mName = string2;
            invokable.mRS = renderScript = this.mRS;
            invokable.mSlot = n2 = this.mInvokableCount;
            Invokable[] invokableArray = this.mInvokables;
            int n3 = this.mInvokableCount;
            this.mInvokableCount = n = n3 + 1;
            invokableArray[n3] = invokable;
            return invokable;
        }

        public void setRoot(boolean bl) {
            this.mIsRoot = bl;
        }

        public void setType(Type type, int n) {
            this.mTypes[n] = type;
            this.mNames[n] = null;
        }

        public void setType(Type type, String string2, int n) {
            this.mTypes[n] = type;
            this.mNames[n] = string2;
        }

        public void setType(boolean bl, int n) {
            this.mWritable[n] = bl;
        }

        void transferCreate() {
            int n;
            RenderScript renderScript = this.mRS;
            boolean bl = this.mIsRoot;
            renderScript.nScriptSetRoot(bl);
            for (int i = 0; i < (n = this.mTypes.length); ++i) {
                if (this.mTypes[i] == null) continue;
                RenderScript renderScript2 = this.mRS;
                int n2 = this.mTypes[i].mID;
                boolean bl2 = this.mWritable[i];
                String string2 = this.mNames[i];
                renderScript2.nScriptSetType(n2, bl2, string2, i);
            }
            int n3 = 0;
            int n4;
            while (n3 < (n4 = this.mInvokableCount)) {
                RenderScript renderScript3 = this.mRS;
                String string3 = this.mInvokables[n3].mName;
                renderScript3.nScriptSetInvokable(string3, n3);
                ++n3;
            }
            return;
        }

        void transferObject(Script script) {
            int n;
            boolean bl;
            script.mIsRoot = bl = this.mIsRoot;
            Type[] typeArray = this.mTypes;
            script.mTypes = typeArray;
            Invokable[] invokableArray = new Invokable[this.mInvokableCount];
            script.mInvokables = invokableArray;
            for (int i = 0; i < (n = this.mInvokableCount); ++i) {
                Invokable invokable;
                Invokable[] invokableArray2 = script.mInvokables;
                invokableArray2[i] = invokable = this.mInvokables[i];
                script.mInvokables[i].mScript = script;
            }
            script.mInvokables = null;
        }
    }

    public static class Invokable {
        String mName;
        RenderScript mRS;
        Script mScript;
        int mSlot = -1;

        Invokable() {
        }

        public void execute() {
            RenderScript renderScript = this.mRS;
            int n = this.mScript.mID;
            int n2 = this.mSlot;
            renderScript.nScriptInvoke(n, n2);
        }
    }
}

