/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.res.Resources;
import android.renderscript.RenderScript;
import android.renderscript.Script;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ScriptC
extends Script {
    private static final String TAG = "ScriptC";

    ScriptC(int n, RenderScript renderScript) {
        super(n, renderScript);
    }

    public static class Builder
    extends Script.Builder {
        HashMap<String, Float> mFloatDefines;
        HashMap<String, Integer> mIntDefines;
        byte[] mProgram;
        int mProgramLength;

        public Builder(RenderScript renderScript) {
            super(renderScript);
            HashMap hashMap = new HashMap();
            this.mIntDefines = hashMap;
            HashMap hashMap2 = new HashMap();
            this.mFloatDefines = hashMap2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static ScriptC internalCreate(Builder builder) {
            synchronized (Builder.class) {
                builder.mRS.nScriptCBegin();
                builder.transferCreate();
                for (Map.Entry<String, Integer> entry : builder.mIntDefines.entrySet()) {
                    RenderScript renderScript = builder.mRS;
                    String string2 = entry.getKey();
                    int n = entry.getValue();
                    renderScript.nScriptCAddDefineI32(string2, n);
                }
                Iterator<Map.Entry<String, Number>> iterator = builder.mFloatDefines.entrySet().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        RenderScript renderScript = builder.mRS;
                        byte[] byArray = builder.mProgram;
                        int n = builder.mProgramLength;
                        renderScript.nScriptCSetScript(byArray, 0, n);
                        int n2 = builder.mRS.nScriptCCreate();
                        RenderScript renderScript2 = builder.mRS;
                        ScriptC scriptC = new ScriptC(n2, renderScript2);
                        builder.transferObject(scriptC);
                        return scriptC;
                    }
                    Map.Entry<String, Number> entry = iterator.next();
                    RenderScript renderScript = builder.mRS;
                    String string3 = entry.getKey();
                    float f = ((Float)entry.getValue()).floatValue();
                    renderScript.nScriptCAddDefineF(string3, f);
                }
            }
        }

        public void addDefine(String string2, float f) {
            HashMap<String, Float> hashMap = this.mFloatDefines;
            Float f2 = Float.valueOf(f);
            Float f3 = hashMap.put(string2, f2);
        }

        public void addDefine(String string2, int n) {
            HashMap<String, Integer> hashMap = this.mIntDefines;
            Integer n2 = n;
            Integer n3 = hashMap.put(string2, n2);
        }

        public void addDefines(Class clazz) {
            Field[] fieldArray = clazz.getFields();
            this.addDefines(fieldArray, 25, null);
        }

        public void addDefines(Object object) {
            Field[] fieldArray = object.getClass().getFields();
            this.addDefines(fieldArray, 1, object);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void addDefines(Field[] fieldArray, int n, Object object) {
            Field[] fieldArray2 = fieldArray;
            int n2 = fieldArray2.length;
            int n3 = 0;
            while (true) {
                block6: {
                    if (n3 >= n2) {
                        return;
                    }
                    Field field = fieldArray2[n3];
                    try {
                        Class<Integer> clazz;
                        if ((field.getModifiers() & n) == n) break block6;
                        Class<?> clazz2 = field.getType();
                        if (clazz2 == (clazz = Integer.TYPE)) {
                            HashMap<String, Integer> hashMap = this.mIntDefines;
                            String string2 = field.getName();
                            Integer n4 = field.getInt(object);
                            Integer n5 = hashMap.put(string2, n4);
                            break block6;
                        }
                        Class<Float> clazz3 = Float.TYPE;
                        if (clazz2 == clazz3) {
                            HashMap<String, Float> hashMap = this.mFloatDefines;
                            String string3 = field.getName();
                            Float f = Float.valueOf(field.getFloat(object));
                            Float f2 = hashMap.put(string3, f);
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        StringBuilder stringBuilder = new StringBuilder().append("addDefines skipping field ");
                        String string4 = field.getName();
                        String string5 = stringBuilder.append(string4).toString();
                        int n6 = Log.d(ScriptC.TAG, string5);
                    }
                }
                ++n3;
            }
        }

        public ScriptC create() {
            return Builder.internalCreate(this);
        }

        /*
         * Loose catch block
         */
        public void setScript(Resources resources, int n) {
            InputStream inputStream = resources.openRawResource(n);
            this.setScript(inputStream);
            {
                catch (Throwable throwable) {
                    inputStream.close();
                    throw throwable;
                }
            }
            try {
                inputStream.close();
                return;
            }
            catch (IOException iOException) {
                throw new Resources.NotFoundException();
            }
        }

        public void setScript(InputStream inputStream) throws IOException {
            byte[] byArray = new byte[1024];
            int n = 0;
            while (true) {
                int n2;
                int n3;
                if ((n3 = byArray.length - n) == 0) {
                    byte[] byArray2 = new byte[byArray.length * 2];
                    int n4 = byArray.length;
                    System.arraycopy(byArray, 0, byArray2, 0, n4);
                    byArray = byArray2;
                    n3 = byArray.length - n;
                }
                if ((n2 = inputStream.read(byArray, n, n3)) <= 0) {
                    this.mProgram = byArray;
                    this.mProgramLength = n;
                    return;
                }
                n += n2;
            }
        }

        public void setScript(String string2) {
            try {
                int n;
                byte[] byArray = string2.getBytes("UTF-8");
                this.mProgram = byArray;
                this.mProgramLength = n = this.mProgram.length;
                return;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
    }
}

