/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.Dimension;
import android.renderscript.Element;
import android.renderscript.Primitive;
import android.renderscript.RenderScript;
import android.renderscript.Type;

public class SimpleMesh
extends BaseObj {
    Type mIndexType;
    Primitive mPrimitive;
    Type[] mVertexTypes;

    SimpleMesh(int n, RenderScript renderScript) {
        super(renderScript);
        this.mID = n;
    }

    public void bindIndexAllocation(Allocation allocation) {
        this.mRS.validate();
        RenderScript renderScript = this.mRS;
        int n = this.mID;
        int n2 = allocation.mID;
        renderScript.nSimpleMeshBindIndex(n, n2);
    }

    public void bindVertexAllocation(Allocation allocation, int n) {
        this.mRS.validate();
        RenderScript renderScript = this.mRS;
        int n2 = this.mID;
        int n3 = allocation.mID;
        renderScript.nSimpleMeshBindVertex(n2, n3, n);
    }

    public Allocation createIndexAllocation() {
        this.mRS.validate();
        RenderScript renderScript = this.mRS;
        Type type = this.mIndexType;
        return Allocation.createTyped(renderScript, type);
    }

    public Allocation createVertexAllocation(int n) {
        this.mRS.validate();
        RenderScript renderScript = this.mRS;
        Type type = this.mVertexTypes[n];
        return Allocation.createTyped(renderScript, type);
    }

    public Type getIndexType() {
        return this.mIndexType;
    }

    public Type getVertexType(int n) {
        return this.mVertexTypes[n];
    }

    public static class TriangleMeshBuilder {
        public static final int COLOR = 1;
        public static final int NORMAL = 2;
        public static final int TEXTURE_0 = 256;
        float mA = 1.0f;
        float mB = 1.0f;
        Element mElement;
        int mFlags;
        float mG = 1.0f;
        int mIndexCount;
        short[] mIndexData;
        float mNX = 0.0f;
        float mNY = 0.0f;
        float mNZ = -1.0f;
        float mR = 1.0f;
        RenderScript mRS;
        float mS0 = 0.0f;
        float mT0 = 0.0f;
        int mVtxCount;
        float[] mVtxData;
        int mVtxSize;

        public TriangleMeshBuilder(RenderScript renderScript, int n, int n2) {
            this.mRS = renderScript;
            this.mVtxCount = 0;
            this.mIndexCount = 0;
            float[] fArray = new float[128];
            this.mVtxData = fArray;
            Object var5_5 = null;
            this.mIndexData = var5_5;
            this.mVtxSize = n;
            this.mFlags = n2;
            if (n >= 2 && n <= 3) {
                return;
            }
            throw new IllegalArgumentException("Vertex size out of range.");
        }

        private void latch() {
            float f;
            int n;
            float f2;
            int n2;
            float f3;
            int n3;
            if ((this.mFlags & 1) != 0) {
                float f4;
                int n4;
                float f5;
                int n5;
                float f6;
                int n6;
                float f7;
                int n7;
                this.makeSpace(4);
                float[] fArray = this.mVtxData;
                int n8 = this.mVtxCount;
                this.mVtxCount = n7 = n8 + 1;
                fArray[n8] = f7 = this.mR;
                float[] fArray2 = this.mVtxData;
                int n9 = this.mVtxCount;
                this.mVtxCount = n6 = n9 + 1;
                fArray2[n9] = f6 = this.mG;
                float[] fArray3 = this.mVtxData;
                int n10 = this.mVtxCount;
                this.mVtxCount = n5 = n10 + 1;
                fArray3[n10] = f5 = this.mB;
                float[] fArray4 = this.mVtxData;
                int n11 = this.mVtxCount;
                this.mVtxCount = n4 = n11 + 1;
                fArray4[n11] = f4 = this.mA;
            }
            if ((this.mFlags & 0x100) != 0) {
                float f8;
                int n12;
                float f9;
                int n13;
                this.makeSpace(2);
                float[] fArray = this.mVtxData;
                int n14 = this.mVtxCount;
                this.mVtxCount = n13 = n14 + 1;
                fArray[n14] = f9 = this.mS0;
                float[] fArray5 = this.mVtxData;
                int n15 = this.mVtxCount;
                this.mVtxCount = n12 = n15 + 1;
                fArray5[n15] = f8 = this.mT0;
            }
            if ((this.mFlags & 2) == 0) {
                return;
            }
            this.makeSpace(3);
            float[] fArray = this.mVtxData;
            int n16 = this.mVtxCount;
            this.mVtxCount = n3 = n16 + 1;
            fArray[n16] = f3 = this.mNX;
            float[] fArray6 = this.mVtxData;
            int n17 = this.mVtxCount;
            this.mVtxCount = n2 = n17 + 1;
            fArray6[n17] = f2 = this.mNY;
            float[] fArray7 = this.mVtxData;
            int n18 = this.mVtxCount;
            this.mVtxCount = n = n18 + 1;
            fArray7[n18] = f = this.mNZ;
        }

        private void makeSpace(int n) {
            int n2 = this.mVtxCount + n;
            int n3 = this.mVtxData.length;
            if (n2 < n3) {
                return;
            }
            float[] fArray = new float[this.mVtxData.length * 2];
            float[] fArray2 = this.mVtxData;
            int n4 = this.mVtxData.length;
            System.arraycopy(fArray2, 0, fArray, 0, n4);
            this.mVtxData = fArray;
        }

        public void addTriangle(int n, int n2, int n3) {
            short s;
            int n4;
            short s2;
            int n5;
            short s3;
            int n6;
            int n7;
            int n8;
            int n9 = this.mVtxCount;
            if (n >= n9 || n < 0 || n2 >= (n8 = this.mVtxCount) || n2 < 0 || n3 >= (n7 = this.mVtxCount) || n3 < 0) {
                throw new IllegalStateException("Index provided greater than vertex count.");
            }
            int n10 = this.mIndexCount + 3;
            int n11 = this.mIndexData.length;
            if (n10 >= n11) {
                int n12 = this.mIndexData.length * 2;
                short[] sArray = this.mIndexData;
                int n13 = this.mIndexData.length;
                System.arraycopy(sArray, 0, n12, 0, n13);
                this.mIndexData = (short[])n12;
            }
            short[] sArray = this.mIndexData;
            int n14 = this.mIndexCount;
            this.mIndexCount = n6 = n14 + 1;
            sArray[n14] = s3 = (short)n;
            short[] sArray2 = this.mIndexData;
            int n15 = this.mIndexCount;
            this.mIndexCount = n5 = n15 + 1;
            sArray2[n15] = s2 = (short)n2;
            short[] sArray3 = this.mIndexData;
            int n16 = this.mIndexCount;
            this.mIndexCount = n4 = n16 + 1;
            sArray3[n16] = s = (short)n3;
        }

        public void addVertex(float f, float f2) {
            int n;
            int n2;
            if (this.mVtxSize != 2) {
                throw new IllegalStateException("add mistmatch with declared components.");
            }
            this.makeSpace(2);
            float[] fArray = this.mVtxData;
            int n3 = this.mVtxCount;
            this.mVtxCount = n2 = n3 + 1;
            fArray[n3] = f;
            float[] fArray2 = this.mVtxData;
            int n4 = this.mVtxCount;
            this.mVtxCount = n = n4 + 1;
            fArray2[n4] = f2;
            this.latch();
        }

        public void addVertex(float f, float f2, float f3) {
            int n;
            int n2;
            int n3;
            if (this.mVtxSize != 3) {
                throw new IllegalStateException("add mistmatch with declared components.");
            }
            this.makeSpace(3);
            float[] fArray = this.mVtxData;
            int n4 = this.mVtxCount;
            this.mVtxCount = n3 = n4 + 1;
            fArray[n4] = f;
            float[] fArray2 = this.mVtxData;
            int n5 = this.mVtxCount;
            this.mVtxCount = n2 = n5 + 1;
            fArray2[n5] = f2;
            float[] fArray3 = this.mVtxData;
            int n6 = this.mVtxCount;
            this.mVtxCount = n = n6 + 1;
            fArray3[n6] = f3;
            this.latch();
        }

        public SimpleMesh create() {
            Element element;
            RenderScript renderScript = this.mRS;
            Element.Builder builder = new Element.Builder(renderScript);
            int n = this.mVtxSize;
            RenderScript renderScript2 = this.mRS;
            Element.DataType dataType = Element.DataType.FLOAT_32;
            Element.DataKind dataKind = Element.DataKind.POSITION;
            int n2 = this.mVtxSize;
            Element element2 = Element.createAttrib(renderScript2, dataType, dataKind, n2);
            builder.add(element2, "position");
            if ((this.mFlags & 1) != 0) {
                n += 4;
                RenderScript renderScript3 = this.mRS;
                Element.DataType dataType2 = Element.DataType.FLOAT_32;
                Element.DataKind dataKind2 = Element.DataKind.COLOR;
                Element element3 = Element.createAttrib(renderScript3, dataType2, dataKind2, 4);
                builder.add(element3, "color");
            }
            if ((this.mFlags & 0x100) != 0) {
                n += 2;
                RenderScript renderScript4 = this.mRS;
                Element.DataType dataType3 = Element.DataType.FLOAT_32;
                Element.DataKind dataKind3 = Element.DataKind.TEXTURE;
                Element element4 = Element.createAttrib(renderScript4, dataType3, dataKind3, 2);
                builder.add(element4, "texture");
            }
            if ((this.mFlags & 2) != 0) {
                n += 3;
                RenderScript renderScript5 = this.mRS;
                Element.DataType dataType4 = Element.DataType.FLOAT_32;
                Element.DataKind dataKind4 = Element.DataKind.NORMAL;
                Element element5 = Element.createAttrib(renderScript5, dataType4, dataKind4, 3);
                builder.add(element5, "normal");
            }
            this.mElement = element = builder.create();
            RenderScript renderScript6 = this.mRS;
            Builder builder2 = new Builder(renderScript6);
            Element element6 = this.mElement;
            int n3 = this.mVtxCount / n;
            int n4 = builder2.addVertexType(element6, n3);
            Element element7 = Element.createIndex(this.mRS);
            int n5 = this.mIndexCount;
            builder2.setIndexType(element7, n5);
            Primitive primitive = Primitive.TRIANGLE;
            builder2.setPrimitive(primitive);
            SimpleMesh simpleMesh = builder2.create();
            Allocation allocation = simpleMesh.createVertexAllocation(0);
            Allocation allocation2 = simpleMesh.createIndexAllocation();
            simpleMesh.bindVertexAllocation(allocation, 0);
            simpleMesh.bindIndexAllocation(allocation2);
            float[] fArray = this.mVtxData;
            allocation.data(fArray);
            allocation.uploadToBufferObject();
            short[] sArray = this.mIndexData;
            allocation2.data(sArray);
            allocation2.uploadToBufferObject();
            return simpleMesh;
        }

        public void setColor(float f, float f2, float f3, float f4) {
            if ((this.mFlags & 1) == 0) {
                throw new IllegalStateException("add mistmatch with declared components.");
            }
            this.mR = f;
            this.mG = f2;
            this.mB = f3;
            this.mA = f4;
        }

        public void setNormal(float f, float f2, float f3) {
            if ((this.mFlags & 2) == 0) {
                throw new IllegalStateException("add mistmatch with declared components.");
            }
            this.mNX = f;
            this.mNY = f2;
            this.mNZ = f3;
        }

        public void setTexture(float f, float f2) {
            if ((this.mFlags & 0x100) == 0) {
                throw new IllegalStateException("add mistmatch with declared components.");
            }
            this.mS0 = f;
            this.mT0 = f2;
        }
    }

    public static class Builder {
        Entry mIndexType;
        Primitive mPrimitive;
        RenderScript mRS;
        int mVertexTypeCount;
        Entry[] mVertexTypes;

        public Builder(RenderScript renderScript) {
            Entry entry;
            this.mRS = renderScript;
            this.mVertexTypeCount = 0;
            Entry[] entryArray = new Entry[16];
            this.mVertexTypes = entryArray;
            this.mIndexType = entry = new Entry();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static SimpleMesh internalCreate(RenderScript renderScript, Builder builder) {
            synchronized (Builder.class) {
                int n;
                int n2;
                Object var2_2 = null;
                Type[] typeArray = new Type[18];
                int n3 = 0;
                int n4 = 0;
                if (builder.mIndexType.t != null) {
                    n4 = builder.mIndexType.t.mID;
                } else if (builder.mIndexType.size != 0) {
                    Type type;
                    Type type2;
                    Entry entry = builder.mIndexType;
                    Element element = builder.mIndexType.e;
                    int n5 = builder.mIndexType.size;
                    entry.t = type2 = builder.newType(element, n5);
                    n4 = builder.mIndexType.t.mID;
                    int n6 = n3 + 1;
                    typeArray[n3] = type = builder.mIndexType.t;
                    n3 = n6;
                }
                int[] nArray = new int[builder.mVertexTypeCount];
                int n7 = n3;
                for (n2 = 0; n2 < (n = builder.mVertexTypeCount); ++n2) {
                    if (builder.mVertexTypes[n2].t != null) {
                        int n8;
                        nArray[n2] = n8 = builder.mVertexTypes[n2].t.mID;
                        n3 = n7;
                    } else {
                        Type type;
                        int n9;
                        Type type3;
                        Entry entry = builder.mVertexTypes[n2];
                        Element element = builder.mVertexTypes[n2].e;
                        int n10 = builder.mVertexTypes[n2].size;
                        entry.t = type3 = builder.newType(element, n10);
                        nArray[n2] = n9 = builder.mVertexTypes[n2].t.mID;
                        n3 = n7 + 1;
                        typeArray[n7] = type = builder.mVertexTypes[n2].t;
                    }
                    n7 = n3;
                }
                int n11 = 0;
                int n12 = builder.mPrimitive.mID;
                int n13 = renderScript.nSimpleMeshCreate(n11, n4, nArray, n12);
                n2 = 0;
                while (n2 < n7) {
                    typeArray[n2].destroy();
                    ++n2;
                }
                return new SimpleMesh(n13, renderScript);
            }
        }

        public int addVertexType(Element element, int n) throws IllegalStateException {
            int n2;
            Entry entry;
            int n3 = this.mVertexTypeCount;
            int n4 = this.mVertexTypes.length;
            if (n3 >= n4) {
                throw new IllegalStateException("Max vertex types exceeded.");
            }
            int n5 = this.mVertexTypeCount;
            Entry[] entryArray = this.mVertexTypes;
            int n6 = this.mVertexTypeCount;
            entryArray[n6] = entry = new Entry();
            Entry[] entryArray2 = this.mVertexTypes;
            int n7 = this.mVertexTypeCount;
            entryArray2[n7].e = element;
            Entry[] entryArray3 = this.mVertexTypes;
            int n8 = this.mVertexTypeCount;
            entryArray3[n8].size = n;
            this.mVertexTypeCount = n2 = this.mVertexTypeCount + 1;
            return n5;
        }

        public int addVertexType(Type type) throws IllegalStateException {
            int n;
            Entry entry;
            int n2 = this.mVertexTypeCount;
            int n3 = this.mVertexTypes.length;
            if (n2 >= n3) {
                throw new IllegalStateException("Max vertex types exceeded.");
            }
            int n4 = this.mVertexTypeCount;
            Entry[] entryArray = this.mVertexTypes;
            int n5 = this.mVertexTypeCount;
            entryArray[n5] = entry = new Entry();
            Entry[] entryArray2 = this.mVertexTypes;
            int n6 = this.mVertexTypeCount;
            entryArray2[n6].t = type;
            this.mVertexTypeCount = n = this.mVertexTypeCount + 1;
            return n4;
        }

        public SimpleMesh create() {
            Primitive primitive;
            Type type;
            int n;
            this.mRS.validate();
            SimpleMesh simpleMesh = Builder.internalCreate(this.mRS, this);
            Type[] typeArray = new Type[this.mVertexTypeCount];
            simpleMesh.mVertexTypes = typeArray;
            for (int i = 0; i < (n = this.mVertexTypeCount); ++i) {
                Type type2;
                Type[] typeArray2 = simpleMesh.mVertexTypes;
                typeArray2[i] = type2 = this.mVertexTypes[i].t;
            }
            simpleMesh.mIndexType = type = this.mIndexType.t;
            simpleMesh.mPrimitive = primitive = this.mPrimitive;
            return simpleMesh;
        }

        Type newType(Element element, int n) {
            RenderScript renderScript = this.mRS;
            Type.Builder builder = new Type.Builder(renderScript, element);
            Dimension dimension = Dimension.X;
            builder.add(dimension, n);
            return builder.create();
        }

        public void setIndexType(Element element, int n) {
            this.mIndexType.t = null;
            this.mIndexType.e = element;
            this.mIndexType.size = n;
        }

        public void setIndexType(Type type) {
            this.mIndexType.t = type;
            this.mIndexType.e = null;
            this.mIndexType.size = 0;
        }

        public void setPrimitive(Primitive primitive) {
            this.mPrimitive = primitive;
        }

        class Entry {
            Element e;
            int size;
            Type t;

            Entry() {
            }
        }
    }
}

