/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.Dimension;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import java.lang.reflect.Field;

public class Type
extends BaseObj {
    boolean mDimFaces;
    boolean mDimLOD;
    int mDimX;
    int mDimY;
    int mDimZ;
    Element mElement;
    int mElementCount;
    Class mJavaClass;
    private int mNativeCache;

    Type(int n, RenderScript renderScript) {
        super(renderScript);
        this.mID = n;
        this.mNativeCache = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Type createFromClass(RenderScript renderScript, Class clazz, int n) {
        Element element = Element.createFromClass(renderScript, clazz);
        Builder builder = new Builder(renderScript, element);
        Dimension dimension = Dimension.X;
        builder.add(dimension, n);
        Type type = builder.create();
        element.destroy();
        Field[] fieldArray = clazz.getFields();
        int[] nArray = new int[fieldArray.length];
        int[] nArray2 = new int[fieldArray.length];
        int n2 = 0;
        while (true) {
            Class<Integer> clazz2;
            int n3;
            if (n2 >= (n3 = fieldArray.length)) {
                renderScript.nTypeSetupFields(type, nArray, nArray2, fieldArray);
                type.mJavaClass = clazz;
                return type;
            }
            Class<?> clazz3 = fieldArray[n2].getType();
            if (clazz3 == (clazz2 = Integer.TYPE)) {
                int n4;
                nArray[n2] = n4 = Element.DataType.SIGNED_32.mID;
                nArray2[n2] = 32;
            } else {
                Class<Short> clazz4 = Short.TYPE;
                if (clazz3 == clazz4) {
                    int n5;
                    nArray[n2] = n5 = Element.DataType.SIGNED_16.mID;
                    nArray2[n2] = 16;
                } else {
                    Class<Byte> clazz5 = Byte.TYPE;
                    if (clazz3 == clazz5) {
                        int n6;
                        nArray[n2] = n6 = Element.DataType.SIGNED_8.mID;
                        nArray2[n2] = 8;
                    } else {
                        int n7;
                        Class<Float> clazz6 = Float.TYPE;
                        if (clazz3 != clazz6) {
                            throw new IllegalArgumentException("Unkown field type");
                        }
                        nArray[n2] = n7 = Element.DataType.FLOAT_32.mID;
                        nArray2[n2] = 32;
                    }
                }
            }
            ++n2;
        }
    }

    public static Type createFromClass(RenderScript renderScript, Class clazz, int n, String string2) {
        Type type = Type.createFromClass(renderScript, clazz, n);
        type.setName(string2);
        return type;
    }

    void calcElementCount() {
        boolean bl = this.getLOD();
        int n = this.getX();
        int n2 = this.getY();
        int n3 = this.getZ();
        int n4 = 1;
        if (this.getFaces()) {
            n4 = 6;
        }
        if (n == 0) {
            n = 1;
        }
        if (n2 == 0) {
            n2 = 1;
        }
        if (n3 == 0) {
            n3 = 1;
        }
        int n5 = n * n2 * n3 * n4;
        if (bl && n > 1 && n2 > 1 && n3 > 1) {
            if (n > 1) {
                n >>= 1;
            }
            if (n2 > 1) {
                n2 >>= 1;
            }
            if (n3 > 1) {
                n3 >>= 1;
            }
            int n6 = n * n2 * n3 * n4;
            n5 += n6;
        }
        this.mElementCount = n5;
    }

    @Override
    protected void finalize() throws Throwable {
        if (this.mNativeCache != 0) {
            this.mRS.nTypeFinalDestroy(this);
            this.mNativeCache = 0;
        }
        super.finalize();
    }

    public Element getElement() {
        return this.mElement;
    }

    public int getElementCount() {
        return this.mElementCount;
    }

    public boolean getFaces() {
        return this.mDimFaces;
    }

    public boolean getLOD() {
        return this.mDimLOD;
    }

    public int getX() {
        return this.mDimX;
    }

    public int getY() {
        return this.mDimY;
    }

    public int getZ() {
        return this.mDimZ;
    }

    public static class Builder {
        Element mElement;
        Entry[] mEntries;
        int mEntryCount;
        RenderScript mRS;

        public Builder(RenderScript renderScript, Element element) {
            if (element.mID == 0) {
                throw new IllegalArgumentException("Invalid element.");
            }
            this.mRS = renderScript;
            Entry[] entryArray = new Entry[4];
            this.mEntries = entryArray;
            this.mElement = element;
        }

        static Type internalCreate(RenderScript renderScript, Builder builder) {
            synchronized (Builder.class) {
                int n;
                int n2 = builder.mElement.mID;
                renderScript.nTypeBegin(n2);
                for (int i = 0; i < (n = builder.mEntryCount); ++i) {
                    Entry entry = builder.mEntries[i];
                    int n3 = entry.mDim.mID;
                    int n4 = entry.mValue;
                    renderScript.nTypeAdd(n3, n4);
                }
                int n5 = renderScript.nTypeCreate();
                Type type = new Type(n5, renderScript);
                return type;
            }
        }

        public void add(Dimension dimension, int n) {
            int n2;
            Entry entry;
            if (n < 1) {
                throw new IllegalArgumentException("Values of less than 1 for Dimensions are not valid.");
            }
            int n3 = this.mEntries.length;
            int n4 = this.mEntryCount;
            if (n3 >= n4) {
                Entry[] entryArray = new Entry[this.mEntryCount + 8];
                Entry[] entryArray2 = this.mEntries;
                int n5 = this.mEntries.length;
                System.arraycopy(entryArray2, 0, entryArray, 0, n5);
                this.mEntries = entryArray;
            }
            Entry[] entryArray = this.mEntries;
            int n6 = this.mEntryCount;
            entryArray[n6] = entry = new Entry();
            Entry[] entryArray3 = this.mEntries;
            int n7 = this.mEntryCount;
            entryArray3[n7].mDim = dimension;
            Entry[] entryArray4 = this.mEntries;
            int n8 = this.mEntryCount;
            entryArray4[n8].mValue = n;
            this.mEntryCount = n2 = this.mEntryCount + 1;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Type create() {
            Element element;
            Type type = Builder.internalCreate(this.mRS, this);
            type.mElement = element = this.mElement;
            int n = 0;
            while (true) {
                Dimension dimension;
                Dimension dimension2;
                Dimension dimension3;
                Dimension dimension4;
                Dimension dimension5;
                Dimension dimension6;
                Dimension dimension7;
                Dimension dimension8;
                int n2;
                if (n >= (n2 = this.mEntryCount)) {
                    type.calcElementCount();
                    return type;
                }
                Dimension dimension9 = this.mEntries[n].mDim;
                Dimension dimension10 = Dimension.X;
                if (dimension9 == dimension10) {
                    int n3;
                    type.mDimX = n3 = this.mEntries[n].mValue;
                }
                if ((dimension8 = this.mEntries[n].mDim) == (dimension7 = Dimension.Y)) {
                    int n4;
                    type.mDimY = n4 = this.mEntries[n].mValue;
                }
                if ((dimension6 = this.mEntries[n].mDim) == (dimension5 = Dimension.Z)) {
                    int n5;
                    type.mDimZ = n5 = this.mEntries[n].mValue;
                }
                if ((dimension4 = this.mEntries[n].mDim) == (dimension3 = Dimension.LOD)) {
                    boolean bl = this.mEntries[n].mValue != 0;
                    type.mDimLOD = bl;
                }
                if ((dimension2 = this.mEntries[n].mDim) == (dimension = Dimension.FACE)) {
                    boolean bl = this.mEntries[n].mValue != 0;
                    type.mDimFaces = bl;
                }
                ++n;
            }
        }

        class Entry {
            Dimension mDim;
            int mValue;

            Entry() {
            }
        }
    }
}

