/*
 * Decompiled with CFR 0.152.
 */
package android.sax;

import android.sax.BadXmlException;
import android.sax.Children;
import android.sax.ElementListener;
import android.sax.EndElementListener;
import android.sax.EndTextElementListener;
import android.sax.StartElementListener;
import android.sax.TextElementListener;
import java.util.ArrayList;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public class Element {
    Children children;
    final int depth;
    EndElementListener endElementListener;
    EndTextElementListener endTextElementListener;
    final String localName;
    final Element parent;
    ArrayList<Element> requiredChilden;
    StartElementListener startElementListener;
    final String uri;
    boolean visited;

    Element(Element element, String string2, String string3, int n) {
        this.parent = element;
        this.uri = string2;
        this.localName = string3;
        this.depth = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String toString(String string2, String string3) {
        String string4;
        StringBuilder stringBuilder = new StringBuilder().append("'");
        if (string2.equals("")) {
            string4 = string3;
            return stringBuilder.append(string4).append("'").toString();
        }
        string4 = string2 + ":" + string3;
        return stringBuilder.append(string4).append("'").toString();
    }

    void checkRequiredChildren(Locator locator) throws SAXParseException {
        ArrayList<Element> arrayList = this.requiredChilden;
        if (arrayList == null) {
            return;
        }
        int n = arrayList.size() - 1;
        while (n >= 0) {
            Element element = arrayList.get(n);
            if (!element.visited) {
                String string2 = "Element named " + this + " is missing required" + " child element named " + element + ".";
                throw new BadXmlException(string2, locator);
            }
            n += -1;
        }
        return;
    }

    public Element getChild(String string2) {
        return this.getChild("", string2);
    }

    public Element getChild(String string2, String string3) {
        if (this.endTextElementListener != null) {
            throw new IllegalStateException("This element already has an end text element listener. It cannot have children.");
        }
        if (this.children == null) {
            Children children;
            this.children = children = new Children();
        }
        return this.children.getOrCreate(this, string2, string3);
    }

    public Element requireChild(String string2) {
        return this.requireChild("", string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Element requireChild(String string2, String string3) {
        Element element = this.getChild(string2, string3);
        if (this.requiredChilden == null) {
            ArrayList arrayList = new ArrayList();
            this.requiredChilden = arrayList;
            boolean bl = this.requiredChilden.add(element);
            return element;
        }
        if (this.requiredChilden.contains(element)) return element;
        boolean bl = this.requiredChilden.add(element);
        return element;
    }

    void resetRequiredChildren() {
        ArrayList<Element> arrayList = this.requiredChilden;
        if (arrayList == null) {
            return;
        }
        int n = arrayList.size() - 1;
        while (n >= 0) {
            arrayList.get((int)n).visited = false;
            n += -1;
        }
        return;
    }

    public void setElementListener(ElementListener elementListener) {
        this.setStartElementListener(elementListener);
        this.setEndElementListener(elementListener);
    }

    public void setEndElementListener(EndElementListener endElementListener) {
        if (this.endElementListener != null) {
            throw new IllegalStateException("End element listener has already been set.");
        }
        this.endElementListener = endElementListener;
    }

    public void setEndTextElementListener(EndTextElementListener endTextElementListener) {
        if (this.endTextElementListener != null) {
            throw new IllegalStateException("End text element listener has already been set.");
        }
        if (this.children != null) {
            throw new IllegalStateException("This element already has children. It cannot have an end text element listener.");
        }
        this.endTextElementListener = endTextElementListener;
    }

    public void setStartElementListener(StartElementListener startElementListener) {
        if (this.startElementListener != null) {
            throw new IllegalStateException("Start element listener has already been set.");
        }
        this.startElementListener = startElementListener;
    }

    public void setTextElementListener(TextElementListener textElementListener) {
        this.setStartElementListener(textElementListener);
        this.setEndTextElementListener(textElementListener);
    }

    public String toString() {
        String string2 = this.uri;
        String string3 = this.localName;
        return Element.toString(string2, string3);
    }
}

