/*
 * Decompiled with CFR 0.152.
 */
package android.sax;

import android.sax.BadXmlException;
import android.sax.Children;
import android.sax.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RootElement
extends Element {
    final Handler handler;

    public RootElement(String string2) {
        this("", string2);
    }

    public RootElement(String string2, String string3) {
        super(null, string2, string3, 0);
        Handler handler;
        this.handler = handler = new Handler();
    }

    public ContentHandler getContentHandler() {
        return this.handler;
    }

    class Handler
    extends DefaultHandler {
        StringBuilder bodyBuilder = null;
        Element current = null;
        int depth = -1;
        Locator locator;

        Handler() {
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.bodyBuilder == null) {
                return;
            }
            StringBuilder stringBuilder = this.bodyBuilder.append(cArray, n, n2);
        }

        @Override
        public void endElement(String string2, String string3, String string4) throws SAXException {
            int n;
            Element element = this.current;
            int n2 = this.depth;
            int n3 = element.depth;
            if (n2 != n3) {
                Element element2;
                Locator locator = this.locator;
                element.checkRequiredChildren(locator);
                if (element.endElementListener != null) {
                    element.endElementListener.end();
                }
                if (this.bodyBuilder != null) {
                    String string5 = this.bodyBuilder.toString();
                    this.bodyBuilder = null;
                    element.endTextElementListener.end(string5);
                }
                this.current = element2 = element.parent;
            }
            this.depth = n = this.depth - 1;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        void start(Element element, Attributes attributes) {
            this.current = element;
            if (element.startElementListener != null) {
                element.startElementListener.start(attributes);
            }
            if (element.endTextElementListener != null) {
                StringBuilder stringBuilder;
                this.bodyBuilder = stringBuilder = new StringBuilder();
            }
            element.resetRequiredChildren();
            element.visited = true;
        }

        @Override
        public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
            int n;
            this.depth = n = this.depth + 1;
            if (n == 0) {
                this.startRoot(string2, string3, attributes);
                return;
            }
            if (this.bodyBuilder != null) {
                StringBuilder stringBuilder = new StringBuilder().append("Encountered mixed content within text element named ");
                Element element = this.current;
                String string5 = stringBuilder.append(element).append(".").toString();
                Locator locator = this.locator;
                throw new BadXmlException(string5, locator);
            }
            int n2 = this.current.depth + 1;
            if (n != n2) {
                return;
            }
            Children children = this.current.children;
            if (children == null) {
                return;
            }
            Element element = children.get(string2, string3);
            if (element == null) {
                return;
            }
            this.start(element, attributes);
        }

        void startRoot(String string2, String string3, Attributes attributes) throws SAXException {
            RootElement rootElement = RootElement.this;
            if (rootElement.uri.compareTo(string2) != 0 || rootElement.localName.compareTo(string3) != 0) {
                StringBuilder stringBuilder = new StringBuilder().append("Root element name does not match. Expected: ").append(rootElement).append(", Got: ");
                String string4 = Element.toString(string2, string3);
                String string5 = stringBuilder.append(string4).toString();
                Locator locator = this.locator;
                throw new BadXmlException(string5, locator);
            }
            this.start(rootElement, attributes);
        }
    }
}

