/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import java.security.KeyPair;

public class Credentials {
    public static final String CA_CERTIFICATE = "CACERT_";
    public static final String CERTIFICATE = "CERT";
    public static final String INSTALL_ACTION = "android.credentials.INSTALL";
    private static final String LOGTAG = "Credentials";
    public static final String PKCS12 = "PKCS12";
    public static final String PRIVATE_KEY = "PKEY";
    public static final String PUBLIC_KEY = "KEY";
    public static final String SYSTEM_INSTALL_ACTION = "android.credentials.SYSTEM_INSTALL";
    public static final String UNLOCK_ACTION = "android.credentials.UNLOCK";
    public static final String USER_CERTIFICATE = "USRCERT_";
    public static final String USER_PRIVATE_KEY = "USRPKEY_";
    public static final String VPN = "VPN_";
    public static final String WIFI = "WIFI_";
    private static Credentials singleton;

    private Intent createInstallIntent() {
        Intent intent = new Intent(INSTALL_ACTION);
        Intent intent2 = intent.setClassName("com.android.certinstaller", "com.android.certinstaller.CertInstallerMain");
        return intent;
    }

    public static Credentials getInstance() {
        if (singleton == null) {
            singleton = new Credentials();
        }
        return singleton;
    }

    public void install(Context context, String string2, byte[] byArray) {
        try {
            Intent intent = this.createInstallIntent();
            Intent intent2 = intent.putExtra(string2, byArray);
            context.startActivity(intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            String string3 = activityNotFoundException.toString();
            int n = Log.w(LOGTAG, string3);
            return;
        }
    }

    public void install(Context context, KeyPair keyPair) {
        try {
            Intent intent = this.createInstallIntent();
            byte[] byArray = keyPair.getPrivate().getEncoded();
            Intent intent2 = intent.putExtra(PRIVATE_KEY, byArray);
            byte[] byArray2 = keyPair.getPublic().getEncoded();
            Intent intent3 = intent.putExtra(PUBLIC_KEY, byArray2);
            context.startActivity(intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            String string2 = activityNotFoundException.toString();
            int n = Log.w(LOGTAG, string2);
            return;
        }
    }

    public void installFromSdCard(Context context) {
        try {
            Intent intent = this.createInstallIntent();
            context.startActivity(intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            String string2 = activityNotFoundException.toString();
            int n = Log.w(LOGTAG, string2);
            return;
        }
    }

    public void unlock(Context context) {
        try {
            Intent intent = new Intent(UNLOCK_ACTION);
            context.startActivity(intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            String string2 = activityNotFoundException.toString();
            int n = Log.w(LOGTAG, string2);
            return;
        }
    }
}

