/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.os.Environment;
import android.os.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.KeyGenerator;
import org.apache.harmony.luni.util.InputStreamHelper;

public class SystemKeyStore {
    private static final String KEY_FILE_EXTENSION = ".sks";
    private static final String SYSTEM_KEYSTORE_DIRECTORY = "misc/systemkeys";
    private static SystemKeyStore mInstance = new SystemKeyStore();

    private SystemKeyStore() {
    }

    public static SystemKeyStore getInstance() {
        return mInstance;
    }

    private File getKeyFile(String string2) {
        File file = Environment.getDataDirectory();
        File file2 = new File(file, SYSTEM_KEYSTORE_DIRECTORY);
        String string3 = string2 + KEY_FILE_EXTENSION;
        return new File(file2, string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String toHexString(byte[] byArray) {
        int n;
        if (byArray == null) {
            return null;
        }
        int n2 = byArray.length;
        int n3 = byArray.length * 2;
        StringBuilder stringBuilder = new StringBuilder(n3);
        int n4 = 0;
        while (n4 < (n = byArray.length)) {
            String string2 = Integer.toString(byArray[n4] & 0xFF, 16);
            if (string2.length() == 1) {
                string2 = "0" + string2;
            }
            StringBuilder stringBuilder2 = stringBuilder.append(string2);
            ++n4;
        }
        return stringBuilder.toString();
    }

    public void deleteKey(String string2) {
        File file = this.getKeyFile(string2);
        if (!file.exists()) {
            throw new IllegalArgumentException();
        }
        boolean bl = file.delete();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] generateNewKey(int n, String string2, String string3) throws NoSuchAlgorithmException {
        File file = this.getKeyFile(string3);
        if (file.exists()) {
            throw new IllegalArgumentException();
        }
        KeyGenerator keyGenerator = KeyGenerator.getInstance(string2);
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        keyGenerator.init(n, secureRandom);
        byte[] byArray = keyGenerator.generateKey().getEncoded();
        try {
            if (!file.createNewFile()) {
                throw new IllegalArgumentException();
            }
        }
        catch (IOException iOException) {
            return null;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        fileOutputStream.flush();
        boolean bl = FileUtils.sync(fileOutputStream);
        fileOutputStream.close();
        int n2 = FileUtils.setPermissions(file.getName(), 384, -1, -1);
        return byArray;
    }

    public String generateNewKeyHexString(int n, String string2, String string3) throws NoSuchAlgorithmException {
        return SystemKeyStore.toHexString(this.generateNewKey(n, string2, string3));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] retrieveKey(String string2) throws IOException {
        File file = this.getKeyFile(string2);
        if (file.exists()) return InputStreamHelper.readFullyAndClose((InputStream)new FileInputStream(file));
        return null;
    }

    public String retrieveKeyHexString(String string2) throws IOException {
        return SystemKeyStore.toHexString(this.retrieveKey(string2));
    }
}

