/*
 * Decompiled with CFR 0.152.
 */
package android.server;

import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothUuid;
import android.bluetooth.IBluetoothA2dp;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.ParcelUuid;
import android.provider.Settings;
import android.server.BluetoothService;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class BluetoothA2dpService
extends IBluetoothA2dp.Stub {
    public static final String BLUETOOTH_A2DP_SERVICE = "bluetooth_a2dp";
    private static final String BLUETOOTH_ADMIN_PERM = "android.permission.BLUETOOTH_ADMIN";
    private static final String BLUETOOTH_ENABLED = "bluetooth_enabled";
    private static final String BLUETOOTH_PERM = "android.permission.BLUETOOTH";
    private static final boolean DBG = true;
    private static final String PROPERTY_STATE = "State";
    private static final String SINK_STATE_CONNECTED = "connected";
    private static final String SINK_STATE_CONNECTING = "connecting";
    private static final String SINK_STATE_DISCONNECTED = "disconnected";
    private static final String SINK_STATE_PLAYING = "playing";
    private static final String TAG = "BluetoothA2dpService";
    private static int mSinkCount;
    private final BluetoothAdapter mAdapter;
    private HashMap<BluetoothDevice, Integer> mAudioDevices;
    private final AudioManager mAudioManager;
    private final BluetoothService mBluetoothService;
    private final Context mContext;
    private final IntentFilter mIntentFilter;
    private final BroadcastReceiver mReceiver;
    private int mTargetA2dpState;

    public BluetoothA2dpService(Context context, BluetoothService bluetoothService) {
        IntentFilter intentFilter;
        BluetoothAdapter bluetoothAdapter;
        AudioManager audioManager;
        BroadcastReceiver broadcastReceiver;
        this.mReceiver = broadcastReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                String string2 = intent.getAction();
                BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (string2.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                    switch (intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE)) {
                        default: {
                            return;
                        }
                        case 12: {
                            BluetoothA2dpService.this.onBluetoothEnable();
                            return;
                        }
                        case 13: 
                    }
                    BluetoothA2dpService.this.onBluetoothDisable();
                    return;
                }
                if (string2.equals("android.bluetooth.device.action.BOND_STATE_CHANGED")) {
                    switch (intent.getIntExtra("android.bluetooth.device.extra.BOND_STATE", Integer.MIN_VALUE)) {
                        default: {
                            return;
                        }
                        case 10: {
                            boolean bl = BluetoothA2dpService.this.setSinkPriority(bluetoothDevice, -1);
                            return;
                        }
                        case 12: 
                    }
                    if (BluetoothA2dpService.this.getSinkPriority(bluetoothDevice) != -1) {
                        return;
                    }
                    boolean bl = BluetoothA2dpService.this.setSinkPriority(bluetoothDevice, 100);
                    return;
                }
                if (string2.equals("android.bluetooth.device.action.ACL_DISCONNECTED")) {
                    synchronized (this) {
                        if (BluetoothA2dpService.this.mAudioDevices.containsKey(bluetoothDevice)) {
                            int n = (Integer)BluetoothA2dpService.this.mAudioDevices.get(bluetoothDevice);
                            BluetoothA2dpService.this.handleSinkStateChange(bluetoothDevice, n, 0);
                        }
                        return;
                    }
                }
                if (!string2.equals("android.media.VOLUME_CHANGED_ACTION")) {
                    return;
                }
                if (intent.getIntExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", -1) != 3) {
                    return;
                }
                BluetoothDevice[] bluetoothDeviceArray = BluetoothA2dpService.this.getConnectedSinks();
                if (bluetoothDeviceArray.length == 0) {
                    return;
                }
                BluetoothA2dpService bluetoothA2dpService = BluetoothA2dpService.this;
                BluetoothDevice bluetoothDevice2 = bluetoothDeviceArray[0];
                if (!bluetoothA2dpService.isPhoneDocked(bluetoothDevice2)) {
                    return;
                }
                String string3 = bluetoothDeviceArray[0].getAddress();
                int n = intent.getIntExtra("android.media.EXTRA_VOLUME_STREAM_VALUE", 0);
                int n2 = intent.getIntExtra("android.media.EXTRA_PREV_VOLUME_STREAM_VALUE", 0);
                String string4 = BluetoothA2dpService.this.mBluetoothService.getObjectPathFromAddress(string3);
                if (n > n2) {
                    boolean bl = BluetoothA2dpService.this.avrcpVolumeUpNative(string4);
                    return;
                }
                if (n >= n2) {
                    return;
                }
                boolean bl = BluetoothA2dpService.this.avrcpVolumeDownNative(string4);
            }
        };
        this.mContext = context;
        this.mAudioManager = audioManager = (AudioManager)context.getSystemService("audio");
        this.mBluetoothService = bluetoothService;
        if (this.mBluetoothService == null) {
            throw new RuntimeException("Platform does not support Bluetooth");
        }
        if (!this.initNative()) {
            throw new RuntimeException("Could not init BluetoothA2dpService");
        }
        this.mAdapter = bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mIntentFilter = intentFilter = new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED");
        this.mIntentFilter.addAction("android.bluetooth.device.action.BOND_STATE_CHANGED");
        this.mIntentFilter.addAction("android.bluetooth.device.action.ACL_CONNECTED");
        this.mIntentFilter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
        this.mIntentFilter.addAction("android.media.VOLUME_CHANGED_ACTION");
        Context context2 = this.mContext;
        BroadcastReceiver broadcastReceiver2 = this.mReceiver;
        IntentFilter intentFilter2 = this.mIntentFilter;
        Intent intent = context2.registerReceiver(broadcastReceiver2, intentFilter2);
        HashMap hashMap = new HashMap();
        this.mAudioDevices = hashMap;
        if (this.mBluetoothService.isEnabled()) {
            this.onBluetoothEnable();
        }
        this.mTargetA2dpState = -1;
        this.mBluetoothService.setA2dpService(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean addAudioSink(BluetoothDevice bluetoothDevice) {
        synchronized (this) {
            String[] stringArray;
            block7: {
                BluetoothService bluetoothService = this.mBluetoothService;
                String string2 = bluetoothDevice.getAddress();
                String string3 = bluetoothService.getObjectPathFromAddress(string2);
                stringArray = (String[])this.getSinkPropertiesNative(string3);
                if (stringArray != null) break block7;
                String string4 = "Error while getting AudioSink properties for device: " + bluetoothDevice;
                int n = Log.e(TAG, string4);
                return false;
            }
            Integer n = null;
            int n2 = 0;
            while (true) {
                block9: {
                    block8: {
                        int n3 = stringArray.length;
                        if (n2 >= n3) break block8;
                        if (!stringArray[n2].equals(PROPERTY_STATE)) break block9;
                        int n4 = n2 + 1;
                        String string5 = stringArray[n4];
                        int n5 = this.convertBluezSinkStringtoState(string5);
                        n = new Integer(n5);
                    }
                    Object var15_15 = this.mAudioDevices.put(bluetoothDevice, n);
                    int n6 = n;
                    this.handleSinkStateChange(bluetoothDevice, 0, n6);
                    return true;
                }
                n2 += 2;
                continue;
                break;
            }
        }
    }

    private void adjustOtherSinkPriorities(BluetoothDevice bluetoothDevice) {
        Iterator<BluetoothDevice> iterator = this.mAdapter.getBondedDevices().iterator();
        while (iterator.hasNext()) {
            BluetoothDevice bluetoothDevice2 = iterator.next();
            if (this.getSinkPriority(bluetoothDevice2) < 1000 || bluetoothDevice2.equals(bluetoothDevice)) continue;
            boolean bl = this.setSinkPriority(bluetoothDevice2, 100);
        }
        return;
    }

    private synchronized native boolean avrcpVolumeDownNative(String var1);

    private synchronized native boolean avrcpVolumeUpNative(String var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkSinkSuspendState(int n) {
        boolean bl = true;
        int n2 = this.mTargetA2dpState;
        if (n == n2) return bl;
        if (n == 4 && this.mTargetA2dpState == 2) {
            this.mAudioManager.setParameters("A2dpSuspended=true");
            return bl;
        }
        if (n != 2) return false;
        if (this.mTargetA2dpState != 4) return false;
        this.mAudioManager.setParameters("A2dpSuspended=false");
        return bl;
    }

    private native void cleanupNative();

    private synchronized native boolean connectSinkNative(String var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int convertBluezSinkStringtoState(String string2) {
        if (string2.equalsIgnoreCase(SINK_STATE_DISCONNECTED)) {
            return 0;
        }
        if (string2.equalsIgnoreCase(SINK_STATE_CONNECTING)) {
            return 1;
        }
        if (string2.equalsIgnoreCase(SINK_STATE_CONNECTED)) {
            return 2;
        }
        if (!string2.equalsIgnoreCase(SINK_STATE_PLAYING)) return -1;
        return 4;
    }

    private synchronized native boolean disconnectSinkNative(String var1);

    private synchronized native Object[] getSinkPropertiesNative(String var1);

    /*
     * Enabled aggressive block sorting
     */
    private void handleSinkStateChange(BluetoothDevice bluetoothDevice, int n, int n2) {
        if (n2 != n) {
            return;
        }
        if (n2 == 0 || n2 == 3) {
            --mSinkCount;
        } else if (n2 == 2) {
            ++mSinkCount;
        }
        HashMap<BluetoothDevice, Integer> hashMap = this.mAudioDevices;
        Integer n3 = n2;
        Integer n4 = hashMap.put(bluetoothDevice, n3);
        boolean bl = this.checkSinkSuspendState(n2);
        this.mTargetA2dpState = -1;
        if (this.getSinkPriority(bluetoothDevice) > 0 && n2 == 2) {
            boolean bl2 = this.setSinkPriority(bluetoothDevice, 1000);
            this.adjustOtherSinkPriorities(bluetoothDevice);
        }
        Intent intent = new Intent("android.bluetooth.a2dp.action.SINK_STATE_CHANGED");
        Intent intent2 = intent.putExtra("android.bluetooth.device.extra.DEVICE", bluetoothDevice);
        Intent intent3 = intent.putExtra("android.bluetooth.a2dp.extra.PREVIOUS_SINK_STATE", n);
        Intent intent4 = intent.putExtra("android.bluetooth.a2dp.extra.SINK_STATE", n2);
        this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
        BluetoothA2dpService.log("A2DP state : device: " + bluetoothDevice + " State:" + n + "->" + n2);
    }

    private native boolean initNative();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isConnectSinkFeasible(BluetoothDevice bluetoothDevice) {
        synchronized (this) {
            block5: {
                if (!this.mBluetoothService.isEnabled()) return false;
                if (!this.isSinkDevice(bluetoothDevice)) return false;
                int n = this.getSinkPriority(bluetoothDevice);
                if (n != null) break block5;
                return false;
            }
            if (this.mAudioDevices.get(bluetoothDevice) == null && !this.addAudioSink(bluetoothDevice)) {
                return false;
            }
            BluetoothService bluetoothService = this.mBluetoothService;
            String string2 = bluetoothDevice.getAddress();
            String string3 = bluetoothService.getObjectPathFromAddress(string2);
            if (string3 != null) return true;
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isDisconnectSinkFeasible(BluetoothDevice bluetoothDevice) {
        synchronized (this) {
            block8: {
                BluetoothService bluetoothService = this.mBluetoothService;
                String string2 = bluetoothDevice.getAddress();
                String string3 = bluetoothService.getObjectPathFromAddress(string2);
                if (string3 != false) break block8;
                return false;
            }
            int n = this.getSinkState(bluetoothDevice);
            switch (n) {
                default: {
                    return true;
                }
                case 0: {
                    return false;
                }
                case 3: 
            }
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isPhoneDocked(BluetoothDevice bluetoothDevice) {
        Context context = this.mContext;
        IntentFilter intentFilter = new IntentFilter("android.intent.action.DOCK_EVENT");
        Intent intent = context.registerReceiver(null, intentFilter);
        if (intent == null) return false;
        if (intent.getIntExtra("android.intent.extra.DOCK_STATE", 0) == 0) return false;
        BluetoothDevice bluetoothDevice2 = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
        if (bluetoothDevice2 == null) return false;
        if (!bluetoothDevice.equals(bluetoothDevice2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSinkDevice(BluetoothDevice bluetoothDevice) {
        BluetoothService bluetoothService = this.mBluetoothService;
        String string2 = bluetoothDevice.getAddress();
        ParcelUuid[] parcelUuidArray = bluetoothService.getRemoteUuids(string2);
        if (parcelUuidArray == null) return false;
        ParcelUuid parcelUuid = BluetoothUuid.AudioSink;
        if (!BluetoothUuid.isUuidPresent(parcelUuidArray, parcelUuid)) return false;
        return true;
    }

    private static void log(String string2) {
        int n = Log.d(TAG, string2);
    }

    /*
     * Unable to fully structure code
     */
    private Set<BluetoothDevice> lookupSinksMatchingStates(int[] var1_1) {
        synchronized (this) {
            block8: {
                var2_2 = new HashSet<BluetoothDevice>();
                var3_3 = this.mAudioDevices.isEmpty();
                if (!var3_3) break block8;
                return var2_2;
            }
            var4_4 = this.mAudioDevices.keySet().iterator();
            block5: while (true) {
                if (!var4_4.hasNext()) ** continue;
                var5_5 = var4_4.next();
                var6_6 = this.getSinkState(var5_5);
                var7_7 = var1_1;
                var8_8 = var7_7.length;
                var9_9 = 0;
lbl18:
                // 2 sources

                while (true) {
                    if (var9_9 >= var8_8) ** continue;
                    if (var7_7[var9_9] != var6_6) {
                        var10_10 = var2_2.add(var5_5);
                        continue block5;
                    }
                    break;
                }
                break;
            }
            ++var9_9;
            ** continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onBluetoothDisable() {
        synchronized (this) {
            if (!this.mAudioDevices.isEmpty()) {
                BluetoothDevice[] bluetoothDeviceArray = new BluetoothDevice[this.mAudioDevices.size()];
                block7: for (BluetoothDevice bluetoothDevice : this.mAudioDevices.keySet().toArray(bluetoothDeviceArray)) {
                    int n = this.getSinkState(bluetoothDevice);
                    switch (n) {
                        case 1: 
                        case 2: 
                        case 4: {
                            BluetoothService bluetoothService = this.mBluetoothService;
                            String string2 = bluetoothDevice.getAddress();
                            String string3 = bluetoothService.getObjectPathFromAddress(string2);
                            boolean bl = this.disconnectSinkNative(string3);
                            this.handleSinkStateChange(bluetoothDevice, n, 0);
                        }
                        default: {
                            continue block7;
                        }
                        case 3: {
                            int n2 = 3;
                            int n3 = 0;
                            this.handleSinkStateChange(bluetoothDevice, n2, n3);
                        }
                    }
                }
                this.mAudioDevices.clear();
            }
            this.mAudioManager.setParameters("bluetooth_enabled=false");
            return;
        }
    }

    private void onBluetoothEnable() {
        synchronized (this) {
            String string2 = this.mBluetoothService.getProperty("Devices");
            mSinkCount = 0;
            if (string2 != null) {
                for (String string3 : string2.split(",")) {
                    String string4 = this.mBluetoothService.getAddressFromObjectPath(string3);
                    BluetoothDevice bluetoothDevice = this.mAdapter.getRemoteDevice(string4);
                    ParcelUuid[] parcelUuidArray = this.mBluetoothService.getRemoteUuids(string4);
                    if (parcelUuidArray == null) continue;
                    ParcelUuid parcelUuid = BluetoothUuid.AudioSink;
                    ParcelUuid parcelUuid2 = BluetoothUuid.AdvAudioDist;
                    ParcelUuid[] parcelUuidArray2 = new ParcelUuid[]{parcelUuid, parcelUuid2};
                    if (!BluetoothUuid.containsAnyUuid(parcelUuidArray, parcelUuidArray2)) continue;
                    boolean bl = this.addAudioSink(bluetoothDevice);
                }
            }
            this.mAudioManager.setParameters("bluetooth_enabled=true");
            this.mAudioManager.setParameters("A2dpSuspended=false");
            return;
        }
    }

    private void onConnectSinkResult(String string2, boolean bl) {
        if (bl) {
            return;
        }
        if (string2 == null) {
            return;
        }
        String string3 = this.mBluetoothService.getAddressFromObjectPath(string2);
        if (string3 == null) {
            return;
        }
        BluetoothDevice bluetoothDevice = this.mAdapter.getRemoteDevice(string3);
        int n = this.getSinkState(bluetoothDevice);
        this.handleSinkStateChange(bluetoothDevice, n, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onSinkPropertyChanged(String string2, String[] stringArray) {
        synchronized (this) {
            boolean bl = this.mBluetoothService.isEnabled();
            if (bl) {
                int n = 0;
                String string3 = stringArray[n];
                String string4 = this.mBluetoothService.getAddressFromObjectPath(string2);
                if (string4 == null) {
                    int n2 = Log.e(TAG, "onSinkPropertyChanged: Address of the remote device in null");
                } else {
                    BluetoothDevice bluetoothDevice = this.mAdapter.getRemoteDevice(string4);
                    if (string3.equals(PROPERTY_STATE)) {
                        String string5 = stringArray[1];
                        int n3 = this.convertBluezSinkStringtoState(string5);
                        if (this.mAudioDevices.get(bluetoothDevice) == null) {
                            boolean bl2 = this.addAudioSink(bluetoothDevice);
                        } else {
                            int n4 = this.mAudioDevices.get(bluetoothDevice);
                            this.handleSinkStateChange(bluetoothDevice, n4, n3);
                        }
                    }
                }
            }
            return;
        }
    }

    private synchronized native boolean resumeSinkNative(String var1);

    private synchronized native boolean suspendSinkNative(String var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean connectSink(BluetoothDevice bluetoothDevice) {
        synchronized (this) {
            boolean bl;
            block4: {
                this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
                BluetoothA2dpService.log("connectSink(" + bluetoothDevice + ")");
                bl = this.isConnectSinkFeasible(bluetoothDevice);
                if (bl) break block4;
                return false;
            }
            BluetoothService bluetoothService = this.mBluetoothService;
            String string2 = bluetoothDevice.getAddress();
            bl = bluetoothService.connectSink(string2);
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean connectSinkInternal(BluetoothDevice bluetoothDevice) {
        synchronized (this) {
            block10: {
                boolean bl = this.mBluetoothService.isEnabled();
                if (bl) break block10;
                return false;
            }
            int n = this.mAudioDevices.get(bluetoothDevice);
            int[] nArray = new int[]{1, 2, 4, 3};
            if (this.lookupSinksMatchingStates(nArray).size() != 0) {
                return false;
            }
            switch (n) {
                default: {
                    BluetoothService bluetoothService = this.mBluetoothService;
                    String string2 = bluetoothDevice.getAddress();
                    String string3 = bluetoothService.getObjectPathFromAddress(string2);
                    if (this.getSinkPriority(bluetoothDevice) < 1000) {
                        boolean bl = this.setSinkPriority(bluetoothDevice, 1000);
                    }
                    this.handleSinkStateChange(bluetoothDevice, n, 1);
                    if (this.connectSinkNative(string3)) return true;
                    int n2 = this.mAudioDevices.get(bluetoothDevice);
                    this.handleSinkStateChange(bluetoothDevice, n2, n);
                    return false;
                }
                case 2: 
                case 3: 
                case 4: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean disconnectSink(BluetoothDevice bluetoothDevice) {
        synchronized (this) {
            boolean bl;
            block4: {
                this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
                BluetoothA2dpService.log("disconnectSink(" + bluetoothDevice + ")");
                bl = this.isDisconnectSinkFeasible(bluetoothDevice);
                if (bl) break block4;
                return false;
            }
            BluetoothService bluetoothService = this.mBluetoothService;
            String string2 = bluetoothDevice.getAddress();
            bl = bluetoothService.disconnectSink(string2);
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean disconnectSinkInternal(BluetoothDevice bluetoothDevice) {
        synchronized (this) {
            int n = this.getSinkState(bluetoothDevice);
            BluetoothService bluetoothService = this.mBluetoothService;
            String string2 = bluetoothDevice.getAddress();
            String string3 = bluetoothService.getObjectPathFromAddress(string2);
            switch (n) {
                default: {
                    this.handleSinkStateChange(bluetoothDevice, n, 3);
                    if (this.disconnectSinkNative(string3)) return true;
                    int n2 = this.mAudioDevices.get(bluetoothDevice);
                    this.handleSinkStateChange(bluetoothDevice, n2, n);
                    return false;
                }
            }
            {
                case 0: 
                case 3: {
                    return false;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        synchronized (this) {
            boolean bl = this.mAudioDevices.isEmpty();
            if (!bl) {
                printWriter.println("Cached audio devices:");
                for (BluetoothDevice bluetoothDevice : this.mAudioDevices.keySet()) {
                    int n = this.mAudioDevices.get(bluetoothDevice);
                    StringBuilder stringBuilder = new StringBuilder().append(bluetoothDevice).append(" ");
                    String string2 = BluetoothA2dp.stateToString(n);
                    String string3 = stringBuilder.append(string2).toString();
                    printWriter.println(string3);
                }
            }
            return;
        }
    }

    @Override
    protected void finalize() throws Throwable {
        try {
            this.cleanupNative();
            return;
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public BluetoothDevice[] getConnectedSinks() {
        synchronized (this) {
            this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
            int[] nArray = new int[]{2, 4};
            Set<BluetoothDevice> set = this.lookupSinksMatchingStates(nArray);
            BluetoothDevice[] bluetoothDeviceArray = new BluetoothDevice[set.size()];
            BluetoothDevice[] bluetoothDeviceArray2 = set.toArray(bluetoothDeviceArray);
            return bluetoothDeviceArray2;
        }
    }

    @Override
    public BluetoothDevice[] getNonDisconnectedSinks() {
        synchronized (this) {
            this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
            int[] nArray = new int[]{2, 4, 1, 3};
            Set<BluetoothDevice> set = this.lookupSinksMatchingStates(nArray);
            BluetoothDevice[] bluetoothDeviceArray = new BluetoothDevice[set.size()];
            BluetoothDevice[] bluetoothDeviceArray2 = set.toArray(bluetoothDeviceArray);
            return bluetoothDeviceArray2;
        }
    }

    @Override
    public int getSinkPriority(BluetoothDevice bluetoothDevice) {
        synchronized (this) {
            int n;
            this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
            ContentResolver contentResolver = this.mContext.getContentResolver();
            String string2 = Settings.Secure.getBluetoothA2dpSinkPriorityKey(bluetoothDevice.getAddress());
            int n2 = n = Settings.Secure.getInt(contentResolver, string2, -1);
            return n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getSinkState(BluetoothDevice bluetoothDevice) {
        synchronized (this) {
            Integer n;
            block4: {
                this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_PERM, "Need BLUETOOTH permission");
                n = this.mAudioDevices.get(bluetoothDevice);
                if (n != null) break block4;
                return 0;
            }
            int n2 = n;
            return n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean resumeSink(BluetoothDevice bluetoothDevice) {
        synchronized (this) {
            block5: {
                this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
                StringBuilder stringBuilder = new StringBuilder().append("resumeSink(").append(bluetoothDevice).append("), mTargetA2dpState: ");
                int n = this.mTargetA2dpState;
                BluetoothA2dpService.log(stringBuilder.append(n).toString());
                if (bluetoothDevice == null) return false;
                HashMap<BluetoothDevice, Integer> hashMap = this.mAudioDevices;
                if (hashMap != null) break block5;
                return false;
            }
            BluetoothService bluetoothService = this.mBluetoothService;
            String string2 = bluetoothDevice.getAddress();
            String string3 = bluetoothService.getObjectPathFromAddress(string2);
            Integer n = this.mAudioDevices.get(bluetoothDevice);
            if (string3 == null) return false;
            if (n == null) {
                return false;
            }
            this.mTargetA2dpState = 4;
            int n2 = n;
            boolean bl = this.checkSinkSuspendState(n2);
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setSinkPriority(BluetoothDevice bluetoothDevice, int n) {
        synchronized (this) {
            boolean bl;
            block4: {
                this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
                bl = BluetoothAdapter.checkBluetoothAddress(bluetoothDevice.getAddress());
                if (bl) break block4;
                return false;
            }
            ContentResolver contentResolver = this.mContext.getContentResolver();
            String string2 = Settings.Secure.getBluetoothA2dpSinkPriorityKey(bluetoothDevice.getAddress());
            bl = Settings.Secure.putInt(contentResolver, string2, n);
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean suspendSink(BluetoothDevice bluetoothDevice) {
        synchronized (this) {
            block5: {
                this.mContext.enforceCallingOrSelfPermission(BLUETOOTH_ADMIN_PERM, "Need BLUETOOTH_ADMIN permission");
                StringBuilder stringBuilder = new StringBuilder().append("suspendSink(").append(bluetoothDevice).append("), mTargetA2dpState: ");
                int n = this.mTargetA2dpState;
                BluetoothA2dpService.log(stringBuilder.append(n).toString());
                if (bluetoothDevice == null) return false;
                HashMap<BluetoothDevice, Integer> hashMap = this.mAudioDevices;
                if (hashMap != null) break block5;
                return false;
            }
            BluetoothService bluetoothService = this.mBluetoothService;
            String string2 = bluetoothDevice.getAddress();
            String string3 = bluetoothService.getObjectPathFromAddress(string2);
            Integer n = this.mAudioDevices.get(bluetoothDevice);
            if (string3 == null) return false;
            if (n == null) {
                return false;
            }
            this.mTargetA2dpState = 2;
            int n2 = n;
            boolean bl = this.checkSinkSuspendState(n2);
            return bl;
        }
    }
}

