/*
 * Decompiled with CFR 0.152.
 */
package android.server;

import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothUuid;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.os.ParcelUuid;
import android.server.BluetoothService;
import android.util.Log;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

class BluetoothEventLoop {
    private static final String BLUETOOTH_ADMIN_PERM = "android.permission.BLUETOOTH_ADMIN";
    private static final String BLUETOOTH_PERM = "android.permission.BLUETOOTH";
    private static final int CREATE_DEVICE_ALREADY_EXISTS = 1;
    private static final int CREATE_DEVICE_FAILED = 255;
    private static final int CREATE_DEVICE_SUCCESS = 0;
    private static final boolean DBG = false;
    private static final int EVENT_AGENT_CANCEL = 3;
    private static final int EVENT_PAIRING_CONSENT_DELAYED_ACCEPT = 2;
    private static final int EVENT_RESTART_BLUETOOTH = 1;
    private static final String TAG = "BluetoothEventLoop";
    private final BluetoothAdapter mAdapter;
    private final BluetoothService mBluetoothService;
    private final Context mContext;
    private final Handler mHandler;
    private boolean mInterrupted;
    private int mNativeData;
    private final HashMap<String, Integer> mPasskeyAgentRequestData;
    private boolean mStarted;
    private Thread mThread;

    static {
        BluetoothEventLoop.classInitNative();
    }

    BluetoothEventLoop(Context context, BluetoothAdapter bluetoothAdapter, BluetoothService bluetoothService) {
        Handler handler;
        this.mHandler = handler = new Handler(){

            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 1: {
                        BluetoothEventLoop.this.mBluetoothService.restart();
                        return;
                    }
                    case 2: {
                        String string2 = (String)message.obj;
                        if (string2 == null) {
                            return;
                        }
                        boolean bl = BluetoothEventLoop.this.mBluetoothService.setPairingConfirmation(string2, true);
                        return;
                    }
                    case 3: 
                }
                String[] stringArray = BluetoothEventLoop.this.mBluetoothService.listInState(11);
                if (stringArray.length == 0) {
                    return;
                }
                if (stringArray.length > 1) {
                    int n = Log.e(BluetoothEventLoop.TAG, " There is more than one device in the Bonding State");
                    return;
                }
                String string3 = stringArray[0];
                boolean bl = BluetoothEventLoop.this.mBluetoothService.setBondState(string3, 10, 8);
            }
        };
        this.mBluetoothService = bluetoothService;
        this.mContext = context;
        HashMap hashMap = new HashMap();
        this.mPasskeyAgentRequestData = hashMap;
        this.mAdapter = bluetoothAdapter;
        this.initializeNativeDataNative();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void addDevice(String string2, String[] stringArray) {
        this.mBluetoothService.addRemoteDeviceProperties(string2, stringArray);
        String string3 = this.mBluetoothService.getRemoteDeviceProperty(string2, "RSSI");
        String string4 = this.mBluetoothService.getRemoteDeviceProperty(string2, "Class");
        String string5 = this.mBluetoothService.getRemoteDeviceProperty(string2, "Name");
        if (string3 != null) {
            short s = (short)Integer.valueOf(string3).intValue();
        } else {
            int n = 32768;
        }
        if (string4 != null) {
            void var6_7;
            Intent intent = new Intent("android.bluetooth.device.action.FOUND");
            BluetoothDevice bluetoothDevice = this.mAdapter.getRemoteDevice(string2);
            Intent intent2 = intent.putExtra("android.bluetooth.device.extra.DEVICE", bluetoothDevice);
            int n = Integer.valueOf(string4);
            BluetoothClass bluetoothClass = new BluetoothClass(n);
            Intent intent3 = intent.putExtra("android.bluetooth.device.extra.CLASS", bluetoothClass);
            Intent intent4 = intent.putExtra("android.bluetooth.device.extra.RSSI", (short)var6_7);
            Intent intent5 = intent.putExtra("android.bluetooth.device.extra.NAME", string5);
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
            return;
        }
        BluetoothEventLoop.log("ClassValue: " + string4 + " for remote device: " + string2 + " is null");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String checkPairingRequestAndGetAddress(String string2, int n) {
        String string3 = this.mBluetoothService.getAddressFromObjectPath(string2);
        if (string3 == null) {
            int n2 = Log.e(TAG, "Unable to get device address in checkPairingRequestAndGetAddress, returning null");
            return null;
        }
        string3 = string3.toUpperCase();
        HashMap<String, Integer> hashMap = this.mPasskeyAgentRequestData;
        Integer n3 = new Integer(n);
        Integer n4 = hashMap.put(string3, n3);
        if (this.mBluetoothService.getBluetoothState() == 13) {
            boolean bl = this.mBluetoothService.cancelPairingUserInput(string3);
            return null;
        }
        if (this.mBluetoothService.getBondState(string3) == 12) return string3;
        boolean bl = this.mBluetoothService.setBondState(string3, 11);
        return string3;
    }

    private static native void classInitNative();

    private native void cleanupNativeDataNative();

    private native void initializeNativeDataNative();

    private native boolean isEventLoopRunningNative();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isOtherSinkInNonDisconnectingState(String string2) {
        Context context = this.mContext;
        Set<BluetoothDevice> set = new BluetoothA2dp(context).getNonDisconnectedSinks();
        if (set.size() == 0) {
            return false;
        }
        Iterator<BluetoothDevice> iterator = set.iterator();
        do {
            if (!iterator.hasNext()) return false;
        } while (iterator.next().getAddress().equals(string2));
        return true;
    }

    private static void log(String string2) {
        int n = Log.d(TAG, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean onAgentAuthorize(String string2, String string3) {
        boolean bl;
        block5: {
            String string4;
            block4: {
                string4 = this.mBluetoothService.getAddressFromObjectPath(string2);
                if (string4 == null) {
                    int n = Log.e(TAG, "Unable to get device address in onAuthAgentAuthorize");
                    return false;
                }
                bl = false;
                ParcelUuid parcelUuid = ParcelUuid.fromString(string3);
                Context context = this.mContext;
                BluetoothA2dp bluetoothA2dp = new BluetoothA2dp(context);
                if (!this.mBluetoothService.isEnabled() || !BluetoothUuid.isAudioSource(parcelUuid) && !BluetoothUuid.isAvrcpTarget(parcelUuid) && !BluetoothUuid.isAdvAudioDist(parcelUuid) || this.isOtherSinkInNonDisconnectingState(string4)) break block4;
                BluetoothDevice bluetoothDevice = this.mAdapter.getRemoteDevice(string4);
                bl = bluetoothA2dp.getSinkPriority(bluetoothDevice) > 0;
                if (bl) {
                    String string5 = "Allowing incoming A2DP / AVRCP connection from " + string4;
                    int n = Log.i(TAG, string5);
                    if (!BluetoothUuid.isAvrcpTarget(parcelUuid)) {
                        boolean bl2 = this.mBluetoothService.notifyIncomingA2dpConnection(string4);
                    }
                    break block5;
                } else {
                    String string6 = "Rejecting incoming A2DP / AVRCP connection from " + string4;
                    int n = Log.i(TAG, string6);
                }
                break block5;
            }
            String string7 = "Rejecting incoming " + string3 + " connection from " + string4;
            int n = Log.i(TAG, string7);
        }
        BluetoothEventLoop.log("onAgentAuthorize(" + string2 + ", " + string3 + ") = " + bl);
        return bl;
    }

    private void onAgentCancel() {
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_CANCEL");
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
        Handler handler = this.mHandler;
        Message message = this.mHandler.obtainMessage(3);
        boolean bl = handler.sendMessageDelayed(message, 1500L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean onAgentOutOfBandDataAvailable(String string2) {
        if (!this.mBluetoothService.isEnabled()) {
            return false;
        }
        String string3 = this.mBluetoothService.getAddressFromObjectPath(string2);
        if (string3 == null) {
            return false;
        }
        BluetoothService bluetoothService = this.mBluetoothService;
        BluetoothDevice bluetoothDevice = this.mAdapter.getRemoteDevice(string3);
        if (bluetoothService.getDeviceOutOfBandData(bluetoothDevice) == null) return false;
        return true;
    }

    private void onCreateDeviceResult(String string2, int n) {
        switch (n) {
            default: {
                return;
            }
            case 1: {
                String string3 = this.mBluetoothService.getObjectPathFromAddress(string2);
                if (string3 != null) {
                    boolean bl = this.mBluetoothService.discoverServicesNative(string3, "");
                    return;
                }
                int n2 = Log.w(TAG, "Device exists, but we dont have the bluez path, failing");
            }
            case -1: 
        }
        this.mBluetoothService.sendUuidIntent(string2);
        this.mBluetoothService.makeServiceChannelCallbacks(string2);
    }

    private void onCreatePairedDeviceResult(String string2, int n) {
        String string3 = string2.toUpperCase();
        this.mBluetoothService.onCreatePairedDeviceResult(string3, n);
    }

    private void onDeviceCreated(String string2) {
        String string3 = this.mBluetoothService.getAddressFromObjectPath(string2);
        if (this.mBluetoothService.isRemoteDeviceInCache(string3)) {
            return;
        }
        String[] stringArray = this.mBluetoothService.getRemoteDeviceProperties(string3);
        if (stringArray == null) {
            return;
        }
        this.addDevice(string3, stringArray);
    }

    private void onDeviceDisappeared(String string2) {
        Intent intent = new Intent("android.bluetooth.device.action.DISAPPEARED");
        BluetoothDevice bluetoothDevice = this.mAdapter.getRemoteDevice(string2);
        Intent intent2 = intent.putExtra("android.bluetooth.device.extra.DEVICE", bluetoothDevice);
        this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
    }

    private void onDeviceDisconnectRequested(String string2) {
        String string3 = this.mBluetoothService.getAddressFromObjectPath(string2);
        if (string3 == null) {
            int n = Log.e(TAG, "onDeviceDisconnectRequested: Address of the remote device in null");
            return;
        }
        Intent intent = new Intent("android.bluetooth.device.action.ACL_DISCONNECT_REQUESTED");
        BluetoothDevice bluetoothDevice = this.mAdapter.getRemoteDevice(string3);
        Intent intent2 = intent.putExtra("android.bluetooth.device.extra.DEVICE", bluetoothDevice);
        this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
    }

    private void onDeviceFound(String string2, String[] stringArray) {
        if (stringArray == null) {
            int n = Log.e(TAG, "ERROR: Remote device properties are null");
            return;
        }
        this.addDevice(string2, stringArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onDevicePropertyChanged(String string2, String[] stringArray) {
        String string3 = stringArray[0];
        String string4 = this.mBluetoothService.getAddressFromObjectPath(string2);
        if (string4 == null) {
            int n = Log.e(TAG, "onDevicePropertyChanged: Address of the remote device in null");
            return;
        }
        BluetoothDevice bluetoothDevice = this.mAdapter.getRemoteDevice(string4);
        if (string3.equals("Name")) {
            BluetoothService bluetoothService = this.mBluetoothService;
            String string5 = stringArray[1];
            bluetoothService.setRemoteDeviceProperty(string4, string3, string5);
            Intent intent = new Intent("android.bluetooth.device.action.NAME_CHANGED");
            Intent intent2 = intent.putExtra("android.bluetooth.device.extra.DEVICE", bluetoothDevice);
            String string6 = stringArray[1];
            Intent intent3 = intent.putExtra("android.bluetooth.device.extra.NAME", string6);
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
            return;
        }
        if (string3.equals("Class")) {
            BluetoothService bluetoothService = this.mBluetoothService;
            String string7 = stringArray[1];
            bluetoothService.setRemoteDeviceProperty(string4, string3, string7);
            Intent intent = new Intent("android.bluetooth.device.action.CLASS_CHANGED");
            Intent intent4 = intent.putExtra("android.bluetooth.device.extra.DEVICE", bluetoothDevice);
            int n = Integer.valueOf(stringArray[1]);
            BluetoothClass bluetoothClass = new BluetoothClass(n);
            Intent intent5 = intent.putExtra("android.bluetooth.device.extra.CLASS", bluetoothClass);
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
            return;
        }
        if (string3.equals("Connected")) {
            Intent intent;
            BluetoothService bluetoothService = this.mBluetoothService;
            String string8 = stringArray[1];
            bluetoothService.setRemoteDeviceProperty(string4, string3, string8);
            if (stringArray[1].equals("true")) {
                intent = new Intent("android.bluetooth.device.action.ACL_CONNECTED");
                if (this.mBluetoothService.isBluetoothDock(string4)) {
                    this.mBluetoothService.setLinkTimeout(string4, 8000);
                }
            } else {
                intent = new Intent("android.bluetooth.device.action.ACL_DISCONNECTED");
            }
            Intent intent6 = intent.putExtra("android.bluetooth.device.extra.DEVICE", bluetoothDevice);
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
            return;
        }
        if (string3.equals("UUIDs")) {
            String string9 = null;
            if (Integer.valueOf(stringArray[1]) > 0) {
                int n;
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 2; i < (n = stringArray.length); ++i) {
                    String string10 = stringArray[i];
                    StringBuilder stringBuilder2 = stringBuilder.append(string10);
                    StringBuilder stringBuilder3 = stringBuilder.append(",");
                }
                string9 = stringBuilder.toString();
            }
            this.mBluetoothService.setRemoteDeviceProperty(string4, string3, string9);
            this.mBluetoothService.updateDeviceServiceChannelCache(string4);
            this.mBluetoothService.sendUuidIntent(string4);
            return;
        }
        if (string3.equals("Paired")) {
            if (!stringArray[1].equals("true")) {
                boolean bl = this.mBluetoothService.setBondState(string4, 10);
                this.mBluetoothService.setRemoteDeviceProperty(string4, "Trusted", "false");
                return;
            }
            if (this.mBluetoothService.getPendingOutgoingBonding() != null) {
                return;
            }
            boolean bl = this.mBluetoothService.setBondState(string4, 12);
            return;
        }
        if (!string3.equals("Trusted")) {
            return;
        }
        BluetoothService bluetoothService = this.mBluetoothService;
        String string11 = stringArray[1];
        bluetoothService.setRemoteDeviceProperty(string4, string3, string11);
    }

    private void onDeviceRemoved(String string2) {
        String string3 = this.mBluetoothService.getAddressFromObjectPath(string2);
        if (string3 == null) {
            return;
        }
        BluetoothService bluetoothService = this.mBluetoothService;
        String string4 = string3.toUpperCase();
        boolean bl = bluetoothService.setBondState(string4, 10, 9);
        this.mBluetoothService.setRemoteDeviceProperty(string3, "UUIDs", null);
    }

    private void onDiscoverServicesResult(String string2, boolean bl) {
        String string3 = this.mBluetoothService.getAddressFromObjectPath(string2);
        if (bl) {
            boolean bl2 = this.mBluetoothService.updateRemoteDevicePropertiesCache(string3);
        }
        this.mBluetoothService.sendUuidIntent(string3);
        this.mBluetoothService.makeServiceChannelCallbacks(string3);
    }

    private void onDisplayPasskey(String string2, int n, int n2) {
        String string3 = this.checkPairingRequestAndGetAddress(string2, n2);
        if (string3 == null) {
            return;
        }
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_REQUEST");
        BluetoothDevice bluetoothDevice = this.mAdapter.getRemoteDevice(string3);
        Intent intent2 = intent.putExtra("android.bluetooth.device.extra.DEVICE", bluetoothDevice);
        Intent intent3 = intent.putExtra("android.bluetooth.device.extra.PASSKEY", n);
        Intent intent4 = intent.putExtra("android.bluetooth.device.extra.PAIRING_VARIANT", 4);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
    }

    private void onRequestOobData(String string2, int n) {
        String string3 = this.checkPairingRequestAndGetAddress(string2, n);
        if (string3 == null) {
            return;
        }
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_REQUEST");
        BluetoothDevice bluetoothDevice = this.mAdapter.getRemoteDevice(string3);
        Intent intent2 = intent.putExtra("android.bluetooth.device.extra.DEVICE", bluetoothDevice);
        Intent intent3 = intent.putExtra("android.bluetooth.device.extra.PAIRING_VARIANT", 5);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
    }

    private void onRequestPairingConsent(String string2, int n) {
        String string3 = this.checkPairingRequestAndGetAddress(string2, n);
        if (string3 == null) {
            return;
        }
        if (this.mBluetoothService.getBondState(string3) == 12) {
            Message message = this.mHandler.obtainMessage(2);
            message.obj = string3;
            boolean bl = this.mHandler.sendMessageDelayed(message, 1500L);
            return;
        }
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_REQUEST");
        BluetoothDevice bluetoothDevice = this.mAdapter.getRemoteDevice(string3);
        Intent intent2 = intent.putExtra("android.bluetooth.device.extra.DEVICE", bluetoothDevice);
        Intent intent3 = intent.putExtra("android.bluetooth.device.extra.PAIRING_VARIANT", 3);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
    }

    private void onRequestPasskey(String string2, int n) {
        String string3 = this.checkPairingRequestAndGetAddress(string2, n);
        if (string3 == null) {
            return;
        }
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_REQUEST");
        BluetoothDevice bluetoothDevice = this.mAdapter.getRemoteDevice(string3);
        Intent intent2 = intent.putExtra("android.bluetooth.device.extra.DEVICE", bluetoothDevice);
        Intent intent3 = intent.putExtra("android.bluetooth.device.extra.PAIRING_VARIANT", 1);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
    }

    private void onRequestPasskeyConfirmation(String string2, int n, int n2) {
        String string3 = this.checkPairingRequestAndGetAddress(string2, n2);
        if (string3 == null) {
            return;
        }
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_REQUEST");
        BluetoothDevice bluetoothDevice = this.mAdapter.getRemoteDevice(string3);
        Intent intent2 = intent.putExtra("android.bluetooth.device.extra.DEVICE", bluetoothDevice);
        Intent intent3 = intent.putExtra("android.bluetooth.device.extra.PASSKEY", n);
        Intent intent4 = intent.putExtra("android.bluetooth.device.extra.PAIRING_VARIANT", 2);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onRequestPinCode(String string2, int n) {
        String string3 = this.checkPairingRequestAndGetAddress(string2, n);
        if (string3 == null) {
            return;
        }
        String string4 = this.mBluetoothService.getPendingOutgoingBonding();
        if (string3.equals(string4)) {
            if (this.mBluetoothService.isBluetoothDock(string3)) {
                String string5 = this.mBluetoothService.getDockPin();
                BluetoothService bluetoothService = this.mBluetoothService;
                byte[] byArray = BluetoothDevice.convertPinToBytes(string5);
                boolean bl = bluetoothService.setPin(string3, byArray);
                return;
            }
            int n2 = this.mBluetoothService.getRemoteClass(string3);
            switch (new BluetoothClass(n2).getDeviceClass()) {
                default: {
                    break;
                }
                case 1028: 
                case 1032: 
                case 1048: 
                case 1052: 
                case 1056: 
                case 1064: {
                    if (!this.mBluetoothService.attemptAutoPair(string3)) break;
                    return;
                }
            }
        }
        Intent intent = new Intent("android.bluetooth.device.action.PAIRING_REQUEST");
        BluetoothDevice bluetoothDevice = this.mAdapter.getRemoteDevice(string3);
        Intent intent2 = intent.putExtra("android.bluetooth.device.extra.DEVICE", bluetoothDevice);
        Intent intent3 = intent.putExtra("android.bluetooth.device.extra.PAIRING_VARIANT", 0);
        this.mContext.sendBroadcast(intent, BLUETOOTH_ADMIN_PERM);
    }

    private void onRestartRequired() {
        if (!this.mBluetoothService.isEnabled()) {
            return;
        }
        int n = Log.e(TAG, "*** A serious error occurred (did bluetoothd crash?) - restarting Bluetooth ***");
        boolean bl = this.mHandler.sendEmptyMessage(1);
    }

    private native void startEventLoopNative();

    private native void stopEventLoopNative();

    protected void finalize() throws Throwable {
        try {
            this.cleanupNativeDataNative();
            return;
        }
        finally {
            super.finalize();
        }
    }

    HashMap<String, Integer> getPasskeyAgentRequestData() {
        return this.mPasskeyAgentRequestData;
    }

    public boolean isEventLoopRunning() {
        return this.isEventLoopRunningNative();
    }

    /*
     * Enabled aggressive block sorting
     */
    void onPropertyChanged(String[] stringArray) {
        String string2;
        if (this.mBluetoothService.isAdapterPropertiesEmpty()) {
            this.mBluetoothService.getAllProperties();
        }
        if ((string2 = stringArray[0]).equals("Name")) {
            BluetoothService bluetoothService = this.mBluetoothService;
            String string3 = stringArray[1];
            bluetoothService.setProperty(string2, string3);
            Intent intent = new Intent("android.bluetooth.adapter.action.LOCAL_NAME_CHANGED");
            String string4 = stringArray[1];
            Intent intent2 = intent.putExtra("android.bluetooth.adapter.extra.LOCAL_NAME", string4);
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
            return;
        }
        if (string2.equals("Pairable") || string2.equals("Discoverable")) {
            String string5 = string2.equals("Pairable") ? stringArray[1] : this.mBluetoothService.getPropertyInternal("Pairable");
            String string6 = string2.equals("Discoverable") ? stringArray[1] : this.mBluetoothService.getPropertyInternal("Discoverable");
            if (string5 == null) {
                return;
            }
            if (string6 == null) {
                return;
            }
            BluetoothService bluetoothService = this.mBluetoothService;
            String string7 = stringArray[1];
            bluetoothService.setProperty(string2, string7);
            boolean bl = string5.equals("true");
            boolean bl2 = string6.equals("true");
            int n = BluetoothService.bluezStringToScanMode(bl, bl2);
            if (n < 0) {
                return;
            }
            Intent intent = new Intent("android.bluetooth.adapter.action.SCAN_MODE_CHANGED");
            Intent intent3 = intent.putExtra("android.bluetooth.adapter.extra.SCAN_MODE", n);
            Intent intent4 = intent.addFlags(0x10000000);
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
            return;
        }
        if (string2.equals("Discovering")) {
            Intent intent;
            BluetoothService bluetoothService = this.mBluetoothService;
            String string8 = stringArray[1];
            bluetoothService.setProperty(string2, string8);
            if (stringArray[1].equals("true")) {
                this.mBluetoothService.setIsDiscovering(true);
                intent = new Intent("android.bluetooth.adapter.action.DISCOVERY_STARTED");
            } else {
                boolean bl = this.mBluetoothService.cancelDiscovery();
                this.mBluetoothService.setIsDiscovering(false);
                intent = new Intent("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
            }
            this.mContext.sendBroadcast(intent, BLUETOOTH_PERM);
            return;
        }
        if (string2.equals("Devices")) {
            String string9 = null;
            if (Integer.valueOf(stringArray[1]) > 0) {
                int n;
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 2; i < (n = stringArray.length); ++i) {
                    String string10 = stringArray[i];
                    StringBuilder stringBuilder2 = stringBuilder.append(string10);
                    StringBuilder stringBuilder3 = stringBuilder.append(",");
                }
                string9 = stringBuilder.toString();
            }
            this.mBluetoothService.setProperty(string2, string9);
            return;
        }
        if (!string2.equals("Powered")) {
            return;
        }
        if (!stringArray[1].equals("true")) {
            return;
        }
        this.onRestartRequired();
    }

    void start() {
        if (this.isEventLoopRunningNative()) {
            return;
        }
        this.startEventLoopNative();
    }

    public void stop() {
        if (!this.isEventLoopRunningNative()) {
            return;
        }
        this.stopEventLoopNative();
    }
}

