/*
 * Decompiled with CFR 0.152.
 */
package android.server;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothDeviceProfileState;
import android.bluetooth.BluetoothProfileState;
import android.bluetooth.BluetoothUuid;
import android.bluetooth.IBluetooth;
import android.bluetooth.IBluetoothCallback;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemService;
import android.provider.Settings;
import android.server.BluetoothA2dpService;
import android.server.BluetoothEventLoop;
import android.server.BluetoothService;
import android.util.Log;
import android.util.Pair;
import com.android.internal.app.IBatteryStats;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public class BluetoothService
extends IBluetooth.Stub {
    private static final String BLUETOOTH_ADMIN_PERM = "android.permission.BLUETOOTH_ADMIN";
    private static final String BLUETOOTH_PERM = "android.permission.BLUETOOTH";
    private static final boolean DBG = true;
    private static final String DOCK_ADDRESS_PATH = "/sys/class/switch/dock/bt_addr";
    private static final String DOCK_PIN_PATH = "/sys/class/switch/dock/bt_pin";
    private static final long INIT_AUTO_PAIRING_FAILURE_ATTEMPT_DELAY = 3000L;
    private static final long MAX_AUTO_PAIRING_FAILURE_ATTEMPT_DELAY = 12000L;
    private static final int MESSAGE_AUTO_PAIRING_FAILURE_ATTEMPT_DELAY = 5;
    private static final int MESSAGE_DISCOVERABLE_TIMEOUT = 4;
    private static final int MESSAGE_FINISH_DISABLE = 2;
    private static final int MESSAGE_REGISTER_SDP_RECORDS = 1;
    private static final int MESSAGE_UUID_INTENT = 3;
    private static final ParcelUuid[] RFCOMM_UUIDS;
    private static final String SHARED_PREFERENCES_NAME = "bluetooth_service_settings";
    private static final String SHARED_PREFERENCE_DOCK_ADDRESS = "dock_bluetooth_address";
    private static final String TAG = "BluetoothService";
    private static final int UUID_INTENT_DELAY = 6000;
    private static String mDockAddress;
    private final BluetoothProfileState mA2dpProfileState;
    private BluetoothA2dpService mA2dpService;
    private BluetoothAdapter mAdapter;
    private final Map<String, String> mAdapterProperties;
    private final IBatteryStats mBatteryStats;
    private int mBluetoothState;
    private final BondState mBondState;
    private final Context mContext;
    private final HashMap<String, Pair<byte[], byte[]>> mDeviceOobData;
    private final HashMap<String, BluetoothDeviceProfileState> mDeviceProfileState;
    private final HashMap<String, Map<String, String>> mDeviceProperties;
    private final HashMap<String, Map<ParcelUuid, Integer>> mDeviceServiceChannelCache;
    private String mDockPin;
    private EnableThread mEnableThread;
    private BluetoothEventLoop mEventLoop;
    private final Handler mHandler;
    private final BluetoothProfileState mHfpProfileState;
    private boolean mIsAirplaneSensitive;
    private boolean mIsAirplaneToggleable;
    private boolean mIsDiscovering;
    private int mNativeData;
    private final BroadcastReceiver mReceiver;
    private boolean mRestart = false;
    private final HashMap<Integer, Integer> mServiceRecordToPid;
    private final HashMap<RemoteService, IBluetoothCallback> mUuidCallbackTracker;
    private final ArrayList<String> mUuidIntentTracker;

    static {
        ParcelUuid parcelUuid = BluetoothUuid.Handsfree;
        ParcelUuid parcelUuid2 = BluetoothUuid.HSP;
        ParcelUuid parcelUuid3 = BluetoothUuid.ObexObjectPush;
        ParcelUuid[] parcelUuidArray = new ParcelUuid[]{parcelUuid, parcelUuid2, parcelUuid3};
        RFCOMM_UUIDS = parcelUuidArray;
        BluetoothService.classInitNative();
    }

    public BluetoothService(Context context) {
        BluetoothProfileState bluetoothProfileState;
        BluetoothProfileState bluetoothProfileState2;
        IBatteryStats iBatteryStats;
        BroadcastReceiver broadcastReceiver;
        Handler handler;
        BondState bondState;
        this.mBondState = bondState = new BondState(this);
        this.mHandler = handler = new Handler(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 1: {
                        if (!BluetoothService.this.isEnabledInternal()) {
                            return;
                        }
                        switch (message.arg1) {
                            default: {
                                return;
                            }
                            case 1: {
                                int n = Log.d(BluetoothService.TAG, "Registering hfag record");
                                SystemService.start("hfag");
                                Handler handler = BluetoothService.this.mHandler;
                                Message message2 = BluetoothService.this.mHandler.obtainMessage(1, 2, -1);
                                boolean bl = handler.sendMessageDelayed(message2, 500L);
                                return;
                            }
                            case 2: {
                                int n = Log.d(BluetoothService.TAG, "Registering hsag record");
                                SystemService.start("hsag");
                                Handler handler = BluetoothService.this.mHandler;
                                Message message3 = BluetoothService.this.mHandler.obtainMessage(1, 3, -1);
                                boolean bl = handler.sendMessageDelayed(message3, 500L);
                                return;
                            }
                            case 3: {
                                int n = Log.d(BluetoothService.TAG, "Registering opush record");
                                SystemService.start("opush");
                                Handler handler = BluetoothService.this.mHandler;
                                Message message4 = BluetoothService.this.mHandler.obtainMessage(1, 4, -1);
                                boolean bl = handler.sendMessageDelayed(message4, 500L);
                                return;
                            }
                            case 4: 
                        }
                        int n = Log.d(BluetoothService.TAG, "Registering pbap record");
                        SystemService.start("pbap");
                        return;
                    }
                    case 2: {
                        BluetoothService bluetoothService = BluetoothService.this;
                        boolean bl = message.arg1 != 0;
                        bluetoothService.finishDisable(bl);
                        return;
                    }
                    case 3: {
                        String string2 = (String)message.obj;
                        if (string2 == null) {
                            return;
                        }
                        BluetoothService.this.sendUuidIntent(string2);
                        BluetoothService.this.makeServiceChannelCallbacks(string2);
                        return;
                    }
                    case 4: {
                        int n = message.arg1;
                        if (!BluetoothService.this.isEnabledInternal()) {
                            return;
                        }
                        boolean bl = BluetoothService.this.setScanMode(21, -1);
                        return;
                    }
                    case 5: 
                }
                String string3 = (String)message.obj;
                if (string3 == null) {
                    return;
                }
                boolean bl = BluetoothService.this.createBond(string3);
            }
        };
        this.mReceiver = broadcastReceiver = new BroadcastReceiver(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                if (intent == null) {
                    return;
                }
                String string2 = intent.getAction();
                if (string2.equals("android.intent.action.AIRPLANE_MODE")) {
                    ContentResolver contentResolver = context.getContentResolver();
                    boolean bl = !BluetoothService.this.isAirplaneModeOn();
                    if (Settings.Secure.getInt(contentResolver, "bluetooth_on", 0) <= 0) {
                        return;
                    }
                    if (bl) {
                        boolean bl2 = BluetoothService.this.enable(false);
                        return;
                    }
                    boolean bl3 = BluetoothService.this.disable(false);
                    return;
                }
                if (!"android.intent.action.DOCK_EVENT".equals(string2)) {
                    return;
                }
                int n = intent.getIntExtra("android.intent.extra.DOCK_STATE", 0);
                String string3 = "Received ACTION_DOCK_EVENT with State:" + n;
                int n2 = Log.v(BluetoothService.TAG, string3);
                if (n == 0) {
                    String string4 = BluetoothService.access$2502(null);
                    String string5 = BluetoothService.access$2602(BluetoothService.this, null);
                    return;
                }
                Context context2 = BluetoothService.this.mContext;
                Context context3 = BluetoothService.this.mContext;
                SharedPreferences.Editor editor = context2.getSharedPreferences(BluetoothService.SHARED_PREFERENCES_NAME, 0).edit();
                StringBuilder stringBuilder = new StringBuilder().append(BluetoothService.SHARED_PREFERENCE_DOCK_ADDRESS);
                String string6 = mDockAddress;
                String string7 = stringBuilder.append(string6).toString();
                SharedPreferences.Editor editor2 = editor.putBoolean(string7, true);
                editor.apply();
            }
        };
        this.mContext = context;
        this.mBatteryStats = iBatteryStats = IBatteryStats.Stub.asInterface(ServiceManager.getService("batteryinfo"));
        this.initializeNativeDataNative();
        if (this.isEnabledNative() == 1) {
            int n = Log.w("BluetoothService", "Bluetooth daemons already running - runtime restart? ");
            int n2 = this.disableNative();
        }
        this.mBluetoothState = 10;
        this.mIsDiscovering = false;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.mAdapterProperties = hashMap;
        HashMap hashMap2 = new HashMap();
        this.mDeviceProperties = hashMap2;
        HashMap hashMap3 = new HashMap();
        this.mDeviceServiceChannelCache = hashMap3;
        HashMap hashMap4 = new HashMap();
        this.mDeviceOobData = hashMap4;
        ArrayList arrayList = new ArrayList();
        this.mUuidIntentTracker = arrayList;
        HashMap hashMap5 = new HashMap();
        this.mUuidCallbackTracker = hashMap5;
        HashMap hashMap6 = new HashMap();
        this.mServiceRecordToPid = hashMap6;
        HashMap hashMap7 = new HashMap();
        this.mDeviceProfileState = hashMap7;
        Context context2 = this.mContext;
        this.mA2dpProfileState = bluetoothProfileState2 = new BluetoothProfileState(context2, 1);
        Context context3 = this.mContext;
        this.mHfpProfileState = bluetoothProfileState = new BluetoothProfileState(context3, 0);
        this.mHfpProfileState.start();
        this.mA2dpProfileState.start();
        IntentFilter intentFilter = new IntentFilter();
        this.registerForAirplaneMode(intentFilter);
        intentFilter.addAction("android.intent.action.DOCK_EVENT");
        Context context4 = this.mContext;
        BroadcastReceiver broadcastReceiver2 = this.mReceiver;
        Intent intent = context4.registerReceiver(broadcastReceiver2, intentFilter);
    }

    static /* synthetic */ BondState access$1000(BluetoothService bluetoothService) {
        return bluetoothService.mBondState;
    }

    static /* synthetic */ void access$1100(BluetoothService bluetoothService) {
        bluetoothService.initProfileState();
    }

    static /* synthetic */ IBatteryStats access$1200(BluetoothService bluetoothService) {
        return bluetoothService.mBatteryStats;
    }

    static /* synthetic */ EnableThread access$1302(BluetoothService bluetoothService, EnableThread enableThread) {
        bluetoothService.mEnableThread = enableThread;
        return enableThread;
    }

    static /* synthetic */ void access$1400(BluetoothService bluetoothService, int n) {
        bluetoothService.setBluetoothState(n);
    }

    static /* synthetic */ boolean access$1500(BluetoothService bluetoothService) {
        return bluetoothService.mIsAirplaneSensitive;
    }

    static /* synthetic */ boolean access$1700(BluetoothService bluetoothService) {
        return bluetoothService.mIsAirplaneToggleable;
    }

    static /* synthetic */ int access$1800(BluetoothService bluetoothService) {
        return bluetoothService.mBluetoothState;
    }

    static /* synthetic */ BluetoothDeviceProfileState access$1900(BluetoothService bluetoothService, String string2) {
        return bluetoothService.addProfileState(string2);
    }

    static /* synthetic */ void access$2000(BluetoothService bluetoothService, String string2) {
        bluetoothService.removeProfileState(string2);
    }

    static /* synthetic */ BluetoothAdapter access$2100(BluetoothService bluetoothService) {
        return bluetoothService.mAdapter;
    }

    static /* synthetic */ String access$2502(String string2) {
        mDockAddress = string2;
        return string2;
    }

    static /* synthetic */ String access$2602(BluetoothService bluetoothService, String string2) {
        bluetoothService.mDockPin = string2;
        return string2;
    }

    static /* synthetic */ int access$300(BluetoothService bluetoothService) {
        return bluetoothService.enableNative();
    }

    static /* synthetic */ BluetoothEventLoop access$400(BluetoothService bluetoothService) {
        return bluetoothService.mEventLoop;
    }

    static /* synthetic */ int access$600(BluetoothService bluetoothService) {
        return bluetoothService.disableNative();
    }

    static /* synthetic */ boolean access$700(BluetoothService bluetoothService) {
        return bluetoothService.setupNativeDataNative();
    }

    static /* synthetic */ void access$800(BluetoothService bluetoothService, boolean bl) {
        bluetoothService.persistBluetoothOnSetting(bl);
    }

    static /* synthetic */ boolean access$902(BluetoothService bluetoothService, boolean bl) {
        bluetoothService.mIsDiscovering = bl;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BluetoothDeviceProfileState addProfileState(String string2) {
        BluetoothDeviceProfileState bluetoothDeviceProfileState = this.mDeviceProfileState.get(string2);
        if (bluetoothDeviceProfileState != null) {
            return bluetoothDeviceProfileState;
        }
        Context context = this.mContext;
        BluetoothA2dpService bluetoothA2dpService = this.mA2dpService;
        BluetoothDeviceProfileState bluetoothDeviceProfileState2 = new BluetoothDeviceProfileState(context, string2, this, bluetoothA2dpService);
        BluetoothDeviceProfileState bluetoothDeviceProfileState3 = this.mDeviceProfileState.put(string2, bluetoothDeviceProfileState2);
        bluetoothDeviceProfileState2.start();
        return bluetoothDeviceProfileState2;
    }

    private native int addRfcommServiceRecordNative(String var1, long var2, long var4, short var6);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int bluezStringToScanMode(boolean bl, boolean bl2) {
        if (bl && bl2) {
            return 23;
        }
        if (!bl) return 20;
        if (bl2) return 20;
        return 21;
    }

    private native boolean cancelDeviceCreationNative(String var1);

    private native boolean cancelPairingUserInputNative(String var1, int var2);

    private void checkAndRemoveRecord(int n, int n2) {
        synchronized (this) {
            int n3;
            Integer n4 = new Integer(n);
            Integer n5 = this.mServiceRecordToPid.get(n4);
            if (n5 != null && n2 != (n3 = n5.intValue())) {
                StringBuilder stringBuilder = new StringBuilder().append("Removing service record ");
                String string2 = Integer.toHexString(n);
                BluetoothService.log(stringBuilder.append(string2).append(" for pid ").append(n2).toString());
                Integer n6 = this.mServiceRecordToPid.remove(n4);
                boolean bl = this.removeServiceRecordNative(n);
            }
            return;
        }
    }

    private static native void classInitNative();

    private native void cleanupNativeDataNative();

    private native boolean createDeviceNative(String var1);

    private native boolean createPairedDeviceNative(String var1, int var2);

    private native boolean createPairedDeviceOutOfBandNative(String var1, int var2);

    private native int disableNative();

    private native int enableNative();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void finishDisable(boolean bl) {
        synchronized (this) {
            block13: {
                block12: {
                    long l;
                    int n = this.mBluetoothState;
                    if (n != 13) break block13;
                    this.mEventLoop.stop();
                    boolean bl2 = this.tearDownNativeDataNative();
                    int n2 = this.disableNative();
                    for (String string2 : this.mBondState.listInState(11)) {
                        this.mBondState.setBondState(string2, 10, 3);
                    }
                    Intent intent = new Intent("android.bluetooth.adapter.action.SCAN_MODE_CHANGED");
                    Intent intent2 = intent.putExtra("android.bluetooth.adapter.extra.SCAN_MODE", 20);
                    this.mContext.sendBroadcast(intent, "android.permission.BLUETOOTH");
                    this.mIsDiscovering = false;
                    this.mAdapterProperties.clear();
                    this.mServiceRecordToPid.clear();
                    if (bl) {
                        this.persistBluetoothOnSetting(false);
                    }
                    this.setBluetoothState(10);
                    long l2 = l = Binder.clearCallingIdentity();
                    try {
                        this.mBatteryStats.noteBluetoothOff();
                        break block12;
                    }
                    catch (RemoteException remoteException) {}
                    break block12;
                    finally {
                        Binder.restoreCallingIdentity(l2);
                    }
                }
                if (this.mRestart) {
                    this.mRestart = false;
                    boolean bl3 = this.enable();
                }
            }
            return;
        }
    }

    private native String getAdapterPathNative();

    private native Object[] getAdapterPropertiesNative();

    private native Object[] getDevicePropertiesNative(String var1);

    private native int getDeviceServiceChannelNative(String var1, String var2, int var3);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ParcelUuid[] getUuidFromCache(String string2) {
        int n;
        String string3 = this.getRemoteDeviceProperty(string2, "UUIDs");
        if (string3 == null) {
            return null;
        }
        String[] stringArray = string3.split(",");
        ParcelUuid[] parcelUuidArray = new ParcelUuid[stringArray.length];
        int n2 = 0;
        while (n2 < (n = stringArray.length)) {
            ParcelUuid parcelUuid;
            parcelUuidArray[n2] = parcelUuid = ParcelUuid.fromString(stringArray[n2]);
            ++n2;
        }
        return parcelUuidArray;
    }

    private void initProfileState() {
        String[] stringArray = null;
        String string2 = this.getPropertyInternal("Devices");
        if (string2 != null) {
            stringArray = string2.split(",");
        }
        if (stringArray == null) {
            return;
        }
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray2[n2];
            String string4 = this.getAddressFromObjectPath(string3);
            BluetoothDeviceProfileState bluetoothDeviceProfileState = this.addProfileState(string4);
            Message message = new Message();
            message.what = 101;
            bluetoothDeviceProfileState.sendMessageDelayed(message, 8000L);
            ++n2;
        }
        return;
    }

    private native void initializeNativeDataNative();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAirplaneModeOn() {
        if (Settings.System.getInt(this.mContext.getContentResolver(), "airplane_mode_on", 0) != 1) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isBondingFeasible(String string2) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH_ADMIN", "Need BLUETOOTH_ADMIN permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        if (!BluetoothAdapter.checkBluetoothAddress(string2)) {
            return false;
        }
        string2 = string2.toUpperCase();
        if (this.mBondState.getPendingOutgoingBonding() != null) {
            BluetoothService.log("Ignoring createBond(): another device is bonding");
            return false;
        }
        if (!this.mBondState.isAutoPairingAttemptsInProgress(string2) && this.mBondState.getBondState(string2) != 10) {
            BluetoothService.log("Ignoring createBond(): this device is already bonding or bonded");
            return false;
        }
        String string3 = mDockAddress;
        if (!string2.equals(string3)) return true;
        if (this.writeDockPin()) return true;
        BluetoothService.log("Error while writing Pin for the dock");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isEnabledInternal() {
        if (this.mBluetoothState != 12) return false;
        return true;
    }

    private native int isEnabledNative();

    private static void log(String string2) {
        int n = Log.d("BluetoothService", string2);
    }

    private void pairingAttempt(String string2, int n) {
        int n2 = this.mBondState.getAttempt(string2);
        if ((long)n2 * 3000L > 12000L) {
            this.mBondState.clearPinAttempts(string2);
            boolean bl = this.setBondState(string2, 10, n);
            return;
        }
        Message message = this.mHandler.obtainMessage(5);
        message.obj = string2;
        Handler handler = this.mHandler;
        long l = (long)n2 * 3000L;
        if (!handler.sendMessageDelayed(message, l)) {
            this.mBondState.clearPinAttempts(string2);
            boolean bl = this.setBondState(string2, 10, n);
            return;
        }
        this.mBondState.attempt(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void persistBluetoothOnSetting(boolean bl) {
        long l = Binder.clearCallingIdentity();
        ContentResolver contentResolver = this.mContext.getContentResolver();
        int n = bl ? 1 : 0;
        boolean bl2 = Settings.Secure.putInt(contentResolver, "bluetooth_on", n);
        Binder.restoreCallingIdentity(l);
    }

    private native byte[] readAdapterOutOfBandDataNative();

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readDockBluetoothAddress() {
        synchronized (BluetoothService.class) {
            block26: {
                block25: {
                    if (BluetoothService.mDockAddress != null) {
                        return BluetoothService.mDockAddress;
                    }
                    var1_4 = null;
                    var2_5 = new FileInputStream("/sys/class/switch/dock/bt_addr");
                    var3_6 = new BufferedInputStream(var2_5);
                    var4_7 = 17;
                    var5_8 = new byte[var4_7];
                    var6_9 = var3_6.read(var5_8);
                    var7_10 = new String(var5_8).toUpperCase();
                    if (!BluetoothAdapter.checkBluetoothAddress(var7_10)) break block25;
                    var0 = BluetoothService.mDockAddress = var7_10;
                    if (var3_6 == null) return var0;
                    try {
                        var3_6.close();
                    }
                    catch (IOException var8_11) {}
                    ** GOTO lbl66
                }
                BluetoothService.log("CheckBluetoothAddress failed for car dock address:" + var7_10);
                if (var3_6 == null) break block26;
                try {
                    var3_6.close();
                    break block26;
                }
                catch (IOException var15_17) {}
                catch (FileNotFoundException var10_13) {}
                ** GOTO lbl-1000
                catch (IOException var12_15) {}
                ** GOTO lbl-1000
            }
            var9_12 = var3_6;
            ** GOTO lbl63
            catch (Throwable var0_3) {
                var1_4 = var3_6;
                ** GOTO lbl-1000
            }
            catch (IOException var16_18) {
                var1_4 = var3_6;
            }
lbl-1000:
            // 2 sources

            {
                BluetoothService.log("IOException while trying to read dock address");
                if (var1_4 == null) ** GOTO lbl63
                var1_4.close();
                ** GOTO lbl63
                {
                    catch (IOException var11_14) {}
                }
                catch (FileNotFoundException var17_19) {
                    var1_4 = var3_6;
                }
lbl-1000:
                // 2 sources

                {
                    block27: {
                        try {
                            BluetoothService.log("FileNotFoundException while trying to read dock address");
                            if (var1_4 == null) break block27;
                        }
                        catch (Throwable var0_1) lbl-1000:
                        // 2 sources

                        {
                            if (var1_4 == null) throw var0_2;
                            try {
                                var1_4.close();
                            }
                            catch (IOException var14_16) {
                                throw var0_2;
                            }
                            throw var0_2;
                        }
                        var1_4.close();
                    }
                    BluetoothService.mDockAddress = var0 = null;
                    return null;
lbl66:
                    // 2 sources

                    return var0;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void registerForAirplaneMode(IntentFilter intentFilter) {
        ContentResolver contentResolver = this.mContext.getContentResolver();
        String string2 = Settings.System.getString(contentResolver, "airplane_mode_radios");
        String string3 = Settings.System.getString(contentResolver, "airplane_mode_toggleable_radios");
        boolean bl = string2 == null ? true : string2.contains("bluetooth");
        this.mIsAirplaneSensitive = bl;
        boolean bl2 = string3 == null ? false : string3.contains("bluetooth");
        this.mIsAirplaneToggleable = bl2;
        if (!this.mIsAirplaneSensitive) {
            return;
        }
        intentFilter.addAction("android.intent.action.AIRPLANE_MODE");
    }

    private native boolean removeDeviceNative(String var1);

    private void removeProfileState(String string2) {
        BluetoothDeviceProfileState bluetoothDeviceProfileState = this.mDeviceProfileState.remove(string2);
    }

    private native boolean removeServiceRecordNative(int var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String scanModeToBluezString(int n) {
        switch (n) {
            default: {
                return null;
            }
            case 20: {
                return "off";
            }
            case 21: {
                return "connectable";
            }
            case 23: 
        }
        return "discoverable";
    }

    private native boolean setAdapterPropertyBooleanNative(String var1, int var2);

    private native boolean setAdapterPropertyIntegerNative(String var1, int var2);

    private native boolean setAdapterPropertyStringNative(String var1, String var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setBluetoothState(int n) {
        synchronized (this) {
            block6: {
                int n2 = this.mBluetoothState;
                if (n == n2) break block6;
                return;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Bluetooth state ");
            int n3 = this.mBluetoothState;
            BluetoothService.log(stringBuilder.append(n3).append(" -> ").append(n).toString());
            Intent intent = new Intent("android.bluetooth.adapter.action.STATE_CHANGED");
            int n4 = this.mBluetoothState;
            Intent intent2 = intent.putExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", n4);
            Intent intent3 = intent.putExtra("android.bluetooth.adapter.extra.STATE", n);
            Intent intent4 = intent.addFlags(0x10000000);
            this.mBluetoothState = n;
            this.mContext.sendBroadcast(intent, "android.permission.BLUETOOTH");
            return;
        }
    }

    private native boolean setDevicePropertyBooleanNative(String var1, String var2, int var3);

    private native boolean setLinkTimeoutNative(String var1, int var2);

    private native boolean setPairingConfirmationNative(String var1, boolean var2, int var3);

    private native boolean setPasskeyNative(String var1, int var2, int var3);

    private native boolean setPinNative(String var1, String var2, int var3);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean setPropertyBoolean(String string2, boolean bl) {
        int n;
        this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH", "Need BLUETOOTH permission");
        if (!this.isEnabledInternal()) {
            return false;
        }
        if (bl) {
            n = 1;
            return this.setAdapterPropertyBooleanNative(string2, n);
        }
        n = 0;
        return this.setAdapterPropertyBooleanNative(string2, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean setPropertyInteger(String string2, int n) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH", "Need BLUETOOTH permission");
        if (this.isEnabledInternal()) return this.setAdapterPropertyIntegerNative(string2, n);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean setPropertyString(String string2, String string3) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH", "Need BLUETOOTH permission");
        if (this.isEnabledInternal()) return this.setAdapterPropertyStringNative(string2, string3);
        return false;
    }

    private native boolean setRemoteOutOfBandDataNative(String var1, byte[] var2, byte[] var3, int var4);

    private native boolean setupNativeDataNative();

    private native boolean startDiscoveryNative();

    private native boolean stopDiscoveryNative();

    private native boolean tearDownNativeDataNative();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String toBondStateString(int n) {
        switch (n) {
            default: {
                return "??????";
            }
            case 10: {
                return "not bonded";
            }
            case 11: {
                return "bonding";
            }
            case 12: 
        }
        return "bonded";
    }

    /*
     * Unable to fully structure code
     */
    private boolean writeDockPin() {
        synchronized (this) {
            block30: {
                var1_1 = null;
                var2_2 = new FileWriter("/sys/class/switch/dock/bt_pin");
                var3_3 = new BufferedWriter(var2_2);
                var4_4 = (int)Math.floor(Math.random() * 10000.0);
                var5_5 = new Object[1];
                var6_6 = var4_4;
                var5_5[0] = var6_6;
                var8_8 = this.mDockPin = (var7_7 = String.format("%04d", var5_5));
                var3_3.write(var8_8);
                if (var3_3 == null) break block30;
                try {
                    var3_3.close();
                }
                catch (IOException var17_22) {
                    ** continue;
                }
            }
lbl17:
            // 2 sources

            while (true) {
                var9_9 = var3_3;
                var10_10 = true;
lbl20:
                // 2 sources

                return var10_10;
            }
            catch (FileNotFoundException var11_11) lbl-1000:
            // 2 sources

            {
                while (true) {
                    block31: {
                        BluetoothService.log("FileNotFoundException while trying to write dock pairing pin");
                        if (var1_1 == null) break block31;
                        var1_1.close();
                    }
lbl30:
                    // 4 sources

                    while (true) {
                        var12_12 = null;
                        this.mDockPin = var12_12;
                        var10_10 = false;
                        ** continue;
                        break;
                    }
                    break;
                }
            }
            catch (IOException var13_16) lbl-1000:
            // 2 sources

            {
                while (true) {
                    BluetoothService.log("IOException while while trying to write dock pairing pin");
                    if (var1_1 == null) ** GOTO lbl30
                    {
                        catch (Throwable var12_13) lbl-1000:
                        // 2 sources

                        {
                            while (true) {
                                if (var1_1 == null) ** GOTO lbl47
                                try {
                                    var1_1.close();
lbl47:
                                    // 3 sources

                                    throw var12_14;
                                }
                                catch (Throwable var15_18) lbl-1000:
                                // 2 sources

                                {
                                    throw var15_19;
                                }
                                {
                                    catch (IOException var16_21) {
                                        ** continue;
                                    }
                                }
                                break;
                            }
                        }
                    }
                    var1_1.close();
                    ** GOTO lbl30
                    {
                        catch (IOException var14_17) {
                            ** continue;
                        }
                    }
                    break;
                }
            }
            catch (Throwable var12_15) {
                var1_1 = var3_3;
                ** continue;
            }
            catch (IOException var18_23) {
                var1_1 = var3_3;
                ** continue;
            }
            catch (FileNotFoundException var19_24) {
                var1_1 = var3_3;
                ** continue;
            }
            catch (Throwable var15_20) {
                var20_25 = var3_3;
                ** continue;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void addRemoteDeviceProperties(String string2, String[] stringArray) {
        synchronized (this) {
            Map<String, String> map = this.mDeviceProperties.get(string2);
            if (map == null) {
                map = new HashMap<String, String>();
            }
            int n = 0;
            while (true) {
                int n2;
                if (n >= (n2 = stringArray.length)) {
                    Map<String, String> map2 = this.mDeviceProperties.put(string2, map);
                    this.updateDeviceServiceChannelCache(string2);
                    return;
                }
                String string3 = stringArray[n];
                String string4 = null;
                if (string3 == null) {
                    String string5 = "Error: Remote Device Property at index" + n + "is null";
                    int n3 = Log.e("BluetoothService", string5);
                } else {
                    if (string3.equals("UUIDs") || string3.equals("Nodes")) {
                        StringBuilder stringBuilder = new StringBuilder();
                        int n4 = Integer.valueOf(stringArray[++n]);
                        for (int i = 0; i < n4; ++i) {
                            String string6 = stringArray[++n];
                            StringBuilder stringBuilder2 = stringBuilder.append(string6);
                            StringBuilder stringBuilder3 = stringBuilder.append(",");
                        }
                        if (n4 > 0) {
                            string4 = stringBuilder.toString();
                        }
                    } else {
                        string4 = stringArray[++n];
                    }
                    String string7 = map.put(string3, string4);
                }
                ++n;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int addRfcommServiceRecord(String string2, ParcelUuid parcelUuid, int n, IBinder iBinder) {
        synchronized (this) {
            block10: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH", "Need BLUETOOTH permission");
                boolean bl = this.isEnabledInternal();
                if (bl) break block10;
                return -1;
            }
            if (string2 == null) return -1;
            if (parcelUuid == null) return -1;
            if (n < 1) return -1;
            if (n > 30) {
                return -1;
            }
            if (BluetoothUuid.isUuidPresent(BluetoothUuid.RESERVED_UUIDS, parcelUuid)) {
                String string3 = "Attempted to register a reserved UUID: " + parcelUuid;
                int n2 = Log.w("BluetoothService", string3);
                return -1;
            }
            long l = parcelUuid.getUuid().getMostSignificantBits();
            long l2 = parcelUuid.getUuid().getLeastSignificantBits();
            short s = (short)n;
            BluetoothService bluetoothService = this;
            String string4 = string2;
            int n3 = bluetoothService.addRfcommServiceRecordNative(string4, l, l2, s);
            StringBuilder stringBuilder = new StringBuilder().append("new handle ");
            String string5 = Integer.toHexString(n3);
            BluetoothService.log(stringBuilder.append(string5).toString());
            if (n3 == -1) {
                return -1;
            }
            int n4 = Binder.getCallingPid();
            HashMap<Integer, Integer> hashMap = this.mServiceRecordToPid;
            Integer n5 = new Integer(n3);
            Integer n6 = new Integer(n4);
            Integer n7 = hashMap.put(n5, n6);
            try {
                Reaper reaper = new Reaper(n3, n4);
                iBinder.linkToDeath(reaper, 0);
                return n3;
            }
            catch (RemoteException remoteException) {
                return n3;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean attemptAutoPair(String string2) {
        synchronized (this) {
            if (this.mBondState.hasAutoPairingFailed(string2)) return false;
            if (this.mBondState.isAutoPairingBlacklisted(string2)) return false;
            this.mBondState.attempt(string2);
            byte[] byArray = BluetoothDevice.convertPinToBytes("0000");
            boolean bl = this.setPin(string2, byArray);
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean cancelBondProcess(String string2) {
        synchronized (this) {
            block6: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH_ADMIN", "Need BLUETOOTH_ADMIN permission");
                boolean bl = this.isEnabledInternal();
                if (bl) break block6;
                return false;
            }
            if (!BluetoothAdapter.checkBluetoothAddress(string2)) {
                return false;
            }
            if (this.mBondState.getBondState(string2 = string2.toUpperCase()) != 11) {
                return false;
            }
            this.mBondState.setBondState(string2, 10, 3);
            boolean bl = this.cancelDeviceCreationNative(string2);
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean cancelDiscovery() {
        synchronized (this) {
            boolean bl;
            block4: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH_ADMIN", "Need BLUETOOTH_ADMIN permission");
                bl = this.isEnabledInternal();
                if (bl) break block4;
                return false;
            }
            bl = this.stopDiscoveryNative();
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean cancelPairingUserInput(String string2) {
        synchronized (this) {
            boolean bl;
            block6: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH_ADMIN", "Need BLUETOOTH_ADMIN permission");
                bl = this.isEnabledInternal();
                if (bl) break block6;
                return false;
            }
            if (!BluetoothAdapter.checkBluetoothAddress(string2)) {
                return false;
            }
            this.mBondState.setBondState(string2, 10, 3);
            string2 = string2.toUpperCase();
            Integer n = this.mEventLoop.getPasskeyAgentRequestData().remove(string2);
            if (n == null) {
                String string3 = "cancelUserInputNative(" + string2 + ") called but no native data " + "available, ignoring. Maybe the PasskeyAgent Request was already cancelled " + "by the remote or by bluez.\n";
                int n2 = Log.w("BluetoothService", string3);
                return false;
            }
            int n3 = n;
            bl = this.cancelPairingUserInputNative(string2, n3);
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean connectHeadset(String string2) {
        BluetoothDeviceProfileState bluetoothDeviceProfileState = this.mDeviceProfileState.get(string2);
        if (bluetoothDeviceProfileState == null) return false;
        Message message = new Message();
        message.arg1 = 1;
        message.obj = bluetoothDeviceProfileState;
        this.mHfpProfileState.sendMessage(message);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean connectSink(String string2) {
        BluetoothDeviceProfileState bluetoothDeviceProfileState = this.mDeviceProfileState.get(string2);
        if (bluetoothDeviceProfileState == null) return false;
        Message message = new Message();
        message.arg1 = 3;
        message.obj = bluetoothDeviceProfileState;
        this.mA2dpProfileState.sendMessage(message);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean createBond(String string2) {
        synchronized (this) {
            block5: {
                boolean bl = this.isBondingFeasible(string2);
                if (bl) break block5;
                return false;
            }
            int n = 60000;
            if (!this.createPairedDeviceNative(string2, n)) {
                return false;
            }
            BondState.access$2300((BondState)this.mBondState, (String)string2);
            this.mBondState.setBondState(string2, 11);
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean createBondOutOfBand(String string2, byte[] byArray, byte[] byArray2) {
        synchronized (this) {
            block5: {
                boolean bl = this.isBondingFeasible(string2);
                if (bl) break block5;
                return false;
            }
            int n = 60000;
            if (!this.createPairedDeviceOutOfBandNative(string2, n)) {
                return false;
            }
            boolean bl = this.setDeviceOutOfBandData(string2, byArray, byArray2);
            BondState.access$2300((BondState)this.mBondState, (String)string2);
            this.mBondState.setBondState(string2, 11);
            return true;
        }
    }

    public boolean disable() {
        return this.disable(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean disable(boolean bl) {
        int n = 0;
        synchronized (this) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH_ADMIN", "Need BLUETOOTH_ADMIN permission");
            Object object = this.mBluetoothState;
            switch (object) {
                default: {
                    return false;
                }
                case 10: {
                    return true;
                }
                case 12: 
            }
            if (this.mEnableThread != null && this.mEnableThread.isAlive()) {
                return false;
            }
            this.setBluetoothState(13);
            this.mHandler.removeMessages(1);
            object = this.mHandler;
            Handler handler = this.mHandler;
            int n2 = 2;
            if (bl) {
                n = 1;
            }
            Message message = handler.obtainMessage(n2, n, 0);
            boolean bl2 = ((Handler)object).sendMessageDelayed(message, 3000L);
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean disconnectHeadset(String string2) {
        BluetoothDeviceProfileState bluetoothDeviceProfileState = this.mDeviceProfileState.get(string2);
        if (bluetoothDeviceProfileState == null) return false;
        Message message = new Message();
        message.arg1 = 5;
        message.obj = bluetoothDeviceProfileState;
        this.mHfpProfileState.sendMessage(message);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean disconnectSink(String string2) {
        BluetoothDeviceProfileState bluetoothDeviceProfileState = this.mDeviceProfileState.get(string2);
        if (bluetoothDeviceProfileState == null) return false;
        Message message = new Message();
        message.arg1 = 7;
        message.obj = bluetoothDeviceProfileState;
        this.mA2dpProfileState.sendMessage(message);
        return true;
    }

    native boolean discoverServicesNative(String var1, String var2);

    /*
     * Unable to fully structure code
     */
    @Override
    protected void dump(FileDescriptor var1_1, PrintWriter var2_2, String[] var3_3) {
        block25: {
            block0 : switch (this.mBluetoothState) lbl-1000:
            // 2 sources

            {
                default: {
                    var4_6 = new StringBuilder().append("mIsAirplaneSensitive = ");
                    var5_7 = this.mIsAirplaneSensitive;
                    var6_8 = var4_6.append(var5_7).toString();
                    var7_9 = var2_2;
                    var8_10 = var6_8;
                    var7_9.println(var8_10);
                    var9_11 = new StringBuilder().append("mIsAirplaneToggleable = ");
                    var10_12 = this.mIsAirplaneToggleable;
                    var11_13 = var9_11.append(var10_12).toString();
                    var12_14 = var2_2;
                    var13_15 = var11_13;
                    var12_14.println(var13_15);
                    var14_16 = new StringBuilder().append("Local address = ");
                    var15_17 = this.getAddress();
                    var16_18 = var14_16.append(var15_17).toString();
                    var17_19 = var2_2;
                    var18_20 = var16_18;
                    var17_19.println(var18_20);
                    var19_21 = new StringBuilder().append("Local name = ");
                    var20_22 = this.getName();
                    var21_23 = var19_21.append(var20_22).toString();
                    var22_24 = var2_2;
                    var23_25 = var21_23;
                    var22_24.println(var23_25);
                    var24_26 = new StringBuilder().append("isDiscovering() = ");
                    var25_27 = this.isDiscovering();
                    var26_28 = var24_26.append(var25_27).toString();
                    var27_29 = var2_2;
                    var28_30 = var26_28;
                    var27_29.println(var28_30);
                    var30_32 = this.mContext;
                    var31_33 = var29_31;
                    var32_34 = var30_32;
                    var33_35 = null;
                    var31_33(var32_34, var33_35);
                    var34_36 = var2_2;
                    var35_37 = "\n--Known devices--";
                    var34_36.println(var35_37);
                    block13: for (String var37_40 : this.mDeviceProperties.keySet()) {
                        var38_41 = this.mBondState;
                        var39_42 = var37_40;
                        var40_43 = var38_41.getBondState(var39_42);
                        var41_44 = new Object[4];
                        var41_44[0] = var37_40;
                        var42_45 = BluetoothService.toBondStateString(var40_43);
                        var41_44[1] = var42_45;
                        var43_46 = this.mBondState;
                        var44_47 = var37_40;
                        var45_48 = var43_46.getAttempt(var44_47);
                        var41_44[2] = var45_48;
                        var46_49 = this;
                        var47_50 = var37_40;
                        var48_51 = var46_49.getRemoteName(var47_50);
                        var41_44[3] = var48_51;
                        var49_52 = var2_2;
                        var50_53 = "%s %10s (%d) %s\n";
                        var51_54 = var41_44;
                        var52_55 = var49_52.printf(var50_53, var51_54);
                        var53_56 = this.mDeviceServiceChannelCache;
                        var54_57 = var37_40;
                        var55_58 = var53_56.get(var54_57);
                        if (var55_58 != null) break block0;
                        var56_59 = var2_2;
                        var57_60 = "\tuuids = null";
                        var56_59.println(var57_60);
                        while (true) {
                            for (RemoteService var59_62 : this.mUuidCallbackTracker.keySet()) {
                                var60_63 = var59_62.address;
                                var61_64 = var37_40;
                                if (!var60_63.equals(var61_64)) continue;
                                var62_65 = new StringBuilder().append("\tPENDING CALLBACK: ");
                                var63_66 = var59_62.uuid;
                                var64_67 = var62_65.append(var63_66).toString();
                                var65_68 = var2_2;
                                var66_69 = var64_67;
                                var65_68.println(var66_69);
                            }
                            continue block13;
                            break;
                        }
                    }
                    break block25;
                }
                case 10: {
                    var67_87 = var2_2;
                    var68_88 = "Bluetooth OFF\n";
                    var67_87.println(var68_88);
                    return;
                }
                case 11: {
                    var69_89 = var2_2;
                    var70_90 = "Bluetooth TURNING ON\n";
                    var69_89.println(var70_90);
                    return;
                }
                case 13: {
                    var71_91 = var2_2;
                    var72_92 = "Bluetooth TURNING OFF\n";
                    var71_91.println(var72_92);
                    return;
                }
                case 12: {
                    var73_4 = var2_2;
                    var74_5 = "Bluetooth ON\n";
                    var73_4.println(var74_5);
                    ** GOTO lbl-1000
                }
            }
            var75_70 = var55_58.keySet().iterator();
            while (true) lbl-1000:
            // 3 sources

            {
                if (!var75_70.hasNext()) ** continue;
                var77_72 = var55_58;
                var76_71 = var75_70.next();
                var78_73 = var76_71;
                var79_74 = var77_72.get(var78_73);
                if (var79_74 == null) {
                    var80_75 = new StringBuilder().append("\t");
                    var81_76 = var76_71;
                    var82_77 = var80_75.append(var81_76).toString();
                    var83_78 = var2_2;
                    var84_79 = var82_77;
                    var83_78.println(var84_79);
                    ** continue;
                }
                var85_80 = new StringBuilder().append("\t");
                var86_81 = var76_71;
                var87_82 = var85_80.append(var86_81).append(" RFCOMM channel = ");
                var88_83 = var79_74;
                var89_84 = var87_82.append(var88_83).toString();
                var90_85 = var2_2;
                var91_86 = var89_84;
                var90_85.println(var91_86);
            }
        }
        var92_93 = this;
        var93_94 = "Devices";
        var94_95 = var92_93.getProperty(var93_94);
        var95_96 = null;
        if (var94_95 != null) {
            var95_96 = var94_95.split(",");
        }
        var96_97 = var2_2;
        var97_98 = "\n--ACL connected devices--";
        var96_97.println(var97_98);
        if (var95_96 != null) {
            for (String var100_101 : var95_96) {
                var101_102 = this;
                var102_103 = var100_101;
                var103_104 = var101_102.getAddressFromObjectPath(var102_103);
                var104_105 = var2_2;
                var105_106 = var103_104;
                var104_105.println(var105_106);
            }
        }
        var106_107 = var2_2;
        var107_108 = "\n--Headset Service--";
        var106_107.println(var107_108);
        var108_109 = var29_31.getCurrentHeadset();
        var109_110 = var29_31;
        var110_111 = var108_109;
        switch (var109_110.getState(var110_111)) lbl-1000:
        // 4 sources

        {
            default: lbl-1000:
            // 2 sources

            {
                while (true) {
                    var111_120 = new StringBuilder().append("\ngetCurrentHeadset() = ");
                    var112_121 = var29_31.getCurrentHeadset();
                    var113_122 = var111_120.append(var112_121).toString();
                    var114_123 = var2_2;
                    var115_124 = var113_122;
                    var114_123.println(var115_124);
                    var116_125 = new StringBuilder().append("getBatteryUsageHint() = ");
                    var117_126 = var29_31.getBatteryUsageHint();
                    var118_127 = var116_125.append(var117_126).toString();
                    var119_128 = var2_2;
                    var120_129 = var118_127;
                    var119_128.println(var120_129);
                    var29_31.close();
                    var121_130 = var2_2;
                    var122_131 = "\n--Application Service Records--";
                    var121_130.println(var122_131);
                    var123_132 = this.mServiceRecordToPid.keySet().iterator();
                    while (true) {
                        if (!var123_132.hasNext()) {
                            return;
                        }
                        var124_133 = var123_132.next();
                        var125_134 = this.mServiceRecordToPid;
                        var126_135 = var124_133;
                        var127_136 = var125_134.get(var126_135);
                        var128_137 = new StringBuilder().append("\tpid ");
                        var129_138 = var127_136;
                        var130_139 = var128_137.append(var129_138).append(" handle ");
                        var131_140 = Integer.toHexString(var124_133);
                        var132_141 = var130_139.append(var131_140).toString();
                        var133_142 = var2_2;
                        var134_143 = var132_141;
                        var133_142.println(var134_143);
                    }
                    break;
                }
            }
            case 0: {
                var135_112 = var2_2;
                var136_113 = "getState() = STATE_DISCONNECTED";
                var135_112.println(var136_113);
                ** GOTO lbl-1000
            }
            case 1: {
                var137_114 = var2_2;
                var138_115 = "getState() = STATE_CONNECTING";
                var137_114.println(var138_115);
                ** GOTO lbl-1000
            }
            case 2: {
                var139_116 = var2_2;
                var140_117 = "getState() = STATE_CONNECTED";
                var139_116.println(var140_117);
                ** GOTO lbl-1000
            }
            case -1: 
        }
        var141_118 = var2_2;
        var142_119 = "getState() = STATE_ERROR";
        var141_118.println(var142_119);
        ** while (true)
    }

    @Override
    public boolean enable() {
        return this.enable(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean enable(boolean bl) {
        synchronized (this) {
            EnableThread enableThread;
            block6: {
                boolean bl2;
                this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH_ADMIN", "Need BLUETOOTH_ADMIN permission");
                if (!this.mIsAirplaneSensitive || !this.isAirplaneModeOn() || (bl2 = this.mIsAirplaneToggleable)) break block6;
                return false;
            }
            if (this.mBluetoothState != 10) {
                return false;
            }
            if (this.mEnableThread != null && this.mEnableThread.isAlive()) {
                return false;
            }
            this.setBluetoothState(11);
            this.mEnableThread = enableThread = new EnableThread(bl);
            this.mEnableThread.start();
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean fetchRemoteUuids(String string2, ParcelUuid parcelUuid, IBluetoothCallback iBluetoothCallback) {
        synchronized (this) {
            boolean bl;
            this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH", "Need BLUETOOTH permission");
            boolean bl2 = this.isEnabledInternal();
            if (!bl2) {
                return false;
            }
            if (!BluetoothAdapter.checkBluetoothAddress(string2)) {
                return false;
            }
            RemoteService remoteService = new RemoteService(string2, parcelUuid);
            if (parcelUuid != null && this.mUuidCallbackTracker.get(remoteService) != null) {
                return false;
            }
            if (this.mUuidIntentTracker.contains(string2)) {
                if (parcelUuid == null) return true;
                HashMap<RemoteService, IBluetoothCallback> hashMap = this.mUuidCallbackTracker;
                RemoteService remoteService2 = new RemoteService(string2, parcelUuid);
                IBluetoothCallback iBluetoothCallback2 = hashMap.put(remoteService2, iBluetoothCallback);
                return true;
            }
            if (this.isRemoteDeviceInCache(string2) && this.getRemoteUuids(string2) != null) {
                String string3 = this.getObjectPathFromAddress(string2);
                if (string3 == null) {
                    return false;
                }
                bl = this.discoverServicesNative(string3, "");
            } else {
                bl = bl2 = this.createDeviceNative(string2);
            }
            boolean bl3 = this.mUuidIntentTracker.add(string2);
            if (parcelUuid != null) {
                HashMap<RemoteService, IBluetoothCallback> hashMap = this.mUuidCallbackTracker;
                RemoteService remoteService3 = new RemoteService(string2, parcelUuid);
                IBluetoothCallback iBluetoothCallback3 = hashMap.put(remoteService3, iBluetoothCallback);
            }
            Message message = this.mHandler.obtainMessage(3);
            message.obj = string2;
            boolean bl4 = this.mHandler.sendMessageDelayed(message, 6000L);
            return bl;
        }
    }

    @Override
    protected void finalize() throws Throwable {
        Context context = this.mContext;
        BroadcastReceiver broadcastReceiver = this.mReceiver;
        context.unregisterReceiver(broadcastReceiver);
        try {
            this.cleanupNativeDataNative();
            return;
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public String getAddress() {
        synchronized (this) {
            String string2;
            this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH", "Need BLUETOOTH permission");
            String string3 = string2 = this.getProperty("Address");
            return string3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getAddressFromObjectPath(String string2) {
        String string3 = this.getPropertyInternal("ObjectPath");
        if (string3 == null || string2 == null) {
            String string4 = "getAddressFromObjectPath: AdapterObjectPath:" + string3 + "  or deviceObjectPath:" + string2 + " is null";
            int n = Log.e("BluetoothService", string4);
            return null;
        }
        if (!string2.startsWith(string3)) {
            String string5 = "getAddressFromObjectPath: AdapterObjectPath:" + string3 + "  is not a prefix of deviceObjectPath:" + string2 + "bluetoothd crashed ?";
            int n = Log.e("BluetoothService", string5);
            return null;
        }
        int n = string3.length();
        String string6 = string2.substring(n);
        if (string6 != null) {
            return string6.replace('_', ':');
        }
        int n2 = Log.e("BluetoothService", "getAddressFromObjectPath: Address being returned is null");
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void getAllProperties() {
        synchronized (this) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH", "Need BLUETOOTH permission");
            this.mAdapterProperties.clear();
            var1_1 = (String[])this.getAdapterPropertiesNative();
            if (var1_1 == null) {
                var2_2 = Log.e("BluetoothService", "*Error*: GetAdapterProperties returned NULL");
lbl7:
                // 3 sources

                return;
            }
            for (var3_3 = 0; var3_3 < (var4_4 = var1_1.length); ++var3_3) {
                var5_5 = var1_1[var3_3];
                var6_6 = null;
                if (var5_5 == null) {
                    var7_7 = "Error:Adapter Property at index" + var3_3 + "is null";
                    var8_8 = Log.e("BluetoothService", var7_7);
                    continue;
                }
                if (var5_5.equals("Devices") || var5_5.equals("UUIDs")) {
                    var9_9 = new StringBuilder();
                    var10_10 = Integer.valueOf(var1_1[++var3_3]);
                    for (var11_11 = 0; var11_11 < var10_10; ++var11_11) {
                        var12_12 = var1_1[++var3_3];
                        var13_13 = var9_9.append(var12_12);
                        var14_14 = var9_9.append(",");
                    }
                    if (var10_10 > 0) {
                        var6_6 = var9_9.toString();
                    }
                } else {
                    var6_6 = var1_1[++var3_3];
                }
                var15_15 = this.mAdapterProperties.put(var5_5, var6_6);
            }
            var17_16 = this.getAdapterPathNative();
            if (var17_16 == null) ** GOTO lbl7
            var18_17 = this.mAdapterProperties;
            var19_18 = var17_16 + "/dev_";
            var20_19 = var18_17.put("ObjectPath", var19_18);
            ** continue;
        }
    }

    @Override
    public int getBluetoothState() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH", "Need BLUETOOTH permission");
        return this.mBluetoothState;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getBondState(String string2) {
        synchronized (this) {
            int n;
            block4: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH", "Need BLUETOOTH permission");
                n = BluetoothAdapter.checkBluetoothAddress(string2);
                if (n != 0) break block4;
                return Integer.MIN_VALUE;
            }
            BondState bondState = this.mBondState;
            String string3 = string2.toUpperCase();
            n = bondState.getBondState(string3);
            return n;
        }
    }

    Pair<byte[], byte[]> getDeviceOutOfBandData(BluetoothDevice bluetoothDevice) {
        HashMap<String, Pair<byte[], byte[]>> hashMap = this.mDeviceOobData;
        String string2 = bluetoothDevice.getAddress();
        return hashMap.get(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getDiscoverableTimeout() {
        synchronized (this) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH", "Need BLUETOOTH permission");
            String string2 = this.getProperty("DiscoverableTimeout");
            if (string2 == null) return -1;
            int n = Integer.valueOf(string2);
            return n;
        }
    }

    String getDockPin() {
        synchronized (this) {
            String string2 = this.mDockPin;
            return string2;
        }
    }

    @Override
    public String getName() {
        synchronized (this) {
            String string2;
            this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH", "Need BLUETOOTH permission");
            String string3 = string2 = this.getProperty("Name");
            return string3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getObjectPathFromAddress(String string2) {
        String string3 = this.getPropertyInternal("ObjectPath");
        if (string3 == null) {
            int n = Log.e("BluetoothService", "Error: Object Path is null");
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder().append(string3);
        String string4 = string2.replace(":", "_");
        return stringBuilder.append(string4).toString();
    }

    String getPendingOutgoingBonding() {
        synchronized (this) {
            String string2;
            String string3 = string2 = this.mBondState.getPendingOutgoingBonding();
            return string3;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getProperty(String string2) {
        synchronized (this) {
            void var3_5;
            boolean bl = this.isEnabledInternal();
            if (bl == null) {
                Object var3_4 = null;
            } else {
                String string3;
                String string4 = string3 = this.getPropertyInternal(string2);
            }
            return var3_5;
        }
    }

    String getPropertyInternal(String string2) {
        synchronized (this) {
            String string3;
            if (!this.mAdapterProperties.isEmpty()) {
                string3 = this.mAdapterProperties.get(string2);
                return string3;
            }
            this.getAllProperties();
            string3 = this.mAdapterProperties.get(string2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getRemoteClass(String string2) {
        synchronized (this) {
            block4: {
                if (BluetoothAdapter.checkBluetoothAddress(string2)) break block4;
                this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH", "Need BLUETOOTH permission");
                return -16777216;
            }
            String string3 = this.getRemoteDeviceProperty(string2, "Class");
            int n = Integer.valueOf(string3);
            if (string3 != null) return n;
            return -16777216;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String[] getRemoteDeviceProperties(String string2) {
        if (!this.isEnabledInternal()) {
            return null;
        }
        String string3 = this.getObjectPathFromAddress(string2);
        return (String[])this.getDevicePropertiesNative(string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getRemoteDeviceProperty(String string2, String string3) {
        synchronized (this) {
            block5: {
                Map<String, String> map = this.mDeviceProperties.get(string2);
                if (map == null) break block5;
                return map.get(string3);
            }
            if (this.updateRemoteDevicePropertiesCache(string2)) {
                return this.getRemoteDeviceProperty(string2, string3);
            }
            String string4 = "getRemoteDeviceProperty: " + string3 + "not present:" + string2;
            int n = Log.e("BluetoothService", string4);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getRemoteName(String string2) {
        synchronized (this) {
            void var3_5;
            this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH", "Need BLUETOOTH permission");
            boolean bl = BluetoothAdapter.checkBluetoothAddress(string2);
            if (bl == null) {
                Object var3_4 = null;
            } else {
                String string3;
                String string4 = string3 = this.getRemoteDeviceProperty(string2, "Name");
            }
            return var3_5;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getRemoteServiceChannel(String string2, ParcelUuid parcelUuid) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH", "Need BLUETOOTH permission");
        if (!this.isEnabledInternal()) {
            return -1;
        }
        if (!BluetoothAdapter.checkBluetoothAddress(string2)) {
            return Integer.MIN_VALUE;
        }
        if (this.mDeviceProperties.isEmpty() && !this.updateRemoteDevicePropertiesCache(string2)) {
            return -1;
        }
        Map<ParcelUuid, Integer> map = this.mDeviceServiceChannelCache.get(string2);
        if (map == null) return -1;
        if (!map.containsKey(parcelUuid)) return -1;
        return map.get(parcelUuid);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ParcelUuid[] getRemoteUuids(String string2) {
        synchronized (this) {
            void var3_5;
            this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH", "Need BLUETOOTH permission");
            boolean bl = BluetoothAdapter.checkBluetoothAddress(string2);
            if (bl == null) {
                Object var3_4 = null;
            } else {
                ParcelUuid[] parcelUuidArray;
                ParcelUuid[] parcelUuidArray2 = parcelUuidArray = this.getUuidFromCache(string2);
            }
            return var3_5;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getScanMode() {
        synchronized (this) {
            int n;
            block4: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH", "Need BLUETOOTH permission");
                n = this.isEnabledInternal();
                if (n != 0) break block4;
                return 20;
            }
            boolean bl = this.getProperty("Pairable").equals("true");
            boolean bl2 = this.getProperty("Discoverable").equals("true");
            n = BluetoothService.bluezStringToScanMode(bl, bl2);
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getTrustState(String string2) {
        synchronized (this) {
            block5: {
                if (BluetoothAdapter.checkBluetoothAddress(string2)) break block5;
                this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH", "Need BLUETOOTH permission");
                return false;
            }
            String string3 = this.getRemoteDeviceProperty(string2, "Trusted");
            if (string3 == null) {
                return false;
            }
            boolean bl = string3.equals("true");
            if (!bl) return false;
            return true;
        }
    }

    public void initAfterRegistration() {
        synchronized (this) {
            BluetoothEventLoop bluetoothEventLoop;
            BluetoothAdapter bluetoothAdapter;
            this.mAdapter = bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            Context context = this.mContext;
            BluetoothAdapter bluetoothAdapter2 = this.mAdapter;
            this.mEventLoop = bluetoothEventLoop = new BluetoothEventLoop(context, bluetoothAdapter2, this);
            return;
        }
    }

    boolean isAdapterPropertiesEmpty() {
        synchronized (this) {
            boolean bl;
            boolean bl2 = bl = this.mAdapterProperties.isEmpty();
            return bl2;
        }
    }

    @Override
    public boolean isBluetoothDock(String string2) {
        synchronized (this) {
            boolean bl;
            Context context = this.mContext;
            Context context2 = this.mContext;
            SharedPreferences sharedPreferences = context.getSharedPreferences("bluetooth_service_settings", 0);
            String string3 = "dock_bluetooth_address" + string2;
            boolean bl2 = bl = sharedPreferences.contains(string3);
            return bl2;
        }
    }

    @Override
    public boolean isDiscovering() {
        synchronized (this) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH", "Need BLUETOOTH permission");
            boolean bl = this.mIsDiscovering;
            return bl;
        }
    }

    @Override
    public boolean isEnabled() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH", "Need BLUETOOTH permission");
        return this.isEnabledInternal();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isRemoteDeviceInCache(String string2) {
        if (this.mDeviceProperties.get(string2) == null) return false;
        return true;
    }

    @Override
    public String[] listBonds() {
        synchronized (this) {
            String[] stringArray;
            this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH", "Need BLUETOOTH permission");
            String[] stringArray2 = stringArray = this.mBondState.listInState(12);
            return stringArray2;
        }
    }

    String[] listInState(int n) {
        synchronized (this) {
            String[] stringArray;
            String[] stringArray2 = stringArray = this.mBondState.listInState(n);
            return stringArray2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void makeServiceChannelCallbacks(String string2) {
        synchronized (this) {
            Iterator<RemoteService> iterator = this.mUuidCallbackTracker.keySet().iterator();
            while (iterator.hasNext()) {
                RemoteService remoteService = iterator.next();
                if (!remoteService.address.equals(string2)) continue;
                StringBuilder stringBuilder = new StringBuilder().append("Cleaning up failed UUID channel lookup: ");
                String string3 = remoteService.address;
                StringBuilder stringBuilder2 = stringBuilder.append(string3).append(" ");
                ParcelUuid parcelUuid = remoteService.uuid;
                BluetoothService.log(stringBuilder2.append(parcelUuid).toString());
                IBluetoothCallback iBluetoothCallback = this.mUuidCallbackTracker.get(remoteService);
                if (iBluetoothCallback != null) {
                    int n = -1;
                    try {
                        iBluetoothCallback.onRfcommChannelFound(n);
                    }
                    catch (RemoteException remoteException) {
                        int n2 = Log.e("BluetoothService", "", remoteException);
                    }
                }
                iterator.remove();
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean notifyIncomingA2dpConnection(String string2) {
        BluetoothDeviceProfileState bluetoothDeviceProfileState = this.mDeviceProfileState.get(string2);
        if (bluetoothDeviceProfileState == null) return false;
        Message message = new Message();
        message.what = 4;
        bluetoothDeviceProfileState.sendMessage(message);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean notifyIncomingConnection(String string2) {
        BluetoothDeviceProfileState bluetoothDeviceProfileState = this.mDeviceProfileState.get(string2);
        if (bluetoothDeviceProfileState == null) return false;
        Message message = new Message();
        message.what = 2;
        bluetoothDeviceProfileState.sendMessage(message);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void onCreatePairedDeviceResult(String string2, int n) {
        synchronized (this) {
            if (n == 0) {
                int n2 = 12;
                boolean bl = this.setBondState(string2, n2);
                if (this.mBondState.isAutoPairingAttemptsInProgress(string2)) {
                    this.mBondState.clearPinAttempts(string2);
                }
            } else if (n == 1 && this.mBondState.getAttempt(string2) == 1) {
                this.mBondState.addAutoPairingFailure(string2);
                this.pairingAttempt(string2, n);
            } else if (n == 4 && this.mBondState.isAutoPairingAttemptsInProgress(string2)) {
                this.pairingAttempt(string2, n);
            } else {
                boolean bl = this.setBondState(string2, 10, n);
                if (this.mBondState.isAutoPairingAttemptsInProgress(string2)) {
                    this.mBondState.clearPinAttempts(string2);
                }
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] readOutOfBandData() {
        synchronized (this) {
            void var2_4;
            this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH", "Need BLUETOOTH permission");
            boolean bl = this.isEnabledInternal();
            if (bl == null) {
                Object var2_3 = null;
            } else {
                byte[] byArray;
                byte[] byArray2 = byArray = this.readAdapterOutOfBandDataNative();
            }
            return var2_4;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean removeBond(String string2) {
        synchronized (this) {
            block5: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH_ADMIN", "Need BLUETOOTH_ADMIN permission");
                boolean bl = this.isEnabledInternal();
                if (bl) break block5;
                return false;
            }
            if (!BluetoothAdapter.checkBluetoothAddress(string2)) {
                return false;
            }
            BluetoothDeviceProfileState bluetoothDeviceProfileState = this.mDeviceProfileState.get(string2);
            if (bluetoothDeviceProfileState == null) return false;
            bluetoothDeviceProfileState.sendMessage(100);
            return true;
        }
    }

    public boolean removeBondInternal(String string2) {
        synchronized (this) {
            boolean bl;
            String string3 = this.getObjectPathFromAddress(string2);
            boolean bl2 = bl = this.removeDeviceNative(string3);
            return bl2;
        }
    }

    void removeRemoteDeviceProperties(String string2) {
        Map<String, String> map = this.mDeviceProperties.remove(string2);
    }

    @Override
    public void removeServiceRecord(int n) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH", "Need BLUETOOTH permission");
        int n2 = Binder.getCallingPid();
        this.checkAndRemoveRecord(n, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void restart() {
        synchronized (this) {
            int n = this.mBluetoothState;
            if (n == 12) {
                n = 1;
                this.mRestart = n;
                if (!this.disable(false)) {
                    this.mRestart = false;
                }
            }
            return;
        }
    }

    public void sendProfileStateMessage(int n, int n2) {
        Message message = new Message();
        message.what = n2;
        if (n == 0) {
            this.mHfpProfileState.sendMessage(message);
            return;
        }
        if (n != 1) {
            return;
        }
        this.mA2dpProfileState.sendMessage(message);
    }

    void sendUuidIntent(String string2) {
        synchronized (this) {
            Parcelable[] parcelableArray = this.getUuidFromCache(string2);
            Intent intent = new Intent("android.bleutooth.device.action.UUID");
            BluetoothDevice bluetoothDevice = this.mAdapter.getRemoteDevice(string2);
            Intent intent2 = intent.putExtra("android.bluetooth.device.extra.DEVICE", bluetoothDevice);
            Intent intent3 = intent.putExtra("android.bluetooth.device.extra.UUID", parcelableArray);
            this.mContext.sendBroadcast(intent, "android.permission.BLUETOOTH_ADMIN");
            if (this.mUuidIntentTracker.contains(string2)) {
                boolean bl = this.mUuidIntentTracker.remove(string2);
            }
            return;
        }
    }

    void setA2dpService(BluetoothA2dpService bluetoothA2dpService) {
        this.mA2dpService = bluetoothA2dpService;
    }

    boolean setBondState(String string2, int n) {
        synchronized (this) {
            boolean bl;
            boolean bl2 = bl = this.setBondState(string2, n, 0);
            return bl2;
        }
    }

    boolean setBondState(String string2, int n, int n2) {
        synchronized (this) {
            BondState bondState = this.mBondState;
            String string3 = string2.toUpperCase();
            bondState.setBondState(string3, n);
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setDeviceOutOfBandData(String string2, byte[] byArray, byte[] byArray2) {
        synchronized (this) {
            block4: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH_ADMIN", "Need BLUETOOTH_ADMIN permission");
                boolean bl = this.isEnabledInternal();
                if (bl) break block4;
                return false;
            }
            Pair<byte[], byte[]> pair = new Pair<byte[], byte[]>(byArray, byArray2);
            StringBuilder stringBuilder = new StringBuilder().append("Setting out of band data for:").append(string2).append(":");
            String string3 = Arrays.toString(byArray);
            StringBuilder stringBuilder2 = stringBuilder.append(string3).append(":");
            String string4 = Arrays.toString(byArray2);
            BluetoothService.log(stringBuilder2.append(string4).toString());
            Pair<byte[], byte[]> pair2 = this.mDeviceOobData.put(string2, pair);
            return true;
        }
    }

    @Override
    public boolean setDiscoverableTimeout(int n) {
        synchronized (this) {
            boolean bl;
            this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH_ADMIN", "Need BLUETOOTH_ADMIN permission");
            boolean bl2 = bl = this.setPropertyInteger("DiscoverableTimeout", n);
            return bl2;
        }
    }

    void setIsDiscovering(boolean bl) {
        this.mIsDiscovering = bl;
    }

    void setLinkTimeout(String string2, int n) {
        String string3 = this.getObjectPathFromAddress(string2);
        if (this.setLinkTimeoutNative(string3, n)) {
            return;
        }
        BluetoothService.log("Set Link Timeout to:" + n + " slots failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setName(String string2) {
        synchronized (this) {
            block4: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH_ADMIN", "Need BLUETOOTH_ADMIN permission");
                if (string2 != null) break block4;
                return false;
            }
            boolean bl = this.setPropertyString("Name", string2);
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setPairingConfirmation(String string2, boolean bl) {
        synchronized (this) {
            boolean bl2;
            block5: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH_ADMIN", "Need BLUETOOTH_ADMIN permission");
                bl2 = this.isEnabledInternal();
                if (bl2) break block5;
                return false;
            }
            string2 = string2.toUpperCase();
            Integer n = this.mEventLoop.getPasskeyAgentRequestData().remove(string2);
            if (n == null) {
                String string3 = "setPasskey(" + string2 + ") called but no native data available, " + "ignoring. Maybe the PasskeyAgent Request was cancelled by the remote device" + " or by bluez.\n";
                int n2 = Log.w("BluetoothService", string3);
                return false;
            }
            int n3 = n;
            bl2 = this.setPairingConfirmationNative(string2, bl, n3);
            return bl2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setPasskey(String string2, int n) {
        synchronized (this) {
            boolean bl;
            block6: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH_ADMIN", "Need BLUETOOTH_ADMIN permission");
                bl = this.isEnabledInternal();
                if (bl) break block6;
                return false;
            }
            if (n < 0) return false;
            if (n > 999999) return false;
            if (!BluetoothAdapter.checkBluetoothAddress(string2)) {
                return false;
            }
            string2 = string2.toUpperCase();
            Integer n2 = this.mEventLoop.getPasskeyAgentRequestData().remove(string2);
            if (n2 == null) {
                String string3 = "setPasskey(" + string2 + ") called but no native data available, " + "ignoring. Maybe the PasskeyAgent Request was cancelled by the remote device" + " or by bluez.\n";
                int n3 = Log.w("BluetoothService", string3);
                return false;
            }
            int n4 = n2;
            bl = this.setPasskeyNative(string2, n, n4);
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setPin(String string2, byte[] byArray) {
        synchronized (this) {
            boolean bl;
            Integer n;
            block11: {
                block10: {
                    this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH_ADMIN", "Need BLUETOOTH_ADMIN permission");
                    boolean bl2 = this.isEnabledInternal();
                    if (bl2) break block10;
                    return false;
                }
                if (byArray == null) return false;
                if (byArray.length <= 0) return false;
                if (byArray.length > 16) return false;
                if (!BluetoothAdapter.checkBluetoothAddress(string2)) {
                    return false;
                }
                string2 = string2.toUpperCase();
                n = this.mEventLoop.getPasskeyAgentRequestData().remove(string2);
                if (n != null) break block11;
                String string3 = "setPin(" + string2 + ") called but no native data available, " + "ignoring. Maybe the PasskeyAgent Request was cancelled by the remote device" + " or by bluez.\n";
                int n2 = Log.w("BluetoothService", string3);
                return false;
            }
            try {
                String string4 = new String(byArray, "UTF8");
                int n3 = n;
                bl = this.setPinNative(string2, string4, n3);
                return bl;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                int n4 = Log.e("BluetoothService", "UTF8 not supported?!?");
                bl = false;
            }
            return bl;
        }
    }

    void setProperty(String string2, String string3) {
        synchronized (this) {
            String string4 = this.mAdapterProperties.put(string2, string3);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setRemoteDeviceProperty(String string2, String string3, String string4) {
        synchronized (this) {
            Map<String, String> map = this.mDeviceProperties.get(string2);
            if (map != null) {
                String string5 = map.put(string3, string4);
                Map<String, String> map2 = this.mDeviceProperties.put(string2, map);
            } else {
                String string6 = "setRemoteDeviceProperty for a device not in cache:" + string2;
                int n = Log.e("BluetoothService", string6);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setRemoteOutOfBandData(String string2) {
        synchronized (this) {
            byte[] byArray;
            byte[] byArray2;
            this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH_ADMIN", "Need BLUETOOTH_ADMIN permission");
            boolean bl = this.isEnabledInternal();
            if (!bl) {
                return false;
            }
            string2 = string2.toUpperCase();
            Integer n = this.mEventLoop.getPasskeyAgentRequestData().remove(string2);
            if (n == null) {
                String string3 = "setRemoteOobData(" + string2 + ") called but no native data available, " + "ignoring. Maybe the PasskeyAgent Request was cancelled by the remote device" + " or by bluez.\n";
                int n2 = Log.w("BluetoothService", string3);
                return false;
            }
            Pair<byte[], byte[]> pair = this.mDeviceOobData.get(string2);
            if (pair == null) {
                byArray2 = new byte[16];
                byArray = new byte[16];
            } else {
                byArray2 = (byte[])pair.first;
                byArray = (byte[])pair.second;
            }
            int n3 = n;
            return this.setRemoteOutOfBandDataNative(string2, byArray2, byArray, n3);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setScanMode(int n, int n2) {
        synchronized (this) {
            boolean bl;
            boolean bl2;
            this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS", "Need WRITE_SECURE_SETTINGS permission");
            switch (n) {
                default: {
                    String string2 = "Requested invalid scan mode " + n;
                    int n3 = Log.w("BluetoothService", string2);
                    return false;
                }
                case 20: {
                    this.mHandler.removeMessages(4);
                    bl2 = false;
                    bl = false;
                    break;
                }
                case 21: {
                    this.mHandler.removeMessages(4);
                    bl2 = true;
                    bl = false;
                    break;
                }
                case 23: {
                    this.mHandler.removeMessages(4);
                    bl2 = true;
                    bl = true;
                    Message message = this.mHandler.obtainMessage(4);
                    Handler handler = this.mHandler;
                    long l = n2 * 1000;
                    boolean bl3 = handler.sendMessageDelayed(message, l);
                    String string3 = "BT Discoverable for " + n2 + " seconds";
                    int n4 = Log.d("BluetoothService", string3);
                }
            }
            boolean bl4 = this.setPropertyBoolean("Pairable", bl2);
            boolean bl5 = this.setPropertyBoolean("Discoverable", bl);
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setTrust(String string2, boolean bl) {
        synchronized (this) {
            boolean bl2;
            int n;
            block7: {
                if (BluetoothAdapter.checkBluetoothAddress(string2)) break block7;
                this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH_ADMIN", "Need BLUETOOTH_ADMIN permission");
                return false;
            }
            if (!this.isEnabledInternal()) {
                return false;
            }
            String string3 = this.getObjectPathFromAddress(string2);
            String string4 = "Trusted";
            if (bl) {
                n = 1;
                while (true) {
                    bl2 = this.setDevicePropertyBooleanNative(string3, string4, n);
                    return bl2;
                }
            }
            n = 0;
            bl2 = this.setDevicePropertyBooleanNative(string3, string4, n);
            return bl2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean startDiscovery() {
        synchronized (this) {
            boolean bl;
            block4: {
                this.mContext.enforceCallingOrSelfPermission("android.permission.BLUETOOTH_ADMIN", "Need BLUETOOTH_ADMIN permission");
                bl = this.isEnabledInternal();
                if (bl) break block4;
                return false;
            }
            bl = this.startDiscoveryNative();
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void updateDeviceServiceChannelCache(String string2) {
        ParcelUuid[] parcelUuidArray = this.getRemoteUuids(string2);
        StringBuilder stringBuilder = new StringBuilder().append("updateDeviceServiceChannelCache(");
        String string3 = string2;
        BluetoothService.log(stringBuilder.append(string3).append(")").toString());
        ArrayList<ParcelUuid> arrayList = new ArrayList<ParcelUuid>();
        synchronized (this) {
            for (RemoteService remoteService : this.mUuidCallbackTracker.keySet()) {
                String string4 = remoteService.address;
                String string5 = string2;
                if (!string4.equals(string5)) continue;
                ParcelUuid parcelUuid = remoteService.uuid;
                ArrayList<ParcelUuid> arrayList2 = arrayList;
                ParcelUuid parcelUuid2 = parcelUuid;
                boolean bl = arrayList2.add(parcelUuid2);
            }
        }
        HashMap<ParcelUuid, Integer> hashMap = new HashMap<ParcelUuid, Integer>();
        for (ParcelUuid parcelUuid : RFCOMM_UUIDS) {
            if (!BluetoothUuid.isUuidPresent(parcelUuidArray, parcelUuid)) continue;
            String string6 = this.getObjectPathFromAddress(string2);
            String string7 = parcelUuid.toString();
            BluetoothService bluetoothService = this;
            String string8 = string6;
            String string9 = string7;
            int n = 4;
            int n2 = bluetoothService.getDeviceServiceChannelNative(string8, string9, n);
            StringBuilder stringBuilder2 = new StringBuilder().append("\tuuid(system): ");
            ParcelUuid parcelUuid3 = parcelUuid;
            StringBuilder stringBuilder3 = stringBuilder2.append(parcelUuid3).append(" ");
            int n3 = n2;
            BluetoothService.log(stringBuilder3.append(n3).toString());
            Integer n4 = n2;
            HashMap<ParcelUuid, Integer> hashMap2 = hashMap;
            ParcelUuid parcelUuid4 = parcelUuid;
            Integer n5 = n4;
            Integer n6 = hashMap2.put(parcelUuid4, n5);
        }
        for (ParcelUuid parcelUuid : arrayList) {
            if (!BluetoothUuid.isUuidPresent(parcelUuidArray, parcelUuid)) continue;
            String string10 = this.getObjectPathFromAddress(string2);
            String string11 = parcelUuid.toString();
            BluetoothService bluetoothService = this;
            String string12 = string10;
            String string13 = string11;
            int n = 4;
            int n7 = bluetoothService.getDeviceServiceChannelNative(string12, string13, n);
            StringBuilder stringBuilder4 = new StringBuilder().append("\tuuid(application): ");
            ParcelUuid parcelUuid5 = parcelUuid;
            StringBuilder stringBuilder5 = stringBuilder4.append(parcelUuid5).append(" ");
            int n8 = n7;
            BluetoothService.log(stringBuilder5.append(n8).toString());
            Integer n9 = n7;
            HashMap<ParcelUuid, Integer> hashMap3 = hashMap;
            ParcelUuid parcelUuid6 = parcelUuid;
            Integer n10 = n9;
            Integer n11 = hashMap3.put(parcelUuid6, n10);
        }
        synchronized (this) {
            Iterator<RemoteService> iterator = this.mUuidCallbackTracker.keySet().iterator();
            while (true) {
                int n;
                int n12;
                if (!iterator.hasNext()) {
                    HashMap<String, Map<ParcelUuid, Integer>> hashMap4 = this.mDeviceServiceChannelCache;
                    String string14 = string2;
                    HashMap<ParcelUuid, Integer> hashMap5 = hashMap;
                    HashMap hashMap6 = hashMap4.put(string14, hashMap5);
                    return;
                }
                RemoteService remoteService = iterator.next();
                String string15 = remoteService.address;
                String string16 = string2;
                if (!string15.equals(string16)) continue;
                int n13 = -1;
                ParcelUuid parcelUuid = remoteService.uuid;
                if (hashMap.get(parcelUuid) != null) {
                    ParcelUuid parcelUuid7 = remoteService.uuid;
                    n13 = (Integer)hashMap.get(parcelUuid7);
                }
                if ((n12 = n13) == (n = 65535)) continue;
                StringBuilder stringBuilder6 = new StringBuilder().append("Making callback for ");
                ParcelUuid parcelUuid8 = remoteService.uuid;
                StringBuilder stringBuilder7 = stringBuilder6.append(parcelUuid8).append(" with result ");
                int n14 = n13;
                BluetoothService.log(stringBuilder7.append(n14).toString());
                HashMap<RemoteService, IBluetoothCallback> hashMap7 = this.mUuidCallbackTracker;
                RemoteService remoteService2 = remoteService;
                IBluetoothCallback iBluetoothCallback = hashMap7.get(remoteService2);
                if (iBluetoothCallback != null) {
                    try {
                        iBluetoothCallback.onRfcommChannelFound(n13);
                    }
                    catch (RemoteException remoteException) {
                        String string17 = "BluetoothService";
                        String string18 = "";
                        RemoteException remoteException2 = remoteException;
                        int n15 = Log.e(string17, string18, remoteException2);
                    }
                }
                iterator.remove();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean updateRemoteDevicePropertiesCache(String string2) {
        synchronized (this) {
            String[] stringArray = this.getRemoteDeviceProperties(string2);
            if (stringArray == null) return false;
            this.addRemoteDeviceProperties(string2, stringArray);
            return true;
        }
    }

    private class Reaper
    implements IBinder.DeathRecipient {
        int handle;
        int pid;

        Reaper(int n, int n2) {
            this.pid = n2;
            this.handle = n;
        }

        @Override
        public void binderDied() {
            BluetoothService bluetoothService = BluetoothService.this;
            synchronized (bluetoothService) {
                StringBuilder stringBuilder = new StringBuilder().append("Tracked app ");
                int n = this.pid;
                BluetoothService.log(stringBuilder.append(n).append(" died").toString());
                BluetoothService bluetoothService2 = BluetoothService.this;
                int n2 = this.handle;
                int n3 = this.pid;
                bluetoothService2.checkAndRemoveRecord(n2, n3);
                return;
            }
        }
    }

    private class EnableThread
    extends Thread {
        private final boolean mSaveSetting;

        public EnableThread(boolean bl) {
            this.mSaveSetting = bl;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block25: {
                block21: {
                    block22: {
                        block24: {
                            if (BluetoothService.access$300(BluetoothService.this) != 0) break block24;
                            var1_1 = true;
lbl3:
                            // 2 sources

                            while (var1_1) {
                                var2_2 = false;
                                var3_3 = 2;
                                block6: while (true) {
                                    var4_4 = var3_3 + -1;
                                    if (var3_3 <= 0 || var2_2) break block21;
                                    BluetoothService.access$400(BluetoothService.this).start();
                                    var5_5 = 5;
lbl11:
                                    // 2 sources

                                    while (true) {
                                        var6_6 = var5_5 + -1;
                                        if (var5_5 > 0 && !var2_2) {
                                            if (!BluetoothService.access$400(BluetoothService.this).isEventLoopRunning()) break block22;
                                            var2_2 = true;
                                        }
                                        var3_3 = var4_4;
                                        continue block6;
                                        break;
                                    }
                                    break;
                                }
                            }
                            break block25;
                        }
                        var1_1 = false;
                        ** GOTO lbl3
                    }
                    var7_7 = 100L;
                    try {
                        Thread.sleep(var7_7);
                        var5_5 = var6_6;
                    }
                    catch (InterruptedException var9_8) {
                        var5_5 = var6_6;
                    }
                    ** while (true)
                }
                if (!var2_2) {
                    BluetoothService.access$500("bt EnableThread giving up");
                    var1_1 = false;
                    var10_9 = BluetoothService.access$600(BluetoothService.this);
                }
            }
            if (!var1_1) ** GOTO lbl54
            if (!BluetoothService.access$700(BluetoothService.this)) {
                return;
            }
            if (this.mSaveSetting) {
                BluetoothService.access$800(BluetoothService.this, true);
            }
            var11_10 = BluetoothService.access$902(BluetoothService.this, false);
            BluetoothService.access$1000(BluetoothService.this).readAutoPairingData();
            BluetoothService.access$1000(BluetoothService.this).loadBondState();
            BluetoothService.access$1100(BluetoothService.this);
            var12_11 = BluetoothService.access$100(BluetoothService.this);
            var13_12 = BluetoothService.access$100(BluetoothService.this).obtainMessage(1, 1, -1);
            var14_13 = var12_11.sendMessageDelayed(var13_12, 3000L);
            var15_14 = Binder.clearCallingIdentity();
            try {
                BluetoothService.access$1200(BluetoothService.this).noteBluetoothOn();
            }
            catch (Throwable var23_21) {
                Binder.restoreCallingIdentity(var15_14);
                throw var23_21;
            }
lbl52:
            // 2 sources

            while (true) {
                Binder.restoreCallingIdentity(var15_14);
lbl54:
                // 2 sources

                var17_15 = BluetoothService.access$1302(BluetoothService.this, null);
                var18_16 = BluetoothService.this;
                if (var1_1) {
                    var19_17 = 12;
lbl58:
                    // 2 sources

                    while (true) {
                        BluetoothService.access$1400(var18_16, var19_17);
                        if (var1_1) {
                            var21_19 = BluetoothService.this.getProperty("Pairable");
                            var20_18 = new String[]{"Pairable", var21_19};
                            BluetoothService.access$400(BluetoothService.this).onPropertyChanged(var20_18);
                        }
                        if (!BluetoothService.access$1500(BluetoothService.this)) {
                            return;
                        }
                        if (!BluetoothService.access$1600(BluetoothService.this)) {
                            return;
                        }
                        if (BluetoothService.access$1700(BluetoothService.this)) {
                            return;
                        }
                        var22_20 = BluetoothService.this.disable(false);
                        return;
                    }
                }
                break;
            }
            var19_17 = 10;
            ** while (true)
            catch (RemoteException var24_22) {
                ** continue;
            }
        }
    }

    private static class RemoteService {
        public String address;
        public ParcelUuid uuid;

        public RemoteService(String string2, ParcelUuid parcelUuid) {
            this.address = string2;
            this.uuid = parcelUuid;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof RemoteService)) return false;
            RemoteService remoteService = (RemoteService)object;
            String string2 = this.address;
            String string3 = remoteService.address;
            if (!string2.equals(string3)) return false;
            ParcelUuid parcelUuid = this.uuid;
            ParcelUuid parcelUuid2 = remoteService.uuid;
            if (!parcelUuid.equals(parcelUuid2)) return false;
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        public int hashCode() {
            int n;
            int n2 = 1 * 31;
            int n3 = this.address == null ? 0 : this.address.hashCode();
            int n4 = (n3 + 31) * 31;
            if (this.uuid == null) {
                n = 0;
                return n4 + n;
            }
            n = this.uuid.hashCode();
            return n4 + n;
        }
    }
}

