/*
 * Decompiled with CFR 0.152.
 */
package android.server.search;

import android.app.ISearchManager;
import android.app.SearchableInfo;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Process;
import android.server.search.Searchables;
import android.util.Log;
import com.android.internal.content.PackageMonitor;
import java.util.List;

public class SearchManagerService
extends ISearchManager.Stub {
    private static final String TAG = "SearchManagerService";
    private final Context mContext;
    private Searchables mSearchables;

    public SearchManagerService(Context context) {
        Context context2 = this.mContext = context;
        BootCompletedReceiver bootCompletedReceiver = new BootCompletedReceiver();
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BOOT_COMPLETED");
        Intent intent = context2.registerReceiver(bootCompletedReceiver, intentFilter);
    }

    private Searchables getSearchables() {
        synchronized (this) {
            if (this.mSearchables == null) {
                Searchables searchables;
                int n = Log.i(TAG, "Building list of searchable activities");
                MyPackageMonitor myPackageMonitor = new MyPackageMonitor();
                Context context = this.mContext;
                myPackageMonitor.register(context, true);
                Context context2 = this.mContext;
                this.mSearchables = searchables = new Searchables(context2);
                this.mSearchables.buildSearchableList();
            }
            Searchables searchables = this.mSearchables;
            return searchables;
        }
    }

    @Override
    public ComponentName getGlobalSearchActivity() {
        return this.getSearchables().getGlobalSearchActivity();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SearchableInfo getSearchableInfo(ComponentName componentName) {
        if (componentName != null) return this.getSearchables().getSearchableInfo(componentName);
        int n = Log.e(TAG, "getSearchableInfo(), activity == null");
        return null;
    }

    @Override
    public List<SearchableInfo> getSearchablesInGlobalSearch() {
        return this.getSearchables().getSearchablesInGlobalSearchList();
    }

    @Override
    public ComponentName getWebSearchActivity() {
        return this.getSearchables().getWebSearchActivity();
    }

    class MyPackageMonitor
    extends PackageMonitor {
        MyPackageMonitor() {
        }

        @Override
        public void onSomePackagesChanged() {
            SearchManagerService.this.getSearchables().buildSearchableList();
            Intent intent = new Intent("android.search.action.SEARCHABLES_CHANGED");
            Intent intent2 = intent.addFlags(0x20000000);
            SearchManagerService.this.mContext.sendBroadcast(intent);
        }
    }

    private final class BootCompletedReceiver
    extends BroadcastReceiver {
        private BootCompletedReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            new Thread(){

                @Override
                public void run() {
                    Process.setThreadPriority(10);
                    Context context = SearchManagerService.this.mContext;
                    BootCompletedReceiver bootCompletedReceiver = BootCompletedReceiver.this;
                    context.unregisterReceiver(bootCompletedReceiver);
                    Searchables searchables = SearchManagerService.this.getSearchables();
                }
            }.start();
        }
    }
}

