/*
 * Decompiled with CFR 0.152.
 */
package android.server.search;

import android.app.SearchableInfo;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Searchables {
    public static String ENHANCED_GOOGLE_SEARCH_COMPONENT_NAME;
    public static String GOOGLE_SEARCH_COMPONENT_NAME;
    private static final String LOG_TAG = "Searchables";
    private static final String MD_LABEL_DEFAULT_SEARCHABLE = "android.app.default_searchable";
    private static final String MD_SEARCHABLE_SYSTEM_SEARCH = "*";
    private Context mContext;
    private ComponentName mGlobalSearchActivity = null;
    private ArrayList<SearchableInfo> mSearchablesInGlobalSearchList = null;
    private ArrayList<SearchableInfo> mSearchablesList = null;
    private HashMap<ComponentName, SearchableInfo> mSearchablesMap = null;
    private ComponentName mWebSearchActivity = null;

    static {
        GOOGLE_SEARCH_COMPONENT_NAME = "com.android.googlesearch/.GoogleSearch";
        ENHANCED_GOOGLE_SEARCH_COMPONENT_NAME = "com.google.android.providers.enhancedgooglesearch/.Launcher";
    }

    public Searchables(Context context) {
        this.mContext = context;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ComponentName findGlobalSearchActivity() {
        Intent intent = new Intent("android.search.action.GLOBAL_SEARCH");
        PackageManager packageManager = this.mContext.getPackageManager();
        List<ResolveInfo> list = packageManager.queryIntentActivities(intent, 65536);
        int n = list == null ? 0 : list.size();
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                int n3 = Log.w(LOG_TAG, "No global search activity found");
                return null;
            }
            ActivityInfo activityInfo = list.get((int)n2).activityInfo;
            String string2 = activityInfo.packageName;
            if (packageManager.checkPermission("android.permission.GLOBAL_SEARCH", string2) == 0) {
                String string3 = activityInfo.packageName;
                String string4 = activityInfo.name;
                return new ComponentName(string3, string4);
            }
            StringBuilder stringBuilder = new StringBuilder().append("Package ");
            String string5 = activityInfo.packageName;
            String string6 = stringBuilder.append(string5).append(" wants to handle GLOBAL_SEARCH, ").append("but does not have the GLOBAL_SEARCH permission.").toString();
            int n4 = Log.w(LOG_TAG, string6);
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private ComponentName findWebSearchActivity(ComponentName componentName) {
        if (componentName == null) {
            return null;
        }
        Intent intent = new Intent("android.intent.action.WEB_SEARCH");
        String string2 = componentName.getPackageName();
        Intent intent2 = intent.setPackage(string2);
        int n = 0;
        List<ResolveInfo> list = this.mContext.getPackageManager().queryIntentActivities(intent, 65536);
        int n2 = list == null ? 0 : list.size();
        if (n < n2) {
            ActivityInfo activityInfo = list.get((int)n).activityInfo;
            String string3 = activityInfo.packageName;
            String string4 = activityInfo.name;
            return new ComponentName(string3, string4);
        }
        int n3 = Log.w(LOG_TAG, "No web search activity found");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void buildSearchableList() {
        Intent intent;
        Intent intent2;
        HashMap<ComponentName, SearchableInfo> hashMap = new HashMap<ComponentName, SearchableInfo>();
        ArrayList<SearchableInfo> arrayList = new ArrayList<SearchableInfo>();
        ArrayList<SearchableInfo> arrayList2 = new ArrayList<SearchableInfo>();
        PackageManager packageManager = this.mContext.getPackageManager();
        Intent intent3 = intent2;
        String string2 = "android.intent.action.SEARCH";
        intent3(string2);
        PackageManager packageManager2 = packageManager;
        Intent intent4 = intent2;
        int n = 128;
        List<ResolveInfo> list = packageManager2.queryIntentActivities(intent4, n);
        Intent intent5 = intent;
        String string3 = "android.intent.action.WEB_SEARCH";
        intent5(string3);
        PackageManager packageManager3 = packageManager;
        Intent intent6 = intent;
        int n2 = 128;
        List<ResolveInfo> list2 = packageManager3.queryIntentActivities(intent6, n2);
        if (list != null || list2 != null) {
            int n3 = list == null ? 0 : list.size();
            int n4 = list2 == null ? 0 : list2.size();
            int n5 = n3 + n4;
            for (int i = 0; i < n5; ++i) {
                ActivityInfo activityInfo;
                Context context;
                SearchableInfo searchableInfo;
                ResolveInfo resolveInfo;
                if (i < n3) {
                    resolveInfo = list.get(i);
                } else {
                    int n6 = i - n3;
                    List<ResolveInfo> list3 = list2;
                    int n7 = n6;
                    resolveInfo = list3.get(n7);
                }
                ActivityInfo activityInfo2 = resolveInfo.activityInfo;
                HashMap<ComponentName, SearchableInfo> hashMap2 = hashMap;
                String string4 = activityInfo2.packageName;
                String string5 = activityInfo2.name;
                ComponentName componentName = new ComponentName(string4, string5);
                ComponentName componentName2 = componentName;
                if (hashMap2.get(componentName2) != null || (searchableInfo = SearchableInfo.getActivityMetaData(context = this.mContext, activityInfo = activityInfo2)) == null) continue;
                ArrayList<SearchableInfo> arrayList3 = arrayList;
                SearchableInfo searchableInfo2 = searchableInfo;
                boolean bl = arrayList3.add(searchableInfo2);
                ComponentName componentName3 = searchableInfo.getSearchActivity();
                HashMap<ComponentName, SearchableInfo> hashMap3 = hashMap;
                ComponentName componentName4 = componentName3;
                SearchableInfo searchableInfo3 = searchableInfo;
                SearchableInfo searchableInfo4 = hashMap3.put(componentName4, searchableInfo3);
                if (!searchableInfo.shouldIncludeInGlobalSearch()) continue;
                ArrayList<SearchableInfo> arrayList4 = arrayList2;
                SearchableInfo searchableInfo5 = searchableInfo;
                boolean bl2 = arrayList4.add(searchableInfo5);
            }
        }
        ComponentName componentName = this.findGlobalSearchActivity();
        Searchables searchables = this;
        ComponentName componentName5 = componentName;
        ComponentName componentName6 = searchables.findWebSearchActivity(componentName5);
        synchronized (this) {
            ComponentName componentName7;
            ComponentName componentName8;
            HashMap<ComponentName, SearchableInfo> hashMap4 = hashMap;
            this.mSearchablesMap = hashMap4;
            ArrayList<SearchableInfo> arrayList5 = arrayList;
            this.mSearchablesList = arrayList5;
            ArrayList<SearchableInfo> arrayList6 = arrayList2;
            this.mSearchablesInGlobalSearchList = arrayList6;
            this.mGlobalSearchActivity = componentName8 = componentName;
            this.mWebSearchActivity = componentName7 = componentName6;
            return;
        }
    }

    public ComponentName getGlobalSearchActivity() {
        synchronized (this) {
            ComponentName componentName = this.mGlobalSearchActivity;
            return componentName;
        }
    }

    /*
     * WARNING - bad return control flow
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public SearchableInfo getSearchableInfo(ComponentName componentName) {
        ComponentName componentName2;
        SearchableInfo searchableInfo;
        block16: {
            // MONITORENTER : this
            searchableInfo = this.mSearchablesMap.get(componentName);
            if (searchableInfo != null) {
                // MONITOREXIT : this
                return searchableInfo;
            }
            // MONITOREXIT : this
            try {
                ActivityInfo activityInfo = this.mContext.getPackageManager().getActivityInfo(componentName, 128);
                String string2 = null;
                Bundle bundle = activityInfo.metaData;
                if (bundle != null) {
                    string2 = bundle.getString(MD_LABEL_DEFAULT_SEARCHABLE);
                }
                if (string2 == null && (bundle = activityInfo.applicationInfo.metaData) != null) {
                    string2 = bundle.getString(MD_LABEL_DEFAULT_SEARCHABLE);
                }
                if (string2 == null) return null;
                boolean bl = string2.equals(MD_SEARCHABLE_SYSTEM_SEARCH);
                if (bl) {
                    return null;
                }
                String string3 = componentName.getPackageName();
                if (string2.charAt(0) == '.') {
                    String string4 = string3 + string2;
                    componentName2 = new ComponentName(string3, string4);
                    // MONITORENTER : this
                    break block16;
                }
                componentName2 = new ComponentName(string3, string2);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        if ((searchableInfo = this.mSearchablesMap.get(componentName2)) == null) return null;
        SearchableInfo searchableInfo2 = this.mSearchablesMap.put(componentName, searchableInfo);
        // MONITOREXIT : this
        return searchableInfo;
        return null;
    }

    public ArrayList<SearchableInfo> getSearchablesInGlobalSearchList() {
        synchronized (this) {
            ArrayList<SearchableInfo> arrayList = this.mSearchablesInGlobalSearchList;
            ArrayList<SearchableInfo> arrayList2 = new ArrayList<SearchableInfo>(arrayList);
            return arrayList2;
        }
    }

    public ArrayList<SearchableInfo> getSearchablesList() {
        synchronized (this) {
            ArrayList<SearchableInfo> arrayList = this.mSearchablesList;
            ArrayList<SearchableInfo> arrayList2 = new ArrayList<SearchableInfo>(arrayList);
            return arrayList2;
        }
    }

    public ComponentName getWebSearchActivity() {
        synchronized (this) {
            ComponentName componentName = this.mWebSearchActivity;
            return componentName;
        }
    }
}

