/*
 * Decompiled with CFR 0.152.
 */
package android.service.urlrenderer;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.service.urlrenderer.IUrlRendererCallback;
import android.service.urlrenderer.IUrlRendererService;
import android.service.urlrenderer.UrlRenderer;
import java.util.List;

public abstract class UrlRendererService
extends Service {
    public static final String SERVICE_INTERFACE = "android.service.urlrenderer.UrlRendererService";
    static final String TAG = "UrlRendererService";
    private final IUrlRendererService.Stub mBinderInterface;

    public UrlRendererService() {
        IUrlRendererService.Stub stub;
        this.mBinderInterface = stub = new IUrlRendererService.Stub(){

            @Override
            public void render(List<String> list, int n, int n2, IUrlRendererCallback iUrlRendererCallback) {
                UrlRendererService urlRendererService = UrlRendererService.this;
                InternalCallback internalCallback = new InternalCallback(iUrlRendererCallback);
                urlRendererService.processRequest(list, n, n2, internalCallback);
            }
        };
    }

    @Override
    public final IBinder onBind(Intent intent) {
        return this.mBinderInterface;
    }

    @Override
    public final boolean onUnbind(Intent intent) {
        this.stopSelf();
        return false;
    }

    public abstract void processRequest(List<String> var1, int var2, int var3, UrlRenderer.Callback var4);

    private static class InternalCallback
    implements UrlRenderer.Callback {
        private final IUrlRendererCallback mCallback;

        InternalCallback(IUrlRendererCallback iUrlRendererCallback) {
            this.mCallback = iUrlRendererCallback;
        }

        @Override
        public void complete(String string2, ParcelFileDescriptor parcelFileDescriptor) {
            try {
                this.mCallback.complete(string2, parcelFileDescriptor);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }
    }
}

