/*
 * Decompiled with CFR 0.152.
 */
package android.service.wallpaper;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.os.RemoteException;
import android.service.wallpaper.IWallpaperConnection;
import android.service.wallpaper.IWallpaperEngine;
import android.service.wallpaper.IWallpaperService;
import android.util.Log;
import android.view.IWindowSession;
import android.view.InputChannel;
import android.view.InputHandler;
import android.view.InputQueue;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.ViewRoot;
import android.view.WindowManager;
import com.android.internal.os.HandlerCaller;
import com.android.internal.view.BaseIWindow;
import com.android.internal.view.BaseInputHandler;
import com.android.internal.view.BaseSurfaceHolder;
import java.util.ArrayList;

public abstract class WallpaperService
extends Service {
    static final boolean DEBUG = false;
    private static final int DO_ATTACH = 10;
    private static final int DO_DETACH = 20;
    private static final int DO_SET_DESIRED_SIZE = 30;
    private static final int MSG_TOUCH_EVENT = 10040;
    private static final int MSG_UPDATE_SURFACE = 10000;
    private static final int MSG_VISIBILITY_CHANGED = 10010;
    private static final int MSG_WALLPAPER_COMMAND = 10025;
    private static final int MSG_WALLPAPER_OFFSETS = 10020;
    private static final int MSG_WINDOW_RESIZED = 10030;
    public static final String SERVICE_INTERFACE = "android.service.wallpaper.WallpaperService";
    public static final String SERVICE_META_DATA = "android.service.wallpaper";
    static final String TAG = "WallpaperService";
    private final ArrayList<Engine> mActiveEngines;
    private Looper mCallbackLooper;

    public WallpaperService() {
        ArrayList arrayList = new ArrayList();
        this.mActiveEngines = arrayList;
    }

    @Override
    public final IBinder onBind(Intent intent) {
        return new IWallpaperServiceWrapper(this);
    }

    @Override
    public void onCreate() {
        super.onCreate();
    }

    public abstract Engine onCreateEngine();

    @Override
    public void onDestroy() {
        int n;
        super.onDestroy();
        for (int i = 0; i < (n = this.mActiveEngines.size()); ++i) {
            this.mActiveEngines.get(i).detach();
        }
        this.mActiveEngines.clear();
    }

    public void setCallbackLooper(Looper looper) {
        this.mCallbackLooper = looper;
    }

    class IWallpaperServiceWrapper
    extends IWallpaperService.Stub {
        private final WallpaperService mTarget;

        public IWallpaperServiceWrapper(WallpaperService wallpaperService2) {
            this.mTarget = wallpaperService2;
        }

        @Override
        public void attach(IWallpaperConnection iWallpaperConnection, IBinder iBinder, int n, boolean bl, int n2, int n3) {
            WallpaperService wallpaperService = WallpaperService.this;
            WallpaperService wallpaperService2 = this.mTarget;
            IWallpaperConnection iWallpaperConnection2 = iWallpaperConnection;
            IBinder iBinder2 = iBinder;
            int n4 = n;
            boolean bl2 = bl;
            int n5 = n2;
            int n6 = n3;
            IWallpaperEngineWrapper iWallpaperEngineWrapper = wallpaperService.new IWallpaperEngineWrapper(wallpaperService2, iWallpaperConnection2, iBinder2, n4, bl2, n5, n6);
        }
    }

    class IWallpaperEngineWrapper
    extends IWallpaperEngine.Stub
    implements HandlerCaller.Callback {
        private final HandlerCaller mCaller;
        final IWallpaperConnection mConnection;
        Engine mEngine;
        final boolean mIsPreview;
        int mReqHeight;
        int mReqWidth;
        final IBinder mWindowToken;
        final int mWindowType;

        /*
         * Enabled aggressive block sorting
         */
        IWallpaperEngineWrapper(WallpaperService wallpaperService2, IWallpaperConnection iWallpaperConnection, IBinder iBinder, int n, boolean bl, int n2, int n3) {
            HandlerCaller handlerCaller;
            Looper looper = WallpaperService.this.mCallbackLooper != null ? WallpaperService.this.mCallbackLooper : wallpaperService2.getMainLooper();
            this.mCaller = handlerCaller = new HandlerCaller(wallpaperService2, looper, this);
            this.mConnection = iWallpaperConnection;
            this.mWindowToken = iBinder;
            this.mWindowType = n;
            this.mIsPreview = bl;
            this.mReqWidth = n2;
            this.mReqHeight = n3;
            Message message = this.mCaller.obtainMessage(10);
            this.mCaller.sendMessage(message);
        }

        @Override
        public void destroy() {
            Message message = this.mCaller.obtainMessage(20);
            this.mCaller.sendMessage(message);
        }

        @Override
        public void dispatchPointer(MotionEvent motionEvent) {
            if (this.mEngine == null) {
                return;
            }
            this.mEngine.dispatchPointer(motionEvent);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void executeMessage(Message message) {
            switch (message.what) {
                default: {
                    StringBuilder stringBuilder = new StringBuilder().append("Unknown message type ");
                    int n = message.what;
                    String string2 = stringBuilder.append(n).toString();
                    int n2 = Log.w(WallpaperService.TAG, string2);
                    return;
                }
                case 10: {
                    try {
                        Engine engine;
                        this.mConnection.attachEngine(this);
                        this.mEngine = engine = WallpaperService.this.onCreateEngine();
                        boolean bl = WallpaperService.this.mActiveEngines.add(engine);
                        engine.attach(this);
                        return;
                    }
                    catch (RemoteException remoteException) {
                        int n = Log.w(WallpaperService.TAG, "Wallpaper host disappeared", remoteException);
                        return;
                    }
                }
                case 20: {
                    ArrayList arrayList = WallpaperService.this.mActiveEngines;
                    Engine engine = this.mEngine;
                    boolean bl = arrayList.remove(engine);
                    this.mEngine.detach();
                    return;
                }
                case 30: {
                    Engine engine = this.mEngine;
                    int n = message.arg1;
                    int n3 = message.arg2;
                    engine.doDesiredSizeChanged(n, n3);
                    return;
                }
                case 10000: {
                    this.mEngine.updateSurface(true, false, false);
                    return;
                }
                case 10010: {
                    Engine engine = this.mEngine;
                    boolean bl = message.arg1 != 0;
                    engine.doVisibilityChanged(bl);
                    return;
                }
                case 10020: {
                    this.mEngine.doOffsetsChanged();
                    return;
                }
                case 10025: {
                    WallpaperCommand wallpaperCommand = (WallpaperCommand)message.obj;
                    this.mEngine.doCommand(wallpaperCommand);
                    return;
                }
                case 10030: {
                    boolean bl = message.arg1 != 0;
                    this.mEngine.updateSurface(true, false, bl);
                    this.mEngine.doOffsetsChanged();
                    return;
                }
                case 10040: 
            }
            boolean bl = false;
            MotionEvent motionEvent = (MotionEvent)message.obj;
            if (motionEvent.getAction() == 2) {
                Object object = this.mEngine.mLock;
                synchronized (object) {
                    if (this.mEngine.mPendingMove == motionEvent) {
                        this.mEngine.mPendingMove = null;
                    } else {
                        bl = true;
                    }
                }
            }
            if (!bl) {
                this.mEngine.onTouchEvent(motionEvent);
            }
            motionEvent.recycle();
        }

        @Override
        public void setDesiredSize(int n, int n2) {
            Message message = this.mCaller.obtainMessageII(30, n, n2);
            this.mCaller.sendMessage(message);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void setVisibility(boolean bl) {
            HandlerCaller handlerCaller = this.mCaller;
            int n = bl ? 1 : 0;
            Message message = handlerCaller.obtainMessageI(10010, n);
            this.mCaller.sendMessage(message);
        }
    }

    public class Engine {
        HandlerCaller mCaller;
        final Configuration mConfiguration;
        IWallpaperConnection mConnection;
        final Rect mContentInsets;
        boolean mCreated;
        int mCurHeight;
        int mCurWidth;
        int mCurWindowFlags;
        boolean mDestroyed;
        boolean mDrawingAllowed;
        int mFormat;
        int mHeight;
        IWallpaperEngineWrapper mIWallpaperEngine;
        boolean mInitializing = true;
        InputChannel mInputChannel;
        final InputHandler mInputHandler;
        boolean mIsCreating;
        final WindowManager.LayoutParams mLayout;
        final Object mLock;
        boolean mOffsetMessageEnqueued;
        MotionEvent mPendingMove;
        boolean mPendingSync;
        float mPendingXOffset;
        float mPendingXOffsetStep;
        float mPendingYOffset;
        float mPendingYOffsetStep;
        final BroadcastReceiver mReceiver;
        boolean mReportedVisible;
        boolean mScreenOn = true;
        IWindowSession mSession;
        boolean mSurfaceCreated;
        final BaseSurfaceHolder mSurfaceHolder;
        int mType;
        boolean mVisible;
        final Rect mVisibleInsets;
        int mWidth;
        final Rect mWinFrame;
        final BaseIWindow mWindow;
        int mWindowFlags;
        IBinder mWindowToken;

        public Engine() {
            BaseIWindow baseIWindow;
            BaseSurfaceHolder baseSurfaceHolder;
            BroadcastReceiver broadcastReceiver;
            Object object;
            WindowManager.LayoutParams layoutParams;
            Configuration configuration;
            Rect rect;
            Rect rect2;
            Rect rect3;
            int n;
            this.mCurWindowFlags = n = (this.mWindowFlags = 16);
            this.mVisibleInsets = rect3 = new Rect();
            this.mWinFrame = rect2 = new Rect();
            this.mContentInsets = rect = new Rect();
            this.mConfiguration = configuration = new Configuration();
            this.mLayout = layoutParams = new WindowManager.LayoutParams();
            this.mLock = object = new Object();
            this.mReceiver = broadcastReceiver = new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    String string2 = intent.getAction();
                    if ("android.intent.action.SCREEN_ON".equals(string2)) {
                        Engine.this.mScreenOn = true;
                        Engine.this.reportVisibility();
                        return;
                    }
                    String string3 = intent.getAction();
                    if (!"android.intent.action.SCREEN_OFF".equals(string3)) {
                        return;
                    }
                    Engine.this.mScreenOn = false;
                    Engine.this.reportVisibility();
                }
            };
            this.mSurfaceHolder = baseSurfaceHolder = new BaseSurfaceHolder(){
                {
                    this.mRequestedFormat = 4;
                }

                @Override
                public boolean isCreating() {
                    return Engine.this.mIsCreating;
                }

                @Override
                public boolean onAllowLockCanvas() {
                    return Engine.this.mDrawingAllowed;
                }

                @Override
                public void onRelayoutContainer() {
                    Message message = Engine.this.mCaller.obtainMessage(10000);
                    Engine.this.mCaller.sendMessage(message);
                }

                @Override
                public void onUpdateSurface() {
                    Message message = Engine.this.mCaller.obtainMessage(10000);
                    Engine.this.mCaller.sendMessage(message);
                }

                @Override
                public void setFixedSize(int n, int n2) {
                    throw new UnsupportedOperationException("Wallpapers currently only support sizing from layout");
                }

                @Override
                public void setKeepScreenOn(boolean bl) {
                    throw new UnsupportedOperationException("Wallpapers do not support keep screen on");
                }
            };
            BaseInputHandler baseInputHandler = new BaseInputHandler(){

                @Override
                public void handleMotion(MotionEvent motionEvent, Runnable runnable) {
                    try {
                        if ((motionEvent.getSource() & 2) != 0) {
                            Engine.this.dispatchPointer(motionEvent);
                        }
                        return;
                    }
                    finally {
                        runnable.run();
                    }
                }
            };
            this.mInputHandler = baseInputHandler;
            this.mWindow = baseIWindow = new BaseIWindow(){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void dispatchAppVisibility(boolean bl) {
                    if (Engine.this.mIWallpaperEngine.mIsPreview) {
                        return;
                    }
                    HandlerCaller handlerCaller = Engine.this.mCaller;
                    int n = 10010;
                    int n2 = bl ? 1 : 0;
                    Message message = handlerCaller.obtainMessageI(n, n2);
                    Engine.this.mCaller.sendMessage(message);
                }

                @Override
                public void dispatchWallpaperCommand(String string2, int n, int n2, int n3, Bundle bundle, boolean bl) {
                    Object object = Engine.this.mLock;
                    synchronized (object) {
                        WallpaperCommand wallpaperCommand = new WallpaperCommand();
                        wallpaperCommand.action = string2;
                        wallpaperCommand.x = n;
                        wallpaperCommand.y = n2;
                        wallpaperCommand.z = n3;
                        wallpaperCommand.extras = bundle;
                        wallpaperCommand.sync = bl;
                        Message message = Engine.this.mCaller.obtainMessage(10025);
                        message.obj = wallpaperCommand;
                        Engine.this.mCaller.sendMessage(message);
                        return;
                    }
                }

                @Override
                public void dispatchWallpaperOffsets(float f, float f2, float f3, float f4, boolean bl) {
                    Object object = Engine.this.mLock;
                    synchronized (object) {
                        Engine.this.mPendingXOffset = f;
                        Engine.this.mPendingYOffset = f2;
                        Engine.this.mPendingXOffsetStep = f3;
                        Engine.this.mPendingYOffsetStep = f4;
                        if (bl) {
                            Engine.this.mPendingSync = true;
                        }
                        if (!Engine.this.mOffsetMessageEnqueued) {
                            Engine.this.mOffsetMessageEnqueued = true;
                            Message message = Engine.this.mCaller.obtainMessage(10020);
                            Engine.this.mCaller.sendMessage(message);
                        }
                        return;
                    }
                }

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void resized(int n, int n2, Rect rect, Rect rect2, boolean bl, Configuration configuration) {
                    HandlerCaller handlerCaller = Engine.this.mCaller;
                    int n3 = bl ? 1 : 0;
                    Message message = handlerCaller.obtainMessageI(10030, n3);
                    Engine.this.mCaller.sendMessage(message);
                }
            };
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void dispatchPointer(MotionEvent motionEvent) {
            Object object = this.mLock;
            synchronized (object) {
                if (motionEvent.getAction() == 2) {
                    this.mPendingMove = motionEvent;
                } else {
                    Object var4_4 = null;
                    this.mPendingMove = var4_4;
                }
            }
            Message message = this.mCaller.obtainMessageO(10040, motionEvent);
            this.mCaller.sendMessage(message);
        }

        void attach(IWallpaperEngineWrapper iWallpaperEngineWrapper) {
            IWindowSession iWindowSession;
            IBinder iBinder;
            IWallpaperConnection iWallpaperConnection;
            HandlerCaller handlerCaller;
            if (this.mDestroyed) {
                return;
            }
            this.mIWallpaperEngine = iWallpaperEngineWrapper;
            this.mCaller = handlerCaller = iWallpaperEngineWrapper.mCaller;
            this.mConnection = iWallpaperConnection = iWallpaperEngineWrapper.mConnection;
            this.mWindowToken = iBinder = iWallpaperEngineWrapper.mWindowToken;
            this.mSurfaceHolder.setSizeFromLayout();
            this.mInitializing = true;
            this.mSession = iWindowSession = ViewRoot.getWindowSession(WallpaperService.this.getMainLooper());
            BaseIWindow baseIWindow = this.mWindow;
            IWindowSession iWindowSession2 = this.mSession;
            baseIWindow.setSession(iWindowSession2);
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            WallpaperService wallpaperService = WallpaperService.this;
            BroadcastReceiver broadcastReceiver = this.mReceiver;
            Intent intent = wallpaperService.registerReceiver(broadcastReceiver, intentFilter);
            BaseSurfaceHolder baseSurfaceHolder = this.mSurfaceHolder;
            this.onCreate(baseSurfaceHolder);
            this.mInitializing = false;
            this.updateSurface(false, false, false);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void detach() {
            if (this.mDestroyed) {
                return;
            }
            this.mDestroyed = true;
            if (this.mVisible) {
                this.mVisible = false;
                this.onVisibilityChanged(false);
            }
            this.reportSurfaceDestroyed();
            this.onDestroy();
            WallpaperService wallpaperService = WallpaperService.this;
            BroadcastReceiver broadcastReceiver = this.mReceiver;
            wallpaperService.unregisterReceiver(broadcastReceiver);
            if (!this.mCreated) {
                return;
            }
            try {
                if (this.mInputChannel != null) {
                    InputQueue.unregisterInputChannel(this.mInputChannel);
                }
                IWindowSession iWindowSession = this.mSession;
                BaseIWindow baseIWindow = this.mWindow;
                iWindowSession.remove(baseIWindow);
            }
            catch (RemoteException remoteException) {}
            this.mSurfaceHolder.mSurface.release();
            this.mCreated = false;
            if (this.mInputChannel == null) {
                return;
            }
            this.mInputChannel.dispose();
            this.mInputChannel = null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void doCommand(WallpaperCommand wallpaperCommand) {
            Bundle bundle;
            if (!this.mDestroyed) {
                String string2 = wallpaperCommand.action;
                int n = wallpaperCommand.x;
                int n2 = wallpaperCommand.y;
                int n3 = wallpaperCommand.z;
                Bundle bundle2 = wallpaperCommand.extras;
                boolean bl = wallpaperCommand.sync;
                bundle = this.onCommand(string2, n, n2, n3, bundle2, bl);
            } else {
                bundle = null;
            }
            if (!wallpaperCommand.sync) {
                return;
            }
            try {
                IWindowSession iWindowSession = this.mSession;
                IBinder iBinder = this.mWindow.asBinder();
                iWindowSession.wallpaperCommandComplete(iBinder, bundle);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        void doDesiredSizeChanged(int n, int n2) {
            if (this.mDestroyed) {
                return;
            }
            this.mIWallpaperEngine.mReqWidth = n;
            this.mIWallpaperEngine.mReqHeight = n2;
            this.onDesiredSizeChanged(n, n2);
            this.doOffsetsChanged();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        void doOffsetsChanged() {
            if (this.mDestroyed) {
                return;
            }
            Object object = this.mLock;
            // MONITORENTER : object
            float f = this.mPendingXOffset;
            float f2 = this.mPendingYOffset;
            float f3 = this.mPendingXOffsetStep;
            float f4 = this.mPendingYOffsetStep;
            boolean bl = this.mPendingSync;
            this.mPendingSync = false;
            this.mOffsetMessageEnqueued = false;
            // MONITOREXIT : object
            if (this.mSurfaceCreated) {
                int n = this.mIWallpaperEngine.mReqWidth;
                int n2 = this.mCurWidth;
                int n3 = n - n2;
                int n4 = n3 > 0 ? -((int)((float)n3 * f + 0.5f)) : 0;
                int n5 = this.mIWallpaperEngine.mReqHeight;
                int n6 = this.mCurHeight;
                int n7 = n5 - n6;
                int n8 = n7 > 0 ? -((int)((float)n7 * f2 + 0.5f)) : 0;
                this.onOffsetsChanged(f, f2, f3, f4, n4, n8);
            }
            if (!bl) {
                return;
            }
            try {
                IWindowSession iWindowSession = this.mSession;
                IBinder iBinder = this.mWindow.asBinder();
                iWindowSession.wallpaperOffsetsComplete(iBinder);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        void doVisibilityChanged(boolean bl) {
            if (this.mDestroyed) {
                return;
            }
            this.mVisible = bl;
            this.reportVisibility();
        }

        public int getDesiredMinimumHeight() {
            return this.mIWallpaperEngine.mReqHeight;
        }

        public int getDesiredMinimumWidth() {
            return this.mIWallpaperEngine.mReqWidth;
        }

        public SurfaceHolder getSurfaceHolder() {
            return this.mSurfaceHolder;
        }

        public boolean isPreview() {
            return this.mIWallpaperEngine.mIsPreview;
        }

        public boolean isVisible() {
            return this.mReportedVisible;
        }

        public Bundle onCommand(String string2, int n, int n2, int n3, Bundle bundle, boolean bl) {
            return null;
        }

        public void onCreate(SurfaceHolder surfaceHolder) {
        }

        public void onDesiredSizeChanged(int n, int n2) {
        }

        public void onDestroy() {
        }

        public void onOffsetsChanged(float f, float f2, float f3, float f4, int n, int n2) {
        }

        public void onSurfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        }

        public void onSurfaceCreated(SurfaceHolder surfaceHolder) {
        }

        public void onSurfaceDestroyed(SurfaceHolder surfaceHolder) {
        }

        public void onSurfaceRedrawNeeded(SurfaceHolder surfaceHolder) {
        }

        public void onTouchEvent(MotionEvent motionEvent) {
        }

        public void onVisibilityChanged(boolean bl) {
        }

        void reportSurfaceDestroyed() {
            if (!this.mSurfaceCreated) {
                return;
            }
            this.mSurfaceCreated = false;
            this.mSurfaceHolder.ungetCallbacks();
            SurfaceHolder.Callback[] callbackArray = this.mSurfaceHolder.getCallbacks();
            if (callbackArray != null) {
                for (SurfaceHolder.Callback callback : callbackArray) {
                    BaseSurfaceHolder baseSurfaceHolder = this.mSurfaceHolder;
                    callback.surfaceDestroyed(baseSurfaceHolder);
                }
            }
            BaseSurfaceHolder baseSurfaceHolder = this.mSurfaceHolder;
            this.onSurfaceDestroyed(baseSurfaceHolder);
        }

        /*
         * Enabled aggressive block sorting
         */
        void reportVisibility() {
            if (this.mDestroyed) {
                return;
            }
            boolean bl = this.mVisible && this.mScreenOn;
            if (this.mReportedVisible != bl) {
                return;
            }
            this.mReportedVisible = bl;
            if (bl) {
                this.updateSurface(false, false, false);
            }
            this.onVisibilityChanged(bl);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setTouchEventsEnabled(boolean bl) {
            int n = bl ? this.mWindowFlags & 0xFFFFFFEF : this.mWindowFlags | 0x10;
            this.mWindowFlags = n;
            if (!this.mCreated) {
                return;
            }
            this.updateSurface(false, false, false);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void updateSurface(boolean bl, boolean bl2, boolean bl3) {
            boolean bl4;
            boolean bl5;
            block23: {
                int n31;
                boolean bl10;
                boolean bl9;
                boolean bl8;
                boolean bl7;
                block22: {
                    int n;
                    int n2;
                    int n3;
                    boolean bl6;
                    IBinder iBinder;
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    int n13;
                    int n14;
                    int n15;
                    int n16;
                    int n17;
                    if (this.mDestroyed) {
                        int n18 = Log.w(WallpaperService.TAG, "Ignoring updateSurface: destroyed");
                    }
                    if ((n17 = this.mSurfaceHolder.getRequestedWidth()) <= 0) {
                        n17 = 65535;
                    }
                    if ((n16 = this.mSurfaceHolder.getRequestedHeight()) <= 0) {
                        n16 = 65535;
                    }
                    bl7 = !this.mCreated;
                    bl8 = !this.mSurfaceCreated;
                    int n19 = this.mFormat;
                    int n20 = this.mSurfaceHolder.getRequestedFormat();
                    bl9 = n19 != n20;
                    int n21 = this.mWidth;
                    int n22 = n17;
                    bl10 = n21 == n22 || (n15 = this.mHeight) != (n14 = n16);
                    int n23 = this.mType;
                    int n24 = this.mSurfaceHolder.getRequestedType();
                    boolean bl11 = n23 != n24;
                    int n25 = this.mCurWindowFlags;
                    int n26 = this.mWindowFlags;
                    boolean bl12 = n25 != n26;
                    if (!(bl || bl7 || bl8 || bl9 || bl10 || bl11 || bl12 || bl3)) {
                        return;
                    }
                    this.mWidth = n13 = n17;
                    this.mHeight = n12 = n16;
                    this.mFormat = n11 = this.mSurfaceHolder.getRequestedFormat();
                    this.mType = n10 = this.mSurfaceHolder.getRequestedType();
                    this.mLayout.x = 0;
                    this.mLayout.y = 0;
                    WindowManager.LayoutParams layoutParams = this.mLayout;
                    layoutParams.width = n9 = n17;
                    WindowManager.LayoutParams layoutParams2 = this.mLayout;
                    layoutParams2.height = n8 = n16;
                    WindowManager.LayoutParams layoutParams3 = this.mLayout;
                    layoutParams3.format = n7 = this.mFormat;
                    this.mCurWindowFlags = n6 = this.mWindowFlags;
                    WindowManager.LayoutParams layoutParams4 = this.mLayout;
                    layoutParams4.flags = n5 = this.mWindowFlags | 0x200 | 0x100 | 8;
                    WindowManager.LayoutParams layoutParams5 = this.mLayout;
                    layoutParams5.memoryType = n4 = this.mType;
                    WindowManager.LayoutParams layoutParams6 = this.mLayout;
                    layoutParams6.token = iBinder = this.mWindowToken;
                    if (!this.mCreated) {
                        boolean bl13;
                        InputChannel inputChannel;
                        int n27;
                        WindowManager.LayoutParams layoutParams7 = this.mLayout;
                        layoutParams7.type = n27 = this.mIWallpaperEngine.mWindowType;
                        this.mLayout.gravity = 51;
                        WindowManager.LayoutParams layoutParams8 = this.mLayout;
                        String string2 = WallpaperService.this.getClass().getName();
                        layoutParams8.setTitle(string2);
                        this.mLayout.windowAnimations = 16973945;
                        this.mInputChannel = inputChannel = new InputChannel();
                        IWindowSession iWindowSession = this.mSession;
                        BaseIWindow baseIWindow = this.mWindow;
                        WindowManager.LayoutParams layoutParams9 = this.mLayout;
                        Rect rect = this.mContentInsets;
                        InputChannel inputChannel2 = this.mInputChannel;
                        int n28 = iWindowSession.add(baseIWindow, layoutParams9, 0, rect, inputChannel2);
                        this.mCreated = bl13 = true;
                        InputChannel inputChannel3 = this.mInputChannel;
                        InputHandler inputHandler = this.mInputHandler;
                        MessageQueue messageQueue = Looper.myQueue();
                        InputQueue.registerInputChannel(inputChannel3, inputHandler, messageQueue);
                    }
                    this.mSurfaceHolder.mSurfaceLock.lock();
                    this.mDrawingAllowed = bl6 = true;
                    IWindowSession iWindowSession = this.mSession;
                    BaseIWindow baseIWindow = this.mWindow;
                    WindowManager.LayoutParams layoutParams10 = this.mLayout;
                    int n29 = this.mWidth;
                    int n30 = this.mHeight;
                    Rect rect = this.mWinFrame;
                    Rect rect2 = this.mContentInsets;
                    Rect rect3 = this.mVisibleInsets;
                    Configuration configuration = this.mConfiguration;
                    Surface surface = this.mSurfaceHolder.mSurface;
                    n31 = iWindowSession.relayout(baseIWindow, layoutParams10, n29, n30, 0, false, rect, rect2, rect3, configuration, surface);
                    int n32 = this.mWinFrame.width();
                    int n33 = this.mCurWidth;
                    int n34 = n32;
                    if (n33 != n34) {
                        int n35;
                        bl10 = true;
                        this.mCurWidth = n35 = n32;
                    }
                    if ((n3 = this.mCurHeight) != (n2 = (n = this.mWinFrame.height()))) {
                        int n36;
                        bl10 = true;
                        this.mCurHeight = n36 = n;
                    }
                    this.mSurfaceHolder.mSurfaceLock.unlock();
                    if (this.mSurfaceHolder.mSurface.isValid()) break block22;
                    this.reportSurfaceDestroyed();
                    return;
                }
                try {
                    int n37;
                    int n38;
                    SurfaceHolder.Callback[] callbackArray;
                    SurfaceHolder.Callback[] callbackArray2;
                    this.mSurfaceHolder.ungetCallbacks();
                    if (bl8) {
                        boolean bl14;
                        this.mIsCreating = bl14 = true;
                        BaseSurfaceHolder baseSurfaceHolder = this.mSurfaceHolder;
                        Engine engine = this;
                        BaseSurfaceHolder baseSurfaceHolder2 = baseSurfaceHolder;
                        engine.onSurfaceCreated(baseSurfaceHolder2);
                        callbackArray2 = this.mSurfaceHolder.getCallbacks();
                        if (callbackArray2 != null) {
                            int n39;
                            int n40;
                            callbackArray = callbackArray2;
                            n38 = callbackArray.length;
                            n37 = 0;
                            while ((n40 = ++n37) < (n39 = n38)) {
                                SurfaceHolder.Callback callback = callbackArray[n37];
                                BaseSurfaceHolder baseSurfaceHolder3 = this.mSurfaceHolder;
                                SurfaceHolder.Callback callback2 = callback;
                                BaseSurfaceHolder baseSurfaceHolder4 = baseSurfaceHolder3;
                                callback2.surfaceCreated(baseSurfaceHolder4);
                            }
                        }
                    }
                    boolean bl15 = bl7 || (n31 & 2) != 0;
                    bl3 |= bl15;
                    if (bl2 || bl7 || bl8 || bl9 || bl10) {
                        BaseSurfaceHolder baseSurfaceHolder = this.mSurfaceHolder;
                        int n41 = this.mFormat;
                        int n42 = this.mCurWidth;
                        int n43 = this.mCurHeight;
                        Engine engine = this;
                        BaseSurfaceHolder baseSurfaceHolder5 = baseSurfaceHolder;
                        int n44 = n41;
                        int n45 = n42;
                        int n46 = n43;
                        engine.onSurfaceChanged(baseSurfaceHolder5, n44, n45, n46);
                        callbackArray2 = this.mSurfaceHolder.getCallbacks();
                        if (callbackArray2 != null) {
                            int n47;
                            int n48;
                            callbackArray = callbackArray2;
                            n38 = callbackArray.length;
                            n37 = 0;
                            while ((n48 = ++n37) < (n47 = n38)) {
                                SurfaceHolder.Callback callback = callbackArray[n37];
                                BaseSurfaceHolder baseSurfaceHolder6 = this.mSurfaceHolder;
                                int n49 = this.mFormat;
                                int n50 = this.mCurWidth;
                                int n51 = this.mCurHeight;
                                SurfaceHolder.Callback callback3 = callback;
                                BaseSurfaceHolder baseSurfaceHolder7 = baseSurfaceHolder6;
                                int n52 = n49;
                                int n53 = n50;
                                int n54 = n51;
                                callback3.surfaceChanged(baseSurfaceHolder7, n52, n53, n54);
                            }
                        }
                    }
                    if (!bl3) break block23;
                    BaseSurfaceHolder baseSurfaceHolder = this.mSurfaceHolder;
                    Engine engine = this;
                    BaseSurfaceHolder baseSurfaceHolder8 = baseSurfaceHolder;
                    engine.onSurfaceRedrawNeeded(baseSurfaceHolder8);
                    callbackArray2 = this.mSurfaceHolder.getCallbacks();
                    if (callbackArray2 != null) {
                        int n55;
                        int n56;
                        callbackArray = callbackArray2;
                        n38 = callbackArray.length;
                        n37 = 0;
                        while ((n56 = ++n37) < (n55 = n38)) {
                            SurfaceHolder.Callback callback = callbackArray[n37];
                            if (!(callback instanceof SurfaceHolder.Callback2)) continue;
                            SurfaceHolder.Callback2 callback2 = (SurfaceHolder.Callback2)callback;
                            BaseSurfaceHolder baseSurfaceHolder9 = this.mSurfaceHolder;
                            SurfaceHolder.Callback2 callback22 = callback2;
                            BaseSurfaceHolder baseSurfaceHolder10 = baseSurfaceHolder9;
                            callback22.surfaceRedrawNeeded(baseSurfaceHolder10);
                        }
                    }
                }
                catch (Throwable throwable) {
                    boolean bl16 = false;
                    try {
                        boolean bl17;
                        boolean bl18;
                        this.mIsCreating = bl18 = bl16;
                        this.mSurfaceCreated = bl17 = true;
                        if (bl3) {
                            IWindowSession iWindowSession2 = this.mSession;
                            BaseIWindow baseIWindow2 = this.mWindow;
                            iWindowSession2.finishDrawing(baseIWindow2);
                        }
                        throw throwable;
                    }
                    catch (RemoteException remoteException) {
                        return;
                    }
                }
            }
            this.mIsCreating = bl5 = false;
            this.mSurfaceCreated = bl4 = true;
            if (!bl3) {
                return;
            }
            IWindowSession iWindowSession = this.mSession;
            BaseIWindow baseIWindow = this.mWindow;
            iWindowSession.finishDrawing(baseIWindow);
        }
    }

    static final class WallpaperCommand {
        String action;
        Bundle extras;
        boolean sync;
        int x;
        int y;
        int z;

        WallpaperCommand() {
        }
    }
}

