/*
 * Decompiled with CFR 0.152.
 */
package android.speech;

import android.app.Service;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.speech.IRecognitionListener;
import android.speech.IRecognitionService;
import android.util.Log;

public abstract class RecognitionService
extends Service {
    private static final boolean DBG = false;
    private static final int MSG_CANCEL = 3;
    private static final int MSG_START_LISTENING = 1;
    private static final int MSG_STOP_LISTENING = 2;
    public static final String SERVICE_INTERFACE = "android.speech.RecognitionService";
    public static final String SERVICE_META_DATA = "android.speech";
    private static final String TAG = "RecognitionService";
    private RecognitionServiceBinder mBinder;
    private Callback mCurrentCallback;
    private final Handler mHandler;

    public RecognitionService() {
        Handler handler;
        RecognitionServiceBinder recognitionServiceBinder;
        this.mBinder = recognitionServiceBinder = new RecognitionServiceBinder(this);
        this.mCurrentCallback = null;
        this.mHandler = handler = new Handler(){

            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 1: {
                        StartListeningArgs startListeningArgs = (StartListeningArgs)message.obj;
                        RecognitionService recognitionService = RecognitionService.this;
                        Intent intent = startListeningArgs.mIntent;
                        IRecognitionListener iRecognitionListener = startListeningArgs.mListener;
                        recognitionService.dispatchStartListening(intent, iRecognitionListener);
                        return;
                    }
                    case 2: {
                        RecognitionService recognitionService = RecognitionService.this;
                        IRecognitionListener iRecognitionListener = (IRecognitionListener)message.obj;
                        recognitionService.dispatchStopListening(iRecognitionListener);
                        return;
                    }
                    case 3: 
                }
                RecognitionService recognitionService = RecognitionService.this;
                IRecognitionListener iRecognitionListener = (IRecognitionListener)message.obj;
                recognitionService.dispatchCancel(iRecognitionListener);
            }
        };
    }

    static /* synthetic */ Callback access$502(RecognitionService recognitionService, Callback callback) {
        recognitionService.mCurrentCallback = callback;
        return callback;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkPermissions(IRecognitionListener iRecognitionListener) {
        if (this.checkCallingOrSelfPermission("android.permission.RECORD_AUDIO") == 0) {
            return true;
        }
        try {
            int n = Log.e(TAG, "call for recognition service without RECORD_AUDIO permissions");
            iRecognitionListener.onError(9);
            return false;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "sending ERROR_INSUFFICIENT_PERMISSIONS message failed", remoteException);
            return false;
        }
    }

    private void dispatchCancel(IRecognitionListener iRecognitionListener) {
        IBinder iBinder;
        if (this.mCurrentCallback == null) {
            return;
        }
        IBinder iBinder2 = this.mCurrentCallback.mListener.asBinder();
        if (iBinder2 != (iBinder = iRecognitionListener.asBinder())) {
            int n = Log.w(TAG, "cancel called by client who did not call startListening - ignoring");
            return;
        }
        Callback callback = this.mCurrentCallback;
        this.onCancel(callback);
        this.mCurrentCallback = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dispatchStartListening(Intent intent, IRecognitionListener iRecognitionListener) {
        if (this.mCurrentCallback == null) {
            Callback callback;
            Callback callback2 = this.mCurrentCallback = (callback = new Callback(iRecognitionListener));
            this.onStartListening(intent, callback2);
            return;
        }
        int n = 8;
        try {
            iRecognitionListener.onError(n);
        }
        catch (RemoteException remoteException) {
            int n2 = Log.d(TAG, "onError call from startListening failed");
        }
        int n3 = Log.i(TAG, "concurrent startListening received - ignoring this call");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dispatchStopListening(IRecognitionListener iRecognitionListener) {
        try {
            IBinder iBinder;
            if (this.mCurrentCallback == null) {
                iRecognitionListener.onError(5);
                int n = Log.w(TAG, "stopListening called with no preceding startListening - ignoring");
                return;
            }
            IBinder iBinder2 = this.mCurrentCallback.mListener.asBinder();
            if (iBinder2 != (iBinder = iRecognitionListener.asBinder())) {
                iRecognitionListener.onError(8);
                int n = Log.w(TAG, "stopListening called by other caller than startListening - ignoring");
                return;
            }
        }
        catch (RemoteException remoteException) {
            int n = Log.d(TAG, "onError call from stopListening failed");
            return;
        }
        {
            Callback callback = this.mCurrentCallback;
            this.onStopListening(callback);
            return;
        }
    }

    @Override
    public final IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    protected abstract void onCancel(Callback var1);

    @Override
    public void onDestroy() {
        this.mCurrentCallback = null;
        this.mBinder.clearReference();
        super.onDestroy();
    }

    protected abstract void onStartListening(Intent var1, Callback var2);

    protected abstract void onStopListening(Callback var1);

    private static class RecognitionServiceBinder
    extends IRecognitionService.Stub {
        private RecognitionService mInternalService;

        public RecognitionServiceBinder(RecognitionService recognitionService) {
            this.mInternalService = recognitionService;
        }

        @Override
        public void cancel(IRecognitionListener iRecognitionListener) {
            if (this.mInternalService == null) {
                return;
            }
            if (!this.mInternalService.checkPermissions(iRecognitionListener)) {
                return;
            }
            Handler handler = this.mInternalService.mHandler;
            Message message = Message.obtain(this.mInternalService.mHandler, 3, iRecognitionListener);
            boolean bl = handler.sendMessage(message);
        }

        public void clearReference() {
            this.mInternalService = null;
        }

        @Override
        public void startListening(Intent intent, IRecognitionListener iRecognitionListener) {
            if (this.mInternalService == null) {
                return;
            }
            if (!this.mInternalService.checkPermissions(iRecognitionListener)) {
                return;
            }
            Handler handler = this.mInternalService.mHandler;
            Handler handler2 = this.mInternalService.mHandler;
            RecognitionService recognitionService = this.mInternalService;
            Class<? extends Object> clazz = recognitionService.getClass();
            StartListeningArgs startListeningArgs = recognitionService.new StartListeningArgs(intent, iRecognitionListener);
            Message message = Message.obtain(handler2, 1, startListeningArgs);
            boolean bl = handler.sendMessage(message);
        }

        @Override
        public void stopListening(IRecognitionListener iRecognitionListener) {
            if (this.mInternalService == null) {
                return;
            }
            if (!this.mInternalService.checkPermissions(iRecognitionListener)) {
                return;
            }
            Handler handler = this.mInternalService.mHandler;
            Message message = Message.obtain(this.mInternalService.mHandler, 2, iRecognitionListener);
            boolean bl = handler.sendMessage(message);
        }
    }

    public class Callback {
        private final IRecognitionListener mListener;

        private Callback(IRecognitionListener iRecognitionListener) {
            this.mListener = iRecognitionListener;
        }

        public void beginningOfSpeech() throws RemoteException {
            this.mListener.onBeginningOfSpeech();
        }

        public void bufferReceived(byte[] byArray) throws RemoteException {
            this.mListener.onBufferReceived(byArray);
        }

        public void endOfSpeech() throws RemoteException {
            this.mListener.onEndOfSpeech();
        }

        public void error(int n) throws RemoteException {
            Callback callback = RecognitionService.access$502(RecognitionService.this, null);
            this.mListener.onError(n);
        }

        public void partialResults(Bundle bundle) throws RemoteException {
            this.mListener.onPartialResults(bundle);
        }

        public void readyForSpeech(Bundle bundle) throws RemoteException {
            this.mListener.onReadyForSpeech(bundle);
        }

        public void results(Bundle bundle) throws RemoteException {
            Callback callback = RecognitionService.access$502(RecognitionService.this, null);
            this.mListener.onResults(bundle);
        }

        public void rmsChanged(float f) throws RemoteException {
            this.mListener.onRmsChanged(f);
        }
    }

    private class StartListeningArgs {
        public final Intent mIntent;
        public final IRecognitionListener mListener;

        public StartListeningArgs(Intent intent, IRecognitionListener iRecognitionListener) {
            this.mIntent = intent;
            this.mListener = iRecognitionListener;
        }
    }
}

