/*
 * Decompiled with CFR 0.152.
 */
package android.speech;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.provider.Settings;
import android.speech.IRecognitionListener;
import android.speech.IRecognitionService;
import android.speech.RecognitionListener;
import android.text.TextUtils;
import android.util.Log;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class SpeechRecognizer {
    private static final boolean DBG = false;
    public static final int ERROR_AUDIO = 3;
    public static final int ERROR_CLIENT = 5;
    public static final int ERROR_INSUFFICIENT_PERMISSIONS = 9;
    public static final int ERROR_NETWORK = 2;
    public static final int ERROR_NETWORK_TIMEOUT = 1;
    public static final int ERROR_NO_MATCH = 7;
    public static final int ERROR_RECOGNIZER_BUSY = 8;
    public static final int ERROR_SERVER = 4;
    public static final int ERROR_SPEECH_TIMEOUT = 6;
    private static final int MSG_CANCEL = 3;
    private static final int MSG_CHANGE_LISTENER = 4;
    private static final int MSG_START = 1;
    private static final int MSG_STOP = 2;
    public static final String RESULTS_RECOGNITION = "results_recognition";
    private static final String TAG = "SpeechRecognizer";
    private Connection mConnection;
    private final Context mContext;
    private Handler mHandler;
    private final InternalListener mListener;
    private final Queue<Message> mPendingTasks;
    private IRecognitionService mService;
    private final ComponentName mServiceComponent;

    private SpeechRecognizer(Context context, ComponentName componentName) {
        InternalListener internalListener;
        Handler handler;
        this.mHandler = handler = new Handler(){

            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 1: {
                        SpeechRecognizer speechRecognizer = SpeechRecognizer.this;
                        Intent intent = (Intent)message.obj;
                        speechRecognizer.handleStartListening(intent);
                        return;
                    }
                    case 2: {
                        SpeechRecognizer.this.handleStopMessage();
                        return;
                    }
                    case 3: {
                        SpeechRecognizer.this.handleCancelMessage();
                        return;
                    }
                    case 4: 
                }
                SpeechRecognizer speechRecognizer = SpeechRecognizer.this;
                RecognitionListener recognitionListener = (RecognitionListener)message.obj;
                speechRecognizer.handleChangeListener(recognitionListener);
            }
        };
        LinkedList<Message> linkedList = new LinkedList<Message>();
        this.mPendingTasks = linkedList;
        this.mListener = internalListener = new InternalListener();
        this.mContext = context;
        this.mServiceComponent = componentName;
    }

    static /* synthetic */ IRecognitionService access$502(SpeechRecognizer speechRecognizer, IRecognitionService iRecognitionService) {
        speechRecognizer.mService = iRecognitionService;
        return iRecognitionService;
    }

    static /* synthetic */ Connection access$802(SpeechRecognizer speechRecognizer, Connection connection) {
        speechRecognizer.mConnection = connection;
        return connection;
    }

    private static void checkIsCalledFromMainThread() {
        Looper looper;
        Looper looper2 = Looper.myLooper();
        if (looper2 == (looper = Looper.getMainLooper())) {
            return;
        }
        throw new RuntimeException("SpeechRecognizer should be used only from the application's main thread");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkOpenConnection() {
        if (this.mService != null) {
            return true;
        }
        this.mListener.onError(5);
        int n = Log.e(TAG, "not connected to the recognition service");
        return false;
    }

    public static SpeechRecognizer createSpeechRecognizer(Context context) {
        return SpeechRecognizer.createSpeechRecognizer(context, null);
    }

    public static SpeechRecognizer createSpeechRecognizer(Context context, ComponentName componentName) {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null)");
        }
        SpeechRecognizer.checkIsCalledFromMainThread();
        return new SpeechRecognizer(context, componentName);
    }

    private void handleCancelMessage() {
        if (!this.checkOpenConnection()) {
            return;
        }
        try {
            IRecognitionService iRecognitionService = this.mService;
            InternalListener internalListener = this.mListener;
            iRecognitionService.cancel(internalListener);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "cancel() failed", remoteException);
            this.mListener.onError(5);
            return;
        }
    }

    private void handleChangeListener(RecognitionListener recognitionListener) {
        RecognitionListener recognitionListener2 = InternalListener.access$1002(this.mListener, recognitionListener);
    }

    private void handleStartListening(Intent intent) {
        if (!this.checkOpenConnection()) {
            return;
        }
        try {
            IRecognitionService iRecognitionService = this.mService;
            InternalListener internalListener = this.mListener;
            iRecognitionService.startListening(intent, internalListener);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "startListening() failed", remoteException);
            this.mListener.onError(5);
            return;
        }
    }

    private void handleStopMessage() {
        if (!this.checkOpenConnection()) {
            return;
        }
        try {
            IRecognitionService iRecognitionService = this.mService;
            InternalListener internalListener = this.mListener;
            iRecognitionService.stopListening(internalListener);
            return;
        }
        catch (RemoteException remoteException) {
            int n = Log.e(TAG, "stopListening() failed", remoteException);
            this.mListener.onError(5);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isRecognitionAvailable(Context context) {
        Intent intent;
        PackageManager packageManager = context.getPackageManager();
        List<ResolveInfo> list = packageManager.queryIntentServices(intent = new Intent("android.speech.RecognitionService"), 0);
        if (list == null) return false;
        if (list.size() == 0) return false;
        return true;
    }

    private void putMessage(Message message) {
        if (this.mService == null) {
            boolean bl = this.mPendingTasks.offer(message);
            return;
        }
        boolean bl = this.mHandler.sendMessage(message);
    }

    public void cancel() {
        SpeechRecognizer.checkIsCalledFromMainThread();
        Message message = Message.obtain(this.mHandler, 3);
        this.putMessage(message);
    }

    public void destroy() {
        if (this.mConnection != null) {
            Context context = this.mContext;
            Connection connection = this.mConnection;
            context.unbindService(connection);
        }
        this.mPendingTasks.clear();
        this.mService = null;
        this.mConnection = null;
        RecognitionListener recognitionListener = InternalListener.access$1002(this.mListener, null);
    }

    public void setRecognitionListener(RecognitionListener recognitionListener) {
        SpeechRecognizer.checkIsCalledFromMainThread();
        Message message = Message.obtain(this.mHandler, 4, recognitionListener);
        this.putMessage(message);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void startListening(Intent intent) {
        if (intent == null) {
            throw new IllegalArgumentException("intent must not be null");
        }
        SpeechRecognizer.checkIsCalledFromMainThread();
        if (this.mConnection == null) {
            Connection connection;
            Context context;
            Connection connection2;
            this.mConnection = connection2 = new Connection();
            Intent intent2 = new Intent("android.speech.RecognitionService");
            if (this.mServiceComponent == null) {
                String string2 = Settings.Secure.getString(this.mContext.getContentResolver(), "voice_recognition_service");
                if (TextUtils.isEmpty(string2)) {
                    int n = Log.e(TAG, "no selected voice recognition service");
                    this.mListener.onError(5);
                    return;
                }
                ComponentName componentName = ComponentName.unflattenFromString(string2);
                Intent intent3 = intent2.setComponent(componentName);
            } else {
                ComponentName componentName = this.mServiceComponent;
                Intent intent4 = intent2.setComponent(componentName);
            }
            if (!(context = this.mContext).bindService(intent2, connection = this.mConnection, 1)) {
                int n = Log.e(TAG, "bind to recognition service failed");
                this.mConnection = null;
                this.mService = null;
                this.mListener.onError(5);
                return;
            }
        }
        Message message = Message.obtain(this.mHandler, 1, intent);
        this.putMessage(message);
    }

    public void stopListening() {
        SpeechRecognizer.checkIsCalledFromMainThread();
        Message message = Message.obtain(this.mHandler, 2);
        this.putMessage(message);
    }

    private class InternalListener
    extends IRecognitionListener.Stub {
        private static final int MSG_BEGINNING_OF_SPEECH = 1;
        private static final int MSG_BUFFER_RECEIVED = 2;
        private static final int MSG_END_OF_SPEECH = 3;
        private static final int MSG_ERROR = 4;
        private static final int MSG_ON_EVENT = 9;
        private static final int MSG_PARTIAL_RESULTS = 7;
        private static final int MSG_READY_FOR_SPEECH = 5;
        private static final int MSG_RESULTS = 6;
        private static final int MSG_RMS_CHANGED = 8;
        private final Handler mInternalHandler;
        private RecognitionListener mInternalListener;

        private InternalListener() {
            Handler handler;
            this.mInternalHandler = handler = new Handler(){

                @Override
                public void handleMessage(Message message) {
                    if (InternalListener.this.mInternalListener == null) {
                        return;
                    }
                    switch (message.what) {
                        default: {
                            return;
                        }
                        case 1: {
                            InternalListener.this.mInternalListener.onBeginningOfSpeech();
                            return;
                        }
                        case 2: {
                            RecognitionListener recognitionListener = InternalListener.this.mInternalListener;
                            byte[] byArray = (byte[])message.obj;
                            recognitionListener.onBufferReceived(byArray);
                            return;
                        }
                        case 3: {
                            InternalListener.this.mInternalListener.onEndOfSpeech();
                            return;
                        }
                        case 4: {
                            RecognitionListener recognitionListener = InternalListener.this.mInternalListener;
                            int n = (Integer)message.obj;
                            recognitionListener.onError(n);
                            return;
                        }
                        case 5: {
                            RecognitionListener recognitionListener = InternalListener.this.mInternalListener;
                            Bundle bundle = (Bundle)message.obj;
                            recognitionListener.onReadyForSpeech(bundle);
                            return;
                        }
                        case 6: {
                            RecognitionListener recognitionListener = InternalListener.this.mInternalListener;
                            Bundle bundle = (Bundle)message.obj;
                            recognitionListener.onResults(bundle);
                            return;
                        }
                        case 7: {
                            RecognitionListener recognitionListener = InternalListener.this.mInternalListener;
                            Bundle bundle = (Bundle)message.obj;
                            recognitionListener.onPartialResults(bundle);
                            return;
                        }
                        case 8: {
                            RecognitionListener recognitionListener = InternalListener.this.mInternalListener;
                            float f = ((Float)message.obj).floatValue();
                            recognitionListener.onRmsChanged(f);
                            return;
                        }
                        case 9: 
                    }
                    RecognitionListener recognitionListener = InternalListener.this.mInternalListener;
                    int n = message.arg1;
                    Bundle bundle = (Bundle)message.obj;
                    recognitionListener.onEvent(n, bundle);
                }
            };
        }

        static /* synthetic */ RecognitionListener access$1002(InternalListener internalListener, RecognitionListener recognitionListener) {
            internalListener.mInternalListener = recognitionListener;
            return recognitionListener;
        }

        @Override
        public void onBeginningOfSpeech() {
            Message.obtain(this.mInternalHandler, 1).sendToTarget();
        }

        @Override
        public void onBufferReceived(byte[] byArray) {
            Message.obtain(this.mInternalHandler, 2, byArray).sendToTarget();
        }

        @Override
        public void onEndOfSpeech() {
            Message.obtain(this.mInternalHandler, 3).sendToTarget();
        }

        @Override
        public void onError(int n) {
            Handler handler = this.mInternalHandler;
            Integer n2 = n;
            Message.obtain(handler, 4, n2).sendToTarget();
        }

        @Override
        public void onEvent(int n, Bundle bundle) {
            Message.obtain(this.mInternalHandler, 9, n, n, bundle).sendToTarget();
        }

        @Override
        public void onPartialResults(Bundle bundle) {
            Message.obtain(this.mInternalHandler, 7, bundle).sendToTarget();
        }

        @Override
        public void onReadyForSpeech(Bundle bundle) {
            Message.obtain(this.mInternalHandler, 5, bundle).sendToTarget();
        }

        @Override
        public void onResults(Bundle bundle) {
            Message.obtain(this.mInternalHandler, 6, bundle).sendToTarget();
        }

        @Override
        public void onRmsChanged(float f) {
            Handler handler = this.mInternalHandler;
            Float f2 = Float.valueOf(f);
            Message.obtain(handler, 8, f2).sendToTarget();
        }
    }

    private class Connection
    implements ServiceConnection {
        private Connection() {
        }

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            SpeechRecognizer speechRecognizer = SpeechRecognizer.this;
            IRecognitionService iRecognitionService = IRecognitionService.Stub.asInterface(iBinder);
            IRecognitionService iRecognitionService2 = SpeechRecognizer.access$502(speechRecognizer, iRecognitionService);
            while (!SpeechRecognizer.this.mPendingTasks.isEmpty()) {
                Handler handler = SpeechRecognizer.this.mHandler;
                Message message = (Message)SpeechRecognizer.this.mPendingTasks.poll();
                boolean bl = handler.sendMessage(message);
            }
            return;
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            IRecognitionService iRecognitionService = SpeechRecognizer.access$502(SpeechRecognizer.this, null);
            Connection connection = SpeechRecognizer.access$802(SpeechRecognizer.this, null);
            SpeechRecognizer.this.mPendingTasks.clear();
        }
    }
}

