/*
 * Decompiled with CFR 0.152.
 */
package android.speech.srec;

import java.io.IOException;
import java.io.InputStream;

public final class MicrophoneInputStream
extends InputStream {
    private static final String TAG = "MicrophoneInputStream";
    private int mAudioRecord = 0;
    private byte[] mOneByte;

    static {
        System.loadLibrary("srec_jni");
    }

    public MicrophoneInputStream(int n, int n2) throws IOException {
        int n3;
        byte[] byArray = new byte[1];
        this.mOneByte = byArray;
        this.mAudioRecord = n3 = MicrophoneInputStream.AudioRecordNew(n, n2);
        if (this.mAudioRecord == 0) {
            throw new IOException("AudioRecord constructor failed - busy?");
        }
        int n4 = MicrophoneInputStream.AudioRecordStart(this.mAudioRecord);
        if (n4 == 0) {
            return;
        }
        this.close();
        String string2 = "AudioRecord start failed: " + n4;
        throw new IOException(string2);
    }

    private static native void AudioRecordDelete(int var0) throws IOException;

    private static native int AudioRecordNew(int var0, int var1);

    private static native int AudioRecordRead(int var0, byte[] var1, int var2, int var3) throws IOException;

    private static native int AudioRecordStart(int var0);

    private static native void AudioRecordStop(int var0) throws IOException;

    @Override
    public void close() throws IOException {
        if (this.mAudioRecord == 0) {
            return;
        }
        try {
            MicrophoneInputStream.AudioRecordStop(this.mAudioRecord);
        }
        catch (Throwable throwable) {
            try {
                MicrophoneInputStream.AudioRecordDelete(this.mAudioRecord);
                throw throwable;
            }
            finally {
                this.mAudioRecord = 0;
            }
        }
        try {
            MicrophoneInputStream.AudioRecordDelete(this.mAudioRecord);
            return;
        }
        finally {
            this.mAudioRecord = 0;
        }
    }

    protected void finalize() throws Throwable {
        if (this.mAudioRecord == 0) {
            return;
        }
        this.close();
        throw new IOException("someone forgot to close MicrophoneInputStream");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read() throws IOException {
        if (this.mAudioRecord == 0) {
            throw new IllegalStateException("not open");
        }
        int n = this.mAudioRecord;
        byte[] byArray = this.mOneByte;
        if (MicrophoneInputStream.AudioRecordRead(n, byArray, 0, 1) != 1) return -1;
        return this.mOneByte[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        if (this.mAudioRecord == 0) {
            throw new IllegalStateException("not open");
        }
        int n = this.mAudioRecord;
        int n2 = byArray.length;
        return MicrophoneInputStream.AudioRecordRead(n, byArray, 0, n2);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.mAudioRecord == 0) {
            throw new IllegalStateException("not open");
        }
        return MicrophoneInputStream.AudioRecordRead(this.mAudioRecord, byArray, n, n2);
    }
}

