/*
 * Decompiled with CFR 0.152.
 */
package android.speech.srec;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;

public final class Recognizer {
    public static final int EVENT_END_OF_VOICING = 6;
    public static final int EVENT_INCOMPLETE = 2;
    public static final int EVENT_INVALID = 0;
    public static final int EVENT_MAX_SPEECH = 12;
    public static final int EVENT_NEED_MORE_AUDIO = 11;
    public static final int EVENT_NO_MATCH = 1;
    public static final int EVENT_RECOGNITION_RESULT = 8;
    public static final int EVENT_RECOGNITION_TIMEOUT = 10;
    public static final int EVENT_SPOKE_TOO_SOON = 7;
    public static final int EVENT_STARTED = 3;
    public static final int EVENT_START_OF_UTTERANCE_TIMEOUT = 9;
    public static final int EVENT_START_OF_VOICING = 5;
    public static final int EVENT_STOPPED = 4;
    public static final String KEY_CONFIDENCE = "conf";
    public static final String KEY_LITERAL = "literal";
    public static final String KEY_MEANING = "meaning";
    private static String TAG;
    private Grammar mActiveGrammar = null;
    private byte[] mPutAudioBuffer = null;
    private int mRecognizer = 0;
    private int mVocabulary = 0;

    static {
        System.loadLibrary("srec_jni");
        TAG = "Recognizer";
    }

    public Recognizer(String string2) throws IOException {
        int n;
        int n2;
        Recognizer.PMemInit();
        Recognizer.SR_SessionCreate(string2);
        this.mRecognizer = n2 = Recognizer.SR_RecognizerCreate();
        Recognizer.SR_RecognizerSetup(this.mRecognizer);
        this.mVocabulary = n = Recognizer.SR_VocabularyLoad();
    }

    private static native void PMemInit();

    private static native void PMemShutdown();

    private static native String SR_AcousticStateGet(int var0);

    private static native void SR_AcousticStateReset(int var0);

    private static native void SR_AcousticStateSet(int var0, String var1);

    private static native void SR_GrammarAddWordToSlot(int var0, String var1, String var2, String var3, int var4, String var5);

    private static native void SR_GrammarAllowAll(int var0);

    private static native void SR_GrammarAllowOnly(int var0, String var1);

    private static native void SR_GrammarCompile(int var0);

    private static native int SR_GrammarCreate();

    private static native void SR_GrammarDestroy(int var0);

    private static native int SR_GrammarLoad(String var0);

    private static native void SR_GrammarResetAllSlots(int var0);

    private static native void SR_GrammarSave(int var0, String var1);

    private static native void SR_GrammarSetupRecognizer(int var0, int var1);

    private static native void SR_GrammarSetupVocabulary(int var0, int var1);

    private static native void SR_GrammarUnsetupRecognizer(int var0);

    private static native void SR_RecognizerActivateRule(int var0, int var1, String var2, int var3);

    private static native int SR_RecognizerAdvance(int var0);

    private static native boolean SR_RecognizerCheckGrammarConsistency(int var0, int var1);

    private static native int SR_RecognizerCreate();

    private static native void SR_RecognizerDeactivateAllRules(int var0);

    private static native void SR_RecognizerDeactivateRule(int var0, int var1, String var2);

    private static native void SR_RecognizerDestroy(int var0);

    private static native boolean SR_RecognizerGetBoolParameter(int var0, String var1);

    private static native String SR_RecognizerGetParameter(int var0, String var1);

    private static native int SR_RecognizerGetSize_tParameter(int var0, String var1);

    private static native boolean SR_RecognizerHasSetupRules(int var0);

    private static native boolean SR_RecognizerIsActiveRule(int var0, int var1, String var2);

    private static native boolean SR_RecognizerIsSetup(int var0);

    private static native boolean SR_RecognizerIsSignalClipping(int var0);

    private static native boolean SR_RecognizerIsSignalDCOffset(int var0);

    private static native boolean SR_RecognizerIsSignalNoisy(int var0);

    private static native boolean SR_RecognizerIsSignalTooFewSamples(int var0);

    private static native boolean SR_RecognizerIsSignalTooManySamples(int var0);

    private static native boolean SR_RecognizerIsSignalTooQuiet(int var0);

    private static native int SR_RecognizerPutAudio(int var0, byte[] var1, int var2, int var3, boolean var4);

    private static native int SR_RecognizerResultGetKeyCount(int var0, int var1);

    private static native String[] SR_RecognizerResultGetKeyList(int var0, int var1);

    private static native int SR_RecognizerResultGetSize(int var0);

    private static native String SR_RecognizerResultGetValue(int var0, int var1, String var2);

    private static native byte[] SR_RecognizerResultGetWaveform(int var0);

    private static native void SR_RecognizerSetBoolParameter(int var0, String var1, boolean var2);

    private static native void SR_RecognizerSetParameter(int var0, String var1, String var2);

    private static native void SR_RecognizerSetSize_tParameter(int var0, String var1, int var2);

    private static native void SR_RecognizerSetup(int var0);

    private static native void SR_RecognizerSetupRule(int var0, int var1, String var2);

    private static native void SR_RecognizerStart(int var0);

    private static native void SR_RecognizerStop(int var0);

    private static native void SR_RecognizerUnsetup(int var0);

    private static native void SR_SessionCreate(String var0);

    private static native void SR_SessionDestroy();

    private static native void SR_VocabularyDestroy(int var0);

    private static native String SR_VocabularyGetPronunciation(int var0, String var1);

    private static native int SR_VocabularyLoad();

    static /* synthetic */ Grammar access$802(Recognizer recognizer, Grammar grammar) {
        recognizer.mActiveGrammar = grammar;
        return grammar;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String eventToString(int n) {
        switch (n) {
            default: {
                return "EVENT_" + n;
            }
            case 0: {
                return "EVENT_INVALID";
            }
            case 1: {
                return "EVENT_NO_MATCH";
            }
            case 2: {
                return "EVENT_INCOMPLETE";
            }
            case 3: {
                return "EVENT_STARTED";
            }
            case 4: {
                return "EVENT_STOPPED";
            }
            case 5: {
                return "EVENT_START_OF_VOICING";
            }
            case 6: {
                return "EVENT_END_OF_VOICING";
            }
            case 7: {
                return "EVENT_SPOKE_TOO_SOON";
            }
            case 8: {
                return "EVENT_RECOGNITION_RESULT";
            }
            case 9: {
                return "EVENT_START_OF_UTTERANCE_TIMEOUT";
            }
            case 10: {
                return "EVENT_RECOGNITION_TIMEOUT";
            }
            case 11: {
                return "EVENT_NEED_MORE_AUDIO";
            }
            case 12: 
        }
        return "EVENT_MAX_SPEECH";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getConfigDir(Locale locale) {
        String string2;
        StringBuilder stringBuilder;
        String string3;
        if (locale == null) {
            locale = Locale.US;
        }
        if (!new File(string3 = (stringBuilder = new StringBuilder().append("/system/usr/srec/config/")).append(string2 = locale.toString().replace('_', '.').toLowerCase()).toString()).isDirectory()) return null;
        return string3;
    }

    public int advance() {
        return Recognizer.SR_RecognizerAdvance(this.mRecognizer);
    }

    public void destroy() {
        block43: {
            try {
                if (this.mVocabulary != 0) {
                    Recognizer.SR_VocabularyDestroy(this.mVocabulary);
                }
                this.mVocabulary = 0;
            }
            catch (Throwable throwable) {
                block44: {
                    this.mVocabulary = 0;
                    try {
                        if (this.mRecognizer == 0) break block44;
                        Recognizer.SR_RecognizerUnsetup(this.mRecognizer);
                    }
                    catch (Throwable throwable2) {
                        try {
                            if (this.mRecognizer != 0) {
                                Recognizer.SR_RecognizerDestroy(this.mRecognizer);
                            }
                            this.mRecognizer = 0;
                        }
                        catch (Throwable throwable3) {
                            this.mRecognizer = 0;
                            try {
                                Recognizer.SR_SessionDestroy();
                                throw throwable3;
                            }
                            finally {
                                Recognizer.PMemShutdown();
                            }
                        }
                        try {
                            Recognizer.SR_SessionDestroy();
                            throw throwable2;
                        }
                        finally {
                            Recognizer.PMemShutdown();
                        }
                    }
                }
                try {
                    if (this.mRecognizer != 0) {
                        Recognizer.SR_RecognizerDestroy(this.mRecognizer);
                    }
                    this.mRecognizer = 0;
                }
                catch (Throwable throwable4) {
                    this.mRecognizer = 0;
                    try {
                        Recognizer.SR_SessionDestroy();
                        throw throwable4;
                    }
                    finally {
                        Recognizer.PMemShutdown();
                    }
                }
                try {
                    Recognizer.SR_SessionDestroy();
                    throw throwable;
                }
                finally {
                    Recognizer.PMemShutdown();
                }
            }
            try {
                if (this.mRecognizer == 0) break block43;
                Recognizer.SR_RecognizerUnsetup(this.mRecognizer);
            }
            catch (Throwable throwable) {
                try {
                    if (this.mRecognizer != 0) {
                        Recognizer.SR_RecognizerDestroy(this.mRecognizer);
                    }
                    this.mRecognizer = 0;
                }
                catch (Throwable throwable5) {
                    this.mRecognizer = 0;
                    try {
                        Recognizer.SR_SessionDestroy();
                        throw throwable5;
                    }
                    finally {
                        Recognizer.PMemShutdown();
                    }
                }
                try {
                    Recognizer.SR_SessionDestroy();
                    throw throwable;
                }
                finally {
                    Recognizer.PMemShutdown();
                }
            }
        }
        try {
            if (this.mRecognizer != 0) {
                Recognizer.SR_RecognizerDestroy(this.mRecognizer);
            }
            this.mRecognizer = 0;
        }
        catch (Throwable throwable) {
            this.mRecognizer = 0;
            try {
                Recognizer.SR_SessionDestroy();
                throw throwable;
            }
            finally {
                Recognizer.PMemShutdown();
            }
        }
        try {
            Recognizer.SR_SessionDestroy();
            return;
        }
        finally {
            Recognizer.PMemShutdown();
        }
    }

    protected void finalize() throws Throwable {
        if (this.mVocabulary == 0 && this.mRecognizer == 0) {
            return;
        }
        this.destroy();
        throw new IllegalStateException("someone forgot to destroy Recognizer");
    }

    public String getAcousticState() {
        return Recognizer.SR_AcousticStateGet(this.mRecognizer);
    }

    public String getResult(int n, String string2) {
        return Recognizer.SR_RecognizerResultGetValue(this.mRecognizer, n, string2);
    }

    public int getResultCount() {
        return Recognizer.SR_RecognizerResultGetSize(this.mRecognizer);
    }

    public String[] getResultKeys(int n) {
        return Recognizer.SR_RecognizerResultGetKeyList(this.mRecognizer, n);
    }

    public int putAudio(byte[] byArray, int n, int n2, boolean bl) {
        return Recognizer.SR_RecognizerPutAudio(this.mRecognizer, byArray, n, n2, bl);
    }

    public void putAudio(InputStream inputStream) throws IOException {
        byte[] byArray;
        int n;
        if (this.mPutAudioBuffer == null) {
            byte[] byArray2 = new byte[512];
            this.mPutAudioBuffer = byArray2;
        }
        if ((n = inputStream.read(byArray = this.mPutAudioBuffer)) == -1) {
            int n2 = this.mRecognizer;
            byte[] byArray3 = this.mPutAudioBuffer;
            int n3 = Recognizer.SR_RecognizerPutAudio(n2, byArray3, 0, 0, true);
            return;
        }
        int n4 = this.mRecognizer;
        byte[] byArray4 = this.mPutAudioBuffer;
        int n5 = Recognizer.SR_RecognizerPutAudio(n4, byArray4, 0, n, false);
        if (n != n5) {
            return;
        }
        String string2 = "SR_RecognizerPutAudio failed nbytes=" + n;
        throw new IOException(string2);
    }

    public void resetAcousticState() {
        Recognizer.SR_AcousticStateReset(this.mRecognizer);
    }

    public void setAcousticState(String string2) {
        Recognizer.SR_AcousticStateSet(this.mRecognizer, string2);
    }

    public void start() {
        int n = this.mRecognizer;
        int n2 = this.mActiveGrammar.mGrammar;
        Recognizer.SR_RecognizerActivateRule(n, n2, "trash", 1);
        Recognizer.SR_RecognizerStart(this.mRecognizer);
    }

    public void stop() {
        Recognizer.SR_RecognizerStop(this.mRecognizer);
        int n = this.mRecognizer;
        int n2 = this.mActiveGrammar.mGrammar;
        Recognizer.SR_RecognizerDeactivateRule(n, n2, "trash");
    }

    public class Grammar {
        private int mGrammar = 0;

        public Grammar(String string2) throws IOException {
            int n;
            int n2 = this.mGrammar = (n = Recognizer.SR_GrammarLoad(string2));
            int n3 = Recognizer.this.mVocabulary;
            Recognizer.SR_GrammarSetupVocabulary(n2, n3);
        }

        public void addWordToSlot(String string2, String string3, String string4, int n, String string5) {
            int n2 = this.mGrammar;
            String string6 = string2;
            String string7 = string3;
            String string8 = string4;
            int n3 = n;
            String string9 = string5;
            Recognizer.SR_GrammarAddWordToSlot(n2, string6, string7, string8, n3, string9);
        }

        public void compile() {
            Recognizer.SR_GrammarCompile(this.mGrammar);
        }

        public void destroy() {
            if (this.mGrammar == 0) {
                return;
            }
            Recognizer.SR_GrammarDestroy(this.mGrammar);
            this.mGrammar = 0;
        }

        protected void finalize() {
            if (this.mGrammar == 0) {
                return;
            }
            this.destroy();
            throw new IllegalStateException("someone forgot to destroy Grammar");
        }

        public void resetAllSlots() {
            Recognizer.SR_GrammarResetAllSlots(this.mGrammar);
        }

        public void save(String string2) throws IOException {
            Recognizer.SR_GrammarSave(this.mGrammar, string2);
        }

        public void setupRecognizer() {
            int n = this.mGrammar;
            int n2 = Recognizer.this.mRecognizer;
            Recognizer.SR_GrammarSetupRecognizer(n, n2);
            Grammar grammar = Recognizer.access$802(Recognizer.this, this);
        }
    }
}

