/*
 * Decompiled with CFR 0.152.
 */
package android.speech.srec;

import java.io.IOException;
import java.io.InputStream;

public final class UlawEncoderInputStream
extends InputStream {
    private static final int MAX_ULAW = 8192;
    private static final int SCALE_BITS = 16;
    private static final String TAG = "UlawEncoderInputStream";
    private final byte[] mBuf;
    private int mBufCount;
    private InputStream mIn;
    private int mMax = 0;
    private final byte[] mOneByte;

    public UlawEncoderInputStream(InputStream inputStream, int n) {
        byte[] byArray = new byte[1024];
        this.mBuf = byArray;
        this.mBufCount = 0;
        byte[] byArray2 = new byte[1];
        this.mOneByte = byArray2;
        this.mIn = inputStream;
        this.mMax = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void encode(byte[] byArray, int n, byte[] byArray2, int n2, int n3, int n4) {
        if (n4 <= 0) {
            n4 = 8192;
        }
        int n5 = 0x20000000 / n4;
        int n6 = 0;
        int n7 = n2;
        int n8 = n;
        while (n6 < n3) {
            byte by;
            int n9 = n8 + 1;
            int n10 = byArray[n8] & 0xFF;
            int n11 = n9 + 1;
            int n12 = ((byArray[n9] << 8) + n10) * n5 >> 16;
            int n13 = n12 >= 0 ? (n12 <= 0 ? 255 : (n12 <= 30 ? (30 - n12 >> 1) + 240 : (n12 <= 94 ? (94 - n12 >> 2) + 224 : (n12 <= 222 ? (222 - n12 >> 3) + 208 : (n12 <= 478 ? (478 - n12 >> 4) + 192 : (n12 <= 990 ? (990 - n12 >> 5) + 176 : (n12 <= 2014 ? (2014 - n12 >> 6) + 160 : (n12 <= 4062 ? (4062 - n12 >> 7) + 144 : (n12 <= 8158 ? (8158 - n12 >> 8) + 128 : 128))))))))) : (-1 <= n12 ? 127 : (65505 <= n12 ? (n12 - 65505 >> 1) + 112 : (65441 <= n12 ? (n12 - 65441 >> 2) + 96 : (65313 <= n12 ? (n12 - 65313 >> 3) + 80 : (65057 <= n12 ? (n12 - 65057 >> 4) + 64 : (64545 <= n12 ? (n12 - 64545 >> 5) + 48 : (63521 <= n12 ? (n12 - 63521 >> 6) + 32 : (61473 <= n12 ? (n12 - 61473 >> 7) + 16 : (57377 <= n12 ? (n12 - 57377 >> 8) + 0 : 0)))))))));
            int n14 = n7 + 1;
            byArray2[n7] = by = (byte)n13;
            ++n6;
            n7 = n14;
            n8 = n11;
        }
        return;
    }

    public static int maxAbsPcm(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = n;
        for (int i = 0; i < n2; ++i) {
            int n5 = n4 + 1;
            int n6 = byArray[n4] & 0xFF;
            n4 = n5 + 1;
            int n7 = byArray[n5] << 8;
            int n8 = n6 + n7;
            if (n8 < 0) {
                n8 = -n8;
            }
            if (n8 <= n3) continue;
            n3 = n8;
        }
        return n3;
    }

    @Override
    public int available() throws IOException {
        int n = this.mIn.available();
        int n2 = this.mBufCount;
        return (n + n2) / 2;
    }

    @Override
    public void close() throws IOException {
        if (this.mIn == null) {
            return;
        }
        InputStream inputStream = this.mIn;
        this.mIn = null;
        inputStream.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read() throws IOException {
        byte[] byArray = this.mOneByte;
        if (this.read(byArray, 0, 1) != -1) return this.mOneByte[0] & 0xFF;
        return -1;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = byArray.length;
        return this.read(byArray, 0, n);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int read(byte[] var1_1, int var2_2, int var3_3) throws IOException {
        block3: {
            if (this.mIn != null) ** GOTO lbl4
            throw new IllegalStateException("not open");
lbl-1000:
            // 1 sources

            {
                this.mBufCount = var5_5 = this.mBufCount + var4_4;
lbl4:
                // 2 sources

                if (this.mBufCount >= 2) break block3;
                ** while ((var4_4 = (var6_6 = this.mIn).read((byte[])(var7_7 = this.mBuf), (int)(var8_8 = this.mBufCount), (int)(var13_13 = Math.min((int)(var9_9 = var3_3 * 2), (int)(var12_12 = (var10_10 = this.mBuf.length) - (var11_11 = this.mBufCount)))))) != -1)
            }
lbl6:
            // 1 sources

            var14_14 = -1;
lbl7:
            // 2 sources

            return var14_14;
        }
        var4_4 = Math.min(this.mBufCount / 2, var3_3);
        var15_15 = this.mBuf;
        var16_16 = this.mMax;
        var17_17 = var1_1;
        var18_18 = var2_2;
        UlawEncoderInputStream.encode(var15_15, 0, var17_17, var18_18, var4_4, var16_16);
        var19_19 = this.mBufCount;
        var20_20 = var4_4 * 2;
        this.mBufCount = var21_21 = var19_19 - var20_20;
        for (var22_22 = 0; var22_22 < (var23_23 = this.mBufCount); ++var22_22) {
            var24_24 = this.mBuf;
            var25_25 = this.mBuf;
            var26_26 = var4_4 * 2 + var22_22;
            var24_24[var22_22] = var27_27 = var25_25[var26_26];
        }
        var14_14 = var4_4;
        ** while (true)
    }
}

