/*
 * Decompiled with CFR 0.152.
 */
package android.speech.srec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class WaveHeader {
    public static final short FORMAT_ALAW = 6;
    public static final short FORMAT_PCM = 1;
    public static final short FORMAT_ULAW = 7;
    private static final int HEADER_LENGTH = 44;
    private static final String TAG = "WaveHeader";
    private short mBitsPerSample;
    private short mFormat;
    private int mNumBytes;
    private short mNumChannels;
    private int mSampleRate;

    public WaveHeader() {
    }

    public WaveHeader(short s, short s2, int n, short s3, int n2) {
        this.mFormat = s;
        this.mSampleRate = n;
        this.mNumChannels = s2;
        this.mBitsPerSample = s3;
        this.mNumBytes = n2;
    }

    private static void readId(InputStream inputStream, String string2) throws IOException {
        int n = 0;
        int n2;
        while (n < (n2 = string2.length())) {
            int n3;
            char c = string2.charAt(n);
            if (c != (n3 = inputStream.read())) {
                String string3 = string2 + " tag not present";
                throw new IOException(string3);
            }
            ++n;
        }
        return;
    }

    private static int readInt(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read() << 8;
        int n3 = n | n2;
        int n4 = inputStream.read() << 16;
        int n5 = n3 | n4;
        int n6 = inputStream.read() << 24;
        return n5 | n6;
    }

    private static short readShort(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read() << 8;
        return (short)(n | n2);
    }

    private static void writeId(OutputStream outputStream, String string2) throws IOException {
        int n = 0;
        int n2;
        while (n < (n2 = string2.length())) {
            char c = string2.charAt(n);
            outputStream.write(c);
            ++n;
        }
        return;
    }

    private static void writeInt(OutputStream outputStream, int n) throws IOException {
        int n2 = n >> 0;
        outputStream.write(n2);
        int n3 = n >> 8;
        outputStream.write(n3);
        int n4 = n >> 16;
        outputStream.write(n4);
        int n5 = n >> 24;
        outputStream.write(n5);
    }

    private static void writeShort(OutputStream outputStream, short s) throws IOException {
        int n = s >> 0;
        outputStream.write(n);
        int n2 = s >> 8;
        outputStream.write(n2);
    }

    public short getBitsPerSample() {
        return this.mBitsPerSample;
    }

    public short getFormat() {
        return this.mFormat;
    }

    public int getNumBytes() {
        return this.mNumBytes;
    }

    public short getNumChannels() {
        return this.mNumChannels;
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public int read(InputStream inputStream) throws IOException {
        int n;
        short s;
        int n2;
        short s2;
        short s3;
        WaveHeader.readId(inputStream, "RIFF");
        int n3 = WaveHeader.readInt(inputStream) - 36;
        WaveHeader.readId(inputStream, "WAVE");
        WaveHeader.readId(inputStream, "fmt ");
        int n4 = WaveHeader.readInt(inputStream);
        if (16 != n4) {
            throw new IOException("fmt chunk length not 16");
        }
        this.mFormat = s3 = WaveHeader.readShort(inputStream);
        this.mNumChannels = s2 = WaveHeader.readShort(inputStream);
        this.mSampleRate = n2 = WaveHeader.readInt(inputStream);
        int n5 = WaveHeader.readInt(inputStream);
        short s4 = WaveHeader.readShort(inputStream);
        this.mBitsPerSample = s = WaveHeader.readShort(inputStream);
        short s5 = this.mNumChannels;
        int n6 = this.mSampleRate;
        int n7 = s5 * n6;
        short s6 = this.mBitsPerSample;
        int n8 = n7 * s6 / 8;
        if (n5 != n8) {
            throw new IOException("fmt.ByteRate field inconsistent");
        }
        short s7 = this.mNumChannels;
        short s8 = this.mBitsPerSample;
        int n9 = s7 * s8 / 8;
        if (s4 != n9) {
            throw new IOException("fmt.BlockAlign field inconsistent");
        }
        WaveHeader.readId(inputStream, "data");
        this.mNumBytes = n = WaveHeader.readInt(inputStream);
        return 44;
    }

    public WaveHeader setBitsPerSample(short s) {
        this.mBitsPerSample = s;
        return this;
    }

    public WaveHeader setFormat(short s) {
        this.mFormat = s;
        return this;
    }

    public WaveHeader setNumBytes(int n) {
        this.mNumBytes = n;
        return this;
    }

    public WaveHeader setNumChannels(short s) {
        this.mNumChannels = s;
        return this;
    }

    public WaveHeader setSampleRate(int n) {
        this.mSampleRate = n;
        return this;
    }

    public String toString() {
        Object[] objectArray = new Object[5];
        Short s = this.mFormat;
        objectArray[0] = s;
        Short s2 = this.mNumChannels;
        objectArray[1] = s2;
        Integer n = this.mSampleRate;
        objectArray[2] = n;
        Short s3 = this.mBitsPerSample;
        objectArray[3] = s3;
        Integer n2 = this.mNumBytes;
        objectArray[4] = n2;
        return String.format("WaveHeader format=%d numChannels=%d sampleRate=%d bitsPerSample=%d numBytes=%d", objectArray);
    }

    public int write(OutputStream outputStream) throws IOException {
        WaveHeader.writeId(outputStream, "RIFF");
        int n = this.mNumBytes + 36;
        WaveHeader.writeInt(outputStream, n);
        WaveHeader.writeId(outputStream, "WAVE");
        WaveHeader.writeId(outputStream, "fmt ");
        WaveHeader.writeInt(outputStream, 16);
        short s = this.mFormat;
        WaveHeader.writeShort(outputStream, s);
        short s2 = this.mNumChannels;
        WaveHeader.writeShort(outputStream, s2);
        int n2 = this.mSampleRate;
        WaveHeader.writeInt(outputStream, n2);
        short s3 = this.mNumChannels;
        int n3 = this.mSampleRate;
        int n4 = s3 * n3;
        short s4 = this.mBitsPerSample;
        int n5 = n4 * s4 / 8;
        WaveHeader.writeInt(outputStream, n5);
        short s5 = this.mNumChannels;
        short s6 = this.mBitsPerSample;
        short s7 = (short)(s5 * s6 / 8);
        WaveHeader.writeShort(outputStream, s7);
        short s8 = this.mBitsPerSample;
        WaveHeader.writeShort(outputStream, s8);
        WaveHeader.writeId(outputStream, "data");
        int n6 = this.mNumBytes;
        WaveHeader.writeInt(outputStream, n6);
        return 44;
    }
}

