/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.speech.tts.ITts;
import android.speech.tts.ITtsCallback;
import android.util.Log;
import java.util.HashMap;
import java.util.Locale;

public class TextToSpeech {
    public static final String ACTION_TTS_QUEUE_PROCESSING_COMPLETED = "android.speech.tts.TTS_QUEUE_PROCESSING_COMPLETED";
    public static final int ERROR = 255;
    public static final int LANG_AVAILABLE = 0;
    public static final int LANG_COUNTRY_AVAILABLE = 1;
    public static final int LANG_COUNTRY_VAR_AVAILABLE = 2;
    public static final int LANG_MISSING_DATA = 255;
    public static final int LANG_NOT_SUPPORTED = 254;
    public static final int QUEUE_ADD = 1;
    public static final int QUEUE_FLUSH;
    public static final int SUCCESS;
    private String[] mCachedParams;
    private Context mContext = null;
    private ITts mITts = null;
    private ITtsCallback mITtscallback = null;
    private OnInitListener mInitListener = null;
    private String mPackageName = "";
    private ServiceConnection mServiceConnection;
    private final Object mStartLock;
    private boolean mStarted = false;

    public TextToSpeech(Context context, OnInitListener onInitListener) {
        String string2;
        String string3;
        Object object;
        this.mStartLock = object = new Object();
        this.mContext = context;
        this.mPackageName = string3 = this.mContext.getPackageName();
        this.mInitListener = onInitListener;
        String[] stringArray = new String[16];
        this.mCachedParams = stringArray;
        this.mCachedParams[0] = "rate";
        this.mCachedParams[2] = "language";
        this.mCachedParams[4] = "country";
        this.mCachedParams[6] = "variant";
        this.mCachedParams[8] = "streamType";
        this.mCachedParams[10] = "utteranceId";
        this.mCachedParams[12] = "engine";
        this.mCachedParams[14] = "pitch";
        this.mCachedParams[1] = "";
        this.mCachedParams[3] = "";
        this.mCachedParams[5] = "";
        this.mCachedParams[7] = "";
        String[] stringArray2 = this.mCachedParams;
        stringArray2[9] = string2 = String.valueOf(3);
        this.mCachedParams[11] = "";
        this.mCachedParams[13] = "";
        this.mCachedParams[15] = "100";
        this.initTts();
    }

    static /* synthetic */ ITts access$102(TextToSpeech textToSpeech, ITts iTts) {
        textToSpeech.mITts = iTts;
        return iTts;
    }

    static /* synthetic */ boolean access$202(TextToSpeech textToSpeech, boolean bl) {
        textToSpeech.mStarted = bl;
        return bl;
    }

    static /* synthetic */ OnInitListener access$302(TextToSpeech textToSpeech, OnInitListener onInitListener) {
        textToSpeech.mInitListener = onInitListener;
        return onInitListener;
    }

    private void initTts() {
        ServiceConnection serviceConnection;
        this.mStarted = false;
        this.mServiceConnection = serviceConnection = new ServiceConnection(){

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                Object object = TextToSpeech.this.mStartLock;
                synchronized (object) {
                    TextToSpeech textToSpeech = TextToSpeech.this;
                    ITts iTts = ITts.Stub.asInterface(iBinder);
                    ITts iTts2 = TextToSpeech.access$102(textToSpeech, iTts);
                    boolean bl = TextToSpeech.access$202(TextToSpeech.this, true);
                    TextToSpeech textToSpeech2 = TextToSpeech.this;
                    String string2 = TextToSpeech.this.getDefaultEngine();
                    int n = textToSpeech2.setEngineByPackageName(string2);
                    TextToSpeech textToSpeech3 = TextToSpeech.this;
                    Locale locale = TextToSpeech.this.getLanguage();
                    int n2 = textToSpeech3.setLanguage(locale);
                    if (TextToSpeech.this.mInitListener != null) {
                        TextToSpeech.this.mInitListener.onInit(0);
                    }
                    return;
                }
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
                Object object = TextToSpeech.this.mStartLock;
                synchronized (object) {
                    ITts iTts = TextToSpeech.access$102(TextToSpeech.this, null);
                    OnInitListener onInitListener = TextToSpeech.access$302(TextToSpeech.this, null);
                    boolean bl = TextToSpeech.access$202(TextToSpeech.this, false);
                    return;
                }
            }
        };
        Intent intent = new Intent("android.intent.action.START_TTS_SERVICE");
        Intent intent2 = intent.addCategory("android.intent.category.TTS");
        Context context = this.mContext;
        ServiceConnection serviceConnection2 = this.mServiceConnection;
        if (!context.bindService(intent, serviceConnection2, 1)) {
            int n = Log.e("TextToSpeech.java", "initTts() failed to bind to service");
            if (this.mInitListener == null) {
                return;
            }
            this.mInitListener.onInit(-1);
            return;
        }
        int n = Log.i("TextToSpeech.java", "initTts() successfully bound to service");
    }

    private void resetCachedParams() {
        String string2;
        String[] stringArray = this.mCachedParams;
        stringArray[9] = string2 = String.valueOf(3);
        this.mCachedParams[11] = "";
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addEarcon(String string2, String string3) {
        Object object = this.mStartLock;
        synchronized (object) {
            if (!this.mStarted) {
                return -1;
            }
            try {
                ITts iTts = this.mITts;
                String string4 = this.mPackageName;
                iTts.addEarconFile(string4, string2, string3);
                return 0;
            }
            catch (RemoteException remoteException) {
                block8: {
                    int n = Log.e("TextToSpeech.java - addEarcon", "RemoteException");
                    remoteException.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    break block8;
                    catch (NullPointerException nullPointerException) {
                        int n2 = Log.e("TextToSpeech.java - addEarcon", "NullPointerException");
                        nullPointerException.printStackTrace();
                        this.mStarted = false;
                        this.initTts();
                        break block8;
                    }
                    catch (IllegalStateException illegalStateException) {
                        int n3 = Log.e("TextToSpeech.java - addEarcon", "IllegalStateException");
                        illegalStateException.printStackTrace();
                        this.mStarted = false;
                        this.initTts();
                    }
                }
                return -1;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addEarcon(String string2, String string3, int n) {
        Object object = this.mStartLock;
        synchronized (object) {
            if (!this.mStarted) {
                return -1;
            }
            try {
                ITts iTts = this.mITts;
                String string4 = this.mPackageName;
                iTts.addEarcon(string4, string2, string3, n);
                return 0;
            }
            catch (RemoteException remoteException) {
                block8: {
                    int n2 = Log.e("TextToSpeech.java - addEarcon", "RemoteException");
                    remoteException.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    break block8;
                    catch (NullPointerException nullPointerException) {
                        int n3 = Log.e("TextToSpeech.java - addEarcon", "NullPointerException");
                        nullPointerException.printStackTrace();
                        this.mStarted = false;
                        this.initTts();
                        break block8;
                    }
                    catch (IllegalStateException illegalStateException) {
                        int n4 = Log.e("TextToSpeech.java - addEarcon", "IllegalStateException");
                        illegalStateException.printStackTrace();
                        this.mStarted = false;
                        this.initTts();
                    }
                }
                return -1;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addSpeech(String string2, String string3) {
        Object object = this.mStartLock;
        synchronized (object) {
            if (!this.mStarted) {
                return -1;
            }
            try {
                ITts iTts = this.mITts;
                String string4 = this.mPackageName;
                iTts.addSpeechFile(string4, string2, string3);
                return 0;
            }
            catch (RemoteException remoteException) {
                block8: {
                    int n = Log.e("TextToSpeech.java - addSpeech", "RemoteException");
                    remoteException.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    break block8;
                    catch (NullPointerException nullPointerException) {
                        int n2 = Log.e("TextToSpeech.java - addSpeech", "NullPointerException");
                        nullPointerException.printStackTrace();
                        this.mStarted = false;
                        this.initTts();
                        break block8;
                    }
                    catch (IllegalStateException illegalStateException) {
                        int n3 = Log.e("TextToSpeech.java - addSpeech", "IllegalStateException");
                        illegalStateException.printStackTrace();
                        this.mStarted = false;
                        this.initTts();
                    }
                }
                return -1;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addSpeech(String string2, String string3, int n) {
        Object object = this.mStartLock;
        synchronized (object) {
            if (!this.mStarted) {
                return -1;
            }
            try {
                ITts iTts = this.mITts;
                String string4 = this.mPackageName;
                iTts.addSpeech(string4, string2, string3, n);
                return 0;
            }
            catch (RemoteException remoteException) {
                block8: {
                    int n2 = Log.e("TextToSpeech.java - addSpeech", "RemoteException");
                    remoteException.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    break block8;
                    catch (NullPointerException nullPointerException) {
                        int n3 = Log.e("TextToSpeech.java - addSpeech", "NullPointerException");
                        nullPointerException.printStackTrace();
                        this.mStarted = false;
                        this.initTts();
                        break block8;
                    }
                    catch (IllegalStateException illegalStateException) {
                        int n4 = Log.e("TextToSpeech.java - addSpeech", "IllegalStateException");
                        illegalStateException.printStackTrace();
                        this.mStarted = false;
                        this.initTts();
                    }
                }
                return -1;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean areDefaultsEnforced() {
        Object object = this.mStartLock;
        synchronized (object) {
            boolean bl = false;
            if (!this.mStarted) {
                return false;
            }
            try {
                boolean bl2;
                bl = bl2 = this.mITts.areDefaultsEnforced();
            }
            catch (RemoteException remoteException) {
                int n = Log.e("TextToSpeech.java - areDefaultsEnforced", "RemoteException");
                remoteException.printStackTrace();
                this.mStarted = false;
                this.initTts();
                return false;
                catch (NullPointerException nullPointerException) {
                    int n2 = Log.e("TextToSpeech.java - areDefaultsEnforced", "NullPointerException");
                    nullPointerException.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return false;
                }
                catch (IllegalStateException illegalStateException) {
                    try {
                        int n3 = Log.e("TextToSpeech.java - areDefaultsEnforced", "IllegalStateException");
                        illegalStateException.printStackTrace();
                        this.mStarted = false;
                        this.initTts();
                        return false;
                    }
                    catch (Throwable throwable) {}
                }
                return false;
            }
            return bl;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDefaultEngine() {
        Object object = this.mStartLock;
        synchronized (object) {
            String string2 = "";
            if (!this.mStarted) {
                return string2;
            }
            try {
                String string3;
                string2 = string3 = this.mITts.getDefaultEngine();
            }
            catch (RemoteException remoteException) {
                int n = Log.e("TextToSpeech.java - setEngineByPackageName", "RemoteException");
                remoteException.printStackTrace();
                this.mStarted = false;
                this.initTts();
                return string2;
                {
                    catch (Throwable throwable) {}
                }
                catch (NullPointerException nullPointerException) {
                    int n2 = Log.e("TextToSpeech.java - setEngineByPackageName", "NullPointerException");
                    nullPointerException.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return string2;
                    catch (IllegalStateException illegalStateException) {
                        int n3 = Log.e("TextToSpeech.java - setEngineByPackageName", "IllegalStateException");
                        illegalStateException.printStackTrace();
                        this.mStarted = false;
                        this.initTts();
                        return string2;
                    }
                }
            }
            return string2;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Locale getLanguage() {
        Object object = this.mStartLock;
        synchronized (object) {
            block9: {
                if (!this.mStarted) {
                    return null;
                }
                if (this.mCachedParams[3].length() >= 1) break block9;
                String[] stringArray = this.mITts.getLanguage();
                if (stringArray == null) return null;
                if (stringArray.length != 3) return null;
                String string2 = stringArray[0];
                String string3 = stringArray[1];
                String string4 = stringArray[2];
                Locale locale = new Locale(string2, string3, string4);
                return locale;
            }
            try {
                String string5 = this.mCachedParams[3];
                String string6 = this.mCachedParams[5];
                String string7 = this.mCachedParams[7];
                Locale locale = new Locale(string5, string6, string7);
                return locale;
            }
            catch (RemoteException remoteException) {
                block10: {
                    int n = Log.e("TextToSpeech.java - getLanguage", "RemoteException");
                    remoteException.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    break block10;
                    catch (NullPointerException nullPointerException) {
                        int n2 = Log.e("TextToSpeech.java - getLanguage", "NullPointerException");
                        nullPointerException.printStackTrace();
                        this.mStarted = false;
                        this.initTts();
                        break block10;
                    }
                    catch (IllegalStateException illegalStateException) {
                        int n3 = Log.e("TextToSpeech.java - getLanguage", "IllegalStateException");
                        illegalStateException.printStackTrace();
                        this.mStarted = false;
                        this.initTts();
                    }
                }
                return null;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int isLanguageAvailable(Locale locale) {
        Object object = this.mStartLock;
        synchronized (object) {
            int n = -1;
            if (!this.mStarted) {
                return -1;
            }
            try {
                int n2;
                ITts iTts = this.mITts;
                String string2 = locale.getISO3Language();
                String string3 = locale.getISO3Country();
                String string4 = locale.getVariant();
                String[] stringArray = this.mCachedParams;
                n = n2 = iTts.isLanguageAvailable(string2, string3, string4, stringArray);
            }
            catch (RemoteException remoteException) {
                int n3 = Log.e("TextToSpeech.java - isLanguageAvailable", "RemoteException");
                remoteException.printStackTrace();
                this.mStarted = false;
                this.initTts();
                return n;
                {
                    catch (Throwable throwable) {}
                }
                catch (NullPointerException nullPointerException) {
                    int n4 = Log.e("TextToSpeech.java - isLanguageAvailable", "NullPointerException");
                    nullPointerException.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return n;
                    catch (IllegalStateException illegalStateException) {
                        int n5 = Log.e("TextToSpeech.java - isLanguageAvailable", "IllegalStateException");
                        illegalStateException.printStackTrace();
                        this.mStarted = false;
                        this.initTts();
                        return n;
                    }
                }
            }
            return n;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSpeaking() {
        Object object = this.mStartLock;
        synchronized (object) {
            boolean bl;
            if (!this.mStarted) {
                return false;
            }
            try {
                boolean bl2;
                bl = bl2 = this.mITts.isSpeaking();
            }
            catch (RemoteException remoteException) {
                block8: {
                    int n = Log.e("TextToSpeech.java - isSpeaking", "RemoteException");
                    remoteException.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    break block8;
                    catch (NullPointerException nullPointerException) {
                        int n2 = Log.e("TextToSpeech.java - isSpeaking", "NullPointerException");
                        nullPointerException.printStackTrace();
                        this.mStarted = false;
                        this.initTts();
                        break block8;
                    }
                    catch (IllegalStateException illegalStateException) {
                        int n3 = Log.e("TextToSpeech.java - isSpeaking", "IllegalStateException");
                        illegalStateException.printStackTrace();
                        this.mStarted = false;
                        this.initTts();
                    }
                }
                return false;
            }
            return bl;
        }
    }

    /*
     * Exception decompiling
     */
    public int playEarcon(String var1_1, int var2_2, HashMap<String, String> var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [9 : 205->215)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int playSilence(long var1_1, int var3_2, HashMap<String, String> var4_3) {
        var5_4 = this.mStartLock;
        synchronized (var5_4) {
            var6_5 = -1;
            if (!this.mStarted) {
                return -1;
            }
            if (var4_3 == null) ** GOTO lbl10
            try {
                if (!var4_3.isEmpty() && (var8_7 = var4_3.get("utteranceId")) != null) {
                    this.mCachedParams[11] = var8_7;
                }
lbl10:
                // 4 sources

                var9_8 = this.mITts;
                var10_9 = this.mPackageName;
                var11_10 = this.mCachedParams;
                var12_11 = var1_1;
                var14_12 = var3_2;
                var6_5 = var15_13 = var9_8.playSilence(var10_9, var12_11, var14_12, var11_10);
            }
            catch (RemoteException var16_14) {
                var17_17 = Log.e("TextToSpeech.java - playSilence", "RemoteException");
                var16_14.printStackTrace();
                this.mStarted = false;
                this.initTts();
                return var6_5;
                {
                    catch (Throwable var21_20) {}
                }
                catch (NullPointerException var16_15) {
                    var19_18 = Log.e("TextToSpeech.java - playSilence", "NullPointerException");
                    var16_15.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return var6_5;
                    catch (IllegalStateException var16_16) {
                        var20_19 = Log.e("TextToSpeech.java - playSilence", "IllegalStateException");
                        var16_16.printStackTrace();
                        this.mStarted = false;
                        this.initTts();
                        return var6_5;
                    }
                }
            }
            return var6_5;
            return var6_5;
        }
    }

    /*
     * Exception decompiling
     */
    public int setEngineByPackageName(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [11 : 126->161)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int setLanguage(Locale locale) {
        Object object = this.mStartLock;
        synchronized (object) {
            int n = -1;
            if (!this.mStarted) {
                return -1;
            }
            if (locale == null) {
                return -1;
            }
            try {
                try {
                    String string2 = locale.getISO3Language();
                    String string3 = locale.getISO3Country();
                    String string4 = locale.getVariant();
                    ITts iTts = this.mITts;
                    String[] stringArray = this.mCachedParams;
                    n = iTts.isLanguageAvailable(string2, string3, string4, stringArray);
                    if (n < 0) return n;
                    this.mCachedParams[3] = string2;
                    this.mCachedParams[5] = n >= 1 ? string3 : "";
                    if (n >= 2) {
                        this.mCachedParams[7] = string4;
                    } else {
                        this.mCachedParams[7] = "";
                    }
                    return n;
                }
                catch (RemoteException remoteException) {
                    int n2 = Log.e("TextToSpeech.java - setLanguage", "RemoteException");
                    remoteException.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return n;
                }
                catch (NullPointerException nullPointerException) {
                    int n3 = Log.e("TextToSpeech.java - setLanguage", "NullPointerException");
                    nullPointerException.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return n;
                }
                catch (IllegalStateException illegalStateException) {
                    int n4 = Log.e("TextToSpeech.java - setLanguage", "IllegalStateException");
                    illegalStateException.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                }
                return n;
            }
            catch (Throwable throwable) {}
            return n;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int setOnUtteranceCompletedListener(final OnUtteranceCompletedListener onUtteranceCompletedListener) {
        Object object = this.mStartLock;
        synchronized (object) {
            int n = -1;
            if (!this.mStarted) {
                return -1;
            }
            ITtsCallback.Stub stub = new ITtsCallback.Stub(){

                @Override
                public void utteranceCompleted(String string2) throws RemoteException {
                    if (onUtteranceCompletedListener == null) {
                        return;
                    }
                    onUtteranceCompletedListener.onUtteranceCompleted(string2);
                }
            };
            this.mITtscallback = stub;
            try {
                int n2;
                ITts iTts = this.mITts;
                String string2 = this.mPackageName;
                ITtsCallback iTtsCallback = this.mITtscallback;
                n = n2 = iTts.registerCallback(string2, iTtsCallback);
            }
            catch (RemoteException remoteException) {
                int n3 = Log.e("TextToSpeech.java - registerCallback", "RemoteException");
                remoteException.printStackTrace();
                this.mStarted = false;
                this.initTts();
                return n;
                {
                    catch (Throwable throwable) {}
                }
                catch (NullPointerException nullPointerException) {
                    int n4 = Log.e("TextToSpeech.java - registerCallback", "NullPointerException");
                    nullPointerException.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return n;
                    catch (IllegalStateException illegalStateException) {
                        int n5 = Log.e("TextToSpeech.java - registerCallback", "IllegalStateException");
                        illegalStateException.printStackTrace();
                        this.mStarted = false;
                        this.initTts();
                        return n;
                    }
                }
            }
            return n;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int setPitch(float f) {
        Object object = this.mStartLock;
        synchronized (object) {
            int n = -1;
            if (!this.mStarted) {
                return -1;
            }
            if (!(f > 0.0f)) return n;
            int n2 = (int)(100.0f * f);
            try {
                String string2;
                String[] stringArray = this.mCachedParams;
                stringArray[15] = string2 = String.valueOf(n2);
                return 0;
            }
            catch (NullPointerException nullPointerException) {
                int n3 = Log.e("TextToSpeech.java - setPitch", "NullPointerException");
                nullPointerException.printStackTrace();
                this.mStarted = false;
                this.initTts();
                return n;
                {
                    catch (Throwable throwable) {}
                }
                catch (IllegalStateException illegalStateException) {
                    int n4 = Log.e("TextToSpeech.java - setPitch", "IllegalStateException");
                    illegalStateException.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return n;
                }
            }
            return n;
        }
    }

    /*
     * Loose catch block
     * WARNING - bad return control flow
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int setSpeechRate(float f) {
        Object object = this.mStartLock;
        synchronized (object) {
            int n = -1;
            if (!this.mStarted) {
                return -1;
            }
            if (!(f > 0.0f)) return n;
            int n2 = (int)(100.0f * f);
            try {
                String string2;
                String[] stringArray = this.mCachedParams;
                stringArray[1] = string2 = String.valueOf(n2);
            }
            catch (NullPointerException nullPointerException) {
                int n3 = Log.e("TextToSpeech.java - setSpeechRate", "NullPointerException");
                nullPointerException.printStackTrace();
                this.mStarted = false;
                this.initTts();
                return n;
                {
                    catch (Throwable throwable) {}
                }
                catch (IllegalStateException illegalStateException) {
                    int n4 = Log.e("TextToSpeech.java - setSpeechRate", "IllegalStateException");
                    illegalStateException.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return n;
                }
            }
            if (!(f > 0.0f)) return -1;
            return 0;
            return n;
        }
    }

    public void shutdown() {
        try {
            Context context = this.mContext;
            ServiceConnection serviceConnection = this.mServiceConnection;
            context.unbindService(serviceConnection);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    /*
     * Exception decompiling
     */
    public int speak(String var1_1, int var2_2, HashMap<String, String> var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [9 : 291->301)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int stop() {
        Object object = this.mStartLock;
        synchronized (object) {
            int n = -1;
            if (!this.mStarted) {
                return -1;
            }
            try {
                int n2;
                ITts iTts = this.mITts;
                String string2 = this.mPackageName;
                n = n2 = iTts.stop(string2);
            }
            catch (RemoteException remoteException) {
                int n3 = Log.e("TextToSpeech.java - stop", "RemoteException");
                remoteException.printStackTrace();
                this.mStarted = false;
                this.initTts();
                return n;
                {
                    catch (Throwable throwable) {}
                }
                catch (NullPointerException nullPointerException) {
                    int n4 = Log.e("TextToSpeech.java - stop", "NullPointerException");
                    nullPointerException.printStackTrace();
                    this.mStarted = false;
                    this.initTts();
                    return n;
                    catch (IllegalStateException illegalStateException) {
                        int n5 = Log.e("TextToSpeech.java - stop", "IllegalStateException");
                        illegalStateException.printStackTrace();
                        this.mStarted = false;
                        this.initTts();
                        return n;
                    }
                }
            }
            return n;
        }
    }

    /*
     * Exception decompiling
     */
    public int synthesizeToFile(String var1_1, HashMap<String, String> var2_2, String var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [9 : 277->287)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public class Engine {
        public static final String ACTION_CHECK_TTS_DATA = "android.speech.tts.engine.CHECK_TTS_DATA";
        public static final String ACTION_INSTALL_TTS_DATA = "android.speech.tts.engine.INSTALL_TTS_DATA";
        public static final String ACTION_TTS_DATA_INSTALLED = "android.speech.tts.engine.TTS_DATA_INSTALLED";
        public static final int CHECK_VOICE_DATA_BAD_DATA = 255;
        public static final int CHECK_VOICE_DATA_FAIL = 0;
        public static final int CHECK_VOICE_DATA_MISSING_DATA = 254;
        public static final int CHECK_VOICE_DATA_MISSING_VOLUME = 253;
        public static final int CHECK_VOICE_DATA_PASS = 1;
        public static final int DEFAULT_PITCH = 100;
        public static final int DEFAULT_RATE = 100;
        public static final int DEFAULT_STREAM = 3;
        public static final String DEFAULT_SYNTH = "com.svox.pico";
        public static final String EXTRA_AVAILABLE_VOICES = "availableVoices";
        public static final String EXTRA_CHECK_VOICE_DATA_FOR = "checkVoiceDataFor";
        public static final String EXTRA_TTS_DATA_INSTALLED = "dataInstalled";
        public static final String EXTRA_UNAVAILABLE_VOICES = "unavailableVoices";
        public static final String EXTRA_VOICE_DATA_FILES = "dataFiles";
        public static final String EXTRA_VOICE_DATA_FILES_INFO = "dataFilesInfo";
        public static final String EXTRA_VOICE_DATA_ROOT_DIRECTORY = "dataRoot";
        public static final String KEY_PARAM_COUNTRY = "country";
        public static final String KEY_PARAM_ENGINE = "engine";
        public static final String KEY_PARAM_LANGUAGE = "language";
        public static final String KEY_PARAM_PITCH = "pitch";
        public static final String KEY_PARAM_RATE = "rate";
        public static final String KEY_PARAM_STREAM = "streamType";
        public static final String KEY_PARAM_UTTERANCE_ID = "utteranceId";
        public static final String KEY_PARAM_VARIANT = "variant";
        protected static final int NB_CACHED_PARAMS = 8;
        protected static final int PARAM_POSITION_COUNTRY = 4;
        protected static final int PARAM_POSITION_ENGINE = 12;
        protected static final int PARAM_POSITION_LANGUAGE = 2;
        protected static final int PARAM_POSITION_PITCH = 14;
        protected static final int PARAM_POSITION_RATE = 0;
        protected static final int PARAM_POSITION_STREAM = 8;
        protected static final int PARAM_POSITION_UTTERANCE_ID = 10;
        protected static final int PARAM_POSITION_VARIANT = 6;
        public static final int USE_DEFAULTS;
    }

    public static interface OnUtteranceCompletedListener {
        public void onUtteranceCompleted(String var1);
    }

    public static interface OnInitListener {
        public void onInit(int var1);
    }
}

