/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.telephony.PhoneNumberUtils;
import android.text.Editable;
import android.text.Selection;
import android.text.TextWatcher;
import java.util.Locale;

public class PhoneNumberFormattingTextWatcher
implements TextWatcher {
    private static Locale sCachedLocale;
    private static int sFormatType;
    private boolean mDeletingBackward;
    private boolean mDeletingHyphen;
    private boolean mFormatting;
    private int mHyphenStart;

    public PhoneNumberFormattingTextWatcher() {
        Locale locale;
        Locale locale2;
        if (sCachedLocale != null && (locale2 = sCachedLocale) == (locale = Locale.getDefault())) {
            return;
        }
        sCachedLocale = Locale.getDefault();
        sFormatType = PhoneNumberUtils.getFormatTypeForLocale(sCachedLocale);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void afterTextChanged(Editable editable) {
        synchronized (this) {
            if (!this.mFormatting) {
                this.mFormatting = true;
                if (this.mDeletingHyphen && this.mHyphenStart > 0) {
                    if (this.mDeletingBackward) {
                        int n = this.mHyphenStart - 1;
                        int n2 = editable.length();
                        if (n < n2) {
                            int n3 = this.mHyphenStart - 1;
                            int n4 = this.mHyphenStart;
                            Editable editable2 = editable.delete(n3, n4);
                        }
                    } else {
                        int n = this.mHyphenStart;
                        int n5 = editable.length();
                        if (n < n5) {
                            int n6 = this.mHyphenStart;
                            int n7 = this.mHyphenStart + 1;
                            Editable editable3 = editable.delete(n6, n7);
                        }
                    }
                }
                int n = sFormatType;
                PhoneNumberUtils.formatNumber(editable, n);
                this.mFormatting = false;
            }
            return;
        }
    }

    @Override
    public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        if (this.mFormatting) {
            return;
        }
        int n4 = Selection.getSelectionStart(charSequence);
        int n5 = Selection.getSelectionEnd(charSequence);
        if (charSequence.length() > 1 && n2 == 1 && n3 == 0 && charSequence.charAt(n) == '-' && n4 != n5) {
            this.mDeletingHyphen = true;
            this.mHyphenStart = n;
            int n6 = n + 1;
            if (n4 != n6) {
                this.mDeletingBackward = true;
                return;
            }
            this.mDeletingBackward = false;
            return;
        }
        this.mDeletingHyphen = false;
    }

    @Override
    public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
    }
}

