/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.SystemProperties;
import android.telephony.JapanesePhoneNumberFormatter;
import android.telephony.TelephonyManager;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseIntArray;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PhoneNumberUtils {
    private static final int CCC_LENGTH = 0;
    private static final boolean[] COUNTLY_CALLING_CALL;
    private static final boolean DBG = false;
    public static final int FORMAT_JAPAN = 2;
    public static final int FORMAT_NANP = 1;
    public static final int FORMAT_UNKNOWN = 0;
    private static final Pattern GLOBAL_PHONE_NUMBER_PATTERN;
    private static final SparseIntArray KEYPAD_MAP;
    static final String LOG_TAG = "PhoneNumberUtils";
    static final int MIN_MATCH = 7;
    private static final String[] NANP_COUNTRIES;
    private static final String NANP_IDP_STRING = "011";
    private static final int NANP_LENGTH = 10;
    private static final int NANP_STATE_DASH = 4;
    private static final int NANP_STATE_DIGIT = 1;
    private static final int NANP_STATE_ONE = 3;
    private static final int NANP_STATE_PLUS = 2;
    public static final char PAUSE = ',';
    private static final char PLUS_SIGN_CHAR = '+';
    private static final String PLUS_SIGN_STRING = "+";
    public static final int TOA_International = 145;
    public static final int TOA_Unknown = 129;
    public static final char WAIT = ';';
    public static final char WILD = 'N';

    static {
        GLOBAL_PHONE_NUMBER_PATTERN = Pattern.compile("[\\+]?[0-9.-]+");
        String[] stringArray = new String[]{"US", "CA", "AS", "AI", "AG", "BS", "BB", "BM", "VG", "KY", "DM", "DO", "GD", "GU", "JM", "PR", "MS", "MP", "KN", "LC", "VC", "TT", "TC", "VI"};
        NANP_COUNTRIES = stringArray;
        KEYPAD_MAP = new SparseIntArray();
        KEYPAD_MAP.put(97, 50);
        KEYPAD_MAP.put(98, 50);
        KEYPAD_MAP.put(99, 50);
        KEYPAD_MAP.put(65, 50);
        KEYPAD_MAP.put(66, 50);
        KEYPAD_MAP.put(67, 50);
        KEYPAD_MAP.put(100, 51);
        KEYPAD_MAP.put(101, 51);
        KEYPAD_MAP.put(102, 51);
        KEYPAD_MAP.put(68, 51);
        KEYPAD_MAP.put(69, 51);
        KEYPAD_MAP.put(70, 51);
        KEYPAD_MAP.put(103, 52);
        KEYPAD_MAP.put(104, 52);
        KEYPAD_MAP.put(105, 52);
        KEYPAD_MAP.put(71, 52);
        KEYPAD_MAP.put(72, 52);
        KEYPAD_MAP.put(73, 52);
        KEYPAD_MAP.put(106, 53);
        KEYPAD_MAP.put(107, 53);
        KEYPAD_MAP.put(108, 53);
        KEYPAD_MAP.put(74, 53);
        KEYPAD_MAP.put(75, 53);
        KEYPAD_MAP.put(76, 53);
        KEYPAD_MAP.put(109, 54);
        KEYPAD_MAP.put(110, 54);
        KEYPAD_MAP.put(111, 54);
        KEYPAD_MAP.put(77, 54);
        KEYPAD_MAP.put(78, 54);
        KEYPAD_MAP.put(79, 54);
        KEYPAD_MAP.put(112, 55);
        KEYPAD_MAP.put(113, 55);
        KEYPAD_MAP.put(114, 55);
        KEYPAD_MAP.put(115, 55);
        KEYPAD_MAP.put(80, 55);
        KEYPAD_MAP.put(81, 55);
        KEYPAD_MAP.put(82, 55);
        KEYPAD_MAP.put(83, 55);
        KEYPAD_MAP.put(116, 56);
        KEYPAD_MAP.put(117, 56);
        KEYPAD_MAP.put(118, 56);
        KEYPAD_MAP.put(84, 56);
        KEYPAD_MAP.put(85, 56);
        KEYPAD_MAP.put(86, 56);
        KEYPAD_MAP.put(119, 57);
        KEYPAD_MAP.put(120, 57);
        KEYPAD_MAP.put(121, 57);
        KEYPAD_MAP.put(122, 57);
        KEYPAD_MAP.put(87, 57);
        KEYPAD_MAP.put(88, 57);
        KEYPAD_MAP.put(89, 57);
        KEYPAD_MAP.put(90, 57);
        COUNTLY_CALLING_CALL = new boolean[]{true, true, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true, true, false, true, true, true, true, true, false, true, false, false, true, true, false, false, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, false, true, false, false, true, true, true, true, true, true, true, false, false, true, false};
        CCC_LENGTH = COUNTLY_CALLING_CALL.length;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String appendPwCharBackToOrigDialStr(int n, String string2, String string3) {
        if (n == 1) {
            StringBuilder stringBuilder = new StringBuilder(string2);
            char c = string3.charAt(0);
            return stringBuilder.append(c).toString();
        }
        String string4 = string3.substring(0, n);
        return string2.concat(string4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static char bcdToChar(byte by) {
        if (by < 10) {
            return (char)(by + 48);
        }
        switch (by) {
            default: {
                return '\u0000';
            }
            case 10: {
                return '*';
            }
            case 11: {
                return '#';
            }
            case 12: {
                return ',';
            }
            case 13: 
        }
        return 'N';
    }

    public static String calledPartyBCDFragmentToString(byte[] byArray, int n, int n2) {
        int n3 = n2 * 2;
        StringBuilder stringBuilder = new StringBuilder(n3);
        PhoneNumberUtils.internalCalledPartyBCDFragmentToString(stringBuilder, byArray, n, n2);
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String calledPartyBCDToString(byte[] byArray, int n, int n2) {
        boolean bl = false;
        int n3 = n2 * 2 + 1;
        StringBuilder stringBuilder = new StringBuilder(n3);
        if (n2 < 2) {
            return "";
        }
        if ((byArray[n] & 0xF0) == 144) {
            bl = true;
        }
        int n4 = n + 1;
        int n5 = n2 - 1;
        PhoneNumberUtils.internalCalledPartyBCDFragmentToString(stringBuilder, byArray, n4, n5);
        if (bl && stringBuilder.length() == 0) {
            return "";
        }
        if (!bl) return stringBuilder.toString();
        String string2 = stringBuilder.toString();
        Matcher matcher = Pattern.compile("(^[#*])(.*)([#*])(.*)(#)$").matcher(string2);
        if (matcher.matches()) {
            String string3 = matcher.group(2);
            if ("".equals(string3)) {
                stringBuilder = new StringBuilder();
                String string4 = matcher.group(1);
                StringBuilder stringBuilder2 = stringBuilder.append(string4);
                String string5 = matcher.group(3);
                StringBuilder stringBuilder3 = stringBuilder.append(string5);
                String string6 = matcher.group(4);
                StringBuilder stringBuilder4 = stringBuilder.append(string6);
                String string7 = matcher.group(5);
                StringBuilder stringBuilder5 = stringBuilder.append(string7);
                StringBuilder stringBuilder6 = stringBuilder.append(PLUS_SIGN_STRING);
                return stringBuilder.toString();
            }
            stringBuilder = new StringBuilder();
            String string8 = matcher.group(1);
            StringBuilder stringBuilder7 = stringBuilder.append(string8);
            String string9 = matcher.group(2);
            StringBuilder stringBuilder8 = stringBuilder.append(string9);
            String string10 = matcher.group(3);
            StringBuilder stringBuilder9 = stringBuilder.append(string10);
            StringBuilder stringBuilder10 = stringBuilder.append(PLUS_SIGN_STRING);
            String string11 = matcher.group(4);
            StringBuilder stringBuilder11 = stringBuilder.append(string11);
            String string12 = matcher.group(5);
            StringBuilder stringBuilder12 = stringBuilder.append(string12);
            return stringBuilder.toString();
        }
        matcher = Pattern.compile("(^[#*])(.*)([#*])(.*)").matcher(string2);
        if (matcher.matches()) {
            stringBuilder = new StringBuilder();
            String string13 = matcher.group(1);
            StringBuilder stringBuilder13 = stringBuilder.append(string13);
            String string14 = matcher.group(2);
            StringBuilder stringBuilder14 = stringBuilder.append(string14);
            String string15 = matcher.group(3);
            StringBuilder stringBuilder15 = stringBuilder.append(string15);
            StringBuilder stringBuilder16 = stringBuilder.append(PLUS_SIGN_STRING);
            String string16 = matcher.group(4);
            StringBuilder stringBuilder17 = stringBuilder.append(string16);
            return stringBuilder.toString();
        }
        stringBuilder = new StringBuilder();
        StringBuilder stringBuilder18 = stringBuilder.append('+');
        StringBuilder stringBuilder19 = stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String cdmaCheckAndProcessPlusCode(String string2) {
        if (TextUtils.isEmpty(string2)) return string2;
        if (!PhoneNumberUtils.isReallyDialable(string2.charAt(0))) return string2;
        if (!PhoneNumberUtils.isNonSeparator(string2)) return string2;
        String string3 = SystemProperties.get("gsm.operator.iso-country", "");
        String string4 = SystemProperties.get("gsm.sim.operator.iso-country", "");
        if (TextUtils.isEmpty(string3)) return string2;
        if (TextUtils.isEmpty(string4)) return string2;
        int n = PhoneNumberUtils.getFormatTypeFromCountryCode(string3);
        int n2 = PhoneNumberUtils.getFormatTypeFromCountryCode(string4);
        return PhoneNumberUtils.cdmaCheckAndProcessPlusCodeByNumberFormat(string2, n, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String cdmaCheckAndProcessPlusCodeByNumberFormat(String string2, int n, int n2) {
        String string3 = string2;
        if (string2 == null) return string3;
        if (string2.lastIndexOf(PLUS_SIGN_STRING) == -1) return string3;
        if (n == n2 || n != 1) {
            int n3 = Log.e("checkAndProcessPlusCode:non-NANP not supported", string2);
            return string3;
        } else {
            String string4 = string2;
            string3 = null;
            do {
                String string5;
                if (TextUtils.isEmpty(string5 = PhoneNumberUtils.processPlusCodeWithinNanp(PhoneNumberUtils.extractNetworkPortion(string4)))) {
                    int n4 = Log.e("checkAndProcessPlusCode: null newDialStr", string5);
                    return string2;
                }
                String string6 = string3 == null ? string5 : string3.concat(string5);
                String string7 = PhoneNumberUtils.extractPostDialPortion(string4);
                if (!TextUtils.isEmpty(string7)) {
                    int n5 = PhoneNumberUtils.findDialableIndexFromPostDialStr(string7);
                    if (n5 >= 1) {
                        String string8 = PhoneNumberUtils.appendPwCharBackToOrigDialStr(n5, string6, string7);
                        string4 = string7.substring(n5);
                    } else {
                        if (n5 < 0) {
                            string7 = "";
                        }
                        int n6 = Log.e("wrong postDialStr=", string7);
                    }
                }
                if (TextUtils.isEmpty(string7)) return string3;
            } while (!TextUtils.isEmpty(string4));
        }
        return string3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int charToBCD(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c == '*') {
            return 10;
        }
        if (c == '#') {
            return 11;
        }
        if (c == ',') {
            return 12;
        }
        if (c == 'N') {
            return 13;
        }
        String string2 = "invalid char for BCD " + c;
        throw new RuntimeException(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkPrefixIsIgnorable(String string2, int n, int n2) {
        while (n2 >= n) {
            if (PhoneNumberUtils.tryGetISODigit(string2.charAt(n2)) >= 0 ? false : PhoneNumberUtils.isDialable(string2.charAt(n2))) {
                return false;
            }
            n2 += -1;
        }
        return true;
    }

    public static boolean compare(Context context, String string2, String string3) {
        boolean bl = context.getResources().getBoolean(17629196);
        return PhoneNumberUtils.compare(string2, string3, bl);
    }

    public static boolean compare(String string2, String string3) {
        return PhoneNumberUtils.compare(string2, string3, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean compare(String string2, String string3, boolean bl) {
        if (!bl) return PhoneNumberUtils.compareLoosely(string2, string3);
        return PhoneNumberUtils.compareStrictly(string2, string3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean compareLoosely(String string2, String string3) {
        int n;
        int n2;
        int n3;
        boolean bl;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        block15: {
            n8 = 0;
            n7 = 0;
            if (string2 == null || string3 == null) {
                if (string2 != string3) return false;
                return true;
            }
            if (string2.length() == 0) return false;
            if (string3.length() == 0) {
                return false;
            }
            int n9 = PhoneNumberUtils.indexOfLastNetworkChar(string2);
            int n10 = PhoneNumberUtils.indexOfLastNetworkChar(string3);
            int n11 = 0;
            n7 = 0;
            n6 = 0;
            int n12 = n10;
            int n13 = n9;
            while (n13 >= 0 && n12 >= 0) {
                int n14;
                int n15;
                int n16;
                char c;
                int n17;
                int n18;
                boolean bl2;
                boolean bl3 = false;
                char c2 = string2.charAt(n13);
                if (!PhoneNumberUtils.isDialable(c2)) {
                    int n19 = n6 + 1;
                    bl2 = true;
                    n18 = n19;
                    n17 = n13 += -1;
                } else {
                    bl2 = bl3;
                    n18 = n6;
                    n17 = n13;
                }
                if (!PhoneNumberUtils.isDialable(c = string3.charAt(n12))) {
                    n12 += -1;
                    bl2 = true;
                    ++n11;
                }
                if (!bl2) {
                    if (c != c2 && c2 != 'N' && c != 'N') {
                        n5 = n12;
                        n4 = n17;
                        n8 = n11;
                        n6 = n18;
                        break block15;
                    }
                    n16 = n17 + -1;
                    n15 = n12 + -1;
                    n14 = n7 + 1;
                } else {
                    n15 = n12;
                    n16 = n17;
                    n14 = n7;
                }
                n7 = n14;
                n12 = n15;
                int n20 = n18;
                int n21 = n16;
            }
            n4 = n13;
            n5 = n12;
            n8 = n11;
        }
        if (n7 < 7) {
            int n22;
            int n23 = string2.length() - n6;
            if (n23 != (n22 = string3.length() - n8) && n23 != n7) {
                int n24 = n8;
                bl = true;
                int n25 = n6;
                return bl;
            }
            int n26 = n8;
            bl = false;
            int n27 = n6;
            return bl;
        }
        if (n7 >= 7 && (n4 < 0 || n5 < 0)) {
            int n28 = n8;
            bl = true;
            int n29 = n6;
            return bl;
        }
        int n30 = n4 + 1;
        if (PhoneNumberUtils.matchIntlPrefix(string2, n30) && PhoneNumberUtils.matchIntlPrefix(string3, n3 = n5 + 1)) {
            int n31 = n8;
            bl = true;
            int n32 = n6;
            return bl;
        }
        int n33 = n4 + 1;
        if (PhoneNumberUtils.matchTrunkPrefix(string2, n33) && PhoneNumberUtils.matchIntlPrefixAndCC(string3, n2 = n5 + 1)) {
            int n34 = n8;
            bl = true;
            int n35 = n6;
            return bl;
        }
        int n36 = n5 + 1;
        if (PhoneNumberUtils.matchTrunkPrefix(string3, n36) && PhoneNumberUtils.matchIntlPrefixAndCC(string2, n = n4 + 1)) {
            int n37 = n8;
            bl = true;
            int n38 = n6;
            return bl;
        }
        int n39 = n8;
        bl = false;
        int n40 = n6;
        return bl;
    }

    public static boolean compareStrictly(String string2, String string3) {
        return PhoneNumberUtils.compareStrictly(string2, string3, true);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static boolean compareStrictly(String string2, String string3, boolean c) {
        void var2_3;
        void var18_31;
        char c2;
        char c3;
        if (string2 == null || string3 == null) {
            if (string2 != string3) return false;
            return true;
        }
        if (string2.length() == 0 && string3.length() == 0) {
            return false;
        }
        char c4 = '\u0000';
        char c5 = '\u0000';
        CountryCallingCodeAndNewIndex countryCallingCodeAndNewIndex = PhoneNumberUtils.tryGetCountryCallingCodeAndNewIndex(string2, c != '\u0000');
        CountryCallingCodeAndNewIndex countryCallingCodeAndNewIndex2 = PhoneNumberUtils.tryGetCountryCallingCodeAndNewIndex(string3, c != '\u0000');
        Object var8_12 = null;
        char c6 = '\u0001';
        char c7 = '\u0000';
        char c8 = '\u0000';
        if (countryCallingCodeAndNewIndex != null && countryCallingCodeAndNewIndex2 != null) {
            int n = countryCallingCodeAndNewIndex.countryCallingCode;
            int n2 = countryCallingCodeAndNewIndex2.countryCallingCode;
            if (n != n2) {
                return false;
            }
            char c9 = countryCallingCodeAndNewIndex.newIndex;
            char c10 = countryCallingCodeAndNewIndex2.newIndex;
            c3 = c8;
            c2 = c7;
            c6 = c9;
            c7 = c10;
            c8 = '\u0000';
            countryCallingCodeAndNewIndex2 = null;
        } else if (countryCallingCodeAndNewIndex == null && countryCallingCodeAndNewIndex2 == null) {
            c3 = c8;
            c2 = c7;
            countryCallingCodeAndNewIndex2 = var8_12;
            c6 = c4;
            c7 = c5;
            c8 = '\u0000';
        } else {
            void var23_22;
            if (countryCallingCodeAndNewIndex != null) {
                int n = countryCallingCodeAndNewIndex.newIndex;
                c4 = c7;
            } else {
                int n = PhoneNumberUtils.tryGetTrunkPrefixOmittedIndex(string3, 0);
                if (n >= 0) {
                    int n3 = n;
                    c4 = '\u0001';
                } else {
                    char c11 = c4;
                    c4 = c7;
                }
            }
            if (countryCallingCodeAndNewIndex2 != null) {
                char c12 = countryCallingCodeAndNewIndex2.newIndex;
                c3 = c8;
                c2 = c4;
                c7 = c12;
                countryCallingCodeAndNewIndex2 = var8_12;
                c8 = c6;
                c6 = var23_22;
            } else {
                char c13 = PhoneNumberUtils.tryGetTrunkPrefixOmittedIndex(string3, 0);
                if (c13 >= '\u0000') {
                    char c14 = c13;
                    c3 = '\u0001';
                    c2 = c4;
                    c8 = c6;
                    c7 = c14;
                    countryCallingCodeAndNewIndex2 = var8_12;
                    c6 = var23_22;
                } else {
                    c3 = c8;
                    c2 = c4;
                    countryCallingCodeAndNewIndex2 = var8_12;
                    c7 = c5;
                    c8 = c6;
                    c6 = var23_22;
                }
            }
        }
        int n = string2.length() - 1;
        int n4 = string3.length() - 1;
        while (var18_31 >= c6 && countryCallingCodeAndNewIndex >= c7) {
            boolean bl = false;
            char c15 = string2.charAt((int)var18_31);
            c5 = string3.charAt((int)countryCallingCodeAndNewIndex);
            if (PhoneNumberUtils.isSeparator(c15)) {
                void var21_42 = var18_31 + -1;
                bl = true;
            }
            if (PhoneNumberUtils.isSeparator(c5)) {
                reference var22_43 = countryCallingCodeAndNewIndex + -1;
                bl = true;
            }
            if (bl) continue;
            if (c15 != c5) {
                return false;
            }
            var18_31 += -1;
            reference var6_9 = countryCallingCodeAndNewIndex + -1;
        }
        if (c8 == '\u0000') {
            Object var28_44 = countryCallingCodeAndNewIndex2 == null ? null : null;
            countryCallingCodeAndNewIndex2 = var28_44;
            var2_3 = var18_31;
        } else {
            if (c2 != '\u0000' && c6 <= var18_31 || !PhoneNumberUtils.checkPrefixIsIgnorable(string2, c6, (int)var18_31)) {
                if (c == null) return false;
                return PhoneNumberUtils.compare(string2, string3, false);
            }
            if (c3 != '\u0000' && c7 <= countryCallingCodeAndNewIndex || !PhoneNumberUtils.checkPrefixIsIgnorable(string3, c6, (int)countryCallingCodeAndNewIndex)) {
                if (c == null) return false;
                return PhoneNumberUtils.compare(string2, string3, false);
            }
            CountryCallingCodeAndNewIndex countryCallingCodeAndNewIndex3 = countryCallingCodeAndNewIndex;
            void var36_53 = var18_31;
            return true;
        }
        while (var2_3 >= c6) {
            void var18_34;
            char c16 = string2.charAt((int)var2_3);
            if (PhoneNumberUtils.isDialable(c16)) {
                if (countryCallingCodeAndNewIndex2 == null) return false;
                if (PhoneNumberUtils.tryGetISODigit(c16) != 1) return false;
                Object var18_33 = null;
            } else {
                CountryCallingCodeAndNewIndex countryCallingCodeAndNewIndex4 = countryCallingCodeAndNewIndex2;
            }
            void var29_45 = var2_3 + -1;
            void var30_46 = var18_34;
        }
        CountryCallingCodeAndNewIndex countryCallingCodeAndNewIndex5 = countryCallingCodeAndNewIndex;
        CountryCallingCodeAndNewIndex countryCallingCodeAndNewIndex6 = countryCallingCodeAndNewIndex2;
        while (true) {
            void var18_37;
            block29: {
                block28: {
                    void var31_47;
                    block27: {
                        if (var31_47 < c7) break block27;
                        char c17 = string3.charAt((int)var31_47);
                        if (!PhoneNumberUtils.isDialable(c17)) break block28;
                        if (countryCallingCodeAndNewIndex6 == null) return false;
                        if (PhoneNumberUtils.tryGetISODigit(c17) != 1) return false;
                        Object var18_36 = null;
                        break block29;
                    }
                    void var33_50 = var31_47;
                    void var34_51 = var2_3;
                    return true;
                }
                CountryCallingCodeAndNewIndex countryCallingCodeAndNewIndex7 = countryCallingCodeAndNewIndex6;
            }
            var31_47 += -1;
            void var32_49 = var18_37;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String convertKeypadLettersToDigits(String string2) {
        if (string2 == null) {
            return string2;
        }
        int n = string2.length();
        if (n == 0) {
            return string2;
        }
        char[] cArray = string2.toCharArray();
        int n2 = 0;
        while (n2 < n) {
            char c;
            char c2 = cArray[n2];
            cArray[n2] = c = (char)KEYPAD_MAP.get(c2, c2);
            ++n2;
        }
        return new String(cArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String extractNetworkPortion(String string2) {
        if (string2 == null) {
            return null;
        }
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            if (PhoneNumberUtils.isDialable(c) && (c != '+' || !bl)) {
                StringBuilder stringBuilder2 = stringBuilder.append(c);
            } else if (PhoneNumberUtils.isStartsPostDial(c)) return stringBuilder.toString();
            ++n2;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String extractNetworkPortionAlt(String string2) {
        if (string2 == null) {
            return null;
        }
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            if (c != '+' || !bl) {
                if (PhoneNumberUtils.isDialable(c)) {
                    StringBuilder stringBuilder2 = stringBuilder.append(c);
                } else if (PhoneNumberUtils.isStartsPostDial(c)) return stringBuilder.toString();
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String extractPostDialPortion(String string2) {
        if (string2 == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = PhoneNumberUtils.indexOfLastNetworkChar(string2) + 1;
        int n2 = string2.length();
        while (n < n2) {
            char c = string2.charAt(n);
            if (PhoneNumberUtils.isNonSeparator(c)) {
                StringBuilder stringBuilder2 = stringBuilder.append(c);
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int findDialableIndexFromPostDialStr(String string2) {
        int n;
        int n2 = 0;
        while (n2 < (n = string2.length())) {
            if (PhoneNumberUtils.isReallyDialable(string2.charAt(n2))) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static void formatJapaneseNumber(Editable editable) {
        JapanesePhoneNumberFormatter.format(editable);
    }

    /*
     * Unable to fully structure code
     */
    public static void formatNanpNumber(Editable var0) {
        block21: {
            var1_1 = var0.length();
            if (var1_1 > (var2_2 = "+1-nnn-nnn-nnnn".length())) {
                var3_3 = var1_1;
                return;
            }
            if (var1_1 <= 5) {
                var4_4 = var1_1;
                return;
            }
            var5_5 = var0.subSequence(0, var1_1);
            var6_6 = 0;
            while (var6_6 < (var7_7 = var0.length())) {
                if (var0.charAt(var6_6) == '-') {
                    var8_8 = var6_6 + 1;
                    var9_9 = var0.delete(var6_6, var8_8);
                    continue;
                }
                ++var6_6;
            }
            var10_10 = var0.length();
            var11_11 = new int[3];
            var12_12 = 1;
            var13_13 = 0;
            var14_14 = 0;
            block7: for (var15_15 = 0; var15_15 < var10_10; ++var15_15) {
                block0 : switch (var0.charAt(var15_15)) lbl-1000:
                // 2 sources

                {
                    default: {
                        var16_17 = var0.replace(0, var10_10, var5_5);
                        var17_18 = var10_10;
                        return;
                    }
                    case '1': {
                        if (var13_13 == 0 || var12_12 == 2) {
                            var12_12 = 3;
lbl31:
                            // 1 sources

                            continue block7;
                        }
                    }
                    case '0': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        if (var12_12 == 2) {
                            var18_19 = var0.replace(0, var10_10, var5_5);
                            var19_20 = var10_10;
                            return;
                        }
                        if (var12_12 == 3) {
                            var20_16 = var14_14 + 1;
                            var11_11[var14_14] = var15_15;
lbl41:
                            // 3 sources

                            while (true) {
                                var12_12 = 1;
                                ++var13_13;
                                var14_14 = var20_16;
                                break block0;
                                break;
                            }
                        }
                        if (var12_12 == 4 || var13_13 != 3 && var13_13 != 6) break block21;
                        var20_16 = var14_14 + 1;
                        var11_11[var14_14] = var15_15;
                        ** GOTO lbl41
                    }
                    case '-': {
                        var12_12 = 4;
                        break;
                    }
                    case '+': {
                        if (var15_15 != 0) ** GOTO lbl-1000
                        var12_12 = 2;
                        break;
                    }
                }
                ** continue;
            }
            if (var13_13 == 7) {
                var15_15 = var14_14 + -1;
lbl60:
                // 2 sources

                while (true) {
                    for (var21_21 = 0; var21_21 < var15_15; ++var21_21) {
                        var22_22 = var11_11[var21_21];
                        var23_23 = var22_22 + var21_21;
                        var24_24 = var22_22 + var21_21;
                        var25_25 = var0.replace(var23_23, var24_24, "-");
                    }
                    var1_1 = var0.length();
                    while (var1_1 > 0 && var0.charAt(var26_26 = var1_1 - 1) == '-') {
                        var27_27 = var1_1 - 1;
                        var28_28 = var0.delete(var27_27, var1_1);
                        var29_29 = var1_1 + -1;
                    }
                    var30_30 = var10_10;
                    return;
                }
            }
            var15_15 = var14_14;
            ** while (true)
        }
        var20_16 = var14_14;
        ** while (true)
    }

    public static String formatNumber(String string2) {
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder(string2);
        int n = PhoneNumberUtils.getFormatTypeForLocale(Locale.getDefault());
        PhoneNumberUtils.formatNumber(spannableStringBuilder, n);
        return spannableStringBuilder.toString();
    }

    public static String formatNumber(String string2, int n) {
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder(string2);
        PhoneNumberUtils.formatNumber(spannableStringBuilder, n);
        return spannableStringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void formatNumber(Editable editable, int n) {
        int n2 = n;
        if (editable.length() > 2 && editable.charAt(0) == '+') {
            if (editable.charAt(1) == '1') {
                n2 = 1;
            } else {
                if (editable.length() < 3) {
                    return;
                }
                if (editable.charAt(1) != '8') {
                    return;
                }
                if (editable.charAt(2) != '1') {
                    return;
                }
                n2 = 2;
            }
        }
        switch (n2) {
            default: {
                return;
            }
            case 1: {
                PhoneNumberUtils.formatNanpNumber(editable);
                return;
            }
            case 2: 
        }
        PhoneNumberUtils.formatJapaneseNumber(editable);
    }

    private static String getDefaultIdp() {
        String string2 = null;
        String string3 = SystemProperties.get("ro.cdma.idpstring", string2);
        if (TextUtils.isEmpty(string2)) {
            string2 = NANP_IDP_STRING;
        }
        return string2;
    }

    public static int getFormatTypeForLocale(Locale locale) {
        return PhoneNumberUtils.getFormatTypeFromCountryCode(locale.getCountry());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getFormatTypeFromCountryCode(String string2) {
        int n = NANP_COUNTRIES.length;
        for (int i = 0; i < n; ++i) {
            if (NANP_COUNTRIES[i].compareToIgnoreCase(string2) != 0) continue;
            return 1;
        }
        if ("jp".compareToIgnoreCase(string2) != 0) return 0;
        return 2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getNumberFromIntent(Intent intent, Context context) {
        String string2 = null;
        Uri uri = intent.getData();
        String string3 = uri.getScheme();
        if (string3.equals("tel")) return uri.getSchemeSpecificPart();
        if (string3.equals("sip")) {
            return uri.getSchemeSpecificPart();
        }
        if (string3.equals("voicemail")) {
            return TelephonyManager.getDefault().getCompleteVoiceMailNumber();
        }
        if (context == null) {
            return null;
        }
        String string4 = intent.resolveType(context);
        String string5 = null;
        String string6 = uri.getAuthority();
        if ("contacts".equals(string6)) {
            string5 = "number";
        } else if ("com.android.contacts".equals(string6)) {
            string5 = "data1";
        }
        ContentResolver contentResolver = context.getContentResolver();
        String[] stringArray = new String[]{string5};
        String[] stringArray2 = null;
        String string7 = null;
        Cursor cursor = contentResolver.query(uri, stringArray, null, stringArray2, string7);
        if (cursor == null) return string2;
        try {
            if (cursor.moveToFirst()) {
                String string8;
                int n = cursor.getColumnIndex(string5);
                string2 = string8 = cursor.getString(n);
            }
            cursor.close();
            return string2;
        }
        catch (Throwable throwable) {
            cursor.close();
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getStrippedReversed(String string2) {
        String string3 = PhoneNumberUtils.extractNetworkPortionAlt(string2);
        if (string3 == null) {
            return null;
        }
        int n = string3.length();
        return PhoneNumberUtils.internalGetStrippedReversed(string3, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int indexOfLastNetworkChar(String string2) {
        int n;
        int n2 = string2.length();
        int n3 = string2.indexOf(44);
        int n4 = PhoneNumberUtils.minPositive(n3, n = string2.indexOf(59));
        if (n4 >= 0) return n4 - 1;
        return n2 - 1;
    }

    private static void internalCalledPartyBCDFragmentToString(StringBuilder stringBuilder, byte[] byArray, int n, int n2) {
        int n3 = n;
        int n4;
        while (n3 < (n4 = n2 + n)) {
            int n5;
            int n6;
            char c = PhoneNumberUtils.bcdToChar((byte)(byArray[n3] & 0xF));
            if (c == null) {
                return;
            }
            StringBuilder stringBuilder2 = stringBuilder.append(c);
            byte by = (byte)(byArray[n3] >> 4 & 0xF);
            if (by == 15 && (n6 = n3 + 1) != (n5 = n2 + n)) {
                return;
            }
            c = PhoneNumberUtils.bcdToChar(by);
            if (c == null) {
                return;
            }
            StringBuilder stringBuilder3 = stringBuilder.append(c);
            ++n3;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String internalGetStrippedReversed(String string2, int n) {
        if (string2 == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = string2.length();
        int n3 = n2 - 1;
        int n4 = n2;
        while (n3 >= 0) {
            if (n4 - n3 > n) return stringBuilder.toString();
            char c = string2.charAt(n3);
            StringBuilder stringBuilder2 = stringBuilder.append(c);
            n3 += -1;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean is12Key(char c) {
        if (c >= '0') {
            if (c <= '9') return true;
        }
        if (c == '*') return true;
        if (c != '#') return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isCountryCallingCode(int n) {
        if (n <= 0) return false;
        int n2 = CCC_LENGTH;
        if (n >= n2) return false;
        if (COUNTLY_CALLING_CALL[n] == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isDialable(char c) {
        if (c >= '0') {
            if (c <= '9') return true;
        }
        if (c == '*') return true;
        if (c == '#') return true;
        if (c == '+') return true;
        if (c != 'N') return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isDialable(String string2) {
        int n = 0;
        int n2 = string2.length();
        while (n < n2) {
            if (!PhoneNumberUtils.isDialable(string2.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isEmergencyNumber(String string2) {
        if (string2 == null) {
            return false;
        }
        string2 = PhoneNumberUtils.extractNetworkPortionAlt(string2);
        String string3 = SystemProperties.get("ril.ecclist");
        if (TextUtils.isEmpty(string3)) {
            string3 = SystemProperties.get("ro.ril.ecclist");
        }
        if (!TextUtils.isEmpty(string3)) {
            String[] stringArray = string3.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (stringArray[n2].equals(string2)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        if (string2.equals("112")) return true;
        if (!string2.equals("911")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isGlobalPhoneNumber(String string2) {
        if (!TextUtils.isEmpty(string2)) return GLOBAL_PHONE_NUMBER_PATTERN.matcher(string2).matches();
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isISODigit(char c) {
        if (c < '0') return false;
        if (c > '9') return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean isNanp(String string2) {
        boolean bl = false;
        if (string2 == null) {
            int n = Log.e("isNanp: null dialStr passed in", string2);
            return bl;
        }
        if (string2.length() != 10) return bl;
        if (!PhoneNumberUtils.isTwoToNine(string2.charAt(0))) return bl;
        if (!PhoneNumberUtils.isTwoToNine(string2.charAt(3))) return bl;
        bl = true;
        int n = 1;
        while (n < 10) {
            if (!PhoneNumberUtils.isISODigit(string2.charAt(n))) {
                return false;
            }
            ++n;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNonSeparator(char c) {
        if (c >= '0') {
            if (c <= '9') return true;
        }
        if (c == '*') return true;
        if (c == '#') return true;
        if (c == '+') return true;
        if (c == 'N') return true;
        if (c == ';') return true;
        if (c != ',') return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isNonSeparator(String string2) {
        int n = 0;
        int n2 = string2.length();
        while (n < n2) {
            if (!PhoneNumberUtils.isNonSeparator(string2.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isOneNanp(String string2) {
        boolean bl = false;
        if (string2 != null) {
            String string3 = string2.substring(1);
            if (string2.charAt(0) != '1') return bl;
            if (!PhoneNumberUtils.isNanp(string3)) return bl;
            return true;
        }
        int n = Log.e("isOneNanp: null dialStr passed in", string2);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isReallyDialable(char c) {
        if (c >= '0') {
            if (c <= '9') return true;
        }
        if (c == '*') return true;
        if (c == '#') return true;
        if (c != '+') return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSeparator(char c) {
        if (PhoneNumberUtils.isDialable(c)) return false;
        if ('a' <= c) {
            if (c <= 'z') return false;
        }
        if ('A' > c) return true;
        if (c <= 'Z') return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isStartsPostDial(char c) {
        if (c == ',') return true;
        if (c != ';') return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isTwoToNine(char c) {
        if (c < '2') return false;
        if (c > '9') return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isUriNumber(String string2) {
        if (string2 == null) return false;
        if (string2.contains("@")) return true;
        if (!string2.contains("%40")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isVoiceMailNumber(String string2) {
        String string3;
        try {
            String string4;
            string3 = string4 = TelephonyManager.getDefault().getVoiceMailNumber();
        }
        catch (SecurityException securityException) {
            return false;
        }
        string2 = PhoneNumberUtils.extractNetworkPortionAlt(string2);
        if (TextUtils.isEmpty(string2)) return false;
        if (!PhoneNumberUtils.compare(string2, string3)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isWellFormedSmsAddress(String string2) {
        String string3 = PhoneNumberUtils.extractNetworkPortion(string2);
        if (string3.equals(PLUS_SIGN_STRING)) return false;
        if (TextUtils.isEmpty(string3)) return false;
        if (!PhoneNumberUtils.isDialable(string3)) return false;
        return true;
    }

    private static void log(String string2) {
        int n = Log.d(LOG_TAG, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean matchIntlPrefix(String string2, int n) {
        int n2 = 0;
        block5: for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            switch (n2) {
                default: {
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block5;
                    return false;
                }
                case 0: {
                    if (c == '+') {
                        n2 = 1;
                        continue block5;
                    }
                    if (c == '0') {
                        n2 = 2;
                        continue block5;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block5;
                    return false;
                }
                case 2: {
                    if (c == '0') {
                        n2 = 3;
                        continue block5;
                    }
                    if (c == '1') {
                        n2 = 4;
                        continue block5;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block5;
                    return false;
                }
                case 4: {
                    if (c == '1') {
                        n2 = 5;
                        continue block5;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block5;
                    return false;
                }
            }
        }
        if (n2 == true) return true;
        if (n2 == 3) return true;
        if (n2 == 5) return true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean matchIntlPrefixAndCC(String string2, int n) {
        int n2 = 0;
        block7: for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            switch (n2) {
                default: {
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                case 0: {
                    if (c == '+') {
                        n2 = 1;
                        continue block7;
                    }
                    if (c == '0') {
                        n2 = 2;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                case 2: {
                    if (c == '0') {
                        n2 = 3;
                        continue block7;
                    }
                    if (c == '1') {
                        n2 = 4;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                case 4: {
                    if (c == '1') {
                        n2 = 5;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                case 1: 
                case 3: 
                case 5: {
                    if (PhoneNumberUtils.isISODigit(c)) {
                        n2 = 6;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                case 6: 
                case 7: {
                    if (PhoneNumberUtils.isISODigit(c)) {
                        ++n2;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
            }
        }
        if (n2 == 6) return true;
        if (n2 == 7) return true;
        if (n2 == 8) return true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean matchTrunkPrefix(String string2, int n) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            if (c == '0' && !bl) {
                bl = true;
            } else if (PhoneNumberUtils.isNonSeparator(c)) {
                return false;
            }
            ++n2;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int minPositive(int n, int n2) {
        if (n >= 0 && n2 >= 0) {
            if (n >= n2) return n2;
            return n;
        }
        if (n >= 0) {
            return n;
        }
        if (n2 < 0) return -1;
        return n2;
    }

    public static byte[] networkPortionToCalledPartyBCD(String string2) {
        return PhoneNumberUtils.numberToCalledPartyBCDHelper(PhoneNumberUtils.extractNetworkPortion(string2), false);
    }

    public static byte[] networkPortionToCalledPartyBCDWithLength(String string2) {
        return PhoneNumberUtils.numberToCalledPartyBCDHelper(PhoneNumberUtils.extractNetworkPortion(string2), true);
    }

    public static byte[] numberToCalledPartyBCD(String string2) {
        return PhoneNumberUtils.numberToCalledPartyBCDHelper(string2, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static byte[] numberToCalledPartyBCDHelper(String string2, boolean bl) {
        byte by;
        int n;
        int n2 = n = string2.length();
        boolean bl2 = string2.indexOf(43) != -1;
        if (bl2) {
            n2 += -1;
        }
        if (n2 == 0) {
            return null;
        }
        int n3 = (n2 + 1) / 2;
        int n4 = 1;
        int n5 = bl ? n4 + 1 : n4;
        int n6 = n3 + n5;
        byte[] byArray = new byte[n6];
        int n7 = 0;
        for (int i = 0; i < n; ++i) {
            int n8;
            char c = string2.charAt(i);
            if (c == '+') {
                n8 = n7;
            } else {
                byte by2;
                int n9 = (n7 & 1) == 1 ? 4 : 0;
                int n10 = (n7 >> 1) + n5;
                byte by3 = byArray[n10];
                byArray[n10] = by2 = (byte)((byte)((PhoneNumberUtils.charToBCD(c) & 0xF) << n9) | by3);
                n8 = n7 + 1;
            }
            int n11 = n8;
        }
        if (n7 & true) {
            byte by4;
            int n12 = (n7 >> 1) + n5;
            byArray[n12] = by4 = (byte)(byArray[n12] | 0xF0);
        }
        int n13 = 0;
        if (bl) {
            byte by5;
            int n14 = n13 + 1;
            byArray[n13] = by5 = (byte)(n6 - 1);
            n13 = n14;
        }
        int n15 = bl2 ? 145 : 129;
        byArray[n13] = by = (byte)n15;
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String processPlusCodeWithinNanp(String string2) {
        String string3 = string2;
        if (string2 == null) return string3;
        if (string2.charAt(0) != '+') return string3;
        if (string2.length() <= 1) return string3;
        String string4 = string2.substring(1);
        if (PhoneNumberUtils.isOneNanp(string4)) {
            return string4;
        }
        String string5 = PhoneNumberUtils.getDefaultIdp();
        return string2.replaceFirst("[+]", string5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String stringFromStringAndTOA(String string2, int n) {
        if (string2 == null) {
            return null;
        }
        if (n != 145) return string2;
        if (string2.length() <= 0) return string2;
        if (string2.charAt(0) == '+') return string2;
        return PLUS_SIGN_STRING + string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String stripSeparators(String string2) {
        if (string2 == null) {
            return null;
        }
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            if (PhoneNumberUtils.isNonSeparator(c)) {
                StringBuilder stringBuilder2 = stringBuilder.append(c);
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String toCallerIDMinMatch(String string2) {
        return PhoneNumberUtils.internalGetStrippedReversed(PhoneNumberUtils.extractNetworkPortionAlt(string2), 7);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int toaFromString(String string2) {
        if (string2 == null) return 129;
        if (string2.length() <= 0) return 129;
        if (string2.charAt(0) != '+') return 129;
        return 145;
    }

    /*
     * Unable to fully structure code
     */
    private static CountryCallingCodeAndNewIndex tryGetCountryCallingCodeAndNewIndex(String var0, boolean var1_1) {
        var2_2 = 0;
        var3_3 = 0;
        var4_4 = var0.length();
        block8: for (var5_5 = 0; var5_5 < var4_4; ++var5_5) {
            block12: {
                var6_6 = var0.charAt(var5_5);
                switch (var2_2) {
                    default: {
                        var7_8 = null;
lbl9:
                        // 11 sources

                        return var7_8;
                    }
                    case 0: {
                        if (var6_6 == '+') {
                            var2_2 = 1;
lbl14:
                            // 14 sources

                            continue block8;
                        }
                        if (var6_6 != '0') ** GOTO lbl19
                        var2_2 = 2;
                        ** GOTO lbl14
lbl19:
                        // 1 sources

                        if (var6_6 != '1') ** GOTO lbl25
                        if (!var1_1) ** GOTO lbl23
                        var2_2 = 8;
                        ** GOTO lbl14
lbl23:
                        // 1 sources

                        var7_8 = null;
                        ** GOTO lbl9
lbl25:
                        // 1 sources

                        if (!PhoneNumberUtils.isDialable(var6_6)) ** GOTO lbl14
                        var7_8 = null;
                        ** GOTO lbl9
                    }
                    case 2: {
                        if (var6_6 != '0') ** GOTO lbl32
                        var2_2 = 3;
                        ** GOTO lbl14
lbl32:
                        // 1 sources

                        if (var6_6 != '1') ** GOTO lbl35
                        var2_2 = 4;
                        ** GOTO lbl14
lbl35:
                        // 1 sources

                        if (!PhoneNumberUtils.isDialable(var6_6)) ** GOTO lbl14
                        var7_8 = null;
                        ** GOTO lbl9
                    }
                    case 4: {
                        if (var6_6 != '1') ** GOTO lbl42
                        var2_2 = 5;
                        ** GOTO lbl14
lbl42:
                        // 1 sources

                        if (!PhoneNumberUtils.isDialable(var6_6)) ** GOTO lbl14
                        var7_8 = null;
                        ** GOTO lbl9
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: {
                        var8_7 = PhoneNumberUtils.tryGetISODigit(var6_6);
                        if (var8_7 <= 0) ** GOTO lbl57
                        if ((var3_3 = var3_3 * 10 + var8_7) < 100 && !PhoneNumberUtils.isCountryCallingCode(var3_3)) ** GOTO lbl52
                        var9_9 = var5_5 + 1;
                        var7_8 = new CountryCallingCodeAndNewIndex(var3_3, var9_9);
                        ** GOTO lbl9
lbl52:
                        // 1 sources

                        if (var2_2 != 1 && var2_2 != 3 && var2_2 != 5) ** GOTO lbl55
                        var2_2 = 6;
                        ** GOTO lbl14
lbl55:
                        // 1 sources

                        ++var2_2;
                        ** GOTO lbl14
lbl57:
                        // 1 sources

                        if (!PhoneNumberUtils.isDialable(var6_6)) ** GOTO lbl14
                        var7_8 = null;
                        ** GOTO lbl9
                    }
                    case 8: {
                        if (var6_6 != '6') ** GOTO lbl64
                        var2_2 = 9;
                        ** GOTO lbl14
lbl64:
                        // 1 sources

                        if (PhoneNumberUtils.isDialable(var6_6)) ** break;
                        ** continue;
                        var7_8 = null;
                        ** GOTO lbl9
                    }
                    case 9: 
                }
                if (var6_6 != '6') break block12;
                var10_10 = var5_5 + 1;
                var7_8 = new CountryCallingCodeAndNewIndex(66, var10_10);
                ** GOTO lbl9
            }
            var7_8 = null;
            ** GOTO lbl9
        }
        var7_8 = null;
        ** while (true)
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int tryGetISODigit(char c) {
        if ('0' > c) return -1;
        if (c > '9') return -1;
        return c - 48;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int tryGetTrunkPrefixOmittedIndex(String string2, int n) {
        int n2 = string2.length();
        int n3 = n;
        while (n3 < n2) {
            char c = string2.charAt(n3);
            if (PhoneNumberUtils.tryGetISODigit(c) >= 0) {
                return n3 + 1;
            }
            if (PhoneNumberUtils.isDialable(c)) {
                return -1;
            }
            ++n3;
        }
        return -1;
    }

    private static class CountryCallingCodeAndNewIndex {
        public final int countryCallingCode;
        public final int newIndex;

        public CountryCallingCodeAndNewIndex(int n, int n2) {
            this.countryCallingCode = n;
            this.newIndex = n2;
        }
    }
}

