/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.telephony.CellLocation;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import com.android.internal.telephony.IPhoneStateListener;

public class PhoneStateListener {
    public static final int LISTEN_CALL_FORWARDING_INDICATOR = 8;
    public static final int LISTEN_CALL_STATE = 32;
    public static final int LISTEN_CELL_LOCATION = 16;
    public static final int LISTEN_DATA_ACTIVITY = 128;
    public static final int LISTEN_DATA_CONNECTION_STATE = 64;
    public static final int LISTEN_MESSAGE_WAITING_INDICATOR = 4;
    public static final int LISTEN_NONE = 0;
    public static final int LISTEN_SERVICE_STATE = 1;
    @Deprecated
    public static final int LISTEN_SIGNAL_STRENGTH = 2;
    public static final int LISTEN_SIGNAL_STRENGTHS = 256;
    IPhoneStateListener callback;
    Handler mHandler;

    public PhoneStateListener() {
        Handler handler;
        IPhoneStateListener.Stub stub = new IPhoneStateListener.Stub(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onCallForwardingIndicatorChanged(boolean bl) {
                Handler handler = PhoneStateListener.this.mHandler;
                int n = bl ? 1 : 0;
                Message.obtain(handler, 8, n, 0, null).sendToTarget();
            }

            @Override
            public void onCallStateChanged(int n, String string2) {
                Message.obtain(PhoneStateListener.this.mHandler, 32, n, 0, string2).sendToTarget();
            }

            @Override
            public void onCellLocationChanged(Bundle bundle) {
                CellLocation cellLocation = CellLocation.newFromBundle(bundle);
                Message.obtain(PhoneStateListener.this.mHandler, 16, 0, 0, cellLocation).sendToTarget();
            }

            @Override
            public void onDataActivity(int n) {
                Message.obtain(PhoneStateListener.this.mHandler, 128, n, 0, null).sendToTarget();
            }

            @Override
            public void onDataConnectionStateChanged(int n, int n2) {
                Message.obtain(PhoneStateListener.this.mHandler, 64, n, n2, null).sendToTarget();
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onMessageWaitingIndicatorChanged(boolean bl) {
                Handler handler = PhoneStateListener.this.mHandler;
                int n = bl ? 1 : 0;
                Message.obtain(handler, 4, n, 0, null).sendToTarget();
            }

            @Override
            public void onServiceStateChanged(ServiceState serviceState) {
                Message.obtain(PhoneStateListener.this.mHandler, 1, 0, 0, serviceState).sendToTarget();
            }

            @Override
            public void onSignalStrengthChanged(int n) {
                Message.obtain(PhoneStateListener.this.mHandler, 2, n, 0, null).sendToTarget();
            }

            @Override
            public void onSignalStrengthsChanged(SignalStrength signalStrength) {
                Message.obtain(PhoneStateListener.this.mHandler, 256, 0, 0, signalStrength).sendToTarget();
            }
        };
        this.callback = stub;
        this.mHandler = handler = new Handler(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 1: {
                        PhoneStateListener phoneStateListener = PhoneStateListener.this;
                        ServiceState serviceState = (ServiceState)message.obj;
                        phoneStateListener.onServiceStateChanged(serviceState);
                        return;
                    }
                    case 2: {
                        PhoneStateListener phoneStateListener = PhoneStateListener.this;
                        int n = message.arg1;
                        phoneStateListener.onSignalStrengthChanged(n);
                        return;
                    }
                    case 4: {
                        PhoneStateListener phoneStateListener = PhoneStateListener.this;
                        boolean bl = message.arg1 != 0;
                        phoneStateListener.onMessageWaitingIndicatorChanged(bl);
                        return;
                    }
                    case 8: {
                        PhoneStateListener phoneStateListener = PhoneStateListener.this;
                        boolean bl = message.arg1 != 0;
                        phoneStateListener.onCallForwardingIndicatorChanged(bl);
                        return;
                    }
                    case 16: {
                        PhoneStateListener phoneStateListener = PhoneStateListener.this;
                        CellLocation cellLocation = (CellLocation)message.obj;
                        phoneStateListener.onCellLocationChanged(cellLocation);
                        return;
                    }
                    case 32: {
                        PhoneStateListener phoneStateListener = PhoneStateListener.this;
                        int n = message.arg1;
                        String string2 = (String)message.obj;
                        phoneStateListener.onCallStateChanged(n, string2);
                        return;
                    }
                    case 64: {
                        PhoneStateListener phoneStateListener = PhoneStateListener.this;
                        int n = message.arg1;
                        int n2 = message.arg2;
                        phoneStateListener.onDataConnectionStateChanged(n, n2);
                        PhoneStateListener phoneStateListener2 = PhoneStateListener.this;
                        int n3 = message.arg1;
                        phoneStateListener2.onDataConnectionStateChanged(n3);
                        return;
                    }
                    case 128: {
                        PhoneStateListener phoneStateListener = PhoneStateListener.this;
                        int n = message.arg1;
                        phoneStateListener.onDataActivity(n);
                        return;
                    }
                    case 256: 
                }
                PhoneStateListener phoneStateListener = PhoneStateListener.this;
                SignalStrength signalStrength = (SignalStrength)message.obj;
                phoneStateListener.onSignalStrengthsChanged(signalStrength);
            }
        };
    }

    public void onCallForwardingIndicatorChanged(boolean bl) {
    }

    public void onCallStateChanged(int n, String string2) {
    }

    public void onCellLocationChanged(CellLocation cellLocation) {
    }

    public void onDataActivity(int n) {
    }

    public void onDataConnectionStateChanged(int n) {
    }

    public void onDataConnectionStateChanged(int n, int n2) {
    }

    public void onMessageWaitingIndicatorChanged(boolean bl) {
    }

    public void onServiceStateChanged(ServiceState serviceState) {
    }

    @Deprecated
    public void onSignalStrengthChanged(int n) {
    }

    public void onSignalStrengthsChanged(SignalStrength signalStrength) {
    }
}

