/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;

public class ServiceState
implements Parcelable {
    public static final Parcelable.Creator<ServiceState> CREATOR = new Parcelable.Creator<ServiceState>(){

        @Override
        public ServiceState createFromParcel(Parcel parcel) {
            return new ServiceState(parcel);
        }

        public ServiceState[] newArray(int n) {
            return new ServiceState[n];
        }
    };
    static final String LOG_TAG = "PHONE";
    public static final int RADIO_TECHNOLOGY_1xRTT = 6;
    public static final int RADIO_TECHNOLOGY_EDGE = 2;
    public static final int RADIO_TECHNOLOGY_EVDO_0 = 7;
    public static final int RADIO_TECHNOLOGY_EVDO_A = 8;
    public static final int RADIO_TECHNOLOGY_EVDO_B = 12;
    public static final int RADIO_TECHNOLOGY_GPRS = 1;
    public static final int RADIO_TECHNOLOGY_HSDPA = 9;
    public static final int RADIO_TECHNOLOGY_HSPA = 11;
    public static final int RADIO_TECHNOLOGY_HSUPA = 10;
    public static final int RADIO_TECHNOLOGY_IS95A = 4;
    public static final int RADIO_TECHNOLOGY_IS95B = 5;
    public static final int RADIO_TECHNOLOGY_UMTS = 3;
    public static final int RADIO_TECHNOLOGY_UNKNOWN = 0;
    public static final int REGISTRATION_STATE_HOME_NETWORK = 1;
    public static final int REGISTRATION_STATE_NOT_REGISTERED_AND_NOT_SEARCHING = 0;
    public static final int REGISTRATION_STATE_NOT_REGISTERED_AND_SEARCHING = 2;
    public static final int REGISTRATION_STATE_REGISTRATION_DENIED = 3;
    public static final int REGISTRATION_STATE_ROAMING = 5;
    public static final int REGISTRATION_STATE_UNKNOWN = 4;
    public static final int STATE_EMERGENCY_ONLY = 2;
    public static final int STATE_IN_SERVICE = 0;
    public static final int STATE_OUT_OF_SERVICE = 1;
    public static final int STATE_POWER_OFF = 3;
    private int mCdmaDefaultRoamingIndicator;
    private int mCdmaEriIconIndex;
    private int mCdmaEriIconMode;
    private int mCdmaRoamingIndicator;
    private boolean mCssIndicator;
    private boolean mIsEmergencyOnly;
    private boolean mIsManualNetworkSelection;
    private int mNetworkId;
    private String mOperatorAlphaLong;
    private String mOperatorAlphaShort;
    private String mOperatorNumeric;
    private int mRadioTechnology;
    private boolean mRoaming;
    private int mState = 1;
    private int mSystemId;

    public ServiceState() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public ServiceState(Parcel parcel) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        String string2;
        String string3;
        String string4;
        int n8;
        this.mState = n8 = parcel.readInt();
        boolean bl = parcel.readInt() != 0;
        this.mRoaming = bl;
        this.mOperatorAlphaLong = string4 = parcel.readString();
        this.mOperatorAlphaShort = string3 = parcel.readString();
        this.mOperatorNumeric = string2 = parcel.readString();
        boolean bl2 = parcel.readInt() != 0;
        this.mIsManualNetworkSelection = bl2;
        this.mRadioTechnology = n7 = parcel.readInt();
        boolean bl3 = parcel.readInt() != 0;
        this.mCssIndicator = bl3;
        this.mNetworkId = n6 = parcel.readInt();
        this.mSystemId = n5 = parcel.readInt();
        this.mCdmaRoamingIndicator = n4 = parcel.readInt();
        this.mCdmaDefaultRoamingIndicator = n3 = parcel.readInt();
        this.mCdmaEriIconIndex = n2 = parcel.readInt();
        this.mCdmaEriIconMode = n = parcel.readInt();
        boolean bl4 = parcel.readInt() != 0;
        this.mIsEmergencyOnly = bl4;
    }

    public ServiceState(ServiceState serviceState) {
        this.copyFrom(serviceState);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean equalsHandlesNulls(Object object, Object object2) {
        if (object != null) return object.equals(object2);
        if (object2 != null) return false;
        return true;
    }

    public static ServiceState newFromBundle(Bundle bundle) {
        ServiceState serviceState = new ServiceState();
        serviceState.setFromNotifierBundle(bundle);
        return serviceState;
    }

    private void setFromNotifierBundle(Bundle bundle) {
        boolean bl;
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl2;
        int n5;
        boolean bl3;
        String string2;
        String string3;
        String string4;
        boolean bl4;
        int n6;
        this.mState = n6 = bundle.getInt("state");
        this.mRoaming = bl4 = bundle.getBoolean("roaming");
        this.mOperatorAlphaLong = string4 = bundle.getString("operator-alpha-long");
        this.mOperatorAlphaShort = string3 = bundle.getString("operator-alpha-short");
        this.mOperatorNumeric = string2 = bundle.getString("operator-numeric");
        this.mIsManualNetworkSelection = bl3 = bundle.getBoolean("manual");
        this.mRadioTechnology = n5 = bundle.getInt("radioTechnology");
        this.mCssIndicator = bl2 = bundle.getBoolean("cssIndicator");
        this.mNetworkId = n4 = bundle.getInt("networkId");
        this.mSystemId = n3 = bundle.getInt("systemId");
        this.mCdmaRoamingIndicator = n2 = bundle.getInt("cdmaRoamingIndicator");
        this.mCdmaDefaultRoamingIndicator = n = bundle.getInt("cdmaDefaultRoamingIndicator");
        this.mIsEmergencyOnly = bl = bundle.getBoolean("emergencyOnly");
    }

    protected void copyFrom(ServiceState serviceState) {
        boolean bl;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        boolean bl2;
        int n7;
        boolean bl3;
        String string2;
        String string3;
        String string4;
        boolean bl4;
        int n8;
        this.mState = n8 = serviceState.mState;
        this.mRoaming = bl4 = serviceState.mRoaming;
        this.mOperatorAlphaLong = string4 = serviceState.mOperatorAlphaLong;
        this.mOperatorAlphaShort = string3 = serviceState.mOperatorAlphaShort;
        this.mOperatorNumeric = string2 = serviceState.mOperatorNumeric;
        this.mIsManualNetworkSelection = bl3 = serviceState.mIsManualNetworkSelection;
        this.mRadioTechnology = n7 = serviceState.mRadioTechnology;
        this.mCssIndicator = bl2 = serviceState.mCssIndicator;
        this.mNetworkId = n6 = serviceState.mNetworkId;
        this.mSystemId = n5 = serviceState.mSystemId;
        this.mCdmaRoamingIndicator = n4 = serviceState.mCdmaRoamingIndicator;
        this.mCdmaDefaultRoamingIndicator = n3 = serviceState.mCdmaDefaultRoamingIndicator;
        this.mCdmaEriIconIndex = n2 = serviceState.mCdmaEriIconIndex;
        this.mCdmaEriIconMode = n = serviceState.mCdmaEriIconMode;
        this.mIsEmergencyOnly = bl = serviceState.mIsEmergencyOnly;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        Integer n;
        Integer n2;
        Integer n3;
        Integer n4;
        Boolean bl;
        Integer n5;
        ServiceState serviceState;
        try {
            serviceState = (ServiceState)object;
            if (object == null) {
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        int n6 = this.mState;
        int n7 = serviceState.mState;
        if (n6 == n7) return false;
        boolean bl2 = this.mRoaming;
        boolean bl3 = serviceState.mRoaming;
        if (bl2 == bl3) return false;
        boolean bl4 = this.mIsManualNetworkSelection;
        boolean bl5 = serviceState.mIsManualNetworkSelection;
        if (bl4 == bl5) return false;
        String string2 = this.mOperatorAlphaLong;
        String string3 = serviceState.mOperatorAlphaLong;
        if (!ServiceState.equalsHandlesNulls(string2, string3)) return false;
        String string4 = this.mOperatorAlphaShort;
        String string5 = serviceState.mOperatorAlphaShort;
        if (!ServiceState.equalsHandlesNulls(string4, string5)) return false;
        String string6 = this.mOperatorNumeric;
        String string7 = serviceState.mOperatorNumeric;
        if (!ServiceState.equalsHandlesNulls(string6, string7)) return false;
        Integer n8 = this.mRadioTechnology;
        if (!ServiceState.equalsHandlesNulls(n8, n5 = Integer.valueOf(serviceState.mRadioTechnology))) return false;
        Boolean bl6 = this.mCssIndicator;
        if (!ServiceState.equalsHandlesNulls(bl6, bl = Boolean.valueOf(serviceState.mCssIndicator))) return false;
        Integer n9 = this.mNetworkId;
        if (!ServiceState.equalsHandlesNulls(n9, n4 = Integer.valueOf(serviceState.mNetworkId))) return false;
        Integer n10 = this.mSystemId;
        if (!ServiceState.equalsHandlesNulls(n10, n3 = Integer.valueOf(serviceState.mSystemId))) return false;
        Integer n11 = this.mCdmaRoamingIndicator;
        if (!ServiceState.equalsHandlesNulls(n11, n2 = Integer.valueOf(serviceState.mCdmaRoamingIndicator))) return false;
        Integer n12 = this.mCdmaDefaultRoamingIndicator;
        if (!ServiceState.equalsHandlesNulls(n12, n = Integer.valueOf(serviceState.mCdmaDefaultRoamingIndicator))) return false;
        boolean bl7 = this.mIsEmergencyOnly;
        boolean bl8 = serviceState.mIsEmergencyOnly;
        if (bl7 == bl8) return false;
        return true;
    }

    public void fillInNotifierBundle(Bundle bundle) {
        int n = this.mState;
        bundle.putInt("state", n);
        boolean bl = this.mRoaming;
        bundle.putBoolean("roaming", bl);
        String string2 = this.mOperatorAlphaLong;
        bundle.putString("operator-alpha-long", string2);
        String string3 = this.mOperatorAlphaShort;
        bundle.putString("operator-alpha-short", string3);
        String string4 = this.mOperatorNumeric;
        bundle.putString("operator-numeric", string4);
        boolean bl2 = this.mIsManualNetworkSelection;
        bundle.putBoolean("manual", bl2);
        int n2 = this.mRadioTechnology;
        bundle.putInt("radioTechnology", n2);
        boolean bl3 = this.mCssIndicator;
        bundle.putBoolean("cssIndicator", bl3);
        int n3 = this.mNetworkId;
        bundle.putInt("networkId", n3);
        int n4 = this.mSystemId;
        bundle.putInt("systemId", n4);
        int n5 = this.mCdmaRoamingIndicator;
        bundle.putInt("cdmaRoamingIndicator", n5);
        int n6 = this.mCdmaDefaultRoamingIndicator;
        bundle.putInt("cdmaDefaultRoamingIndicator", n6);
        boolean bl4 = this.mIsEmergencyOnly;
        bundle.putBoolean("emergencyOnly", bl4);
    }

    public int getCdmaDefaultRoamingIndicator() {
        return this.mCdmaDefaultRoamingIndicator;
    }

    public int getCdmaEriIconIndex() {
        return this.mCdmaEriIconIndex;
    }

    public int getCdmaEriIconMode() {
        return this.mCdmaEriIconMode;
    }

    public int getCdmaRoamingIndicator() {
        return this.mCdmaRoamingIndicator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCssIndicator() {
        if (!this.mCssIndicator) return 0;
        return 1;
    }

    public boolean getIsManualSelection() {
        return this.mIsManualNetworkSelection;
    }

    public int getNetworkId() {
        return this.mNetworkId;
    }

    public String getOperatorAlphaLong() {
        return this.mOperatorAlphaLong;
    }

    public String getOperatorAlphaShort() {
        return this.mOperatorAlphaShort;
    }

    public String getOperatorNumeric() {
        return this.mOperatorNumeric;
    }

    public int getRadioTechnology() {
        return this.mRadioTechnology;
    }

    public boolean getRoaming() {
        return this.mRoaming;
    }

    public int getState() {
        return this.mState;
    }

    public int getSystemId() {
        return this.mSystemId;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int n;
        int n2 = this.mState * 4660;
        int n3 = this.mRoaming ? 1 : 0;
        int n4 = n2 + n3;
        int n5 = this.mIsManualNetworkSelection ? 1 : 0;
        int n6 = n4 + n5;
        int n7 = this.mOperatorAlphaLong == null ? 0 : this.mOperatorAlphaLong.hashCode();
        int n8 = n6 + n7;
        int n9 = this.mOperatorAlphaShort == null ? 0 : this.mOperatorAlphaShort.hashCode();
        int n10 = n8 + n9;
        int n11 = this.mOperatorNumeric == null ? 0 : this.mOperatorNumeric.hashCode();
        int n12 = n10 + n11;
        int n13 = this.mCdmaRoamingIndicator;
        int n14 = n12 + n13;
        int n15 = this.mCdmaDefaultRoamingIndicator;
        int n16 = n14 + n15;
        if (this.mIsEmergencyOnly) {
            n = 1;
            return n16 + n;
        }
        n = 0;
        return n16 + n;
    }

    public boolean isEmergencyOnly() {
        return this.mIsEmergencyOnly;
    }

    public void setCdmaDefaultRoamingIndicator(int n) {
        this.mCdmaDefaultRoamingIndicator = n;
    }

    public void setCdmaEriIconIndex(int n) {
        this.mCdmaEriIconIndex = n;
    }

    public void setCdmaEriIconMode(int n) {
        this.mCdmaEriIconMode = n;
    }

    public void setCdmaEriText(String string2) {
        this.mOperatorAlphaLong = string2;
    }

    public void setCdmaRoamingIndicator(int n) {
        this.mCdmaRoamingIndicator = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setCssIndicator(int n) {
        boolean bl = n != 0;
        this.mCssIndicator = bl;
    }

    public void setEmergencyOnly(boolean bl) {
        this.mIsEmergencyOnly = bl;
    }

    public void setIsManualSelection(boolean bl) {
        this.mIsManualNetworkSelection = bl;
    }

    public void setOperatorName(String string2, String string3, String string4) {
        this.mOperatorAlphaLong = string2;
        this.mOperatorAlphaShort = string3;
        this.mOperatorNumeric = string4;
    }

    public void setRadioTechnology(int n) {
        this.mRadioTechnology = n;
    }

    public void setRoaming(boolean bl) {
        this.mRoaming = bl;
    }

    public void setState(int n) {
        this.mState = n;
    }

    public void setStateOff() {
        this.mState = 3;
        this.mRoaming = false;
        this.mOperatorAlphaLong = null;
        this.mOperatorAlphaShort = null;
        this.mOperatorNumeric = null;
        this.mIsManualNetworkSelection = false;
        this.mRadioTechnology = 0;
        this.mCssIndicator = false;
        this.mNetworkId = -1;
        this.mSystemId = -1;
        this.mCdmaRoamingIndicator = -1;
        this.mCdmaDefaultRoamingIndicator = -1;
        this.mCdmaEriIconIndex = -1;
        this.mCdmaEriIconMode = -1;
        this.mIsEmergencyOnly = false;
    }

    public void setStateOutOfService() {
        this.mState = 1;
        this.mRoaming = false;
        this.mOperatorAlphaLong = null;
        this.mOperatorAlphaShort = null;
        this.mOperatorNumeric = null;
        this.mIsManualNetworkSelection = false;
        this.mRadioTechnology = 0;
        this.mCssIndicator = false;
        this.mNetworkId = -1;
        this.mSystemId = -1;
        this.mCdmaRoamingIndicator = -1;
        this.mCdmaDefaultRoamingIndicator = -1;
        this.mCdmaEriIconIndex = -1;
        this.mCdmaEriIconMode = -1;
        this.mIsEmergencyOnly = false;
    }

    public void setSystemAndNetworkId(int n, int n2) {
        this.mSystemId = n;
        this.mNetworkId = n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        String string2 = new String("Error in radioTechnology");
        switch (this.mRadioTechnology) {
            default: {
                int n = Log.w(LOG_TAG, "mRadioTechnology variable out of range.");
                break;
            }
            case 0: {
                string2 = "Unknown";
                break;
            }
            case 1: {
                string2 = "GPRS";
                break;
            }
            case 2: {
                string2 = "EDGE";
                break;
            }
            case 3: {
                string2 = "UMTS";
                break;
            }
            case 4: {
                string2 = "IS95A";
                break;
            }
            case 5: {
                string2 = "IS95B";
                break;
            }
            case 6: {
                string2 = "1xRTT";
                break;
            }
            case 7: {
                string2 = "EvDo rev. 0";
                break;
            }
            case 8: {
                string2 = "EvDo rev. A";
                break;
            }
            case 9: {
                string2 = "HSDPA";
                break;
            }
            case 10: {
                string2 = "HSUPA";
                break;
            }
            case 11: {
                string2 = "HSPA";
                break;
            }
            case 12: {
                string2 = "EvDo rev. B";
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.mState;
        StringBuilder stringBuilder2 = stringBuilder.append(n).append(" ");
        String string3 = this.mRoaming ? "roaming" : "home";
        StringBuilder stringBuilder3 = stringBuilder2.append(string3).append(" ");
        String string4 = this.mOperatorAlphaLong;
        StringBuilder stringBuilder4 = stringBuilder3.append(string4).append(" ");
        String string5 = this.mOperatorAlphaShort;
        StringBuilder stringBuilder5 = stringBuilder4.append(string5).append(" ");
        String string6 = this.mOperatorNumeric;
        StringBuilder stringBuilder6 = stringBuilder5.append(string6).append(" ");
        String string7 = this.mIsManualNetworkSelection ? "(manual)" : "";
        StringBuilder stringBuilder7 = stringBuilder6.append(string7).append(" ").append(string2).append(" ");
        String string8 = this.mCssIndicator ? "CSS supported" : "CSS not supported";
        StringBuilder stringBuilder8 = stringBuilder7.append(string8).append(" ");
        int n2 = this.mNetworkId;
        StringBuilder stringBuilder9 = stringBuilder8.append(n2).append(" ");
        int n3 = this.mSystemId;
        StringBuilder stringBuilder10 = stringBuilder9.append(n3).append("RoamInd: ");
        int n4 = this.mCdmaRoamingIndicator;
        StringBuilder stringBuilder11 = stringBuilder10.append(n4).append("DefRoamInd: ");
        int n5 = this.mCdmaDefaultRoamingIndicator;
        StringBuilder stringBuilder12 = stringBuilder11.append(n5).append("EmergOnly: ");
        boolean bl = this.mIsEmergencyOnly;
        return stringBuilder12.append(bl).toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = this.mState;
        parcel.writeInt(n2);
        int n3 = this.mRoaming ? 1 : 0;
        parcel.writeInt(n3);
        String string2 = this.mOperatorAlphaLong;
        parcel.writeString(string2);
        String string3 = this.mOperatorAlphaShort;
        parcel.writeString(string3);
        String string4 = this.mOperatorNumeric;
        parcel.writeString(string4);
        int n4 = this.mIsManualNetworkSelection ? 1 : 0;
        parcel.writeInt(n4);
        int n5 = this.mRadioTechnology;
        parcel.writeInt(n5);
        int n6 = this.mCssIndicator ? 1 : 0;
        parcel.writeInt(n6);
        int n7 = this.mNetworkId;
        parcel.writeInt(n7);
        int n8 = this.mSystemId;
        parcel.writeInt(n8);
        int n9 = this.mCdmaRoamingIndicator;
        parcel.writeInt(n9);
        int n10 = this.mCdmaDefaultRoamingIndicator;
        parcel.writeInt(n10);
        int n11 = this.mCdmaEriIconIndex;
        parcel.writeInt(n11);
        int n12 = this.mCdmaEriIconMode;
        parcel.writeInt(n12);
        int n13 = this.mIsEmergencyOnly ? 1 : 0;
        parcel.writeInt(n13);
    }
}

