/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.app.PendingIntent;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.SmsMessage;
import android.text.TextUtils;
import com.android.internal.telephony.ISms;
import com.android.internal.telephony.SmsRawData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class SmsManager {
    public static final int RESULT_ERROR_FDN_CHECK_FAILURE = 6;
    public static final int RESULT_ERROR_GENERIC_FAILURE = 1;
    public static final int RESULT_ERROR_LIMIT_EXCEEDED = 5;
    public static final int RESULT_ERROR_NO_SERVICE = 4;
    public static final int RESULT_ERROR_NULL_PDU = 3;
    public static final int RESULT_ERROR_RADIO_OFF = 2;
    public static final int STATUS_ON_ICC_FREE = 0;
    public static final int STATUS_ON_ICC_READ = 1;
    public static final int STATUS_ON_ICC_SENT = 5;
    public static final int STATUS_ON_ICC_UNREAD = 3;
    public static final int STATUS_ON_ICC_UNSENT = 7;
    private static SmsManager sInstance;

    private SmsManager() {
    }

    private ArrayList<SmsMessage> createMessageListFromRawRecords(List<SmsRawData> list) {
        ArrayList<SmsMessage> arrayList = new ArrayList<SmsMessage>();
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                byte[] byArray;
                int n2;
                SmsMessage smsMessage;
                SmsRawData smsRawData = list.get(i);
                if (smsRawData == null || (smsMessage = SmsMessage.createFromEfRecord(n2 = i + 1, byArray = smsRawData.getBytes())) == null) continue;
                boolean bl = arrayList.add(smsMessage);
            }
        }
        return arrayList;
    }

    public static SmsManager getDefault() {
        if (sInstance == null) {
            sInstance = new SmsManager();
        }
        return sInstance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean copyMessageToIcc(byte[] byArray, byte[] byArray2, int n) {
        boolean bl = false;
        try {
            ISms iSms = ISms.Stub.asInterface(ServiceManager.getService("isms"));
            if (iSms == null) return bl;
            boolean bl2 = iSms.copyMessageToIccEf(n, byArray2, byArray);
            return bl2;
        }
        catch (RemoteException remoteException) {
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean deleteMessageFromIcc(int n) {
        boolean bl = false;
        byte[] byArray = new byte[175];
        Arrays.fill(byArray, (byte)-1);
        try {
            ISms iSms = ISms.Stub.asInterface(ServiceManager.getService("isms"));
            if (iSms == null) return bl;
            boolean bl2 = iSms.updateMessageOnIccEf(n, 0, byArray);
            return bl2;
        }
        catch (RemoteException remoteException) {
            return bl;
        }
    }

    public ArrayList<String> divideMessage(String string2) {
        return SmsMessage.fragmentText(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList<SmsMessage> getAllMessagesFromIcc() {
        List<SmsRawData> list = null;
        try {
            ISms iSms = ISms.Stub.asInterface(ServiceManager.getService("isms"));
            if (iSms != null) {
                List<SmsRawData> list2;
                list = list2 = iSms.getAllMessagesFromIccEf();
            }
            return this.createMessageListFromRawRecords(list);
        }
        catch (RemoteException remoteException) {
            return this.createMessageListFromRawRecords(list);
        }
    }

    public void sendDataMessage(String string2, String string3, short s, byte[] byArray, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        if (TextUtils.isEmpty(string2)) {
            throw new IllegalArgumentException("Invalid destinationAddress");
        }
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("Invalid message data");
        }
        try {
            ISms iSms = ISms.Stub.asInterface(ServiceManager.getService("isms"));
            if (iSms == null) {
                return;
            }
            int n = s & 0xFFFF;
            String string4 = string2;
            String string5 = string3;
            byte[] byArray2 = byArray;
            PendingIntent pendingIntent3 = pendingIntent;
            PendingIntent pendingIntent4 = pendingIntent2;
            iSms.sendData(string4, string5, n, byArray2, pendingIntent3, pendingIntent4);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendMultipartTextMessage(String string2, String string3, ArrayList<String> arrayList, ArrayList<PendingIntent> arrayList2, ArrayList<PendingIntent> arrayList3) {
        if (TextUtils.isEmpty(string2)) {
            throw new IllegalArgumentException("Invalid destinationAddress");
        }
        if (arrayList == null || arrayList.size() < 1) {
            throw new IllegalArgumentException("Invalid message body");
        }
        if (arrayList.size() > 1) {
            try {
                ISms iSms = ISms.Stub.asInterface(ServiceManager.getService("isms"));
                if (iSms == null) {
                    return;
                }
                String string4 = string2;
                String string5 = string3;
                ArrayList<String> arrayList4 = arrayList;
                ArrayList<PendingIntent> arrayList5 = arrayList2;
                ArrayList<PendingIntent> arrayList6 = arrayList3;
                iSms.sendMultipartText(string4, string5, arrayList4, arrayList5, arrayList6);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }
        PendingIntent pendingIntent = null;
        PendingIntent pendingIntent2 = null;
        if (arrayList2 != null && arrayList2.size() > 0) {
            PendingIntent pendingIntent3 = arrayList2.get(0);
        }
        if (arrayList3 != null && arrayList3.size() > 0) {
            pendingIntent2 = arrayList3.get(0);
        }
        String string6 = arrayList.get(0);
        SmsManager smsManager = this;
        String string7 = string2;
        String string8 = string3;
        smsManager.sendTextMessage(string7, string8, string6, pendingIntent, pendingIntent2);
    }

    public void sendTextMessage(String string2, String string3, String string4, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        if (TextUtils.isEmpty(string2)) {
            throw new IllegalArgumentException("Invalid destinationAddress");
        }
        if (TextUtils.isEmpty(string4)) {
            throw new IllegalArgumentException("Invalid message body");
        }
        try {
            ISms iSms = ISms.Stub.asInterface(ServiceManager.getService("isms"));
            if (iSms == null) {
                return;
            }
            String string5 = string2;
            String string6 = string3;
            String string7 = string4;
            PendingIntent pendingIntent3 = pendingIntent;
            PendingIntent pendingIntent4 = pendingIntent2;
            iSms.sendText(string5, string6, string7, pendingIntent3, pendingIntent4);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean updateMessageOnIcc(int n, int n2, byte[] byArray) {
        boolean bl = false;
        try {
            ISms iSms = ISms.Stub.asInterface(ServiceManager.getService("isms"));
            if (iSms == null) return bl;
            boolean bl2 = iSms.updateMessageOnIccEf(n, n2, byArray);
            return bl2;
        }
        catch (RemoteException remoteException) {
            return bl;
        }
    }
}

