/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.cdma.SmsMessage;
import com.android.internal.telephony.gsm.SmsMessage;
import java.util.ArrayList;
import java.util.Arrays;

public class SmsMessage {
    public static final int ENCODING_16BIT = 3;
    public static final int ENCODING_7BIT = 1;
    public static final int ENCODING_8BIT = 2;
    public static final int ENCODING_UNKNOWN = 0;
    private static final boolean LOCAL_DEBUG = true;
    private static final String LOG_TAG = "SMS";
    public static final int MAX_USER_DATA_BYTES = 140;
    public static final int MAX_USER_DATA_BYTES_WITH_HEADER = 134;
    public static final int MAX_USER_DATA_SEPTETS = 160;
    public static final int MAX_USER_DATA_SEPTETS_WITH_HEADER = 153;
    public SmsMessageBase mWrappedSmsMessage;

    public SmsMessage() {
        SmsMessageBase smsMessageBase = SmsMessage.getSmsFacility();
        this(smsMessageBase);
    }

    private SmsMessage(SmsMessageBase smsMessageBase) {
        this.mWrappedSmsMessage = smsMessageBase;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int[] calculateLength(CharSequence charSequence, boolean bl) {
        int n = TelephonyManager.getDefault().getPhoneType();
        SmsMessageBase.TextEncodingDetails textEncodingDetails = 2 != n ? com.android.internal.telephony.cdma.SmsMessage.calculateLength(charSequence, bl) : com.android.internal.telephony.gsm.SmsMessage.calculateLength(charSequence, bl);
        int n2 = textEncodingDetails.msgCount;
        int n3 = textEncodingDetails.codeUnitCount;
        int n4 = textEncodingDetails.codeUnitsRemaining;
        int n5 = textEncodingDetails.codeUnitSize;
        int[] nArray = new int[]{n2, n3, n4, n5};
        return nArray;
    }

    public static int[] calculateLength(String string2, boolean bl) {
        return SmsMessage.calculateLength((CharSequence)string2, bl);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static SmsMessage createFromEfRecord(int n, byte[] byArray) {
        void var3_4;
        int n2 = TelephonyManager.getDefault().getPhoneType();
        if (2 != n2) {
            com.android.internal.telephony.cdma.SmsMessage smsMessage = com.android.internal.telephony.cdma.SmsMessage.createFromEfRecord(n, byArray);
        } else {
            com.android.internal.telephony.gsm.SmsMessage smsMessage = com.android.internal.telephony.gsm.SmsMessage.createFromEfRecord(n, byArray);
        }
        if (var3_4 == null) return null;
        return new SmsMessage((SmsMessageBase)var3_4);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SmsMessage createFromPdu(byte[] byArray) {
        void var2_3;
        int n = TelephonyManager.getDefault().getPhoneType();
        if (2 != n) {
            com.android.internal.telephony.cdma.SmsMessage smsMessage = com.android.internal.telephony.cdma.SmsMessage.createFromPdu(byArray);
            return new SmsMessage((SmsMessageBase)var2_3);
        }
        com.android.internal.telephony.gsm.SmsMessage smsMessage = com.android.internal.telephony.gsm.SmsMessage.createFromPdu(byArray);
        return new SmsMessage((SmsMessageBase)var2_3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ArrayList<String> fragmentText(String string2) {
        int n = TelephonyManager.getDefault().getPhoneType();
        SmsMessageBase.TextEncodingDetails textEncodingDetails = 2 != n ? com.android.internal.telephony.cdma.SmsMessage.calculateLength(string2, false) : com.android.internal.telephony.gsm.SmsMessage.calculateLength(string2, false);
        int n2 = textEncodingDetails.msgCount > 1 ? (textEncodingDetails.codeUnitSize == 1 ? 153 : 134) : (textEncodingDetails.codeUnitSize == 1 ? 160 : 140);
        int n3 = 0;
        int n4 = string2.length();
        int n5 = textEncodingDetails.msgCount;
        ArrayList<String> arrayList = new ArrayList<String>(n5);
        while (n3 < n4) {
            int n6;
            if (textEncodingDetails.codeUnitSize == 1) {
                if (n == 2 && textEncodingDetails.msgCount == 1) {
                    int n7 = n4 - n3;
                    int n8 = Math.min(n2, n7);
                    n6 = n3 + n8;
                } else {
                    n6 = GsmAlphabet.findGsmSeptetLimitIndex(string2, n3, n2);
                }
            } else {
                int n9 = n2 / 2;
                int n10 = n4 - n3;
                int n11 = Math.min(n9, n10);
                n6 = n3 + n11;
            }
            if (n6 <= n3 || n6 > n4) {
                String string3 = "fragmentText failed (" + n3 + " >= " + n6 + " or " + n6 + " >= " + n4 + ")";
                int n12 = Log.e(LOG_TAG, string3);
                return arrayList;
            }
            String string4 = string2.substring(n3, n6);
            boolean bl = arrayList.add(string4);
            n3 = n6;
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final SmsMessageBase getSmsFacility() {
        void var1_2;
        int n = TelephonyManager.getDefault().getPhoneType();
        if (2 != n) {
            com.android.internal.telephony.cdma.SmsMessage smsMessage = new com.android.internal.telephony.cdma.SmsMessage();
            return var1_2;
        }
        com.android.internal.telephony.gsm.SmsMessage smsMessage = new com.android.internal.telephony.gsm.SmsMessage();
        return var1_2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SubmitPdu getSubmitPdu(String string2, String string3, String string4, boolean bl) {
        void var5_6;
        int n = TelephonyManager.getDefault().getPhoneType();
        if (2 != n) {
            SmsMessage.SubmitPdu submitPdu = com.android.internal.telephony.cdma.SmsMessage.getSubmitPdu(string2, string3, string4, bl, null);
            return new SubmitPdu((SmsMessageBase.SubmitPduBase)var5_6);
        }
        SmsMessage.SubmitPdu submitPdu = com.android.internal.telephony.gsm.SmsMessage.getSubmitPdu(string2, string3, string4, bl);
        return new SubmitPdu((SmsMessageBase.SubmitPduBase)var5_6);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SubmitPdu getSubmitPdu(String string2, String string3, String string4, boolean bl, byte[] byArray) {
        void var7_8;
        int n = TelephonyManager.getDefault().getPhoneType();
        if (2 != n) {
            SmsHeader smsHeader = SmsHeader.fromByteArray(byArray);
            SmsMessage.SubmitPdu submitPdu = com.android.internal.telephony.cdma.SmsMessage.getSubmitPdu(string2, string3, string4, bl, smsHeader);
            return new SubmitPdu((SmsMessageBase.SubmitPduBase)var7_8);
        }
        SmsMessage.SubmitPdu submitPdu = com.android.internal.telephony.gsm.SmsMessage.getSubmitPdu(string2, string3, string4, bl, byArray);
        return new SubmitPdu((SmsMessageBase.SubmitPduBase)var7_8);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SubmitPdu getSubmitPdu(String string2, String string3, short s, byte[] byArray, boolean bl) {
        void var6_7;
        int n = TelephonyManager.getDefault().getPhoneType();
        if (2 != n) {
            SmsMessage.SubmitPdu submitPdu = com.android.internal.telephony.cdma.SmsMessage.getSubmitPdu(string2, string3, s, byArray, bl);
            return new SubmitPdu((SmsMessageBase.SubmitPduBase)var6_7);
        }
        SmsMessage.SubmitPdu submitPdu = com.android.internal.telephony.gsm.SmsMessage.getSubmitPdu(string2, string3, s, byArray, bl);
        return new SubmitPdu((SmsMessageBase.SubmitPduBase)var6_7);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getTPLayerLengthForPDU(String string2) {
        int n = TelephonyManager.getDefault().getPhoneType();
        if (2 == n) return com.android.internal.telephony.gsm.SmsMessage.getTPLayerLengthForPDU(string2);
        return com.android.internal.telephony.cdma.SmsMessage.getTPLayerLengthForPDU(string2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SmsMessage newFromCDS(String string2) {
        void var2_3;
        int n = TelephonyManager.getDefault().getPhoneType();
        if (2 != n) {
            com.android.internal.telephony.cdma.SmsMessage smsMessage = com.android.internal.telephony.cdma.SmsMessage.newFromCDS(string2);
            return new SmsMessage((SmsMessageBase)var2_3);
        }
        com.android.internal.telephony.gsm.SmsMessage smsMessage = com.android.internal.telephony.gsm.SmsMessage.newFromCDS(string2);
        return new SmsMessage((SmsMessageBase)var2_3);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SmsMessage newFromCMT(String[] stringArray) {
        void var2_3;
        int n = TelephonyManager.getDefault().getPhoneType();
        if (2 != n) {
            com.android.internal.telephony.cdma.SmsMessage smsMessage = com.android.internal.telephony.cdma.SmsMessage.newFromCMT(stringArray);
            return new SmsMessage((SmsMessageBase)var2_3);
        }
        com.android.internal.telephony.gsm.SmsMessage smsMessage = com.android.internal.telephony.gsm.SmsMessage.newFromCMT(stringArray);
        return new SmsMessage((SmsMessageBase)var2_3);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static SmsMessage newFromCMTI(String string2) {
        void var2_3;
        int n = TelephonyManager.getDefault().getPhoneType();
        if (2 != n) {
            com.android.internal.telephony.cdma.SmsMessage smsMessage = com.android.internal.telephony.cdma.SmsMessage.newFromCMTI(string2);
            return new SmsMessage((SmsMessageBase)var2_3);
        }
        com.android.internal.telephony.gsm.SmsMessage smsMessage = com.android.internal.telephony.gsm.SmsMessage.newFromCMTI(string2);
        return new SmsMessage((SmsMessageBase)var2_3);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SmsMessage newFromParcel(Parcel parcel) {
        void var2_3;
        int n = TelephonyManager.getDefault().getPhoneType();
        if (2 != n) {
            com.android.internal.telephony.cdma.SmsMessage smsMessage = com.android.internal.telephony.cdma.SmsMessage.newFromParcel(parcel);
            return new SmsMessage((SmsMessageBase)var2_3);
        }
        SmsMessageBase smsMessageBase = com.android.internal.telephony.gsm.SmsMessage.newFromParcel(parcel);
        return new SmsMessage((SmsMessageBase)var2_3);
    }

    public String getDisplayMessageBody() {
        return this.mWrappedSmsMessage.getDisplayMessageBody();
    }

    public String getDisplayOriginatingAddress() {
        return this.mWrappedSmsMessage.getDisplayOriginatingAddress();
    }

    public String getEmailBody() {
        return this.mWrappedSmsMessage.getEmailBody();
    }

    public String getEmailFrom() {
        return this.mWrappedSmsMessage.getEmailFrom();
    }

    public int getIndexOnIcc() {
        return this.mWrappedSmsMessage.getIndexOnIcc();
    }

    @Deprecated
    public int getIndexOnSim() {
        return this.mWrappedSmsMessage.getIndexOnIcc();
    }

    public String getMessageBody() {
        return this.mWrappedSmsMessage.getMessageBody();
    }

    public MessageClass getMessageClass() {
        return this.mWrappedSmsMessage.getMessageClass();
    }

    public String getOriginatingAddress() {
        return this.mWrappedSmsMessage.getOriginatingAddress();
    }

    public byte[] getPdu() {
        return this.mWrappedSmsMessage.getPdu();
    }

    public int getProtocolIdentifier() {
        return this.mWrappedSmsMessage.getProtocolIdentifier();
    }

    public String getPseudoSubject() {
        return this.mWrappedSmsMessage.getPseudoSubject();
    }

    public String getServiceCenterAddress() {
        return this.mWrappedSmsMessage.getServiceCenterAddress();
    }

    public int getStatus() {
        return this.mWrappedSmsMessage.getStatus();
    }

    public int getStatusOnIcc() {
        return this.mWrappedSmsMessage.getStatusOnIcc();
    }

    @Deprecated
    public int getStatusOnSim() {
        return this.mWrappedSmsMessage.getStatusOnIcc();
    }

    public long getTimestampMillis() {
        return this.mWrappedSmsMessage.getTimestampMillis();
    }

    public byte[] getUserData() {
        return this.mWrappedSmsMessage.getUserData();
    }

    public SmsHeader getUserDataHeader() {
        return this.mWrappedSmsMessage.getUserDataHeader();
    }

    public boolean isCphsMwiMessage() {
        return this.mWrappedSmsMessage.isCphsMwiMessage();
    }

    public boolean isEmail() {
        return this.mWrappedSmsMessage.isEmail();
    }

    public boolean isMWIClearMessage() {
        return this.mWrappedSmsMessage.isMWIClearMessage();
    }

    public boolean isMWISetMessage() {
        return this.mWrappedSmsMessage.isMWISetMessage();
    }

    public boolean isMwiDontStore() {
        return this.mWrappedSmsMessage.isMwiDontStore();
    }

    public boolean isReplace() {
        return this.mWrappedSmsMessage.isReplace();
    }

    public boolean isReplyPathPresent() {
        return this.mWrappedSmsMessage.isReplyPathPresent();
    }

    public boolean isStatusReportMessage() {
        return this.mWrappedSmsMessage.isStatusReportMessage();
    }

    public static class SubmitPdu {
        public byte[] encodedMessage;
        public byte[] encodedScAddress;

        protected SubmitPdu(SmsMessageBase.SubmitPduBase submitPduBase) {
            byte[] byArray = submitPduBase.encodedMessage;
            this.encodedMessage = byArray;
            byte[] byArray2 = submitPduBase.encodedScAddress;
            this.encodedScAddress = byArray2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("SubmitPdu: encodedScAddress = ");
            String string2 = Arrays.toString(this.encodedScAddress);
            StringBuilder stringBuilder2 = stringBuilder.append(string2).append(", encodedMessage = ");
            String string3 = Arrays.toString(this.encodedMessage);
            return stringBuilder2.append(string3).toString();
        }
    }

    public static final class MessageClass
    extends Enum<MessageClass> {
        private static final /* synthetic */ MessageClass[] $VALUES;
        public static final /* enum */ MessageClass CLASS_0;
        public static final /* enum */ MessageClass CLASS_1;
        public static final /* enum */ MessageClass CLASS_2;
        public static final /* enum */ MessageClass CLASS_3;
        public static final /* enum */ MessageClass UNKNOWN;

        static {
            UNKNOWN = new MessageClass();
            CLASS_0 = new MessageClass();
            CLASS_1 = new MessageClass();
            CLASS_2 = new MessageClass();
            CLASS_3 = new MessageClass();
            MessageClass messageClass = UNKNOWN;
            MessageClass messageClass2 = CLASS_0;
            MessageClass messageClass3 = CLASS_1;
            MessageClass messageClass4 = CLASS_2;
            MessageClass messageClass5 = CLASS_3;
            MessageClass[] messageClassArray = new MessageClass[]{messageClass, messageClass2, messageClass3, messageClass4, messageClass5};
            $VALUES = messageClassArray;
        }

        public static MessageClass valueOf(String string2) {
            return Enum.valueOf(MessageClass.class, string2);
        }

        public static MessageClass[] values() {
            return (MessageClass[])$VALUES.clone();
        }
    }
}

