/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.content.Context;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.telephony.CellLocation;
import android.telephony.NeighboringCellInfo;
import android.telephony.PhoneStateListener;
import com.android.internal.telephony.IPhoneStateListener;
import com.android.internal.telephony.IPhoneSubInfo;
import com.android.internal.telephony.ITelephony;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import java.util.List;

public class TelephonyManager {
    public static final String ACTION_PHONE_STATE_CHANGED = "android.intent.action.PHONE_STATE";
    public static final int CALL_STATE_IDLE = 0;
    public static final int CALL_STATE_OFFHOOK = 2;
    public static final int CALL_STATE_RINGING = 1;
    public static final int DATA_ACTIVITY_DORMANT = 4;
    public static final int DATA_ACTIVITY_IN = 1;
    public static final int DATA_ACTIVITY_INOUT = 3;
    public static final int DATA_ACTIVITY_NONE = 0;
    public static final int DATA_ACTIVITY_OUT = 2;
    public static final int DATA_CONNECTED = 2;
    public static final int DATA_CONNECTING = 1;
    public static final int DATA_DISCONNECTED = 0;
    public static final int DATA_SUSPENDED = 3;
    public static final String EXTRA_INCOMING_NUMBER = "incoming_number";
    public static final String EXTRA_STATE = "state";
    public static final String EXTRA_STATE_IDLE;
    public static final String EXTRA_STATE_OFFHOOK;
    public static final String EXTRA_STATE_RINGING;
    public static final int NETWORK_TYPE_1xRTT = 7;
    public static final int NETWORK_TYPE_CDMA = 4;
    public static final int NETWORK_TYPE_EDGE = 2;
    public static final int NETWORK_TYPE_EHRPD = 14;
    public static final int NETWORK_TYPE_EVDO_0 = 5;
    public static final int NETWORK_TYPE_EVDO_A = 6;
    public static final int NETWORK_TYPE_EVDO_B = 12;
    public static final int NETWORK_TYPE_GPRS = 1;
    public static final int NETWORK_TYPE_HSDPA = 8;
    public static final int NETWORK_TYPE_HSPA = 10;
    public static final int NETWORK_TYPE_HSUPA = 9;
    public static final int NETWORK_TYPE_IDEN = 11;
    public static final int NETWORK_TYPE_LTE = 13;
    public static final int NETWORK_TYPE_UMTS = 3;
    public static final int NETWORK_TYPE_UNKNOWN = 0;
    public static final int PHONE_TYPE_CDMA = 2;
    public static final int PHONE_TYPE_GSM = 1;
    public static final int PHONE_TYPE_NONE = 0;
    public static final int SIM_STATE_ABSENT = 1;
    public static final int SIM_STATE_NETWORK_LOCKED = 4;
    public static final int SIM_STATE_PIN_REQUIRED = 2;
    public static final int SIM_STATE_PUK_REQUIRED = 3;
    public static final int SIM_STATE_READY = 5;
    public static final int SIM_STATE_UNKNOWN = 0;
    private static final String TAG = "TelephonyManager";
    private static TelephonyManager sInstance;
    private Context mContext;
    private ITelephonyRegistry mRegistry;

    static {
        sInstance = new TelephonyManager();
        EXTRA_STATE_IDLE = Phone.State.IDLE.toString();
        EXTRA_STATE_RINGING = Phone.State.RINGING.toString();
        EXTRA_STATE_OFFHOOK = Phone.State.OFFHOOK.toString();
    }

    private TelephonyManager() {
    }

    public TelephonyManager(Context context) {
        ITelephonyRegistry iTelephonyRegistry;
        this.mContext = context;
        this.mRegistry = iTelephonyRegistry = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
    }

    public static TelephonyManager getDefault() {
        return sInstance;
    }

    private ITelephony getITelephony() {
        return ITelephony.Stub.asInterface(ServiceManager.getService("phone"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getPhoneTypeFromNetworkType() {
        int n = SystemProperties.getInt("ro.telephony.default_network", -1);
        if (n != -1) return PhoneFactory.getPhoneType(n);
        return 0;
    }

    private int getPhoneTypeFromProperty() {
        int n = this.getPhoneTypeFromNetworkType();
        return SystemProperties.getInt("gsm.current.phone-type", n);
    }

    private IPhoneSubInfo getSubscriberInfo() {
        return IPhoneSubInfo.Stub.asInterface(ServiceManager.getService("iphonesubinfo"));
    }

    public void disableLocationUpdates() {
        try {
            this.getITelephony().disableLocationUpdates();
            return;
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void enableLocationUpdates() {
        try {
            this.getITelephony().enableLocationUpdates();
            return;
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCallState() {
        try {
            int n = this.getITelephony().getCallState();
            return n;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCdmaEriIconIndex() {
        try {
            int n = this.getITelephony().getCdmaEriIconIndex();
            return n;
        }
        catch (RemoteException remoteException) {
            return -1;
        }
        catch (NullPointerException nullPointerException) {
            return -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCdmaEriIconMode() {
        try {
            int n = this.getITelephony().getCdmaEriIconMode();
            return n;
        }
        catch (RemoteException remoteException) {
            return -1;
        }
        catch (NullPointerException nullPointerException) {
            return -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getCdmaEriText() {
        try {
            String string2 = this.getITelephony().getCdmaEriText();
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CellLocation getCellLocation() {
        try {
            CellLocation cellLocation = CellLocation.newFromBundle(this.getITelephony().getCellLocation());
            boolean bl = cellLocation.isEmpty();
            if (!bl) return cellLocation;
            return null;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getCompleteVoiceMailNumber() {
        try {
            String string2 = this.getSubscriberInfo().getCompleteVoiceMailNumber();
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getDataActivity() {
        try {
            int n = this.getITelephony().getDataActivity();
            return n;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getDataState() {
        try {
            int n = this.getITelephony().getDataState();
            return n;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getDeviceId() {
        try {
            String string2 = this.getSubscriberInfo().getDeviceId();
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getDeviceSoftwareVersion() {
        try {
            String string2 = this.getSubscriberInfo().getDeviceSvn();
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getLine1AlphaTag() {
        try {
            String string2 = this.getSubscriberInfo().getLine1AlphaTag();
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getLine1Number() {
        try {
            String string2 = this.getSubscriberInfo().getLine1Number();
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<NeighboringCellInfo> getNeighboringCellInfo() {
        try {
            List<NeighboringCellInfo> list = this.getITelephony().getNeighboringCellInfo();
            return list;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getNetworkCountryIso() {
        return SystemProperties.get("gsm.operator.iso-country");
    }

    public String getNetworkOperator() {
        return SystemProperties.get("gsm.operator.numeric");
    }

    public String getNetworkOperatorName() {
        return SystemProperties.get("gsm.operator.alpha");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getNetworkType() {
        try {
            ITelephony iTelephony = this.getITelephony();
            if (iTelephony == null) return 0;
            int n = iTelephony.getNetworkType();
            return n;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getNetworkTypeName() {
        switch (this.getNetworkType()) {
            default: {
                return "UNKNOWN";
            }
            case 1: {
                return "GPRS";
            }
            case 2: {
                return "EDGE";
            }
            case 3: {
                return "UMTS";
            }
            case 8: {
                return "HSDPA";
            }
            case 9: {
                return "HSUPA";
            }
            case 10: {
                return "HSPA";
            }
            case 4: {
                return "CDMA";
            }
            case 5: {
                return "CDMA - EvDo rev. 0";
            }
            case 6: {
                return "CDMA - EvDo rev. A";
            }
            case 12: {
                return "CDMA - EvDo rev. B";
            }
            case 7: 
        }
        return "CDMA - 1xRTT";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getPhoneType() {
        try {
            ITelephony iTelephony = this.getITelephony();
            int n = this.getPhoneTypeFromProperty();
            if (iTelephony == null) return n;
            return iTelephony.getActivePhoneType();
        }
        catch (RemoteException remoteException) {
            return this.getPhoneTypeFromProperty();
        }
        catch (NullPointerException nullPointerException) {
            return this.getPhoneTypeFromProperty();
        }
    }

    public String getSimCountryIso() {
        return SystemProperties.get("gsm.sim.operator.iso-country");
    }

    public String getSimOperator() {
        return SystemProperties.get("gsm.sim.operator.numeric");
    }

    public String getSimOperatorName() {
        return SystemProperties.get("gsm.sim.operator.alpha");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getSimSerialNumber() {
        try {
            String string2 = this.getSubscriberInfo().getIccSerialNumber();
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getSimState() {
        String string2 = SystemProperties.get("gsm.sim.state");
        if ("ABSENT".equals(string2)) {
            return 1;
        }
        if ("PIN_REQUIRED".equals(string2)) {
            return 2;
        }
        if ("PUK_REQUIRED".equals(string2)) {
            return 3;
        }
        if ("NETWORK_LOCKED".equals(string2)) {
            return 4;
        }
        if (!"READY".equals(string2)) return 0;
        return 5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getSubscriberId() {
        try {
            String string2 = this.getSubscriberInfo().getSubscriberId();
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getVoiceMailAlphaTag() {
        try {
            String string2 = this.getSubscriberInfo().getVoiceMailAlphaTag();
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getVoiceMailNumber() {
        try {
            String string2 = this.getSubscriberInfo().getVoiceMailNumber();
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getVoiceMessageCount() {
        try {
            int n = this.getITelephony().getVoiceMessageCount();
            return n;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasIccCard() {
        try {
            boolean bl = this.getITelephony().hasIccCard();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean isNetworkRoaming() {
        String string2 = SystemProperties.get("gsm.operator.isroaming");
        return "true".equals(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void listen(PhoneStateListener phoneStateListener, int n) {
        String string2 = this.mContext != null ? this.mContext.getPackageName() : "<unknown>";
        try {
            boolean bl = this.getITelephony() != null;
            Boolean bl2 = bl;
            ITelephonyRegistry iTelephonyRegistry = this.mRegistry;
            IPhoneStateListener iPhoneStateListener = phoneStateListener.callback;
            boolean bl3 = bl2;
            iTelephonyRegistry.listen(string2, iPhoneStateListener, n, bl3);
            return;
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }
}

