/*
 * Decompiled with CFR 0.152.
 */
package android.test;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import java.lang.reflect.Field;
import junit.framework.TestCase;

public class AndroidTestCase
extends TestCase {
    protected Context mContext;
    private Context mTestContext;

    public void assertActivityRequiresPermission(String string2, String string3, String string4) {
        Intent intent = new Intent();
        Intent intent2 = intent.setClassName(string2, string3);
        Intent intent3 = intent.addFlags(0x10000000);
        try {
            this.getContext().startActivity(intent);
            AndroidTestCase.fail("expected security exception for " + string4);
            return;
        }
        catch (SecurityException securityException) {
            String string5 = securityException.getMessage();
            AndroidTestCase.assertNotNull("security exception's error message.", string5);
            String string6 = "error message should contain " + string4 + ".";
            boolean bl = securityException.getMessage().contains(string4);
            AndroidTestCase.assertTrue(string6, bl);
            return;
        }
    }

    public void assertReadingContentUriRequiresPermission(Uri uri, String string2) {
        try {
            ContentResolver contentResolver = this.getContext().getContentResolver();
            Uri uri2 = uri;
            Cursor cursor = contentResolver.query(uri2, null, null, null, null);
            AndroidTestCase.fail("expected SecurityException requiring " + string2);
            return;
        }
        catch (SecurityException securityException) {
            String string3 = securityException.getMessage();
            AndroidTestCase.assertNotNull("security exception's error message.", string3);
            String string4 = "error message should contain " + string2 + ".";
            boolean bl = securityException.getMessage().contains(string2);
            AndroidTestCase.assertTrue(string4, bl);
            return;
        }
    }

    public void assertWritingContentUriRequiresPermission(Uri uri, String string2) {
        try {
            ContentResolver contentResolver = this.getContext().getContentResolver();
            ContentValues contentValues = new ContentValues();
            Uri uri2 = contentResolver.insert(uri, contentValues);
            AndroidTestCase.fail("expected SecurityException requiring " + string2);
            return;
        }
        catch (SecurityException securityException) {
            String string3 = securityException.getMessage();
            AndroidTestCase.assertNotNull("security exception's error message.", string3);
            String string4 = "error message should contain " + string2 + ".";
            boolean bl = securityException.getMessage().contains(string2);
            AndroidTestCase.assertTrue(string4, bl);
            return;
        }
    }

    public Context getContext() {
        return this.mContext;
    }

    public Context getTestContext() {
        return this.mTestContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void scrubClass(Class<?> clazz) throws IllegalAccessException {
        Field[] fieldArray = this.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Class<?> clazz2 = field.getDeclaringClass();
            if (clazz.isAssignableFrom(clazz2) && !field.getType().isPrimitive()) {
                boolean bl = true;
                try {
                    field.setAccessible(bl);
                    field.set(this, null);
                }
                catch (Exception exception) {
                    int n3 = Log.d("TestCase", "Error: Could not nullify field!");
                }
                if (field.get(this) != null) {
                    int n4 = Log.d("TestCase", "Error: Could not nullify field!");
                }
            }
            ++n2;
        }
        return;
    }

    public void setContext(Context context) {
        this.mContext = context;
    }

    public void setTestContext(Context context) {
        this.mTestContext = context;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAndroidTestCaseSetupProperly() {
        Context context = this.mContext;
        AndroidTestCase.assertNotNull("Context is null. setContext should be called before tests are run", context);
    }
}

